/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.common.Problem;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Severity implements Enumerator
{
    CRITIC(0, "critic", "critic"),
    ERROR(0, "error", "error"),
    WARNING(0, "warning", "warning");

    public static final int CRITIC_VALUE = 0;
    public static final int ERROR_VALUE = 0;
    public static final int WARNING_VALUE = 0;
    private static final Severity[] VALUES_ARRAY;
    public static final List<Severity> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Severity[]{CRITIC, ERROR, WARNING};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Severity get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Severity result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Severity getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Severity result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Severity get(int value) {
        switch (value) {
            case 0: {
                return CRITIC;
            }
        }
        return null;
    }

    private Severity(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

