/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.common;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.m2m.atl.adt.ui.Messages;
import org.eclipse.m2m.atl.adt.ui.common.AbstractAtlSelection;
import org.eclipse.m2m.atl.adt.ui.common.AtlResourceSelectionBox;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AtlModelSelection
extends AbstractAtlSelection {
    private static final String DEFAULT_METAMODEL_NAME = "MM";
    private Text modelNameText;
    private Text metamodelNameText;
    private AtlResourceSelectionBox loadResourceBox;
    private String defaultModelName;
    private Map<String, String> inputFromParent;
    private Map<String, String> outputFromParent;
    private Map<String, String> pathsFromParent;

    public AtlModelSelection(Shell parent, String title, String defaultModelName, Map<String, String> input, Map<String, String> output, Map<String, String> paths) {
        super(parent, title);
        this.defaultModelName = defaultModelName;
        this.inputFromParent = input;
        this.outputFromParent = output;
        this.pathsFromParent = paths;
    }

    @Override
    public void create() {
        super.create();
        this.modelNameText.setText(this.getDefaultName(this.defaultModelName, this.getExistingModels()));
        this.metamodelNameText.setText(this.getDefaultName(DEFAULT_METAMODEL_NAME, this.getExistingMetamodels()));
        this.metamodelNameText.setFocus();
        this.metamodelNameText.selectAll();
    }

    private Set<String> getExistingModels() {
        HashSet<String> res = new HashSet<String>();
        res.addAll(this.inputFromParent.keySet());
        res.addAll(this.outputFromParent.keySet());
        return res;
    }

    private Set<String> getExistingMetamodels() {
        HashSet<String> res = new HashSet<String>();
        res.addAll(this.inputFromParent.values());
        res.addAll(this.outputFromParent.values());
        return res;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridData data = new GridData(1808);
        container.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        Group modelSection = new Group(container, 0);
        modelSection.setText(Messages.getString("AtlModelSelection.NAMING"));
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 10;
        modelSection.setLayout((Layout)layout);
        data = new GridData(768);
        modelSection.setLayoutData((Object)data);
        Label modelLabel = new Label((Composite)modelSection, 0);
        modelLabel.setText(Messages.getString("AtlModelSelection.MODEL_NAME"));
        modelLabel.setLayoutData((Object)new GridData());
        this.modelNameText = new Text((Composite)modelSection, 2048);
        this.modelNameText.setLayoutData((Object)new GridData(768));
        this.modelNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AtlModelSelection.this.textChanged();
            }
        });
        Label metamodelLabel = new Label((Composite)modelSection, 0);
        metamodelLabel.setText(Messages.getString("AtlModelSelection.METAMODEL_NAME"));
        metamodelLabel.setLayoutData((Object)new GridData());
        this.metamodelNameText = new Text((Composite)modelSection, 2048);
        this.metamodelNameText.setLayoutData((Object)new GridData(768));
        this.metamodelNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AtlModelSelection.this.textChanged();
            }
        });
        Group uriSection = new Group(container, 0);
        uriSection.setText(Messages.getString("AtlModelSelection.METAMODEL_LOCATION"));
        uriSection.setLayout((Layout)new GridLayout());
        data = new GridData(768);
        uriSection.setLayoutData((Object)data);
        this.loadResourceBox = new AtlResourceSelectionBox(this.getShell());
        Composite composite = (Composite)this.loadResourceBox.createDialogArea((Composite)uriSection);
        composite.getChildren()[composite.getChildren().length - 1].dispose();
        composite.setLayoutData((Object)data);
        return container;
    }

    private void textChanged() {
        String modelMessage = AtlModelSelection.checkIdentifier(this.modelNameText.getText());
        String metamodelMessage = AtlModelSelection.checkIdentifier(this.metamodelNameText.getText());
        if (modelMessage != null) {
            this.nok(modelMessage);
        } else if (metamodelMessage != null) {
            this.nok(metamodelMessage);
        } else if (this.getExistingModels().contains(this.modelNameText.getText())) {
            this.nok(Messages.getString("AtlModelSelection.MODEL_EXISTS"));
        } else if (this.getExistingMetamodels().contains(this.metamodelNameText.getText())) {
            this.loadResourceBox.setText(this.pathsFromParent.get(this.metamodelNameText.getText()));
            this.warn(Messages.getString("AtlModelSelection.METAMODEL_EXISTS"));
        } else {
            this.ok();
        }
    }

    protected void computeResult() {
        String resource = this.loadResourceBox.getURIText();
        Object[] result = resource != null && !"".equals(resource) ? new Object[]{this.modelNameText.getText(), this.metamodelNameText.getText(), resource} : new Object[]{this.modelNameText.getText(), this.metamodelNameText.getText()};
        this.setResult(Arrays.asList(result));
    }
}

