/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ide.ui;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.eclipse.acceleo.query.services.StringServices;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.MultiStringMatcher;
import org.eclipse.jface.text.TextUtilities;

public class AcceleoAutoEditStrategy
implements IAutoEditStrategy {
    private static final Set<String> BLOCK_STARTS = AcceleoAutoEditStrategy.initBlockStarts();
    private static final String NEW_LINE = System.lineSeparator();

    private static Set<String> initBlockStarts() {
        HashSet<String> res = new HashSet<String>();
        res.add("[comment]");
        res.add("[file ");
        res.add("[for ");
        res.add("[if ");
        res.add("[elseif ");
        res.add("[else]");
        res.add("[let ");
        res.add("[protected ");
        res.add("[query ");
        res.add("[template ");
        return res;
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (this.newLineCommand(document, command)) {
            if (this.atEndOfLine(document, command)) {
                this.autoIndentAfterNewLine(document, command);
            }
        } else if (this.atEndOfBlankLine(document, command) && this.multiLineCommand(document, command)) {
            this.shiftBlock(document, command);
        }
    }

    private boolean multiLineCommand(IDocument document, DocumentCommand command) {
        return MultiStringMatcher.indexOf((CharSequence)command.text, (int)0, (String[])document.getLegalLineDelimiters()) != null;
    }

    protected int findEndOfWhiteSpace(IDocument document, int offset, int end) throws BadLocationException {
        while (offset < end) {
            char c = document.getChar(offset);
            if (c != ' ' && c != '\t') {
                return offset;
            }
            ++offset;
        }
        return end;
    }

    private void autoIndentAfterNewLine(IDocument document, DocumentCommand command) {
        if (command.offset == -1 || document.getLength() == 0) {
            return;
        }
        try {
            int position = command.offset == document.getLength() ? command.offset - 1 : command.offset;
            int indentationSize = this.neededIndentation(document, position);
            StringBuilder buf = new StringBuilder(command.text);
            if (indentationSize > 0) {
                int i = 0;
                while (i < indentationSize) {
                    buf.append(" ");
                    ++i;
                }
            } else {
                IRegion info = document.getLineInformationOfOffset(position);
                int start = info.getOffset();
                int end = this.findEndOfWhiteSpace(document, start, command.offset);
                if (end > start) {
                    buf.append(document.get(start, end - start));
                }
            }
            command.text = buf.toString();
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private int neededIndentation(IDocument document, int position) {
        int res;
        block3: {
            res = 0;
            try {
                IRegion currentLineInfo = document.getLineInformationOfOffset(position);
                String currentLine = document.get(currentLineInfo.getOffset(), currentLineInfo.getLength());
                if (!currentLine.endsWith("]")) break block3;
                for (String start : BLOCK_STARTS) {
                    int indexOfStart = currentLine.indexOf(start);
                    if (indexOfStart <= -1) continue;
                    res = indexOfStart + 2;
                    break;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return res;
    }

    private void shiftBlock(IDocument document, DocumentCommand command) {
        String blockIndentation = this.getBlockIndentation(command.text);
        try {
            IRegion lineInfo = document.getLineInformationOfOffset(command.offset);
            String indentation = document.get(lineInfo.getOffset(), lineInfo.getLength());
            command.text = command.text.substring(blockIndentation.length());
            String emptyLineReplacement = UUID.randomUUID().toString() + UUID.randomUUID().toString() + UUID.randomUUID().toString();
            command.text = StringServices.EMPTY_LINE_PATTERN.matcher(command.text).replaceAll(emptyLineReplacement);
            String[] stringArray = document.getLegalLineDelimiters();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String lineDelimiter = stringArray[n2];
                command.text = command.text.replace(lineDelimiter + blockIndentation, lineDelimiter + indentation);
                ++n2;
            }
            command.text = command.text.replace(emptyLineReplacement, NEW_LINE + NEW_LINE + indentation);
            if (TextUtilities.endsWith((String[])document.getLegalLineDelimiters(), (String)command.text) != -1) {
                command.text = command.text + indentation;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private String getBlockIndentation(String text) {
        int offset = 0;
        while (offset < text.length()) {
            char charAt = text.charAt(offset);
            if (charAt != ' ' && charAt != '\t') break;
            ++offset;
        }
        return text.substring(0, offset);
    }

    private boolean newLineCommand(IDocument document, DocumentCommand command) {
        return command.length == 0 && command.text != null && TextUtilities.endsWith((String[])document.getLegalLineDelimiters(), (String)command.text) != -1 && TextUtilities.startsWith((String[])document.getLegalLineDelimiters(), (String)command.text) != -1;
    }

    private boolean atEndOfBlankLine(IDocument document, DocumentCommand command) {
        boolean res;
        if (this.atEndOfLine(document, command)) {
            try {
                IRegion lineInfo = document.getLineInformationOfOffset(command.offset);
                res = document.get(lineInfo.getOffset(), lineInfo.getLength()).trim().isEmpty();
            }
            catch (BadLocationException e) {
                res = false;
            }
        } else {
            res = false;
        }
        return res;
    }

    private boolean atEndOfLine(IDocument document, DocumentCommand command) {
        boolean res = false;
        try {
            String[] stringArray = document.getLegalLineDelimiters();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String lineDelimiter = stringArray[n2];
                if (document.getLength() <= command.offset + lineDelimiter.length() || !(res = lineDelimiter.equals(document.get(command.offset, lineDelimiter.length())))) {
                    ++n2;
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException e) {
            res = false;
        }
        return res;
    }
}

