/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.datamodel;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.wst.ws.internal.datamodel.BasicConnection;
import org.eclipse.wst.ws.internal.datamodel.BasicProperty;
import org.eclipse.wst.ws.internal.datamodel.BasicRel;
import org.eclipse.wst.ws.internal.datamodel.Connection;
import org.eclipse.wst.ws.internal.datamodel.Element;
import org.eclipse.wst.ws.internal.datamodel.ElementListener;
import org.eclipse.wst.ws.internal.datamodel.Model;
import org.eclipse.wst.ws.internal.datamodel.Property;
import org.eclipse.wst.ws.internal.datamodel.PropertyAddEvent;
import org.eclipse.wst.ws.internal.datamodel.PropertyChangeEvent;
import org.eclipse.wst.ws.internal.datamodel.Rel;
import org.eclipse.wst.ws.internal.datamodel.RelAddEvent;
import org.eclipse.wst.ws.internal.datamodel.RelRemoveEvent;

public class BasicElement
implements Element {
    public static final String copyright = "(c) Copyright IBM Corporation 2000, 2002.";
    private String fName;
    private String fMUID;
    private Model fModel;
    private Hashtable fRels;
    private Hashtable fProperties;
    private Vector fListeners;

    public BasicElement(String name, Model model) {
        this.fName = name;
        this.setMUID(model.makeMUID(name));
        model.addElement(this);
        this.fModel = model;
        this.fRels = new Hashtable();
        this.fListeners = new Vector();
        this.fProperties = new Hashtable();
        this.fProperties.put("name", new BasicProperty("name", this.fName));
    }

    public BasicElement(String name, Element element, String outboundRelName, String inboundRelName) {
        this(name, element.getModel());
        this.connect(element, outboundRelName, inboundRelName);
    }

    @Override
    public Element shallowClone() {
        return new BasicElement(this.fName, this.fModel);
    }

    @Override
    public final Element deepClone() {
        Element newElement = this.shallowClone();
        Enumeration e = this.getProperties();
        while (e.hasMoreElements()) {
            Property property = (Property)e.nextElement();
            Property newProperty = property.shallowClone();
            newElement.setProperty(newProperty);
        }
        return newElement;
    }

    @Override
    public void addListener(ElementListener listener) {
        this.fListeners.add(listener);
    }

    @Override
    public Model getModel() {
        return this.fModel;
    }

    @Override
    public boolean isValid() {
        return this.fModel != null && this.fModel.containsElement(this);
    }

    @Override
    public boolean remove() {
        return this.fModel.removeElement(this);
    }

    @Override
    public void setName(String name) {
        this.fName = name;
        this.fProperties.put("name", new BasicProperty("name", this.fName));
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public String getMUID() {
        return this.fMUID;
    }

    public int getNumberID() {
        String number = this.getMUID().substring(this.getName().length());
        return Integer.parseInt(number);
    }

    private void setMUID(String MUID) {
        this.fMUID = MUID;
    }

    @Override
    public void setProperty(Property property) {
        String propertyName = property.getName();
        Property oldProperty = this.getProperty(propertyName);
        this.fProperties.put(propertyName, property);
        if (oldProperty == null) {
            PropertyAddEvent event = new PropertyAddEvent(this, property);
            Enumeration e = this.fListeners.elements();
            while (e.hasMoreElements()) {
                ((ElementListener)e.nextElement()).propertyAdded(event);
            }
        } else {
            Object newValue;
            Object oldValue = oldProperty.getValue();
            if (!(oldValue == (newValue = property.getValue()) || oldValue != null && newValue != null && oldValue.equals(newValue))) {
                PropertyChangeEvent event = new PropertyChangeEvent(this, property, oldProperty);
                Enumeration e = this.fListeners.elements();
                while (e.hasMoreElements()) {
                    ((ElementListener)e.nextElement()).propertyChanged(event);
                }
            }
        }
        if (propertyName.equals("name")) {
            this.fName = property.getValue().toString();
        }
    }

    @Override
    public void setPropertyAsObject(String name, Object value) {
        this.setProperty(new BasicProperty(name, value));
    }

    @Override
    public void setPropertyAsString(String name, String value) {
        this.setProperty(new BasicProperty(name, value));
    }

    @Override
    public Property getProperty(String name) {
        return (Property)this.fProperties.get(name);
    }

    @Override
    public Object getPropertyAsObject(String name) {
        Property property = this.getProperty(name);
        return property == null ? null : property.getValue();
    }

    @Override
    public String getPropertyAsString(String name) {
        Property property = this.getProperty(name);
        return property == null ? null : property.getValueAsString();
    }

    @Override
    public Enumeration getProperties() {
        return this.fProperties.elements();
    }

    @Override
    public boolean connect(Element targetElement, String outboundRelName, String inboundRelName) {
        if (this.fModel == null || this.fModel != targetElement.getModel()) {
            return false;
        }
        BasicElement sourceElement = this;
        Rel outboundRel = sourceElement.getRel(outboundRelName);
        Rel inboundRel = targetElement.getRel(inboundRelName);
        Connection[] pair = BasicConnection.createPair(outboundRel, targetElement, inboundRel, sourceElement);
        outboundRel.addConnection(pair[0]);
        inboundRel.addConnection(pair[1]);
        RelAddEvent event = new RelAddEvent(pair);
        Enumeration eSource = this.getListeners();
        Enumeration eTarget = targetElement.getListeners();
        while (eSource.hasMoreElements()) {
            ((ElementListener)eSource.nextElement()).relAdded(event);
        }
        while (eTarget.hasMoreElements()) {
            ((ElementListener)eTarget.nextElement()).relAdded(event);
        }
        return true;
    }

    @Override
    public boolean disconnect(Element targetElement, String outboundRelName) {
        return this.disconnect(targetElement, this.getRel(outboundRelName));
    }

    @Override
    public boolean disconnectRel(String outboundRelName) {
        return this.disconnectRel(this.getRel(outboundRelName));
    }

    @Override
    public boolean disconnectAll() {
        if (this.fModel == null) {
            return false;
        }
        Enumeration e = this.fRels.elements();
        while (e.hasMoreElements()) {
            Rel rel = (Rel)e.nextElement();
            this.disconnectRel(rel);
        }
        return true;
    }

    @Override
    public Enumeration getElements(String relName) {
        return this.getRel(relName).getTargetElements();
    }

    @Override
    public int getNumberOfElements(String relName) {
        return this.getRel(relName).getNumberOfTargetElements();
    }

    @Override
    public Rel getRel(String relName) {
        Rel rel = (Rel)this.fRels.get(relName);
        if (rel == null) {
            rel = new BasicRel(relName, this);
            this.fRels.put(relName, rel);
        }
        return rel;
    }

    @Override
    public Enumeration getRels() {
        return this.fRels.elements();
    }

    @Override
    public Enumeration getListeners() {
        return this.fListeners.elements();
    }

    protected boolean disconnect(Element targetElement, Rel outboundRel) {
        if (this.fModel == null || this.fModel != targetElement.getModel() || outboundRel == null) {
            return false;
        }
        Connection outboundConnection = outboundRel.getConnectionTo(targetElement);
        if (outboundConnection == null) {
            return false;
        }
        Connection inboundConnection = outboundConnection.getOpposingConnection();
        RelRemoveEvent event = new RelRemoveEvent(new Connection[]{outboundConnection, inboundConnection});
        Enumeration e = this.fListeners.elements();
        while (e.hasMoreElements()) {
            ((ElementListener)e.nextElement()).relRemoved(event);
        }
        Enumeration eTarget = targetElement.getListeners();
        while (eTarget.hasMoreElements()) {
            ((ElementListener)eTarget.nextElement()).relRemoved(event);
        }
        Rel inboundRel = inboundConnection.getRel();
        boolean done = outboundRel.removeConnection(outboundConnection);
        inboundRel.removeConnection(inboundConnection);
        return done;
    }

    protected boolean disconnectRel(Rel outboundRel) {
        if (this.fModel == null || outboundRel == null) {
            return false;
        }
        Element[] elements = new Element[outboundRel.getNumberOfTargetElements()];
        int i = 0;
        Enumeration e = outboundRel.getTargetElements();
        while (e.hasMoreElements()) {
            elements[i++] = (Element)e.nextElement();
        }
        while (i-- > 0) {
            this.disconnect(elements[i], outboundRel);
        }
        return true;
    }

    public String toString() {
        return this.getName();
    }
}

