/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment;

import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.IXSDFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.XSDComplexTypeToFragmentMapper;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.XSDLiteralXMLEncodingToFragmentMapper;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.XSDToFragmentConfiguration;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.XSDToFragmentController;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.XSDToFragmentMapper;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl.SOAPEncArrayFixFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl.SOAPEncArrayFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl.SOAPEncArrayRangeFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl.SOAPEncodingWrapperFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.util.XSDTypeDefinitionUtil;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.xsd.WSDLPartsToXSDTypeMapper;
import org.eclipse.xsd.XSDAttributeGroupContent;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Element;

public class XSDSOAPEncodingToFragmentMapper
extends XSDToFragmentMapper {
    private XSDLiteralXMLEncodingToFragmentMapper xsdLiteralMapper_ = null;
    private XSDComplexTypeToFragmentMapper xsdComplexMapper_ = null;

    public XSDSOAPEncodingToFragmentMapper(XSDToFragmentController controller, WSDLPartsToXSDTypeMapper wsdlToXSDMapper) {
        super(controller, wsdlToXSDMapper);
    }

    private XSDLiteralXMLEncodingToFragmentMapper getXSDLiteralMapper() {
        if (this.xsdLiteralMapper_ == null) {
            this.xsdLiteralMapper_ = new XSDLiteralXMLEncodingToFragmentMapper(this.getController(), this.getWSDLPartsToXSDTypeMapper());
        }
        return this.xsdLiteralMapper_;
    }

    private XSDComplexTypeToFragmentMapper getXSDComplexMapper() {
        if (this.xsdComplexMapper_ == null) {
            this.xsdComplexMapper_ = new XSDComplexTypeToFragmentMapper(this.getController(), this.getWSDLPartsToXSDTypeMapper());
        }
        return this.xsdComplexMapper_;
    }

    @Override
    public IXSDFragment getFragment(XSDToFragmentConfiguration config, String id, String name) {
        if (config.getIsWSDLPart()) {
            SOAPEncodingWrapperFragment wrapperFragment = new SOAPEncodingWrapperFragment(id, name, null);
            String delegationFragId = wrapperFragment.genID();
            IXSDFragment delegationFragment = this.getFragmentDelegate(config, delegationFragId, name);
            wrapperFragment.setXSDDelegationFragment(delegationFragment);
            this.getController().addToCache(delegationFragId, delegationFragment);
            return wrapperFragment;
        }
        return this.getFragmentDelegate(config, id, name);
    }

    public IXSDFragment getFragmentDelegate(XSDToFragmentConfiguration config, String id, String name) {
        XSDComponent component = (config = this.resolveXSDComponent(config)).getXSDComponent();
        if (!this.isComponentResolvable(component)) {
            return this.getXSDDefaultFragment(config, id, name);
        }
        if (component instanceof XSDComplexTypeDefinition) {
            XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)component;
            if (XSDTypeDefinitionUtil.isSoapEncArray((XSDTypeDefinition)complexType)) {
                return this.getSOAPEncArrayFragment(config, id, name, complexType);
            }
            return this.getXSDComplexMapper().getFragment(config, id, name);
        }
        return this.getXSDLiteralMapper().getFragment(config, id, name);
    }

    private IXSDFragment getSOAPEncArrayFragment(XSDToFragmentConfiguration config, String id, String name, XSDComplexTypeDefinition complexType) {
        EList xsdAttrContents = complexType.getAttributeContents();
        int i = 0;
        while (i < xsdAttrContents.size()) {
            XSDNamedComponent soapEncArrayType;
            String soapEncArrayTypeNamespaceURI = null;
            String soapEncArrayTypeLocalName = null;
            int soapEncArrayDimension = 0;
            XSDAttributeGroupContent xsdAttrContent = (XSDAttributeGroupContent)xsdAttrContents.get(i);
            Element element = xsdAttrContent.getElement();
            String arrayTypeAttr = element.getAttributeNS("http://schemas.xmlsoap.org/wsdl/", "arrayType");
            if (arrayTypeAttr != null && arrayTypeAttr.length() > 0) {
                int colon = arrayTypeAttr.indexOf(":");
                String nsPrefix = colon > 0 ? arrayTypeAttr.substring(0, colon) : null;
                soapEncArrayTypeNamespaceURI = (String)xsdAttrContent.getSchema().getQNamePrefixToNamespaceMap().get(nsPrefix);
                int dimensionIndex = arrayTypeAttr.indexOf("[");
                soapEncArrayTypeLocalName = arrayTypeAttr.substring(colon + 1, dimensionIndex);
                String dimensionString = arrayTypeAttr.substring(dimensionIndex, arrayTypeAttr.length());
                int j = 0;
                while (j < dimensionString.length() - 1) {
                    if (dimensionString.charAt(j) == "[".charAt(0) && dimensionString.charAt(j + 1) == "]".charAt(0)) {
                        ++soapEncArrayDimension;
                        ++j;
                    } else {
                        soapEncArrayDimension = 0;
                        break;
                    }
                    ++j;
                }
            }
            if (soapEncArrayTypeNamespaceURI != null && soapEncArrayTypeLocalName != null && soapEncArrayDimension == 1 && (soapEncArrayType = this.getWSDLPartsToXSDTypeMapper().getXSDTypeFromSchema(soapEncArrayTypeNamespaceURI, soapEncArrayTypeLocalName, false)) != null && soapEncArrayType instanceof XSDTypeDefinition) {
                XSDParticleContent xsdParticleContent;
                XSDModelGroup sequence = null;
                XSDComplexTypeContent complexTypeContent = XSDTypeDefinitionUtil.getXSDComplexTypeContent(complexType);
                if (complexTypeContent != null && complexTypeContent instanceof XSDParticle && (xsdParticleContent = ((XSDParticle)complexTypeContent).getContent()) instanceof XSDModelGroup) {
                    sequence = (XSDModelGroup)xsdParticleContent;
                }
                SOAPEncArrayFragment frag = config.getMinOccurs() == config.getMaxOccurs() ? new SOAPEncArrayFixFragment(id, name, config, this.getController(), sequence) : new SOAPEncArrayRangeFragment(id, name, config, this.getController(), sequence);
                frag.setXSDTypeDefinition((XSDTypeDefinition)soapEncArrayType);
                return frag;
            }
            ++i;
        }
        return this.getXSDComplexMapper().getFragment(config, id, name);
    }
}

