/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.v8native.value;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.wst.jsdt.chromium.JsValue;
import org.eclipse.wst.jsdt.chromium.RelayOk;
import org.eclipse.wst.jsdt.chromium.SyncCallback;
import org.eclipse.wst.jsdt.chromium.internal.JsonUtil;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException;
import org.eclipse.wst.jsdt.chromium.internal.v8native.DebugSession;
import org.eclipse.wst.jsdt.chromium.internal.v8native.InternalContext;
import org.eclipse.wst.jsdt.chromium.internal.v8native.V8BlockingCallback;
import org.eclipse.wst.jsdt.chromium.internal.v8native.V8CommandCallbackBase;
import org.eclipse.wst.jsdt.chromium.internal.v8native.V8CommandProcessor;
import org.eclipse.wst.jsdt.chromium.internal.v8native.V8Helper;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.FailedCommandResponse;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.ScopeBody;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.SuccessCommandResponse;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.V8ProtocolParserAccess;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.data.ObjectValueHandle;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.data.RefWithDisplayData;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.data.SomeHandle;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.data.ValueHandle;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.output.DebuggerMessage;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.output.DebuggerMessageFactory;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.output.EvaluateMessage;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.output.LookupMessage;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.output.ScopeMessage;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.DataWithRef;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.HandleManager;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.LoadableString;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.PropertyReference;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.SubpropertiesMirror;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.ValueLoadException;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.ValueLoader;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.ValueMirror;
import org.eclipse.wst.jsdt.chromium.util.BasicUtil;
import org.eclipse.wst.jsdt.chromium.util.GenericCallback;
import org.eclipse.wst.jsdt.chromium.util.MethodIsBlockingException;
import org.json.simple.JSONObject;

public class ValueLoaderImpl
extends ValueLoader {
    private final ConcurrentMap<Long, ValueMirror> refToMirror = new ConcurrentHashMap<Long, ValueMirror>();
    private final HandleManager specialHandleManager = new HandleManager();
    private final InternalContext context;
    private final LoadableString.Factory loadableStringFactory;
    private final AtomicInteger cacheStateRef = new AtomicInteger(1);
    private static final boolean PRE_PARSE_PROPERTIES = false;

    public ValueLoaderImpl(InternalContext context) {
        this.context = context;
        this.loadableStringFactory = new StringFactory();
    }

    public LoadableString.Factory getLoadableStringFactory() {
        return this.loadableStringFactory;
    }

    public HandleManager getSpecialHandleManager() {
        return this.specialHandleManager;
    }

    @Override
    public void clearCaches() {
        this.cacheStateRef.incrementAndGet();
        this.refToMirror.clear();
    }

    @Override
    int getCurrentCacheState() {
        return this.cacheStateRef.get();
    }

    @Override
    public InternalContext getInternalContext() {
        return this.context;
    }

    public void addHandleFromRefs(SomeHandle handle) {
        if (HandleManager.isSpecialType(handle.type())) {
            this.specialHandleManager.put(handle.handle(), handle);
        } else {
            ValueHandle valueHandle;
            try {
                valueHandle = handle.asValueHandle();
            }
            catch (JsonProtocolParseException e) {
                throw new RuntimeException(e);
            }
            this.addDataToMap(valueHandle);
        }
    }

    public void addDisplayDataToMap(RefWithDisplayData refWithDisplayData) {
        ValueMirror mirror = ValueMirror.createIfSure(refWithDisplayData);
        if (mirror != null) {
            this.mergeValueMirrorIntoMap(mirror.getRef(), mirror);
        }
    }

    public ValueMirror addDataToMap(ValueHandle valueHandle) {
        ValueMirror mirror = ValueMirror.create(valueHandle, this.getLoadableStringFactory());
        return this.putValueMirrorIntoMapRecursive(mirror);
    }

    public ValueMirror addDataToMap(Long ref, JsValue.Type type, String className, LoadableString loadableString, SubpropertiesMirror subpropertiesMirror) {
        ValueMirror mirror = ValueMirror.create(ref, type, className, loadableString, subpropertiesMirror);
        return this.putValueMirrorIntoMapRecursive(mirror);
    }

    private ValueMirror putValueMirrorIntoMapRecursive(ValueMirror mirror) {
        return this.mergeValueMirrorIntoMap(mirror.getRef(), mirror);
    }

    private ValueMirror mergeValueMirrorIntoMap(Long ref, ValueMirror mirror) {
        ValueMirror merged;
        ValueMirror old;
        boolean updated;
        do {
            if ((old = this.refToMirror.putIfAbsent(ref, mirror)) == null) {
                return mirror;
            }
            merged = ValueMirror.merge(old, mirror);
            if (merged != old) continue;
            return merged;
        } while (!(updated = this.refToMirror.replace(ref, old, merged)));
        return merged;
    }

    @Override
    public SubpropertiesMirror getOrLoadSubproperties(Long ref) throws MethodIsBlockingException {
        List<ValueMirror> loadedMirrors;
        ValueMirror loadedMirror;
        ValueMirror mirror = BasicUtil.getSafe(this.refToMirror, ref);
        SubpropertiesMirror references = mirror == null ? null : mirror.getProperties();
        if (references == null && (references = (loadedMirror = (loadedMirrors = this.loadValuesFromRemote(Collections.singletonList(ref))).get(0)).getProperties()) == null) {
            throw new RuntimeException("Failed to load properties");
        }
        return references;
    }

    public ObjectValueHandle loadScopeFields(ScopeMessage.Ref scopeRef) throws MethodIsBlockingException {
        ScopeMessage message = new ScopeMessage(scopeRef);
        V8BlockingCallback<ObjectValueHandle> callback = new V8BlockingCallback<ObjectValueHandle>(){

            @Override
            protected ObjectValueHandle handleSuccessfulResponse(SuccessCommandResponse response) {
                return ValueLoaderImpl.this.readFromScopeResponse(response);
            }
        };
        try {
            return V8Helper.callV8Sync(this.context, message, callback);
        }
        catch (InternalContext.ContextDismissedCheckedException e) {
            this.context.getDebugSession().maybeRethrowContextException(e);
            return null;
        }
    }

    private ObjectValueHandle readFromScopeResponse(SuccessCommandResponse response) {
        ScopeBody body;
        List<SomeHandle> refs = response.refs();
        for (SomeHandle handle : refs) {
            this.addHandleFromRefs(handle);
        }
        try {
            body = response.body().asScopeBody();
        }
        catch (JsonProtocolParseException e) {
            throw new ValueLoadException(e);
        }
        return body.object();
    }

    @Override
    public List<ValueMirror> getOrLoadValueFromRefs(List<? extends PropertyReference> propertyRefs) throws MethodIsBlockingException {
        ValueMirror[] result = new ValueMirror[propertyRefs.size()];
        HashMap<Long, Integer> refToRequestIndex = new HashMap<Long, Integer>();
        ArrayList<PropertyReference> needsLoading = new ArrayList<PropertyReference>();
        int i = 0;
        while (i < propertyRefs.size()) {
            RefWithDisplayData dataWithDisplayData;
            PropertyReference property = propertyRefs.get(i);
            DataWithRef dataWithRef = property.getValueObject();
            long ref = dataWithRef.ref();
            ValueMirror mirror = BasicUtil.getSafe(this.refToMirror, ref);
            if (mirror == null && (dataWithDisplayData = dataWithRef.getWithDisplayData()) != null) {
                mirror = ValueMirror.createIfSure(dataWithDisplayData);
            }
            if (mirror == null) {
                Integer requestPos = (Integer)BasicUtil.getSafe(refToRequestIndex, ref);
                if (requestPos == null) {
                    refToRequestIndex.put(ref, needsLoading.size());
                    needsLoading.add(property);
                }
            } else {
                result[i] = mirror;
            }
            ++i;
        }
        if (!needsLoading.isEmpty()) {
            List<Long> refIds = ValueLoaderImpl.getRefIdFromReferences(needsLoading);
            List<ValueMirror> loadedMirrors = this.loadValuesFromRemote(refIds);
            assert (refIds.size() == loadedMirrors.size());
            int i2 = 0;
            while (i2 < propertyRefs.size()) {
                if (result[i2] == null) {
                    PropertyReference property = propertyRefs.get(i2);
                    DataWithRef dataWithRef = property.getValueObject();
                    Long ref = dataWithRef.ref();
                    int pos = (Integer)BasicUtil.getSafe(refToRequestIndex, ref);
                    result[i2] = loadedMirrors.get(pos);
                }
                ++i2;
            }
        }
        return Arrays.asList(result);
    }

    private static List<Long> getRefIdFromReferences(List<PropertyReference> propertyRefs) {
        ArrayList<Long> result = new ArrayList<Long>(propertyRefs.size());
        for (PropertyReference ref : propertyRefs) {
            result.add(ref.getRef());
        }
        return result;
    }

    public List<ValueMirror> loadValuesFromRemote(final List<Long> propertyRefIds) throws MethodIsBlockingException {
        if (propertyRefIds.isEmpty()) {
            return Collections.emptyList();
        }
        DebuggerMessage message = DebuggerMessageFactory.lookup(propertyRefIds, false);
        V8BlockingCallback<List<ValueMirror>> callback = new V8BlockingCallback<List<ValueMirror>>(){

            @Override
            protected List<ValueMirror> handleSuccessfulResponse(SuccessCommandResponse response) {
                return ValueLoaderImpl.this.readResponseFromLookup(response, propertyRefIds);
            }
        };
        try {
            return V8Helper.callV8Sync(this.context, message, callback);
        }
        catch (InternalContext.ContextDismissedCheckedException e) {
            this.context.getDebugSession().maybeRethrowContextException(e);
            throw new ValueLoadException("Invalid context", e);
        }
    }

    private List<ValueMirror> readResponseFromLookup(SuccessCommandResponse successResponse, List<Long> propertyRefIds) {
        JSONObject body;
        ArrayList<ValueMirror> result = new ArrayList<ValueMirror>(propertyRefIds.size());
        try {
            body = successResponse.body().asLookupMap();
        }
        catch (JsonProtocolParseException e) {
            throw new ValueLoadException(e);
        }
        int i = 0;
        while (i < propertyRefIds.size()) {
            ValueHandle valueHandle;
            int ref = propertyRefIds.get(i).intValue();
            JSONObject value = JsonUtil.getAsJSON(body, String.valueOf(ref));
            if (value == null) {
                throw new ValueLoadException("Failed to find value for ref=" + ref);
            }
            try {
                valueHandle = V8ProtocolParserAccess.get().parseValueHandle(value);
            }
            catch (JsonProtocolParseException e) {
                throw new RuntimeException(e);
            }
            long refLong = valueHandle.handle();
            if (refLong != (long)ref) {
                throw new ValueLoadException("Inconsistent ref in response, ref=" + ref);
            }
            ValueMirror mirror = this.addDataToMap(valueHandle);
            result.add(mirror);
            ++i;
        }
        return result;
    }

    private List<ValueHandle> readResponseFromLookupRaw(SuccessCommandResponse successResponse, List<Long> propertyRefIds) {
        JSONObject body;
        ArrayList<ValueHandle> result = new ArrayList<ValueHandle>(propertyRefIds.size());
        try {
            body = successResponse.body().asLookupMap();
        }
        catch (JsonProtocolParseException e) {
            throw new ValueLoadException(e);
        }
        int i = 0;
        while (i < propertyRefIds.size()) {
            ValueHandle valueHandle;
            int ref = propertyRefIds.get(i).intValue();
            JSONObject value = JsonUtil.getAsJSON(body, String.valueOf(ref));
            if (value == null) {
                throw new ValueLoadException("Failed to find value for ref=" + ref);
            }
            try {
                valueHandle = V8ProtocolParserAccess.get().parseValueHandle(value);
            }
            catch (JsonProtocolParseException e) {
                throw new ValueLoadException(e);
            }
            this.addDataToMap(valueHandle);
            result.add(valueHandle);
            ++i;
        }
        return result;
    }

    private RelayOk relookupValue(long handleId, Long maxLength, final GenericCallback<ValueHandle> callback, SyncCallback syncCallback) throws InternalContext.ContextDismissedCheckedException {
        final List<Long> ids = Collections.singletonList(handleId);
        LookupMessage message = new LookupMessage(ids, false, maxLength);
        V8CommandCallbackBase innerCallback = new V8CommandCallbackBase(){

            @Override
            public void success(SuccessCommandResponse successResponse) {
                List handleList = ValueLoaderImpl.this.readResponseFromLookupRaw(successResponse, ids);
                callback.success((ValueHandle)handleList.get(0));
            }

            @Override
            public void failure(String message, FailedCommandResponse.ErrorDetails errorDetails) {
                callback.failure(new Exception(message));
            }
        };
        return this.context.sendV8CommandAsync(message, true, (V8CommandProcessor.V8HandlerCallback)innerCallback, syncCallback);
    }

    private class StringFactory
    implements LoadableString.Factory {
        private StringFactory() {
        }

        @Override
        public LoadableString create(ValueHandle handle) {
            final long handleId = handle.handle();
            LoadedValue initialValue = new LoadedValue(handle);
            return new LoadableString(initialValue){
                private final AtomicReference<LoadedValue> valueRef;
                {
                    this.valueRef = new AtomicReference<LoadedValue>(loadedValue);
                }

                @Override
                public String getCurrentString() {
                    return this.valueRef.get().stringValue;
                }

                @Override
                public boolean needsReload() {
                    LoadedValue loadedValue = this.valueRef.get();
                    return loadedValue.loadedSize < loadedValue.actualSize;
                }

                @Override
                public RelayOk reloadBigger(final GenericCallback<Void> callback, SyncCallback syncCallback) {
                    long currentlyLoadedSize = this.valueRef.get().loadedSize;
                    long newRequstedSize = this.chooseNewMaxStringLength(currentlyLoadedSize);
                    GenericCallback<ValueHandle> innerCallback = new GenericCallback<ValueHandle>(){

                        @Override
                        public void success(ValueHandle handle) {
                            LoadedValue newLoadedValue = new LoadedValue(handle);
                            this.replaceValue(handle, newLoadedValue);
                            if (callback != null) {
                                callback.success(null);
                            }
                        }

                        @Override
                        public void failure(Exception e) {
                            if (callback != null) {
                                callback.failure(new Exception(e));
                            }
                        }
                    };
                    try {
                        return ValueLoaderImpl.this.relookupValue(handleId, newRequstedSize, innerCallback, syncCallback);
                    }
                    catch (InternalContext.ContextDismissedCheckedException e) {
                        DebugSession debugSession = ValueLoaderImpl.this.context.getDebugSession();
                        debugSession.maybeRethrowContextException(e);
                        return debugSession.sendLoopbackMessage(new Runnable(){

                            @Override
                            public void run() {
                                if (callback != null) {
                                    callback.failure(e);
                                }
                            }
                        }, syncCallback);
                    }
                }

                @Override
                public EvaluateMessage.Value getProtocolDescription(InternalContext hostInternalContext) {
                    hostInternalContext.checkContextIsCompatible(ValueLoaderImpl.this.context);
                    return EvaluateMessage.Value.createForId(handleId);
                }

                private void replaceValue(ValueHandle handle, LoadedValue newValue) {
                    LoadedValue currentValue;
                    boolean updated;
                    do {
                        currentValue = this.valueRef.get();
                        if (currentValue.loadedSize < newValue.loadedSize) continue;
                        return;
                    } while (!(updated = this.valueRef.compareAndSet(currentValue, newValue)));
                }

                private long chooseNewMaxStringLength(long currentSize) {
                    return Math.max(currentSize * 10L, 65536L);
                }
            };
        }

        private class LoadedValue {
            final String stringValue;
            final long loadedSize;
            final long actualSize;

            LoadedValue(ValueHandle handle) {
                this.stringValue = (String)handle.value();
                Long toIndex = handle.toIndex();
                if (toIndex == null) {
                    this.actualSize = this.loadedSize = (long)this.stringValue.length();
                } else {
                    this.loadedSize = toIndex;
                    this.actualSize = handle.length();
                }
            }
        }
    }
}

