/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.vue;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4e.client.DefaultLanguageClient;
import org.eclipse.lsp4j.ConfigurationItem;
import org.eclipse.lsp4j.ConfigurationParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.wildwebdeveloper.css.ui.preferences.CSSPreferenceServerConstants;
import org.eclipse.wildwebdeveloper.html.ui.preferences.HTMLPreferenceServerConstants;
import org.eclipse.wildwebdeveloper.ui.preferences.Settings;
import org.eclipse.wildwebdeveloper.vue.VueLanguageServerExtension;

public class VueClientImpl
extends DefaultLanguageClient
implements VueLanguageServerExtension {
    @Override
    public void projectLoadingFinish(Object object) {
        this.logMessage(new MessageParams(MessageType.Info, "Vue project loading finished"));
    }

    @Override
    public void projectLoadingStart(Object object) {
        this.logMessage(new MessageParams(MessageType.Info, "Vue project loading started"));
    }

    @Override
    public void projectLanguageService(Map<String, Object> data) {
        this.logMessage(new MessageParams(MessageType.Info, "Language Service is " + ((Boolean)data.get("languageServiceEnabled") != false ? "" : "not yet ") + "enabled for project " + String.valueOf(data.get("projectName"))));
    }

    @Override
    public void tsserverRequest(Object[] params) {
        this.logMessage(new MessageParams(MessageType.Info, "Forward TS message " + String.valueOf(params[0])));
    }

    public CompletableFuture<List<Object>> configuration(ConfigurationParams params) {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<Object> settings = new ArrayList<Object>();
            for (ConfigurationItem item : params.getItems()) {
                String section = item.getSection();
                if (HTMLPreferenceServerConstants.isMatchHtmlSection(section)) {
                    Settings htmlSettings = HTMLPreferenceServerConstants.getGlobalSettings();
                    settings.add(htmlSettings.findSettings(section.split("[.]")));
                    continue;
                }
                if (CSSPreferenceServerConstants.isMatchCssSection(section)) {
                    Settings cssSettings = CSSPreferenceServerConstants.getGlobalSettings();
                    settings.add(cssSettings.findSettings(section.split("[.]")));
                    continue;
                }
                if (section.equals("vue.suggest.defineAssignment")) {
                    settings.add(true);
                    continue;
                }
                if (section.equals("vue.suggest.propNameCasing")) {
                    settings.add("preferKebabCase");
                    continue;
                }
                if (section.equals("vue.suggest.componentNameCasing")) {
                    settings.add("preferPascalCase");
                    continue;
                }
                settings.add(null);
            }
            return settings;
        });
    }
}

