/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.wb.internal.core.utils.GenericTypeResolver;
import org.eclipse.wb.internal.core.utils.check.Assert;

public final class GenericsUtils {
    private GenericsUtils() {
    }

    public static <T> T first(ISelection selection) {
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        return (T)structuredSelection.getFirstElement();
    }

    public static <T> Iterable<T> iterable(ISelection selection) {
        final IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(structuredSelection){
                    Iterator<?> iterator;
                    {
                        this.iterator = iStructuredSelection.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public T next() {
                        return this.iterator.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static <T> Iterable<T> iterableSelection(ISelectionProvider selectionProvider) {
        ISelection selection = selectionProvider.getSelection();
        return GenericsUtils.iterable(selection);
    }

    public static <T> T get(Class<T> clazz, Object ... objects) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (GenericsUtils.isAssignable(clazz, object)) {
                return (T)object;
            }
            ++n2;
        }
        return null;
    }

    public static <T> T get(Class<T> clazz, List<?> objects) {
        for (Object object : objects) {
            if (!GenericsUtils.isAssignable(clazz, object)) continue;
            return (T)object;
        }
        return null;
    }

    private static boolean isAssignable(Class<?> clazz, Object object) {
        return object != null && clazz.isAssignableFrom(object.getClass());
    }

    public static <T> List<T> select(Collection<? super T> source, Class<T> clazz) {
        ArrayList<T> result = new ArrayList<T>();
        for (T object : source) {
            if (object == null || !clazz.isAssignableFrom(object.getClass())) continue;
            result.add(object);
        }
        return result;
    }

    public static <T> List<T> cast(Collection<?> source) {
        ArrayList result = new ArrayList();
        for (Object object : source) {
            result.add(object);
        }
        return result;
    }

    public static <T> List<T> asList(T[] elements, T element) {
        ArrayList<T> list = new ArrayList<T>();
        if (elements != null) {
            T[] TArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                T t = TArray[n2];
                list.add(t);
                ++n2;
            }
        }
        list.add(element);
        return list;
    }

    public static <T, E extends T> List<T> singletonList(E element) {
        if (element == null) {
            return Collections.emptyList();
        }
        return List.of(element);
    }

    public static <T> T getPrevOrNull(List<T> elements, int index) {
        Assert.isLegal(index >= 0 && index < elements.size());
        if (index > 0) {
            return elements.get(index - 1);
        }
        return null;
    }

    public static <T> T getPrevOrNull(List<? extends T> elements, T element) {
        int index = elements.indexOf(element);
        if (index == -1) {
            return null;
        }
        return GenericsUtils.getPrevOrNull(elements, index);
    }

    public static <T> T getPrevOrLast(List<? extends T> elements, T element) {
        if (elements.isEmpty()) {
            return null;
        }
        T prev = GenericsUtils.getPrevOrNull(elements, element);
        if (prev != null) {
            return prev;
        }
        return elements.get(elements.size() - 1);
    }

    public static <T> T getNextOrNull(List<T> elements, int index) {
        Assert.isLegal(index >= 0 && index < elements.size());
        if (index < elements.size() - 1) {
            return elements.get(index + 1);
        }
        return null;
    }

    public static <T> T getNextOrNull(List<? extends T> elements, T element) {
        int index = elements.indexOf(element);
        if (index == -1) {
            return null;
        }
        return GenericsUtils.getNextOrNull(elements, index);
    }

    public static <T> T getNextOrFirst(List<? extends T> elements, T element) {
        if (elements.isEmpty()) {
            return null;
        }
        T prev = GenericsUtils.getNextOrNull(elements, element);
        if (prev != null) {
            return prev;
        }
        return elements.get(0);
    }

    public static <T> T getFirstOrNull(List<T> elements) {
        return elements.isEmpty() ? null : (T)elements.get(0);
    }

    public static <T> T getLastOrNull(List<T> elements) {
        return elements.isEmpty() ? null : (T)elements.get(elements.size() - 1);
    }

    public static <T> T getLast(List<T> elements) {
        return elements.get(elements.size() - 1);
    }

    public static <T> boolean areAdjacent(List<T> allElements, List<T> elements) {
        int prevIndex = -1;
        for (T element : elements) {
            if (prevIndex == -1) {
                prevIndex = allElements.indexOf(element);
                continue;
            }
            int index = allElements.indexOf(element);
            if (index != prevIndex + 1) {
                return false;
            }
            prevIndex = index;
        }
        return true;
    }

    public static <T extends Enum<?>> String[] getEnumStrings(T ... values) {
        String[] fieldNames = new String[values.length];
        int i = 0;
        while (i < values.length) {
            T value = values[i];
            fieldNames[i] = ((Enum)value).toString();
            ++i;
        }
        return fieldNames;
    }

    public static <T extends Enum<?>> T[] getEnumValues(Class<T> enumClass, String ... strings) {
        Enum[] values = (Enum[])Array.newInstance(enumClass, strings.length);
        int i = 0;
        while (i < strings.length) {
            String s = strings[i];
            Enum value = GenericsUtils.getEnumValue((String)s, (Enum[])((Enum[])enumClass.getEnumConstants()));
            Assert.isNotNull(value, "No value for %s in %s.", s, enumClass);
            values[i] = value;
            ++i;
        }
        return values;
    }

    public static <T extends Enum<?>> T getEnumValue(String s, T ... values) {
        T[] TArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            T value = TArray[n2];
            if (((Enum)value).toString().equals(s)) {
                return value;
            }
            ++n2;
        }
        return null;
    }

    public static <T extends Enum<?>> T[] getEnumValues(Class<T> enumClass, Predicate<T> predicate) {
        ArrayList<Enum> selectedElements = new ArrayList<Enum>();
        Enum[] enumArray = (Enum[])enumClass.getEnumConstants();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enum element = enumArray[n2];
            if (predicate.test(element)) {
                selectedElements.add(element);
            }
            ++n2;
        }
        return selectedElements.toArray((Enum[])Array.newInstance(enumClass, selectedElements.size()));
    }

    public static String[] getTypeNames(GenericTypeResolver resolver, Type[] types) {
        String[] names = new String[types.length];
        int i = 0;
        while (i < types.length) {
            Type type = types[i];
            names[i] = GenericsUtils.getTypeName(resolver, type);
            ++i;
        }
        return names;
    }

    public static String getTypeName(GenericTypeResolver resolver, Type type) {
        return resolver.resolve(type);
    }
}

