/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.instanceScope;

import java.util.ArrayList;
import java.util.Stack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.ocl.ecore.CollectionItem;
import org.eclipse.ocl.ecore.CollectionLiteralExp;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.examples.impactanalyzer.impl.OperationBodyToCallMapper;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.AbstractTracer;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.EmptyResultNavigationStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.NavigationStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.PathCache;
import org.eclipse.ocl.examples.impactanalyzer.util.OCLFactory;
import org.eclipse.ocl.expressions.CollectionLiteralPart;

public class CollectionLiteralExpTracer
extends AbstractTracer<CollectionLiteralExp> {
    public CollectionLiteralExpTracer(CollectionLiteralExp expression, Stack<String> tuplePartNames, OCLFactory oclFactory) {
        super(expression, tuplePartNames, oclFactory);
    }

    @Override
    public NavigationStep traceback(EClass context, PathCache pathCache, OperationBodyToCallMapper operationBodyToCallMapper) {
        NavigationStep result;
        EList parts = ((CollectionLiteralExp)this.getExpression()).getPart();
        ArrayList<NavigationStep> steps = new ArrayList<NavigationStep>();
        for (CollectionLiteralPart part : parts) {
            if (!(part instanceof CollectionItem)) continue;
            steps.add((NavigationStep)pathCache.getOrCreateNavigationPath((OCLExpression)((CollectionItem)part).getItem(), context, operationBodyToCallMapper, this.getTupleLiteralPartNamesToLookFor(), this.oclFactory));
        }
        if (((CollectionLiteralExp)this.getExpression()).getPart().size() > 0) {
            EClass innermostType = this.getInnermostElementType((EClassifier)((CollectionLiteralExp)this.getExpression()).getType());
            result = pathCache.navigationStepForBranch(innermostType, context, (OCLExpression)this.getExpression(), this.getTupleLiteralPartNamesToLookFor(), false, steps.toArray(new NavigationStep[0]));
        } else {
            result = new EmptyResultNavigationStep((OCLExpression)this.getExpression());
        }
        this.applyScopesOnNavigationStep(result, operationBodyToCallMapper);
        return result;
    }
}

