/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.internal.ui.views;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.net4j.ui.shared.SharedIcons;
import org.eclipse.net4j.util.HexUtil;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.internal.ui.bundle.OM;
import org.eclipse.net4j.util.internal.ui.messages.Messages;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.actions.ToggleAction;
import org.eclipse.net4j.util.ui.views.IntrospectionProvider;
import org.eclipse.net4j.util.ui.views.RowIntrospectionProvider;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;

public class Net4jIntrospectorView
extends ViewPart {
    public static final String VIEW_ID = "org.eclipse.net4j.util.Net4jIntrospectorView";
    private static final Object[] NO_ELEMENTS = new Object[0];
    private static final IntrospectionProvider ARRAY_INTROSPECTION_PROVIDER = new ArrayIntrospectionProvider();
    private static final IntrospectionProvider OBJECT_INTROSPECTION_PROVIDER = new ObjectIntrospectionProvider();
    private static final List<IntrospectionProvider> DEFAULT_INTROSPECTION_PROVIDERS = Arrays.asList(ARRAY_INTROSPECTION_PROVIDER, OBJECT_INTROSPECTION_PROVIDER);
    private static Net4jIntrospectorView instance;
    private final IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            if (part == Net4jIntrospectorView.this) {
                return;
            }
            Net4jIntrospectorView.this.activePart = part;
            if (Net4jIntrospectorView.this.activePartAction.isChecked()) {
                Net4jIntrospectorView.this.history.clear();
                Net4jIntrospectorView.this.setValue(Net4jIntrospectorView.this.activePart);
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
            if (Net4jIntrospectorView.this.activePartAction.isChecked()) {
                IWorkbenchPart newPart = part.getSite().getPage().getActivePart();
                if (newPart == Net4jIntrospectorView.this) {
                    return;
                }
                if (part == Net4jIntrospectorView.this.activePart) {
                    Net4jIntrospectorView.this.activePart = null;
                    Net4jIntrospectorView.this.setValue(null);
                }
            }
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }
    };
    private final ISelectionListener pageSelectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection sel) {
            if (part == Net4jIntrospectorView.this) {
                return;
            }
            if (Net4jIntrospectorView.this.activePartAction.isChecked()) {
                return;
            }
            Object pageSelection = this.getPageSelection(sel);
            if (pageSelection != Net4jIntrospectorView.this.lastPageSelection) {
                Net4jIntrospectorView.this.lastPageSelection = pageSelection;
                Net4jIntrospectorView.this.history.clear();
                if (Net4jIntrospectorView.this.linkSelectionAction.isChecked()) {
                    Net4jIntrospectorView.this.setValue(Net4jIntrospectorView.this.lastPageSelection);
                }
            }
        }

        private Object getPageSelection(ISelection sel) {
            if (sel.isEmpty()) {
                return null;
            }
            if (sel instanceof IStructuredSelection) {
                IStructuredSelection ssel = (IStructuredSelection)sel;
                if (ssel.size() == 1) {
                    return ssel.getFirstElement();
                }
                return ssel.toList();
            }
            return sel;
        }
    };
    private final History history = new History();
    private final Map<IntrospectionProvider, TableViewer> viewers = new HashMap<IntrospectionProvider, TableViewer>();
    private final Map<IntrospectionProvider, MenuManager> menuManagers = new HashMap<IntrospectionProvider, MenuManager>();
    private final List<IntrospectionProvider> providers = new ArrayList<IntrospectionProvider>();
    private IntrospectionProvider currentProvider;
    private Object currentValue;
    private String currentName;
    private Text classLabel;
    private Text identityLabel;
    private Text objectLabel;
    private final IAction copyAction = new CopyAction();
    private final IAction backwardAction = new BackwardAction();
    private final IAction forwardAction = new ForwardAction();
    private final IAction logicalStructureAction = new LogicalStructureAction();
    private final IAction activePartAction = new ActivePartAction();
    private final IAction linkSelectionAction = new LinkSelectionAction();
    private final IAction containerAction = new ContainerAction();
    private final IAction refreshAction = new RefreshAction();
    private StackLayout stackLayout;
    private Composite stacked;
    private IWorkbenchPart activePart;
    private Object lastPageSelection;

    public Net4jIntrospectorView() {
        IPluginContainer.INSTANCE.forEachElement("org.eclipse.net4j.util.ui.introspectionProviders", IntrospectionProvider.class, this.providers::add);
        this.providers.sort(null);
        this.providers.addAll(DEFAULT_INTROSPECTION_PROVIDERS);
    }

    public void dispose() {
        instance = null;
        this.detachListener();
        IWorkbenchPage page = this.getSite().getPage();
        page.removePartListener(this.partListener);
        page.removeSelectionListener(this.pageSelectionListener);
        super.dispose();
    }

    public Object getValue() {
        return this.currentValue;
    }

    public void setValue(Object value) {
        if (this.currentValue == value) {
            return;
        }
        this.detachListener();
        if (value == null) {
            this.classLabel.setText("");
            this.identityLabel.setText("");
            this.objectLabel.setText("");
        } else {
            Class<?> c = value.getClass();
            String className = c.isArray() ? c.getComponentType().getName() + "[]" : c.getName();
            this.classLabel.setText(className);
            String identity = HexUtil.identityHashCode((Object)value, (boolean)true);
            this.identityLabel.setText(identity);
            String label = this.getLabel(value, identity);
            this.objectLabel.setText(label);
        }
        this.classLabel.getParent().layout();
        this.currentValue = value;
        this.updateEnablements();
        this.updateProvider();
        this.attachListener();
    }

    public void createPartControl(Composite parent) {
        Display display = parent.getDisplay();
        Color bg = display.getSystemColor(25);
        Color gray = display.getSystemColor(10);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)UIUtil.createGridLayout(1));
        Composite c = new Composite(composite, 2048);
        c.setLayout((Layout)UIUtil.createGridLayout(3));
        c.setLayoutData((Object)UIUtil.createGridData(true, false));
        this.classLabel = new Text(c, 8);
        this.classLabel.setLayoutData((Object)UIUtil.createGridData(false, false));
        this.classLabel.setBackground(bg);
        this.classLabel.setForeground(gray);
        this.identityLabel = new Text(c, 8);
        this.identityLabel.setLayoutData((Object)UIUtil.createGridData(false, false));
        this.identityLabel.setBackground(bg);
        this.objectLabel = new Text(c, 8);
        this.objectLabel.setLayoutData((Object)UIUtil.createGridData(true, false));
        this.objectLabel.setBackground(bg);
        this.stackLayout = new StackLayout();
        this.stacked = new Composite(composite, 0);
        this.stacked.setLayoutData((Object)UIUtil.createGridData());
        this.stacked.setLayout((Layout)this.stackLayout);
        for (IntrospectionProvider provider : this.providers) {
            TableViewer viewer = provider.createViewer(this.stacked);
            provider.createColumns(viewer);
            viewer.setContentProvider((IContentProvider)new IntrospectionContentProvider(provider));
            viewer.setLabelProvider((IBaseLabelProvider)new IntrospectionLabelProvider(provider));
            viewer.setInput((Object)this.getViewSite());
            viewer.addSelectionChangedListener(e -> {
                Object element = viewer.getStructuredSelection().getFirstElement();
                try {
                    IntrospectionProvider.NameAndValue nameAndValue = this.currentProvider.getNameAndValue(element);
                    if (nameAndValue != null) {
                        this.currentName = nameAndValue.getName();
                    }
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
            });
            Control control = viewer.getControl();
            control.addListener(14, e -> {
                Object element = viewer.getStructuredSelection().getFirstElement();
                provider.open(e, this.currentValue, element, elem -> this.open(elem));
            });
            control.addKeyListener(KeyListener.keyPressedAdapter(e -> {
                if ((e.keyCode == 0x1000003 || e.character == '\b') && this.backwardAction.isEnabled()) {
                    this.backwardAction.run();
                } else if (e.keyCode == 0x1000004 && this.forwardAction.isEnabled()) {
                    this.forwardAction.run();
                }
            }));
            ViewerComparator comparator = provider.getComparator();
            if (comparator != null) {
                viewer.setComparator(comparator);
            }
            this.viewers.put(provider, viewer);
            this.menuManagers.put(provider, this.hookContextMenu(viewer));
        }
        this.linkSelectionAction.setEnabled(!this.activePartAction.isChecked());
        IActionBars bars = this.getViewSite().getActionBars();
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.copyAction);
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
        IWorkbenchPage page = this.getSite().getPage();
        page.addPartListener(this.partListener);
        page.addSelectionListener(this.pageSelectionListener);
        this.setCurrentProvider(OBJECT_INTROSPECTION_PROVIDER);
        this.updateEnablements();
        instance = this;
    }

    public void setFocus() {
        try {
            TableViewer currentViewer = this.getCurrentViewer();
            if (currentViewer != null) {
                currentViewer.getControl().setFocus();
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private void open(Object element) {
        try {
            IntrospectionProvider.NameAndValue nameAndValue = this.currentProvider.getNameAndValue(element);
            if (nameAndValue != null) {
                this.history.open(nameAndValue.getName(), this.currentValue);
                this.setValue(nameAndValue.getValue());
            }
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
        }
    }

    private void goBackward() {
        IntrospectionProvider.NameAndValue nameAndValue = this.history.goBackward(this.currentName, this.currentValue);
        if (nameAndValue != null) {
            this.setValue(nameAndValue.getValue());
            this.selectElement(this.currentValue, nameAndValue.getName());
        }
    }

    private void goForward() {
        IntrospectionProvider.NameAndValue nameAndValue = this.history.goForward(this.currentName, this.currentValue);
        if (nameAndValue != null) {
            this.setValue(nameAndValue.getValue());
            this.selectElement(this.currentValue, nameAndValue.getName());
        }
    }

    private void selectElement(Object parent, String name) {
        try {
            Object element = this.currentProvider.getElementByName(parent, name);
            if (element != null) {
                this.currentName = name;
                TableViewer viewer = this.getCurrentViewer();
                Display display = viewer.getControl().getDisplay();
                UIUtil.asyncExec(display, () -> viewer.setSelection((ISelection)new StructuredSelection(element), true));
            } else {
                this.currentName = null;
            }
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
        }
    }

    private void refreshViewer() {
        UIUtil.refreshViewer((Viewer)this.getCurrentViewer());
    }

    private String getLabel(Object value, String identity) {
        String prefix;
        String str = StringUtil.safe((Object)value);
        if (str.startsWith(prefix = value.getClass().getName() + "@")) {
            String text = str.substring(prefix.length());
            if (identity.endsWith(text)) {
                text = "";
            } else if (text.startsWith(identity)) {
                text = text.substring(identity.length());
            }
            return text.trim();
        }
        return str;
    }

    private TableViewer getCurrentViewer() {
        return this.viewers.get(this.currentProvider);
    }

    private void setCurrentProvider(IntrospectionProvider provider) {
        if (this.currentProvider != provider) {
            TableViewer currentViewer = this.getCurrentViewer();
            boolean hadFocus = currentViewer == null ? false : currentViewer.getControl().isFocusControl();
            this.currentProvider = provider;
            currentViewer = this.getCurrentViewer();
            MenuManager menuManager = this.menuManagers.get(this.currentProvider);
            this.getSite().registerContextMenu(menuManager, (ISelectionProvider)currentViewer);
            this.stackLayout.topControl = currentViewer.getControl();
            this.stacked.layout();
            if (hadFocus) {
                this.setFocus();
            }
        }
    }

    private void updateProvider() {
        IntrospectionProvider result = OBJECT_INTROSPECTION_PROVIDER;
        if (this.currentValue != null) {
            List<IntrospectionProvider> providersToUse = this.logicalStructureAction.isChecked() ? this.providers : DEFAULT_INTROSPECTION_PROVIDERS;
            for (IntrospectionProvider provider : providersToUse) {
                if (!provider.canHandle(this.currentValue)) continue;
                result = provider;
                break;
            }
        }
        this.setCurrentProvider(result);
        this.refreshViewer();
    }

    private void updateEnablements() {
        this.backwardAction.setEnabled(this.history.canGoBackward());
        this.forwardAction.setEnabled(this.history.canGoForward());
    }

    private void attachListener() {
        TableViewer viewer;
        if (this.currentValue != null && (viewer = this.getCurrentViewer()) != null) {
            this.currentProvider.attachListener(viewer, this.currentValue);
        }
    }

    private void detachListener() {
        TableViewer viewer;
        if (this.currentValue != null && (viewer = this.getCurrentViewer()) != null) {
            this.currentProvider.detachListener(viewer, this.currentValue);
        }
    }

    private MenuManager hookContextMenu(TableViewer viewer) {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Net4jIntrospectorView.this.fillContextMenu(manager);
            }
        });
        Control control = viewer.getControl();
        Menu menu = menuManager.createContextMenu(control);
        control.setMenu(menu);
        return menuManager;
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add(this.copyAction);
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add(this.containerAction);
        manager.add(this.refreshAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add(this.backwardAction);
        manager.add(this.forwardAction);
        manager.add((IContributionItem)new Separator());
        manager.add(this.logicalStructureAction);
        manager.add(this.activePartAction);
        manager.add(this.linkSelectionAction);
    }

    public static Net4jIntrospectorView getInstance() {
        return instance;
    }

    public static synchronized Net4jIntrospectorView getInstance(boolean show) {
        if (instance == null) {
            try {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                page.showView(VIEW_ID);
            }
            catch (Exception ex) {
                throw WrappedException.wrap((Exception)ex);
            }
        }
        return instance;
    }

    private final class ActivePartAction
    extends ToggleAction {
        public ActivePartAction() {
            super(Messages.getString("Net4jIntrospectorView_17b"), SharedIcons.getDescriptor((String)"etool16/part_mode"), OM.PREF_ACTIVE_PART);
        }

        @Override
        protected void run(boolean checked) {
            if (checked) {
                Net4jIntrospectorView.this.history.clear();
                Net4jIntrospectorView.this.setValue(Net4jIntrospectorView.this.activePart);
            } else {
                Net4jIntrospectorView.this.setValue(Net4jIntrospectorView.this.lastPageSelection);
            }
            Net4jIntrospectorView.this.linkSelectionAction.setEnabled(!checked);
        }
    }

    public static final class ArrayIntrospectionProvider
    extends IntrospectionProvider {
        public ArrayIntrospectionProvider() {
            super("java.lang.Array", "Array");
        }

        @Override
        public int getPriority() {
            return Integer.MAX_VALUE;
        }

        @Override
        public boolean canHandle(Object object) {
            return object.getClass().isArray();
        }

        @Override
        public void createColumns(TableViewer viewer) {
            ArrayIntrospectionProvider.createColumn(viewer, Messages.getString("Net4jIntrospectorView_13"), 50);
            ArrayIntrospectionProvider.createColumn(viewer, Messages.getString("Net4jIntrospectorView_14"), 400);
            ArrayIntrospectionProvider.createColumn(viewer, Messages.getString("Net4jIntrospectorView_15"), 300);
        }

        @Override
        public Object[] getElements(Object parent) throws Exception {
            int length = Array.getLength(parent);
            Object[] result = new IntrospectionProvider.NameAndValue[length];
            int index = 0;
            while (index < length) {
                Object value = Array.get(parent, index);
                result[index] = new IntrospectionProvider.NameAndValue(index, value);
                ++index;
            }
            return result;
        }

        @Override
        public Object getElementByName(Object parent, String name) throws Exception {
            int index;
            try {
                index = Integer.parseInt(name);
            }
            catch (NumberFormatException ex) {
                return null;
            }
            Object element = Array.get(parent, index);
            return new IntrospectionProvider.NameAndValue(index, element);
        }

        @Override
        public IntrospectionProvider.NameAndValue getNameAndValue(Object element) throws Exception {
            return (IntrospectionProvider.NameAndValue)element;
        }

        @Override
        public String getColumnText(Object element, int index) throws Exception {
            IntrospectionProvider.NameAndValue nameAndValue = (IntrospectionProvider.NameAndValue)element;
            switch (index) {
                case 0: {
                    return nameAndValue.getName();
                }
                case 1: {
                    return ArrayIntrospectionProvider.formatValue(nameAndValue.getValue());
                }
                case 2: {
                    return ArrayIntrospectionProvider.getClassName(nameAndValue.getValue());
                }
            }
            return null;
        }
    }

    private final class BackwardAction
    extends Action {
        public BackwardAction() {
            super(Messages.getString("Net4jIntrospectorView_16"));
            ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
            this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_BACK"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_BACK_DISABLED"));
        }

        public void run() {
            Net4jIntrospectorView.this.goBackward();
        }
    }

    private final class ContainerAction
    extends Action {
        public ContainerAction() {
            super(Messages.getString("Net4jIntrospectorView_17"));
            this.setImageDescriptor(SharedIcons.getDescriptor((String)"view16/container"));
        }

        public void run() {
            Net4jIntrospectorView.this.setValue(IPluginContainer.INSTANCE);
        }
    }

    private final class CopyAction
    extends Action {
        public CopyAction() {
            super(Messages.getString("Net4jIntrospectorView_32"));
            this.setImageDescriptor(SharedIcons.getDescriptor((String)"etool16/copy.png"));
            this.setActionDefinitionId("org.eclipse.ui.edit.copy");
        }

        public void run() {
            TableViewer viewer = Net4jIntrospectorView.this.getCurrentViewer();
            StringBuilder builder = new StringBuilder();
            for (Object element : viewer.getStructuredSelection()) {
                try {
                    IntrospectionProvider.NameAndValue nameAndValue = Net4jIntrospectorView.this.currentProvider.getNameAndValue(element);
                    if (nameAndValue == null) continue;
                    StringUtil.appendSeparator((StringBuilder)builder, (String)StringUtil.NL);
                    builder.append(nameAndValue);
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
            Display display = viewer.getControl().getDisplay();
            UIUtil.copyToClipboard(display, builder.toString());
        }
    }

    private final class ForwardAction
    extends Action {
        public ForwardAction() {
            super(Messages.getString("Net4jIntrospectorView_16b"));
            ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
            this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_BACK"));
            this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_FORWARD"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_FORWARD_DISABLED"));
        }

        public void run() {
            Net4jIntrospectorView.this.goForward();
        }
    }

    private static final class History {
        private final Stack<IntrospectionProvider.NameAndValue> backward = new Stack();
        private final Stack<IntrospectionProvider.NameAndValue> forward = new Stack();

        public void open(String name, Object value) {
            IntrospectionProvider.NameAndValue toPush = new IntrospectionProvider.NameAndValue(name, value);
            if (!this.forward.isEmpty()) {
                IntrospectionProvider.NameAndValue peeked = this.forward.peek();
                if (peeked.equals(toPush)) {
                    this.forward.pop();
                } else {
                    this.forward.clear();
                }
            }
            this.backward.push(toPush);
        }

        public boolean canGoBackward() {
            return !this.backward.isEmpty();
        }

        public boolean canGoForward() {
            return !this.forward.isEmpty();
        }

        public IntrospectionProvider.NameAndValue goBackward(String currentName, Object currentObject) {
            if (this.backward.isEmpty()) {
                return null;
            }
            this.forward.push(new IntrospectionProvider.NameAndValue(currentName, currentObject));
            return this.backward.pop();
        }

        public IntrospectionProvider.NameAndValue goForward(String currentName, Object currentObject) {
            if (this.forward.isEmpty()) {
                return null;
            }
            this.backward.push(new IntrospectionProvider.NameAndValue(currentName, currentObject));
            return this.forward.pop();
        }

        public void clear() {
            this.backward.clear();
            this.forward.clear();
        }
    }

    private final class IntrospectionContentProvider
    implements IStructuredContentProvider {
        private final IntrospectionProvider provider;

        public IntrospectionContentProvider(IntrospectionProvider provider) {
            this.provider = provider;
        }

        public Object[] getElements(Object parent) {
            if (Net4jIntrospectorView.this.currentValue != null && this.provider.canHandle(Net4jIntrospectorView.this.currentValue)) {
                try {
                    Object[] result = this.provider.getElements(Net4jIntrospectorView.this.currentValue);
                    if (result != null) {
                        return result;
                    }
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
            return NO_ELEMENTS;
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private static final class IntrospectionLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IColorProvider {
        private final IntrospectionProvider provider;

        public IntrospectionLabelProvider(IntrospectionProvider provider) {
            this.provider = provider;
        }

        public String getColumnText(Object element, int index) {
            try {
                String result = this.provider.getColumnText(element, index);
                if (result != null) {
                    return result;
                }
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
            return "";
        }

        public Image getColumnImage(Object element, int index) {
            try {
                return this.provider.getColumnImage(element, index);
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
                return null;
            }
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }

        public Image getImage(Object element) {
            return this.getColumnImage(element, 0);
        }

        public Color getForeground(Object element) {
            return this.provider.getForeground(element);
        }

        public Color getBackground(Object element) {
            return this.provider.getBackground(element);
        }
    }

    private final class LinkSelectionAction
    extends ToggleAction {
        public LinkSelectionAction() {
            super(Messages.getString("Net4jIntrospectorView_31"), SharedIcons.getDescriptor((String)"etool16/link_with_editor"), OM.PREF_LINK_SELECTION);
        }

        @Override
        protected void run(boolean checked) {
            if (checked) {
                Net4jIntrospectorView.this.setValue(Net4jIntrospectorView.this.lastPageSelection);
            }
        }
    }

    private final class LogicalStructureAction
    extends ToggleAction {
        public LogicalStructureAction() {
            super(Messages.getString("Net4jIntrospectorView_30"), OM.getImageDescriptor("icons/logical_structure.png"), OM.PREF_LOGICAL_STRUCTURE);
        }

        @Override
        protected void run(boolean checked) {
            Net4jIntrospectorView.this.updateProvider();
        }
    }

    public static final class ObjectIntrospectionProvider
    extends RowIntrospectionProvider {
        public ObjectIntrospectionProvider() {
            super("java.lang.Object", "Object");
        }

        @Override
        public int getPriority() {
            return Integer.MAX_VALUE;
        }

        @Override
        public boolean canHandle(Object object) {
            return true;
        }

        @Override
        protected void fillRows(Object parent, List<RowIntrospectionProvider.Row> rows) throws Exception {
            ReflectUtil.dump((Object)parent, setting -> rows.add(ObjectIntrospectionProvider.createRow(setting)));
        }

        @Override
        public RowIntrospectionProvider.Row getElementByName(Object parent, String name) throws Exception {
            RowIntrospectionProvider.Row[] result = new RowIntrospectionProvider.Row[1];
            ReflectUtil.dump((Object)parent, setting -> {
                if (setting.getName().equals(name)) {
                    rowArray[0] = ObjectIntrospectionProvider.createRow(setting);
                    return false;
                }
                return true;
            });
            return result[0];
        }

        private static RowIntrospectionProvider.Row createRow(ReflectUtil.Setting setting) {
            Object value = setting.getValue();
            return new RowIntrospectionProvider.Row(setting.getName(), value, ObjectIntrospectionProvider.getName(setting.getType()), ObjectIntrospectionProvider.getClassName(value));
        }
    }

    private final class RefreshAction
    extends Action {
        public RefreshAction() {
            super("Refresh");
            this.setImageDescriptor(SharedIcons.getDescriptor((String)"etool16/refresh"));
        }

        public void run() {
            Net4jIntrospectorView.this.refreshViewer();
        }
    }
}

