/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ModelContent;
import org.eclipse.m2m.internal.qvt.oml.emf.util.WorkspaceUtils;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers.ChooserAdapter;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers.ISourceChooser;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers.Messages;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.controls.SelectUriControl;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.provider.EmfModelContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class ResourceSourceChooser
extends ChooserAdapter
implements ISourceChooser {
    private SelectUriControl myControl;
    protected IStructuredSelection myInitialSelection;
    private URI myUri;
    private final boolean myIsConsiderAdaptes;
    protected final ResourceSet myResourceSet;

    public ResourceSourceChooser(boolean isConsiderAdapters, ResourceSet rs) {
        this.myIsConsiderAdaptes = isConsiderAdapters;
        this.myResourceSet = rs;
    }

    @Override
    public Control createControl(Composite parent) {
        this.myControl = new SelectUriControl(parent, this.getDefaultFileName(), this.myIsConsiderAdaptes, this.myResourceSet);
        this.myControl.addSelectionListener(new SelectUriControl.ISelectionListener(){

            @Override
            public void selectionChanged(URI uri) {
                if (uri == null) {
                    ResourceSourceChooser.this.myUri = null;
                } else {
                    ResourceSourceChooser.this.myUri = uri;
                }
                ResourceSourceChooser.this.fireChangedEvent();
            }
        });
        if (this.myInitialSelection != null) {
            this.myControl.setSelection((ISelection)this.myInitialSelection);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.m2m.qvt.oml.resource_source_chooser");
        return this.myControl;
    }

    protected String getDefaultFileName() {
        return null;
    }

    @Override
    public void setInitialSelection(String uriString) {
        EObject obj;
        URI uri;
        URI uRI = uri = uriString.trim().length() == 0 ? null : URI.createURI((String)uriString);
        if (uri == null) {
            return;
        }
        IFile file = WorkspaceUtils.getWorkspaceFile((URI)uri);
        if (file != null) {
            this.myInitialSelection = ResourceSourceChooser.createSelectionForUri(uri, file);
            return;
        }
        ModelContent loadModel = EmfUtil.safeLoadModel((URI)uri, (ResourceSet)this.myResourceSet);
        EObject eObject = obj = loadModel != null && !loadModel.getContent().isEmpty() ? (EObject)loadModel.getContent().get(0) : null;
        if (obj != null) {
            this.myInitialSelection = new StructuredSelection((Object)EmfModelContentProvider.makeEObjectNode(obj, null));
            return;
        }
    }

    public static IStructuredSelection createSelectionForUri(URI uri, IFile file) {
        StructuredSelection initialSelection;
        if (!file.exists()) {
            initialSelection = new StructuredSelection((Object)file.getParent());
        } else if (!uri.hasFragment()) {
            initialSelection = new StructuredSelection((Object)file);
        } else {
            ModelContent loadModel = EmfUtil.loadModel((URI)uri);
            EObject obj = loadModel != null && !loadModel.getContent().isEmpty() ? (EObject)loadModel.getContent().get(0) : null;
            initialSelection = obj == null ? new StructuredSelection((Object)file) : new StructuredSelection((Object)EmfModelContentProvider.makeEObjectNode(obj, file));
        }
        return initialSelection;
    }

    @Override
    public String getTitle() {
        return Messages.EObjectResourceChooser_0;
    }

    @Override
    public URI getUri() {
        return this.myUri;
    }

    @Override
    public String getUriString() {
        return this.myUri == null ? null : this.myUri.toString();
    }
}

