/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base.remote;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.eclipse.core.runtime.ILog;
import org.eclipse.help.AbstractContextProvider;
import org.eclipse.help.IContext;
import org.eclipse.help.internal.base.remote.HttpsUtility;
import org.eclipse.help.internal.base.remote.PreferenceFileHandler;
import org.eclipse.help.internal.base.remote.RemoteHelp;
import org.eclipse.help.internal.base.util.ProxyUtil;
import org.eclipse.help.internal.context.Context;
import org.eclipse.help.internal.dynamic.DocumentReader;

public class RemoteContextProvider
extends AbstractContextProvider {
    private static final String PATH_CONTEXT = "/context";
    private static final String PARAM_ID = "id";
    private static final String PARAM_LANG = "lang";
    private static final String PROTOCOL = "http";
    private DocumentReader reader;

    public IContext getContext(String id, String locale) {
        PreferenceFileHandler prefHandler = new PreferenceFileHandler();
        String[] host = prefHandler.getHostEntries();
        String[] port = prefHandler.getPortEntries();
        String[] path = prefHandler.getPathEntries();
        String[] protocols = prefHandler.getProtocolEntries();
        String[] isEnabled = prefHandler.isEnabled();
        if (RemoteHelp.isEnabled()) {
            int numICs = host.length;
            URL url = null;
            int i = 0;
            while (i < numICs) {
                if (isEnabled[i].equals("true")) {
                    String msg;
                    InputStream in = null;
                    try {
                        if (protocols[i].equals(PROTOCOL)) {
                            url = new URL(PROTOCOL, host[i], Integer.parseInt(port[i]), path[i] + "/context?id=" + id + "&lang=" + locale);
                            HttpURLConnection connection = (HttpURLConnection)ProxyUtil.getConnection(url);
                            if (connection.getResponseCode() == 200) {
                                in = connection.getInputStream();
                            }
                        } else {
                            url = HttpsUtility.getHttpsURL(protocols[i], host[i], port[i], path[i] + "/context?id=" + id + "&lang=" + locale);
                            in = HttpsUtility.getHttpsStream(url);
                        }
                        if (this.reader == null) {
                            this.reader = new DocumentReader();
                        }
                        Context context = (Context)this.reader.read(in);
                        return context;
                    }
                    catch (IOException e) {
                        msg = "I/O error while trying to contact the remote help server";
                        ILog.of(((Object)((Object)this)).getClass()).error(msg, (Throwable)e);
                    }
                    catch (Throwable t) {
                        msg = "Internal error while reading search results from remote server";
                        ILog.of(((Object)((Object)this)).getClass()).error(msg, t);
                    }
                    finally {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public String[] getPlugins() {
        return null;
    }
}

