/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.util.draw2d;

import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.handles.AbstractHandle;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.graphiti.mm.algorithms.styles.LineStyle;
import org.eclipse.graphiti.tb.IShapeSelectionInfo;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProviderInternal;
import org.eclipse.graphiti.ui.internal.figures.GFFigureUtil;
import org.eclipse.graphiti.ui.internal.util.DataTypeTransformation;
import org.eclipse.graphiti.ui.internal.util.draw2d.GFHandleHelper;
import org.eclipse.graphiti.ui.internal.util.draw2d.ZoomingInsetsHandleLocator;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.swt.graphics.Color;

public class GFSurroundingHandle
extends AbstractHandle {
    private static final int LINE_WIDTH = 1;
    private static final Insets HANDLE_INSETS = new Insets(1, 1, 1, 1);
    private static Color FG_COLOR;
    private IConfigurationProviderInternal configurationProvider;
    private boolean movable;
    private IShapeSelectionInfo shapeSelectionInfo = null;

    public Color getFG_COLOR() {
        IColorConstant color;
        if (this.shapeSelectionInfo != null && (color = this.shapeSelectionInfo.getColor()) != null) {
            Color swtColor = DataTypeTransformation.toSwtColor(this.configurationProvider.getResourceRegistry(), color);
            return swtColor;
        }
        if (FG_COLOR == null || FG_COLOR.isDisposed()) {
            FG_COLOR = this.configurationProvider.getResourceRegistry().getSwtColor("ff850f");
        }
        return FG_COLOR;
    }

    public GFSurroundingHandle(GraphicalEditPart owner, IConfigurationProviderInternal configurationProvider, boolean movable, IShapeSelectionInfo shapeSelectionInfo) {
        this.configurationProvider = configurationProvider;
        this.movable = movable;
        this.shapeSelectionInfo = shapeSelectionInfo;
        this.setOwner(owner);
        this.setLocator(new ZoomingInsetsHandleLocator(owner.getFigure(), configurationProvider, HANDLE_INSETS));
        this.setOpaque(false);
        if (movable) {
            this.setCursor(Cursors.SIZEALL);
        } else {
            this.setCursor(null);
        }
    }

    protected DragTracker createDragTracker() {
        if (this.movable) {
            DragEditPartsTracker tracker = new DragEditPartsTracker((EditPart)this.getOwner());
            tracker.setDefaultCursor(this.getCursor());
            return tracker;
        }
        return null;
    }

    public boolean containsPoint(int x, int y) {
        if (!this.getBounds().contains(x, y)) {
            return false;
        }
        Rectangle inner = GFFigureUtil.getAdjustedRectangle(this.getBounds(), 1.0, 2 * this.getLineWidth());
        return !inner.contains(x, y);
    }

    public Point getAccessibleLocation() {
        Point p = this.getBounds().getTopRight().translate(-1, this.getBounds().height / 4);
        this.translateToAbsolute((Translatable)p);
        return p;
    }

    public void paintFigure(Graphics g) {
        g.setAntialias(1);
        int lineWidth = this.getLineWidth();
        g.setLineWidth(lineWidth);
        Rectangle r = GFFigureUtil.getAdjustedRectangle(this.getBounds(), 1.0, lineWidth);
        this.prepareForDrawing(g);
        g.drawLine(r.getTopLeft(), r.getTopRight());
        g.drawLine(r.getBottomLeft(), r.getBottomRight());
        g.drawLine(r.getTopRight(), r.getBottomRight());
        g.drawLine(r.getTopLeft(), r.getBottomLeft());
    }

    private void prepareForDrawing(Graphics g) {
        Color fg = this.getFG_COLOR();
        if (this.shapeSelectionInfo != null) {
            LineStyle lineStyle = this.shapeSelectionInfo.getLineStyle();
            int draw2dLineStyle = DataTypeTransformation.toDraw2dLineStyle(lineStyle);
            g.setLineStyle(draw2dLineStyle);
        } else {
            int[] dashZoomed;
            int[] dash = new int[]{2, 2};
            double zoom = GFHandleHelper.getZoomLevel(this.configurationProvider);
            if (zoom == 1.0) {
                dashZoomed = dash;
            } else {
                dashZoomed = new int[dash.length];
                int i = 0;
                while (i < dashZoomed.length) {
                    dashZoomed[i] = Math.max(1, (int)(zoom * (double)dash[i]));
                    ++i;
                }
            }
            g.setLineStyle(6);
            g.setLineDash(dashZoomed);
        }
        this.setForegroundColor(fg);
        g.setForegroundColor(this.getForegroundColor());
    }

    private int getLineWidth() {
        int lineWidth = 1;
        if (this.shapeSelectionInfo != null) {
            lineWidth = this.shapeSelectionInfo.getLineWidth();
        }
        double zoom = GFHandleHelper.getZoomLevel(this.configurationProvider);
        return Math.max(1, (int)(zoom * (double)lineWidth));
    }
}

