/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequest;

public class LockStateRequest
extends CDOClientRequest<List<CDOLockState>> {
    private int branchID;
    private Collection<CDOID> ids;
    private int prefetchDepth;

    public LockStateRequest(CDOClientProtocol protocol, int branchID, Collection<CDOID> ids, int prefetchDepth) {
        super(protocol, (short)52);
        this.branchID = branchID;
        this.ids = ids;
        this.prefetchDepth = prefetchDepth;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        out.writeXInt(this.branchID);
        if (this.prefetchDepth == 0) {
            out.writeXInt(this.ids.size());
        } else {
            out.writeXInt(-this.ids.size());
            out.writeXInt(this.prefetchDepth);
        }
        for (CDOID id : this.ids) {
            out.writeCDOID(id);
        }
    }

    @Override
    protected List<CDOLockState> confirming(CDODataInput in) throws IOException {
        return in.readCDOLockStates();
    }

    protected String getAdditionalInfo() {
        return MessageFormat.format("branchID={0}, ids={1}, prefetchDepth={2}", this.branchID, this.ids, this.prefetchDepth);
    }
}

