/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.packs.core.data;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.embedcdt.core.StringUtils;
import org.eclipse.embedcdt.internal.packs.core.Activator;
import org.eclipse.embedcdt.packs.core.IConsoleStream;
import org.eclipse.embedcdt.packs.core.data.FileNotFoundException;

public class DataUtils {
    private static final int TIME_OUT = 60000;
    private static final String MARKER_ID = "org.eclipse.embedcdt.packs.core.marker";

    public static InputStream checkForUtf8BOM(InputStream inputStream) throws IOException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(new BufferedInputStream(inputStream), 3);
        byte[] bom = new byte[3];
        if (pushbackInputStream.read(bom) != -1 && (bom[0] != -17 || bom[1] != -69 || bom[2] != -65)) {
            pushbackInputStream.unread(bom);
        }
        return pushbackInputStream;
    }

    public static void copyFile(URL sourceUrl, File destinationFile, IConsoleStream out, IProgressMonitor monitor) throws IOException {
        int bytesRead;
        URLConnection connection;
        URL url = sourceUrl;
        while ((connection = url.openConnection()) instanceof HttpURLConnection) {
            connection.setConnectTimeout(60000);
            connection.setReadTimeout(60000);
            HttpURLConnection httpURLConnection = (HttpURLConnection)connection;
            int responseCode = httpURLConnection.getResponseCode();
            if (responseCode == 200) break;
            if (responseCode == 302 || responseCode == 301 || responseCode == 303) {
                String newUrl = connection.getHeaderField("Location");
                url = new URL(newUrl);
                continue;
            }
            if (responseCode == 404) {
                httpURLConnection.disconnect();
                throw new FileNotFoundException("File \"" + url + "\" not found (" + responseCode + "), pack not installed.");
            }
            httpURLConnection.disconnect();
            throw new IOException("Failed to open connection, response code " + responseCode);
        }
        destinationFile.getParentFile().mkdirs();
        InputStream input = connection.getInputStream();
        FileOutputStream output = new FileOutputStream(destinationFile);
        int totalBytes = 0;
        byte[] buf = new byte[1024];
        while ((bytesRead = input.read(buf)) > 0) {
            ((OutputStream)output).write(buf, 0, bytesRead);
            totalBytes += bytesRead;
        }
        ((OutputStream)output).close();
        input.close();
        if (out != null) {
            String s = destinationFile.getCanonicalPath();
            if (s.endsWith(".download")) {
                s = s.substring(0, s.length() - ".download".length());
            }
            out.println("Copied " + totalBytes + " bytes");
            out.println(" from \"" + url + "\"");
            if (!url.equals(sourceUrl)) {
                out.println(" redirected from \"" + sourceUrl + "\"");
            }
            out.println(" to   \"" + s + "\"");
        }
        if (connection instanceof HttpURLConnection) {
            ((HttpURLConnection)connection).disconnect();
        }
    }

    public static void copyFile(File sourceFile, File destinationFile, IConsoleStream out, IProgressMonitor monitor) throws IOException {
        int bytesRead;
        if (out != null) {
            int size = (int)sourceFile.length();
            String sizeString = StringUtils.convertSizeToString((int)size);
            out.println("Copy " + sizeString);
            out.println(" from \"" + sourceFile.getCanonicalPath() + "\"");
            out.println(" to   \"" + destinationFile.getCanonicalPath() + "\"");
        }
        destinationFile.getParentFile().mkdirs();
        FileInputStream input = new FileInputStream(sourceFile);
        FileOutputStream output = new FileOutputStream(destinationFile);
        byte[] buf = new byte[1024];
        while ((bytesRead = ((InputStream)input).read(buf)) > 0) {
            ((OutputStream)output).write(buf, 0, bytesRead);
            if (monitor == null) continue;
            monitor.worked(bytesRead);
        }
        ((OutputStream)output).close();
        ((InputStream)input).close();
    }

    public static int deleteFolderRecursive(File folder) {
        int count = 0;
        if (folder == null) {
            return count;
        }
        if (folder.exists()) {
            File[] fileArray = folder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    count += DataUtils.deleteFolderRecursive(f);
                    f.setWritable(true, false);
                    f.delete();
                } else {
                    f.setWritable(true, false);
                    f.delete();
                    ++count;
                }
                ++n2;
            }
            folder.setWritable(true, false);
            folder.delete();
        }
        return count;
    }

    public static void makeFolderReadOnlyRecursive(File folder) {
        if (folder == null) {
            return;
        }
        if (folder.exists()) {
            File[] fileArray = folder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    DataUtils.makeFolderReadOnlyRecursive(f);
                    f.setWritable(false, false);
                } else {
                    f.setWritable(false, false);
                }
                ++n2;
            }
            folder.setWritable(false, false);
        }
    }

    public static String reportError(String message) {
        try {
            IMarker marker = ResourcesPlugin.getWorkspace().getRoot().createMarker(MARKER_ID);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", 2);
            marker.setAttribute("location", (Object)"-");
        }
        catch (CoreException e) {
            Activator.log((IStatus)e.getStatus());
        }
        return message;
    }

    public static String reportWarning(String message) {
        try {
            IMarker marker = ResourcesPlugin.getWorkspace().getRoot().createMarker(MARKER_ID);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", 1);
            marker.setAttribute("location", (Object)"-");
        }
        catch (CoreException e) {
            Activator.log((IStatus)e.getStatus());
        }
        return message;
    }

    public static String reportInfo(String message) {
        try {
            IMarker marker = ResourcesPlugin.getWorkspace().getRoot().createMarker(MARKER_ID);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", 0);
            marker.setAttribute("location", (Object)"-");
        }
        catch (CoreException e) {
            Activator.log((IStatus)e.getStatus());
        }
        return message;
    }
}

