/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.text.hover;

import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.text.hover.AbstractScriptEditorTextHover;
import org.eclipse.dltk.internal.ui.text.hover.DocumentationBrowserInformationControlInput;
import org.eclipse.dltk.internal.ui.text.hover.ScriptHoverMessages;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.ScriptElementImageProvider;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.dltk.ui.documentation.IDocumentationResponse;
import org.eclipse.dltk.ui.documentation.IScriptDocumentationTitleAdapter;
import org.eclipse.dltk.ui.documentation.ScriptDocumentationAccess;
import org.eclipse.dltk.ui.documentation.TextDocumentationResponse;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.internal.text.html.BrowserInformationControlInput;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension4;
import org.eclipse.jface.text.IInputChangedListener;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;

public class DocumentationHover
extends AbstractScriptEditorTextHover
implements IInformationProviderExtension2,
ITextHoverExtension {
    private static final long LABEL_FLAGS = ScriptElementLabels.ALL_FULLY_QUALIFIED | 0x20L | 0x4000L | 1L | 2L | 0x10L | 0x8000L | 4L | 0x200000L | 0x1000000000000L;
    private static final long LOCAL_VARIABLE_FLAGS = LABEL_FLAGS & 0xFFFFFFFFFFFEFFFFL | 0x20000L;
    private IInformationControlCreator fHoverControlCreator;
    private IInformationControlCreator fPresenterControlCreator;
    private static final ScriptDocumentationTitleAdapter titleAdapter = new ScriptDocumentationTitleAdapter();

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fPresenterControlCreator == null) {
            this.fPresenterControlCreator = new PresenterControlCreator(this.getSite());
        }
        return this.fPresenterControlCreator;
    }

    private IWorkbenchSite getSite() {
        IWorkbenchPage page;
        IEditorPart editor = this.getEditor();
        if (editor == null && (page = DLTKUIPlugin.getActivePage()) != null) {
            editor = page.getActiveEditor();
        }
        if (editor != null) {
            return editor.getSite();
        }
        return null;
    }

    @Override
    public IInformationControlCreator getHoverControlCreator() {
        if (this.fHoverControlCreator == null) {
            this.fHoverControlCreator = new HoverControlCreator(this.getInformationPresenterControlCreator());
        }
        return this.fHoverControlCreator;
    }

    @Override
    protected String getHoverInfo(String nature, Object[] result) {
        StringBuffer buffer = new StringBuffer();
        int nResults = result.length;
        if (nResults == 0) {
            return null;
        }
        boolean hasContents = false;
        if (nResults > 1) {
            org.eclipse.dltk.ui.text.completion.HTMLPrinter.addSmallHeader(buffer, this.getInfoText(result[0], titleAdapter.getTitle(result[0]), titleAdapter.getImage(result[0])));
            org.eclipse.dltk.ui.text.completion.HTMLPrinter.addParagraph(buffer, "<hr>");
            int i = 0;
            while (i < result.length) {
                Object element = result[i];
                Reader reader = ScriptDocumentationAccess.getHTMLContentReader(nature, element, true, true);
                if (reader != null) {
                    if (hasContents) {
                        org.eclipse.dltk.ui.text.completion.HTMLPrinter.addParagraph(buffer, "<hr>");
                    }
                    org.eclipse.dltk.ui.text.completion.HTMLPrinter.addParagraph(buffer, reader);
                    hasContents = true;
                }
                ++i;
            }
        } else {
            Object element = result[0];
            IDocumentationResponse response = ScriptDocumentationAccess.getDocumentation(nature, element, (IAdaptable)titleAdapter);
            if (response == null) {
                response = new TextDocumentationResponse(element, titleAdapter.getTitle(element), titleAdapter.getImage(element), ScriptHoverMessages.ScriptdocHover_noAttachedInformation);
            }
            try {
                org.eclipse.dltk.ui.text.completion.HTMLPrinter.addSmallHeader(buffer, this.getInfoText(element, response.getTitle(), response.getImage()));
                org.eclipse.dltk.ui.text.completion.HTMLPrinter.addParagraph(buffer, response.getReader());
                hasContents = true;
            }
            catch (IOException e) {
                return null;
            }
        }
        if (!hasContents) {
            return null;
        }
        if (buffer.length() > 0) {
            ColorRegistry registry = JFaceResources.getColorRegistry();
            RGB fgRGB = registry.getRGB("org.eclipse.dltk.ui.documentation.foregroundColor");
            RGB bgRGB = registry.getRGB("org.eclipse.dltk.ui.documentation.backgroundColor");
            org.eclipse.dltk.ui.text.completion.HTMLPrinter.insertPageProlog(buffer, 0, bgRGB, fgRGB, DocumentationHover.getStyleSheet());
            org.eclipse.dltk.ui.text.completion.HTMLPrinter.addPageEpilog(buffer);
            return buffer.toString();
        }
        return null;
    }

    private String getInfoText(Object element, String title, ImageDescriptor image) {
        URL imageURL;
        String imageName = null;
        if (image != null && (imageURL = DLTKUIPlugin.getDefault().getImagesOnFSRegistry().getImageURL(image)) != null) {
            imageName = imageURL.toExternalForm();
        }
        StringBuffer buf = new StringBuffer();
        DocumentationHover.addImageAndLabel(buf, element, imageName, 16, 16, HTMLPrinter.convertToHTMLContent((String)title), 20, 2);
        return buf.toString();
    }

    private static void addImageAndLabel(StringBuffer buf, Object element, String imageSrcPath, int imageWidth, int imageHeight, String label, int labelLeft, int labelTop) {
        buf.append("<div style='word-wrap: break-word; position: relative; ");
        if (imageSrcPath != null) {
            buf.append("margin-left: ").append(labelLeft).append("px; ");
            buf.append("padding-top: ").append(labelTop).append("px; ");
        }
        buf.append("'>");
        if (imageSrcPath != null) {
            StringBuilder imageStyle = new StringBuilder("border:none; position: absolute; ");
            imageStyle.append("width: ").append(imageWidth).append("px; ");
            imageStyle.append("height: ").append(imageHeight).append("px; ");
            imageStyle.append("left: ").append(-labelLeft - 1).append("px; ");
            buf.append("<!--[if lte IE 6]><![if gte IE 5.5]>\n");
            Object tooltip = element == null ? "" : "alt='" + ScriptHoverMessages.ScriptdocHover_openDeclaration + "' ";
            buf.append("<span ").append((String)tooltip).append("style=\"").append((CharSequence)imageStyle).append("filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='").append(imageSrcPath).append("')\"></span>\n");
            buf.append("<![endif]><![endif]-->\n");
            buf.append("<!--[if !IE]>-->\n");
            buf.append("<img ").append((String)tooltip).append("style='").append((CharSequence)imageStyle).append("' src='").append(imageSrcPath).append("'/>\n");
            buf.append("<!--<![endif]-->\n");
            buf.append("<!--[if gte IE 7]>\n");
            buf.append("<img ").append((String)tooltip).append("style='").append((CharSequence)imageStyle).append("' src='").append(imageSrcPath).append("'/>\n");
            buf.append("<![endif]-->\n");
        }
        buf.append(label);
        buf.append("</div>");
    }

    @Override
    protected String getHoverInfo(String nature, String content) {
        try {
            Reader reader = ScriptDocumentationAccess.getKeywordDocumentation(nature, (IModelElement)this.getEditorInputModelElement(), content);
            if (reader != null) {
                StringBuffer buffer = new StringBuffer();
                org.eclipse.dltk.ui.text.completion.HTMLPrinter.addParagraph(buffer, reader);
                if (buffer.length() > 0) {
                    ColorRegistry registry = JFaceResources.getColorRegistry();
                    RGB fgRGB = registry.getRGB("org.eclipse.dltk.ui.documentation.foregroundColor");
                    RGB bgRGB = registry.getRGB("org.eclipse.dltk.ui.documentation.backgroundColor");
                    org.eclipse.dltk.ui.text.completion.HTMLPrinter.insertPageProlog(buffer, 0, bgRGB, fgRGB, DocumentationHover.getStyleSheet());
                    org.eclipse.dltk.ui.text.completion.HTMLPrinter.addPageEpilog(buffer);
                    return buffer.toString();
                }
            }
        }
        catch (ModelException modelException) {
            // empty catch block
        }
        return null;
    }

    private static final class BackAction
    extends Action {
        private final BrowserInformationControl fInfoControl;

        public BackAction(BrowserInformationControl infoControl) {
            this.fInfoControl = infoControl;
            this.setText(ScriptHoverMessages.ScriptdocHover_back);
            ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
            this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_BACK"));
            this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_BACK_DISABLED"));
            this.update();
        }

        public void run() {
            BrowserInformationControlInput previous = (BrowserInformationControlInput)this.fInfoControl.getInput().getPrevious();
            if (previous != null) {
                this.fInfoControl.setInput((Object)previous);
            }
        }

        public void update() {
            BrowserInformationControlInput current = this.fInfoControl.getInput();
            if (current != null && current.getPrevious() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
            this.setToolTipText(ScriptHoverMessages.ScriptdocHover_back);
        }
    }

    private static final class ForwardAction
    extends Action {
        private final BrowserInformationControl fInfoControl;

        public ForwardAction(BrowserInformationControl infoControl) {
            this.fInfoControl = infoControl;
            this.setText(ScriptHoverMessages.ScriptdocHover_forward);
            ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
            this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_FORWARD"));
            this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_FORWARD_DISABLED"));
            this.update();
        }

        public void run() {
            BrowserInformationControlInput next = (BrowserInformationControlInput)this.fInfoControl.getInput().getNext();
            if (next != null) {
                this.fInfoControl.setInput((Object)next);
            }
        }

        public void update() {
            BrowserInformationControlInput current = this.fInfoControl.getInput();
            if (current != null && current.getNext() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
            this.setToolTipText(ScriptHoverMessages.ScriptdocHover_forward);
        }
    }

    public static final class HoverControlCreator
    extends AbstractReusableInformationControlCreator {
        private final IInformationControlCreator fInformationPresenterControlCreator;
        private final boolean fAdditionalInfoAffordance;

        public HoverControlCreator(IInformationControlCreator informationPresenterControlCreator) {
            this(informationPresenterControlCreator, false);
        }

        public HoverControlCreator(IInformationControlCreator informationPresenterControlCreator, boolean additionalInfoAffordance) {
            this.fInformationPresenterControlCreator = informationPresenterControlCreator;
            this.fAdditionalInfoAffordance = additionalInfoAffordance;
        }

        public IInformationControl doCreateInformationControl(Shell parent) {
            String tooltipAffordanceString;
            String string = tooltipAffordanceString = this.fAdditionalInfoAffordance ? DLTKUIPlugin.getAdditionalInfoAffordanceString() : EditorsUI.getTooltipAffordanceString();
            if (BrowserInformationControl.isAvailable((Composite)parent)) {
                String font = "org.eclipse.dltk.ui.documentationFont";
                BrowserInformationControl iControl = new BrowserInformationControl(parent, font, tooltipAffordanceString){

                    public IInformationControlCreator getInformationPresenterControlCreator() {
                        return fInformationPresenterControlCreator;
                    }
                };
                return iControl;
            }
            return new DefaultInformationControl(parent, tooltipAffordanceString);
        }

        public boolean canReuse(IInformationControl control) {
            if (!super.canReuse(control)) {
                return false;
            }
            if (control instanceof IInformationControlExtension4) {
                String tooltipAffordanceString = this.fAdditionalInfoAffordance ? DLTKUIPlugin.getAdditionalInfoAffordanceString() : EditorsUI.getTooltipAffordanceString();
                ((IInformationControlExtension4)control).setStatusText(tooltipAffordanceString);
            }
            return true;
        }
    }

    private static final class OpenDeclarationAction
    extends Action {
        private final BrowserInformationControl fInfoControl;

        public OpenDeclarationAction(BrowserInformationControl infoControl) {
            this.fInfoControl = infoControl;
            this.setText(ScriptHoverMessages.ScriptdocHover_openDeclaration);
            DLTKPluginImages.setLocalImageDescriptors((IAction)this, "goto_input.png");
        }

        public void run() {
            DocumentationBrowserInformationControlInput infoInput = (DocumentationBrowserInformationControlInput)this.fInfoControl.getInput();
            this.fInfoControl.notifyDelayedInputChange(null);
            this.fInfoControl.dispose();
            try {
                if (infoInput.getElement() instanceof IModelElement) {
                    DLTKUIPlugin.openInEditor((IModelElement)infoInput.getElement());
                }
            }
            catch (ModelException | PartInitException e) {
                DLTKUIPlugin.log(e);
            }
        }
    }

    public static final class PresenterControlCreator
    extends AbstractReusableInformationControlCreator {
        public PresenterControlCreator(IWorkbenchSite site) {
        }

        public IInformationControl doCreateInformationControl(Shell parent) {
            if (BrowserInformationControl.isAvailable((Composite)parent)) {
                ToolBarManager tbm = new ToolBarManager(0x800000);
                String font = "org.eclipse.dltk.ui.documentationFont";
                BrowserInformationControl iControl = new BrowserInformationControl(parent, font, tbm);
                BackAction backAction = new BackAction(iControl);
                backAction.setEnabled(false);
                tbm.add((IAction)backAction);
                ForwardAction forwardAction = new ForwardAction(iControl);
                tbm.add((IAction)forwardAction);
                forwardAction.setEnabled(false);
                OpenDeclarationAction openDeclarationAction = new OpenDeclarationAction(iControl);
                tbm.add((IAction)openDeclarationAction);
                IInputChangedListener inputChangeListener = newInput -> {
                    backAction.update();
                    forwardAction.update();
                    if (newInput != null && newInput instanceof BrowserInformationControlInput) {
                        BrowserInformationControlInput input = (BrowserInformationControlInput)newInput;
                        Object inputElement = input.getInputElement();
                        boolean isJavaElementInput = inputElement instanceof IModelElement;
                        openDeclarationAction.setEnabled(isJavaElementInput);
                    }
                };
                iControl.addInputChangeListener(inputChangeListener);
                tbm.update(true);
                return iControl;
            }
            return new DefaultInformationControl(parent, true);
        }
    }

    static class ScriptDocumentationTitleAdapter
    extends PlatformObject
    implements IScriptDocumentationTitleAdapter {
        private ScriptElementImageProvider fImageProvider;

        ScriptDocumentationTitleAdapter() {
        }

        @Override
        public String getTitle(Object element) {
            if (element instanceof IModelElement) {
                IModelElement member = (IModelElement)element;
                long flags = member.getElementType() == 13 ? LOCAL_VARIABLE_FLAGS : LABEL_FLAGS;
                String label = ScriptElementLabels.getDefault().getElementLabel(member, flags);
                return label;
            }
            return null;
        }

        @Override
        public ImageDescriptor getImage(Object element) {
            if (element instanceof IModelElement) {
                IModelElement modelElement = (IModelElement)element;
                if (this.fImageProvider == null) {
                    this.fImageProvider = new ScriptElementImageProvider();
                }
                return this.fImageProvider.getScriptImageDescriptor(modelElement, 3);
            }
            return null;
        }
    }
}

