/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.regionaccess.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.xtext.formatting2.debug.TextRegionAccessToString;
import org.eclipse.xtext.formatting2.regionaccess.HiddenRegionPartAssociation;
import org.eclipse.xtext.formatting2.regionaccess.IComment;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegionPart;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegionPartAssociator;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegionFinder;
import org.eclipse.xtext.formatting2.regionaccess.ISequentialRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.formatting2.regionaccess.IWhitespace;
import org.eclipse.xtext.formatting2.regionaccess.internal.AbstractTextSegment;
import org.eclipse.xtext.formatting2.regionaccess.internal.NodeHidden;
import org.eclipse.xtext.formatting2.regionaccess.internal.SemanticRegionMatcher;
import org.eclipse.xtext.formatting2.regionaccess.internal.StringHidden;
import org.eclipse.xtext.formatting2.regionaccess.internal.TextSegment;
import org.eclipse.xtext.resource.IResourceServiceProvider;

public abstract class AbstractHiddenRegion
extends AbstractTextSegment
implements IHiddenRegion {
    private final ITextRegionAccess access;
    private final List<IHiddenRegionPart> hiddens = Lists.newArrayList();
    private ISemanticRegion next;
    private ISemanticRegion previous;

    protected AbstractHiddenRegion(ITextRegionAccess access) {
        this.access = access;
    }

    protected void addPart(IHiddenRegionPart part) {
        this.hiddens.add(part);
    }

    protected List<ITextSegment> collectAlternatingSpaceAndComments(boolean includeComments) {
        List<IHiddenRegionPart> parts = this.getParts();
        if (parts.isEmpty()) {
            return Collections.singletonList(this);
        }
        ITextSegment lastWhitespace = null;
        ArrayList<ITextSegment> result = new ArrayList<ITextSegment>();
        for (IHiddenRegionPart part : parts) {
            if (part instanceof IWhitespace) {
                if (lastWhitespace == null) {
                    result.add(part);
                    lastWhitespace = part;
                    continue;
                }
                int mergedLength = lastWhitespace.getLength() + part.getLength();
                lastWhitespace = new TextSegment(this.access, lastWhitespace.getOffset(), mergedLength);
                result.set(result.size() - 1, lastWhitespace);
                continue;
            }
            if (!(part instanceof IComment)) continue;
            if (lastWhitespace == null) {
                result.add(new TextSegment(this.access, part.getOffset(), 0));
            } else {
                lastWhitespace = null;
            }
            if (!includeComments) continue;
            result.add(part);
        }
        if (lastWhitespace == null) {
            result.add(new TextSegment(this.access, this.getEndOffset(), 0));
        }
        return ImmutableList.copyOf(result);
    }

    @Override
    public boolean containsComment() {
        for (IHiddenRegionPart hidden : this.hiddens) {
            if (!(hidden instanceof IComment)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<ITextSegment> getAlternatingMergedSpaceAndComments() {
        return this.collectAlternatingSpaceAndComments(true);
    }

    public int getLength() {
        if (this.hiddens.isEmpty()) {
            return 0;
        }
        int start = this.hiddens.get(0).getOffset();
        int end = this.hiddens.get(this.hiddens.size() - 1).getEndOffset();
        return end - start;
    }

    @Override
    public IHiddenRegion getNextHiddenRegion() {
        return this.next == null ? null : this.next.getNextHiddenRegion();
    }

    @Override
    public ISemanticRegion getNextSemanticRegion() {
        return this.next;
    }

    @Override
    public ISequentialRegion getNextSequentialRegion() {
        return this.next;
    }

    public int getOffset() {
        if (this.hiddens.isEmpty()) {
            if (this.previous != null) {
                return this.previous.getEndOffset();
            }
            return 0;
        }
        return this.hiddens.get(0).getOffset();
    }

    @Override
    public List<IHiddenRegionPart> getParts() {
        return ImmutableList.copyOf(this.hiddens);
    }

    @Override
    public IHiddenRegion getPreviousHiddenRegion() {
        return this.previous == null ? null : this.previous.getPreviousHiddenRegion();
    }

    @Override
    public ISemanticRegion getPreviousSemanticRegion() {
        return this.previous;
    }

    @Override
    public ISequentialRegion getPreviousSequentialRegion() {
        return this.previous;
    }

    @Override
    public List<ITextSegment> getMergedSpaces() {
        return this.collectAlternatingSpaceAndComments(false);
    }

    @Override
    public ITextRegionAccess getTextRegionAccess() {
        return this.access;
    }

    protected void setNext(ISemanticRegion next) {
        this.next = next;
    }

    protected void setPrevious(ISemanticRegion previous) {
        this.previous = previous;
    }

    public String toString() {
        return new TextRegionAccessToString().withOrigin(this).highlightOrigin().toString();
    }

    @Override
    public ISemanticRegionFinder immediatelyFollowing() {
        return new SemanticRegionMatcher(this.getNextSemanticRegion());
    }

    @Override
    public ISemanticRegionFinder immediatelyPreceding() {
        return new SemanticRegionMatcher(this.getPreviousSemanticRegion());
    }

    protected void initAssociations() {
        IResourceServiceProvider provider = this.access.getResource().getResourceServiceProvider();
        IHiddenRegionPartAssociator associator = provider.get(IHiddenRegionPartAssociator.class);
        associator.associate(this, (part, status) -> {
            if (part instanceof NodeHidden) {
                ((NodeHidden)part).setAssociation((HiddenRegionPartAssociation)((Object)status));
            } else if (part instanceof StringHidden) {
                ((StringHidden)part).setAssociation((HiddenRegionPartAssociation)((Object)status));
            } else {
                throw new IllegalStateException();
            }
        });
    }
}

