/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils;

import java.util.Locale;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;

public class StringUtilities {
    private StringUtilities() {
    }

    public static String normalizeWhitespaces(String s) {
        int length = s.length();
        StringBuffer normalized = new StringBuffer(length);
        boolean needSpace = false;
        int index = 0;
        while (index < length) {
            char c = s.charAt(index);
            if (Character.isWhitespace(c)) {
                needSpace = true;
            } else {
                if (needSpace) {
                    needSpace = false;
                    normalized.append(' ');
                }
                normalized.append(c);
            }
            ++index;
        }
        if (needSpace) {
            normalized.append(' ');
        }
        return normalized.toString();
    }

    public static String getLinePrefix(String s, int index) {
        int beginOfLine = index - 1;
        while (beginOfLine >= 0) {
            char c = s.charAt(beginOfLine);
            if (c == '\r' || c == '\n' || !Character.isWhitespace(c)) break;
            --beginOfLine;
        }
        return s.substring(beginOfLine + 1, index);
    }

    public static String removeFirstWord(String s) {
        s = s.trim();
        int length = s.length();
        int index = 0;
        while (index < length) {
            char c = s.charAt(index);
            if (Character.isWhitespace(c)) {
                return s.substring(index).trim();
            }
            ++index;
        }
        return "";
    }

    public static String extractCamelCaps(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(string.length());
        int length = string.length();
        int i = 0;
        while (i < length) {
            char ch = string.charAt(i);
            if (Character.isUpperCase(ch)) {
                buf.append(ch);
            }
            ++i;
        }
        return buf.toString();
    }

    public static String[] extractCamelWords(String string) {
        if (string == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        int length = string.length();
        int count = 0;
        int i = 0;
        while (i < length) {
            char ch = string.charAt(i);
            if (Character.isUpperCase(ch)) {
                ++count;
            }
            ++i;
        }
        String[] words = new String[count];
        int wordNum = 0;
        int begin = -1;
        int i2 = 0;
        while (i2 < length) {
            boolean isLast;
            char ch = string.charAt(i2);
            boolean bl = isLast = i2 == length - 1;
            if (Character.isUpperCase(ch) || isLast) {
                if (begin >= 0) {
                    int end = i2;
                    if (isLast) {
                        ++end;
                    }
                    String word = string.substring(begin, end);
                    words[wordNum++] = word;
                }
                begin = i2;
            }
            ++i2;
        }
        return words;
    }

    public static int indexOfFirstLowerCase(String str) {
        if (str == null) {
            return -1;
        }
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (Character.isLowerCase(ch)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String stripLeadingUppercaseChars(String string, int keepCount) {
        int index = StringUtilities.indexOfFirstLowerCase(string);
        if (index > 0 && index > keepCount) {
            return string.substring(index - keepCount);
        }
        return string;
    }

    public static String stripHtml(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        StringBuffer result = new StringBuffer();
        boolean insideTag = false;
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c == '<') {
                insideTag = true;
            }
            if (!insideTag) {
                result.append(c);
            }
            if (c == '>') {
                insideTag = false;
            }
            ++i;
        }
        return result.toString();
    }

    public static String removeDuplicateCharacters(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        char[] chars = str.toCharArray();
        StringBuffer buffer = new StringBuffer();
        char lastChar = '\u0000';
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (i == 0 || c != lastChar) {
                buffer.append(c);
                lastChar = c;
            }
            ++i;
        }
        return buffer.toString();
    }

    public static int[] getDifferenceIntervals(String s1, String s2) {
        int prefixLength = 0;
        while (prefixLength < s1.length() && prefixLength < s2.length()) {
            char c2;
            char c1 = s1.charAt(prefixLength);
            if (c1 != (c2 = s2.charAt(prefixLength))) break;
            ++prefixLength;
        }
        int suffixLength = 0;
        while (suffixLength < s1.length() - prefixLength && suffixLength < s2.length() - prefixLength) {
            char c2;
            char c1 = s1.charAt(s1.length() - 1 - suffixLength);
            if (c1 != (c2 = s2.charAt(s2.length() - 1 - suffixLength))) break;
            ++suffixLength;
        }
        return new int[]{prefixLength, s1.length() - suffixLength - prefixLength, prefixLength, s2.length() - suffixLength - prefixLength};
    }

    public static String[] replace(String[] strings, String searchString, String replacement) {
        String[] result = new String[strings.length];
        int i = 0;
        while (i < strings.length) {
            String string = strings[i];
            result[i] = string.replace(searchString, replacement);
            ++i;
        }
        return result;
    }

    public static String escapeJava(String s) {
        return StringEscapeUtils.escapeJava((String)s);
    }

    public static String escapeForJavaSource(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(str.length() * 2);
        StringUtilities.escapeForJavaSource(buffer, str);
        return buffer.toString();
    }

    private static void escapeForJavaSource(StringBuffer out, String str) {
        int sz = str.length();
        int i = 0;
        while (i < sz) {
            char c = str.charAt(i);
            if (c < ' ') {
                switch (c) {
                    case '\b': {
                        out.append('\\');
                        out.append('b');
                        break;
                    }
                    case '\n': {
                        out.append('\\');
                        out.append('n');
                        break;
                    }
                    case '\t': {
                        out.append('\\');
                        out.append('t');
                        break;
                    }
                    case '\f': {
                        out.append('\\');
                        out.append('f');
                        break;
                    }
                    case '\r': {
                        out.append('\\');
                        out.append('r');
                        break;
                    }
                    default: {
                        if (c > '\u000f') {
                            out.append("\\u00" + StringUtilities.hex(c));
                            break;
                        }
                        out.append("\\u000" + StringUtilities.hex(c));
                        break;
                    }
                }
            } else {
                switch (c) {
                    case '\"': {
                        out.append('\\');
                        out.append('\"');
                        break;
                    }
                    case '\\': {
                        out.append('\\');
                        out.append('\\');
                        break;
                    }
                    default: {
                        out.append(c);
                    }
                }
            }
            ++i;
        }
    }

    private static String hex(char c) {
        return Integer.toHexString(c).toUpperCase(Locale.ENGLISH);
    }

    public static String removeNonLatinCharacters(String s) {
        StringBuffer sb = new StringBuffer();
        char[] chars = s.toCharArray();
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (StringUtilities.isLatinCharacter(c)) {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static boolean isLatinCharacter(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }
}

