/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.nls.model;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.internal.core.nls.model.LocalePartInfo;
import org.eclipse.wb.internal.core.nls.ui.FlagImagesRepository;

public final class LocalePartInfos {
    private static LocalePartInfo[] m_languages;
    private static LocalePartInfo[] m_countries;

    public static LocalePartInfo[] getLanguages() {
        LocalePartInfos.initLanguagesAndCountries();
        return m_languages;
    }

    public static LocalePartInfo[] getCountries() {
        LocalePartInfos.initLanguagesAndCountries();
        return m_countries;
    }

    public static int indexByName(LocalePartInfo[] parts, String name) {
        int i = 0;
        while (i < parts.length) {
            LocalePartInfo part = parts[i];
            if (part.getName().equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static void initLanguagesAndCountries() {
        if (m_languages == null) {
            Image flagImage;
            Locale locale;
            HashSet<LocalePartInfo> languagesSet = new HashSet<LocalePartInfo>();
            String[] stringArray = Locale.getISOLanguages();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String language = stringArray[n2];
                locale = Locale.of(language);
                flagImage = FlagImagesRepository.getFlagImage(locale);
                languagesSet.add(new LocalePartInfo(locale.getLanguage(), locale.getDisplayLanguage(), flagImage));
                ++n2;
            }
            m_languages = languagesSet.toArray(new LocalePartInfo[languagesSet.size()]);
            Arrays.sort(m_languages);
            HashSet<LocalePartInfo> countriesSet = new HashSet<LocalePartInfo>();
            countriesSet.add(new LocalePartInfo("", "(none)", FlagImagesRepository.getEmptyFlagImage()));
            stringArray = Locale.getISOCountries();
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                String country = stringArray[n2];
                locale = Locale.of("", country);
                flagImage = FlagImagesRepository.getFlagImage(locale);
                countriesSet.add(new LocalePartInfo(locale.getCountry(), locale.getDisplayCountry(), flagImage));
                ++n2;
            }
            m_countries = countriesSet.toArray(new LocalePartInfo[countriesSet.size()]);
            Arrays.sort(m_countries);
        }
    }
}

