/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.databinding.ui.providers;

import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.wb.internal.core.databinding.model.IObserveDecoration;
import org.eclipse.wb.internal.core.databinding.ui.decorate.IObserveDecorator;
import org.eclipse.wb.internal.core.databinding.ui.providers.ObserveLabelProvider;
import org.eclipse.wb.internal.core.utils.ui.DrawUtils;

public final class ObserveDecoratingLabelProvider
extends ObserveLabelProvider
implements IColorProvider,
IFontProvider {
    private final Font m_italicFont;
    private final Font m_boldFont;
    private final Font m_boldItalicFont;

    public ObserveDecoratingLabelProvider(StructuredViewer viewer) {
        Font baseFont = viewer.getControl().getFont();
        this.m_boldFont = DrawUtils.getBoldFont((Font)baseFont);
        this.m_italicFont = DrawUtils.getItalicFont((Font)baseFont);
        this.m_boldItalicFont = DrawUtils.getBoldItalicFont((Font)baseFont);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.m_italicFont.dispose();
        this.m_boldFont.dispose();
        this.m_boldItalicFont.dispose();
    }

    private static IObserveDecorator getDecorator(Object element) {
        IObserveDecoration observe = (IObserveDecoration)element;
        return observe.getDecorator();
    }

    public Color getBackground(Object element) {
        return ObserveDecoratingLabelProvider.getDecorator(element).getBackground();
    }

    public Color getForeground(Object element) {
        return ObserveDecoratingLabelProvider.getDecorator(element).getForeground();
    }

    public Font getFont(Object element) {
        return ObserveDecoratingLabelProvider.getDecorator(element).getFont(this.m_italicFont, this.m_boldFont, this.m_boldItalicFont);
    }
}

