/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.kernel.core.trace;

import com.google.common.collect.Multimap;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.event.aspect.LinuxTidAspect;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.trace.layout.LttngEventLayout;
import org.eclipse.tracecompass.lttng2.kernel.core.trace.LttngKernelTrace;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.trace.TmfEventTypeCollectionHelper;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEventType;

public class ContextTidAspect
extends LinuxTidAspect {
    private final LttngEventLayout fLayout;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static @Nullable ContextTidAspect getAspect(LttngKernelTrace trace) {
        IKernelAnalysisEventLayout layout = trace.getKernelEventLayout();
        if (!(layout instanceof LttngEventLayout)) {
            return null;
        }
        LttngEventLayout lttngLayout = (LttngEventLayout)layout;
        Set<@NonNull CtfTmfEventType> eventTypes = trace.getContainedEventTypes();
        @NonNull @NonNull Multimap eventFieldNames = TmfEventTypeCollectionHelper.getEventFieldNames(eventTypes);
        return eventFieldNames.containsValue((Object)lttngLayout.contextTid()) ? new ContextTidAspect(lttngLayout) : null;
    }

    private ContextTidAspect(LttngEventLayout layout) {
        this.fLayout = layout;
    }

    public @Nullable Integer resolve(@NonNull ITmfEvent event) {
        ITmfEventField content = event.getContent();
        Long tid = (Long)content.getFieldValue(Long.class, new String[]{this.fLayout.contextTid()});
        return tid == null ? null : Integer.valueOf(tid.intValue());
    }
}

