/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.swt.tools.internal.ASTClass;
import org.eclipse.swt.tools.internal.ASTField;
import org.eclipse.swt.tools.internal.ASTMethod;
import org.eclipse.swt.tools.internal.ASTParameter;
import org.eclipse.swt.tools.internal.AbstractItem;
import org.eclipse.swt.tools.internal.JNIClass;
import org.eclipse.swt.tools.internal.JNIField;
import org.eclipse.swt.tools.internal.JNIGenerator;
import org.eclipse.swt.tools.internal.JNIMethod;
import org.eclipse.swt.tools.internal.JNIParameter;

public class EmbedMetaData
extends JNIGenerator {
    TreeMap<Integer, String> inserts;

    @Override
    public void generate(JNIClass clazz) {
        this.inserts = new TreeMap();
        String data = ((AbstractItem)((Object)clazz)).flatten();
        if (data != null && data.length() != 0) {
            String doc = "/** @jniclass " + data + " */" + this.delimiter;
            this.inserts.put(((ASTClass)clazz).start, doc);
        }
        JNIField[] fields = clazz.getDeclaredFields();
        this.generate(fields);
        JNIMethod[] methods = clazz.getDeclaredMethods();
        this.generate(methods);
        if (this.inserts.size() == 0) {
            return;
        }
        String sourcePath = ((ASTClass)clazz).sourcePath;
        String source = JNIGenerator.loadFile(sourcePath);
        Set<Integer> set = this.inserts.keySet();
        ArrayList<Integer> keys = new ArrayList<Integer>();
        keys.addAll(set);
        Collections.reverse(keys);
        StringBuilder buffer = new StringBuilder(source);
        for (Integer index : keys) {
            String doc = this.inserts.get(index);
            buffer.insert((int)index, doc);
        }
        try {
            EmbedMetaData.output(buffer.toString().getBytes(), sourcePath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.inserts = null;
    }

    public void generate(JNIField[] fields) {
        JNIField[] jNIFieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            JNIField field = jNIFieldArray[n2];
            int mods = field.getModifiers();
            if ((mods & 1) != 0 && (mods & 0x10) == 0 && (mods & 8) == 0) {
                this.generate(field);
            }
            ++n2;
        }
    }

    public void generate(JNIField field) {
        field.setCast(field.getCast());
        String data = ((AbstractItem)((Object)field)).flatten();
        if (data != null && data.length() != 0) {
            String doc = "/** @field " + data + " */" + this.delimiter + "\t";
            this.inserts.put(((ASTField)field).start, doc);
        }
    }

    public void generate(JNIMethod[] methods) {
        JNIMethod[] jNIMethodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            JNIMethod method = jNIMethodArray[n2];
            if ((method.getModifiers() & 0x100) != 0) {
                this.generate(method);
            }
            ++n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void generate(JNIMethod method) {
        void var5_8;
        ArrayList<CallSite> tags = new ArrayList<CallSite>();
        String data = ((AbstractItem)((Object)method)).flatten();
        if (data != null && data.length() != 0) {
            tags.add((CallSite)((Object)("@method " + data)));
        }
        JNIParameter[] jNIParameterArray = method.getParameters();
        int n = jNIParameterArray.length;
        boolean n2 = false;
        while (var5_8 < n) {
            JNIParameter p = jNIParameterArray[var5_8];
            ASTParameter param = (ASTParameter)p;
            param.setCast(param.getCast());
            data = param.flatten();
            if (data != null && data.length() != 0) {
                tags.add((CallSite)((Object)("@param " + param.getName() + " " + data)));
            }
            ++var5_8;
        }
        if (tags.size() == 0) {
            return;
        }
        if (tags.size() == 1) {
            String doc = "/** " + (String)tags.get(0) + " */" + this.delimiter;
            this.inserts.put(((ASTMethod)method).start, doc);
        } else {
            StringBuilder buffer = new StringBuilder();
            buffer.append("/**");
            buffer.append(this.delimiter);
            for (String string : tags) {
                buffer.append(" * ");
                buffer.append(string);
                buffer.append(this.delimiter);
            }
            buffer.append(" */");
            buffer.append(this.delimiter);
            this.inserts.put(((ASTMethod)method).start, buffer.toString());
        }
    }
}

