/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.api.query;

import java.util.Objects;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.ecore.EPackageMetaData;

public class NotificationQuery {
    private final Notification notification;

    public NotificationQuery(Notification notification) {
        this.notification = Objects.requireNonNull(notification);
    }

    public boolean isTransientNotification() {
        if (this.isNotificationOnTransientFeature()) {
            return true;
        }
        return this.isNotificationOnEObjectContainedThroughTransientFeature();
    }

    private boolean isNotificationOnTransientFeature() {
        return this.notification.getFeature() instanceof EStructuralFeature && ((EStructuralFeature)this.notification.getFeature()).isTransient();
    }

    private boolean isNotificationOnEObjectContainedThroughTransientFeature() {
        if (this.notification.getNotifier() instanceof EObject) {
            EObject obj = (EObject)this.notification.getNotifier();
            return this.isContainedThroughTransientFeature(obj);
        }
        return false;
    }

    private boolean isContainedThroughTransientFeature(EObject obj) {
        EObject current = obj;
        while (current.eContainer() != null) {
            EObject container = current.eContainer();
            if (current.eContainingFeature().isTransient() && !this.isDocumentRoot(container.eClass())) {
                return true;
            }
            current = container;
        }
        return false;
    }

    private boolean isDocumentRoot(EClass eClass) {
        return ExtendedMetaData.INSTANCE.isDocumentRoot(eClass) || this.isDeclaredAsDocumentRoot(eClass);
    }

    private boolean isDeclaredAsDocumentRoot(EClass eClass) {
        String nsURI;
        EPackageMetaData metaData;
        if (eClass != null && eClass.getEPackage() != null && (metaData = DslCommonPlugin.INSTANCE.getEPackageMetaData(nsURI = eClass.getEPackage().getNsURI())) != null && metaData.getDocumentRootClassNames() != null) {
            return metaData.getDocumentRootClassNames().contains(eClass.getName());
        }
        return false;
    }
}

