/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.compiler.ast.nodes;

import java.util.List;
import org.eclipse.dltk.ast.ASTListNode;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.php.core.compiler.ast.nodes.Attribute;
import org.eclipse.php.core.compiler.ast.nodes.IAttributed;
import org.eclipse.php.core.compiler.ast.nodes.IPHPDocAwareDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.IRecoverable;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

public class InterfaceDeclaration
extends TypeDeclaration
implements IPHPDocAwareDeclaration,
IRecoverable,
IAttributed {
    private PHPDocBlock phpDoc;
    private boolean isRecovered;
    private List<Attribute> attributes;

    public InterfaceDeclaration(int start, int end, int nameStart, int nameEnd, String interfaceName, List<TypeReference> interfaces, Block body, PHPDocBlock phpDoc) {
        super(interfaceName, nameStart, nameEnd, start, end);
        if (interfaceName == null) {
            System.out.println("empty");
        }
        this.phpDoc = phpDoc;
        int nodesStart = body.sourceStart() - 1;
        ASTListNode parentsList = new ASTListNode(nodesStart, nodesStart);
        for (TypeReference intface : interfaces) {
            parentsList.addNode((ASTNode)intface);
            if (parentsList.sourceStart() <= intface.sourceStart()) continue;
            parentsList.setStart(intface.sourceStart());
        }
        if (parentsList.getChilds().size() > 0) {
            this.setSuperClasses(parentsList);
        }
        this.setBody(body);
        this.setModifier(8);
    }

    @Override
    public PHPDocBlock getPHPDoc() {
        return this.phpDoc;
    }

    public int getKind() {
        return 40;
    }

    @Override
    public boolean isRecovered() {
        return this.isRecovered;
    }

    @Override
    public void setRecovered(boolean isRecovered) {
        this.isRecovered = isRecovered;
    }

    public final void printNode(CorePrinter output) {
    }

    public String toString() {
        return ASTPrintVisitor.toXMLString((ASTNode)this);
    }

    @Override
    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((TypeDeclaration)this)) {
            if (this.attributes != null) {
                for (Attribute attr : this.attributes) {
                    attr.traverse(visitor);
                }
            }
            if (this.getSuperClasses() != null) {
                this.getSuperClasses().traverse(visitor);
            }
            if (this.fBody != null) {
                this.fBody.traverse(visitor);
            }
            visitor.endvisit((TypeDeclaration)this);
        }
    }

    @Override
    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }

    @Override
    public void setPHPDoc(PHPDocBlock block) {
        this.phpDoc = block;
    }
}

