/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.compiler.ast.nodes;

import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.Argument;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.php.core.compiler.ast.nodes.Attribute;
import org.eclipse.php.core.compiler.ast.nodes.IAttributed;
import org.eclipse.php.core.compiler.ast.nodes.PropertyHook;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

public class FormalParameter
extends Argument
implements IAttributed {
    private final SimpleReference parameterType;
    private final VariableReference parameterName;
    private List<Attribute> attributes;
    private final List<PropertyHook> hooks;
    private final boolean isMandatory;
    private final boolean isVariadic;

    public FormalParameter(int start, int end, SimpleReference type, VariableReference parameterName, Expression defaultValue, boolean isMandatory, boolean isVariadic, List<PropertyHook> hooks) {
        super((SimpleReference)parameterName, start, end, (ASTNode)defaultValue, 0);
        SimpleReference ref;
        if (parameterName != null && defaultValue == null) {
            this.setEnd(parameterName.sourceEnd());
        }
        if ((ref = this.getRef()) != null) {
            ref.setStart(parameterName.sourceStart());
            ref.setEnd(parameterName.sourceEnd());
        }
        assert (parameterName != null);
        this.hooks = hooks;
        this.parameterType = type;
        this.parameterName = parameterName;
        this.isMandatory = isMandatory;
        this.isVariadic = isVariadic;
    }

    public FormalParameter(int start, int end, SimpleReference type, VariableReference parameterName, Expression defaultValue) {
        this(start, end, type, parameterName, defaultValue, false, false, null);
    }

    public FormalParameter(int start, int end, SimpleReference type, VariableReference parameterName, boolean isMandatory) {
        this(start, end, type, parameterName, null, isMandatory, false, null);
    }

    public FormalParameter(int start, int end, SimpleReference type, VariableReference parameterName) {
        this(start, end, type, parameterName, null, true, false, null);
    }

    public FormalParameter(int start, int end, SimpleReference type, VariableReference parameterName, Expression defaultValue, boolean isMandatory, boolean isVariadic) {
        this(start, end, type, parameterName, defaultValue, isMandatory, isVariadic, null);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((Statement)this)) {
            if (this.attributes != null) {
                for (Attribute attr : this.attributes) {
                    attr.traverse(visitor);
                }
            }
            if (this.parameterType != null) {
                this.parameterType.traverse(visitor);
            }
            this.parameterName.traverse(visitor);
            Expression defaultValue = (Expression)this.getInitialization();
            if (defaultValue != null) {
                defaultValue.traverse(visitor);
            }
            if (this.hooks != null) {
                for (PropertyHook h : this.hooks) {
                    h.traverse(visitor);
                }
            }
            visitor.endvisit((Statement)this);
        }
    }

    public int getKind() {
        return 27;
    }

    public boolean isMandatory() {
        return this.isMandatory;
    }

    public boolean isVariadic() {
        return this.isVariadic;
    }

    public VariableReference getParameterName() {
        return this.parameterName;
    }

    public SimpleReference getParameterType() {
        return this.parameterType;
    }

    public final void printNode(CorePrinter output) {
    }

    public String toString() {
        return ASTPrintVisitor.toXMLString((ASTNode)this);
    }

    @Override
    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }

    public boolean isReadonly() {
        return (this.modifiers & 0x8000000) != 0;
    }

    public List<PropertyHook> getHooks() {
        return this.hooks;
    }
}

