/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.restrictions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.api.FeatureIdentifier;
import org.eclipse.passage.lic.api.restrictions.Restriction;
import org.eclipse.passage.lic.api.restrictions.RestrictionComparator;

public final class WorstRestrictionsPerFeature
implements Supplier<Collection<Restriction>> {
    private final Collection<Restriction> restrictions;

    public WorstRestrictionsPerFeature(Collection<Restriction> restrictions) {
        this.restrictions = restrictions;
    }

    @Override
    public Collection<Restriction> get() {
        Map<FeatureIdentifier, List<Restriction>> featured = this.restrictions.stream().collect(Collectors.groupingBy(r -> r.unsatisfiedRequirement().feature().identifier()));
        return featured.values().stream().map(this::worst).collect(Collectors.toSet());
    }

    private Restriction worst(List<Restriction> source) {
        return this.sorted(source).get(source.size() - 1);
    }

    private List<Restriction> sorted(Collection<Restriction> source) {
        ArrayList<Restriction> sorted = new ArrayList<Restriction>(source);
        Collections.sort(sorted, new RestrictionComparator());
        return sorted;
    }
}

