/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.utilities;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.utilities.ThreadLocalExecutor;
import org.eclipse.ocl.pivot.validation.ValidationContext;
import org.eclipse.ocl.pivot.validation.ValidationRegistryAdapter;
import org.eclipse.ocl.xtext.base.cs2as.CS2AS;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.xtext.base.utilities.ElementUtil;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.validation.AbstractInjectableValidator;
import org.eclipse.xtext.validation.CancelableDiagnostician;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.validation.ResourceValidatorImpl;
import org.eclipse.xtext.validation.impl.ConcreteSyntaxEValidator;

public class PivotResourceValidator
extends ResourceValidatorImpl {
    private static final Logger log = Logger.getLogger(PivotResourceValidator.class);
    public static final String HAS_SYNTAX_ERRORS = "has_syntax_errors";

    protected ValidationDiagnostic createDefaultDiagnostic(Diagnostician diagnostician, EObject pivotObject) {
        return new ValidationDiagnostic("");
    }

    protected void issueFromDiagnostics(IAcceptor<Issue> acceptor, ValidationDiagnostic diagnostic) {
        for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
            this.issueFromEValidatorDiagnostic(childDiagnostic, acceptor);
        }
    }

    protected void performValidation(IAcceptor<Issue> acceptor, Resource asResource, CancelIndicator monitor) {
        ValidationRegistryAdapter validationRegistry = ValidationRegistryAdapter.getAdapter((Notifier)asResource);
        ValidationContext validationContext = new ValidationContext((EValidator.Registry)validationRegistry);
        Diagnostician diagnostician = validationContext.getDiagnostician();
        Resource pResource = asResource;
        this.removeValidationDiagnostics((List<Resource.Diagnostic>)pResource.getErrors());
        this.removeValidationDiagnostics((List<Resource.Diagnostic>)pResource.getWarnings());
        EList contents = pResource.getContents();
        int j = 0;
        while (j < contents.size()) {
            block8: {
                try {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    EObject pObject = (EObject)contents.get(j);
                    ValidationDiagnostic diagnostic = this.createDefaultDiagnostic(diagnostician, pObject);
                    diagnostician.validate(pObject, (DiagnosticChain)diagnostic, (Map)validationContext);
                    if (!diagnostic.getChildren().isEmpty()) {
                        if (diagnostic.getSeverity() == 4) {
                            pResource.getErrors().add((Object)diagnostic);
                        } else if (diagnostic.getSeverity() == 2) {
                            pResource.getWarnings().add((Object)diagnostic);
                        }
                        this.issueFromDiagnostics(acceptor, diagnostic);
                    }
                }
                catch (RuntimeException e) {
                    if (monitor.isCanceled()) break block8;
                    pResource.getErrors().add((Object)new ValidationDiagnostic(e.getMessage()));
                }
            }
            ++j;
        }
    }

    protected void removeValidationDiagnostics(List<Resource.Diagnostic> diagnostics) {
        int i = diagnostics.size() - 1;
        while (i >= 0) {
            Resource.Diagnostic diagnostic = diagnostics.get(i);
            if (diagnostic instanceof ValidationDiagnostic) {
                diagnostics.remove(i);
            }
            --i;
        }
    }

    public List<Issue> validate(Resource resource, CheckMode mode, CancelIndicator mon) {
        BaseCSResource csResource;
        CS2AS cs2as;
        assert (ThreadLocalExecutor.basicGetEnvironmentFactory() != null);
        CancelIndicator monitor = mon == null ? CancelIndicator.NullImpl : mon;
        this.resolveProxies(resource, monitor);
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)(resource.getErrors().size() + resource.getWarnings().size()));
        try {
            IAcceptor acceptor = this.createAcceptor(result);
            if (mode.shouldCheck(CheckType.FAST)) {
                int i = 0;
                while (i < resource.getErrors().size()) {
                    if (monitor.isCanceled()) {
                        return Collections.emptyList();
                    }
                    this.issueFromXtextResourceDiagnostic((Resource.Diagnostic)resource.getErrors().get(i), Severity.ERROR, acceptor);
                    ++i;
                }
                i = 0;
                while (i < resource.getWarnings().size()) {
                    if (monitor.isCanceled()) {
                        return Collections.emptyList();
                    }
                    this.issueFromXtextResourceDiagnostic((Resource.Diagnostic)resource.getWarnings().get(i), Severity.WARNING, acceptor);
                    ++i;
                }
            }
            if (monitor.isCanceled()) {
                return Collections.emptyList();
            }
            boolean syntaxDiagFail = !result.isEmpty();
            this.logCheckStatus(resource, syntaxDiagFail, "Syntax");
            ValidationRegistryAdapter validationRegistry = ValidationRegistryAdapter.getAdapter((Notifier)resource);
            ValidationContext validationContext = new ValidationContext((EValidator.Registry)validationRegistry);
            Diagnostician diagnostician = validationContext.getDiagnostician();
            for (EObject ele : resource.getContents()) {
                try {
                    if (monitor.isCanceled()) {
                        return Collections.emptyList();
                    }
                    validationContext.put((Object)"check.mode", (Object)mode);
                    validationContext.put((Object)CancelableDiagnostician.CANCEL_INDICATOR, (Object)monitor);
                    validationContext.put((Object)ConcreteSyntaxEValidator.DISABLE_CONCRETE_SYNTAX_EVALIDATOR, (Object)Boolean.TRUE);
                    boolean hasSyntaxError = false;
                    if (resource instanceof XtextResource) {
                        BaseCSResource csResource2;
                        EList errors;
                        validationContext.put((Object)AbstractInjectableValidator.CURRENT_LANGUAGE_NAME, (Object)((XtextResource)resource).getLanguageName());
                        if (resource instanceof BaseCSResource && (hasSyntaxError = ElementUtil.hasSyntaxError((List<Resource.Diagnostic>)(errors = (csResource2 = (BaseCSResource)resource).getErrors())))) {
                            validationContext.put((Object)HAS_SYNTAX_ERRORS, (Object)Boolean.TRUE);
                        }
                    }
                    if (hasSyntaxError) continue;
                    Diagnostic diagnostic = diagnostician.validate(ele, (Map)validationContext);
                    if (!diagnostic.getChildren().isEmpty()) {
                        for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                            this.issueFromEValidatorDiagnostic(childDiagnostic, acceptor);
                        }
                        continue;
                    }
                    this.issueFromEValidatorDiagnostic(diagnostic, acceptor);
                }
                catch (RuntimeException e) {
                    if (monitor.isCanceled()) continue;
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (RuntimeException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        if (resource instanceof BaseCSResource && (cs2as = (csResource = (BaseCSResource)resource).findCS2AS()) != null) {
            ASResource asResource = cs2as.getASResource();
            IAcceptor acceptor = this.createAcceptor(result);
            this.performValidation((IAcceptor<Issue>)acceptor, (Resource)asResource, monitor);
        }
        ThreadLocalExecutor.resetEnvironmentFactory();
        return result;
    }

    private void logCheckStatus(Resource resource, boolean parserDiagFail, String string) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(String.valueOf(string) + " check " + (parserDiagFail ? "FAIL" : "OK") + "! Resource: " + resource.getURI()));
        }
    }

    public static class ValidationDiagnostic
    extends BasicDiagnostic
    implements Resource.Diagnostic {
        private ValidationDiagnostic(String message) {
            super(2, "org.eclipse.emf.ecore", 0, message, null);
        }

        public int getColumn() {
            return 0;
        }

        public int getLine() {
            return 0;
        }

        public String getLocation() {
            return null;
        }

        public Integer getOffset() {
            return null;
        }

        public Integer getLength() {
            return 10;
        }
    }
}

