/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.cs2as;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.scoping.EnvironmentView;
import org.eclipse.ocl.pivot.internal.scoping.ScopeFilter;
import org.eclipse.ocl.pivot.internal.scoping.ScopeView;
import org.eclipse.ocl.pivot.internal.utilities.AbstractConversion;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.ParserContext;
import org.eclipse.ocl.pivot.utilities.PivotHelper;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.pivot.utilities.ThreadLocalExecutor;
import org.eclipse.ocl.xtext.base.cs2as.AmbiguitiesAdapter;
import org.eclipse.ocl.xtext.base.cs2as.CS2ASConversion;
import org.eclipse.ocl.xtext.base.cs2as.Continuation;
import org.eclipse.ocl.xtext.base.cs2as.ExceptionAdapter;
import org.eclipse.ocl.xtext.base.scoping.AbstractJavaClassScope;
import org.eclipse.ocl.xtext.base.scoping.BaseScopeView;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.xtext.base.utilities.CSI;
import org.eclipse.ocl.xtext.base.utilities.CSI2ASMapping;
import org.eclipse.ocl.xtext.basecs.BaseCSPackage;
import org.eclipse.ocl.xtext.basecs.ElementCS;
import org.eclipse.ocl.xtext.basecs.ElementRefCS;
import org.eclipse.ocl.xtext.basecs.ModelElementCS;
import org.eclipse.ocl.xtext.basecs.MultiplicityCS;
import org.eclipse.ocl.xtext.basecs.PathElementCS;
import org.eclipse.ocl.xtext.basecs.PathNameCS;
import org.eclipse.ocl.xtext.basecs.PivotableElementCS;
import org.eclipse.ocl.xtext.basecs.RootCS;
import org.eclipse.ocl.xtext.basecs.TypedRefCS;
import org.eclipse.ocl.xtext.basecs.TypedTypeRefCS;
import org.eclipse.ocl.xtext.basecs.util.BaseCSVisitor;
import org.eclipse.xtext.diagnostics.DiagnosticMessage;
import org.eclipse.xtext.diagnostics.IDiagnosticConsumer;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.Triple;
import org.eclipse.xtext.util.Tuples;

public abstract class CS2AS
extends AbstractConversion {
    private static Map<EReference, UnresolvedProxyMessageProvider> unresolvedProxyMessageProviderMap = new HashMap<EReference, UnresolvedProxyMessageProvider>();
    public static boolean showContext = false;
    private static MessageBinder messageBinder = DefaultMessageBinder.INSTANCE;
    private static long startTime = System.currentTimeMillis();
    private static @NonNull Map<Thread, Long> threadRunTimes = new HashMap<Thread, Long>();
    private static long[] indentRunTimes = new long[100];
    private static @NonNull Integer indentation = 0;
    private static @NonNull String indents = ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>";
    protected final @NonNull BaseCSResource csResource;
    protected final @NonNull ASResource asResource;
    protected final @NonNull CSI2ASMapping csi2asMapping;
    private @Nullable PivotHelper helper = null;
    private final @Nullable ParserContext parserContext;

    public static EList<EObject> computeRootContainmentFeatures(RootCS csRoot) {
        BasicEList containmentsList = new BasicEList();
        for (EStructuralFeature eStructuralFeature : csRoot.eClass().getEAllStructuralFeatures()) {
            EReference eReference;
            if (!(eStructuralFeature instanceof EReference) || !(eReference = (EReference)eStructuralFeature).isContainment()) continue;
            containmentsList.add((Object)eReference);
        }
        int index = containmentsList.indexOf((Object)BaseCSPackage.Literals.ROOT_CS__OWNED_IMPORTS);
        if (index > 0) {
            containmentsList.move(0, index);
        }
        return new EContentsEList((EObject)csRoot, (List)containmentsList);
    }

    public static void addUnresolvedProxyMessageProvider(UnresolvedProxyMessageProvider unresolvedProxyMessageProvider) {
        unresolvedProxyMessageProviderMap.put(unresolvedProxyMessageProvider.getEReference(), unresolvedProxyMessageProvider);
    }

    public static Element basicGetType(TypedTypeRefCS csTypedRef) {
        EList<PathElementCS> path = csTypedRef.getOwnedPathName().getOwnedPathElements();
        int iLast = path.size() - 1;
        int i = 0;
        while (i < iLast) {
            Element element = ((PathElementCS)path.get(i)).basicGetReferredElement();
            if (element == null) {
                return null;
            }
            ++i;
        }
        Element element = ((PathElementCS)path.get(iLast)).basicGetReferredElement();
        if (element == null) {
            return null;
        }
        return element;
    }

    public static @Nullable DiagnosticMessage getUnresolvedProxyMessage(@NonNull EReference eReference, @NonNull EObject csContext, @NonNull String linkText) {
        String message = CS2AS.getUnresolvedProxyText(eReference, csContext, linkText);
        return message != null ? new DiagnosticMessage(message, Severity.ERROR, "org.eclipse.xtext.diagnostics.Diagnostic.Linking", new String[0]) : null;
    }

    public static @Nullable String getUnresolvedProxyText(@NonNull EReference eReference, @NonNull EObject csContext, @NonNull String linkText) {
        ExceptionAdapter exceptionAdapter = (ExceptionAdapter)((Object)ClassUtil.getAdapter(ExceptionAdapter.class, (Notifier)csContext));
        if (exceptionAdapter != null) {
            return exceptionAdapter.getErrorMessage();
        }
        UnresolvedProxyMessageProvider unresolvedProxyMessageProvider = unresolvedProxyMessageProviderMap.get(eReference);
        if (unresolvedProxyMessageProvider != null) {
            return unresolvedProxyMessageProvider.getMessage(csContext, linkText);
        }
        @NonNull String messageTemplate = PivotMessagesInternal.Unresolved_ERROR_;
        String errorContext = "Unknown";
        EClass referenceType = eReference.getEReferenceType();
        if (referenceType != null) {
            errorContext = referenceType.getName();
        }
        return messageBinder.bind(csContext, messageTemplate, errorContext, linkText);
    }

    public static @Nullable EClassifier getElementType(@NonNull PathNameCS pathNameCS) {
        EList<PathElementCS> path = pathNameCS.getOwnedPathElements();
        int iSize = path.size();
        return iSize > 0 ? ((PathElementCS)path.get(iSize - 1)).getElementType() : null;
    }

    public static MessageBinder getMessageBinder() {
        return messageBinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printDiagnostic(@NonNull String message, boolean dispose, int indent) {
        Integer n = indentation;
        synchronized (n) {
            if (indent < 0) {
                indentation = indentation - 1;
            }
            long currentTimeMillis = System.currentTimeMillis();
            Thread currentThread = Thread.currentThread();
            Long threadStartTime = threadRunTimes.get(currentThread);
            if (threadStartTime == null) {
                threadStartTime = currentTimeMillis;
                threadRunTimes.put(currentThread, threadStartTime);
            }
            if (indent > 0) {
                System.out.printf("%s %8.3f %s -- %6.3f %s\n", indents.substring(0, Math.min(indentation, indents.length() - 1)), (double)(currentTimeMillis - startTime) * 0.001, currentThread.getName(), (double)(currentTimeMillis - threadStartTime) * 0.001, message);
            } else {
                System.out.printf("%s %8.3f %s -- %6.3f %6.3f %s\n", indents.substring(0, Math.min(indentation, indents.length() - 1)), (double)(currentTimeMillis - startTime) * 0.001, currentThread.getName(), (double)(currentTimeMillis - threadStartTime) * 0.001, (double)(currentTimeMillis - indentRunTimes[indentation]) * 0.001, message);
            }
            if (dispose) {
                threadRunTimes.remove(currentThread);
            }
            if (indent > 0) {
                CS2AS.indentRunTimes[CS2AS.indentation.intValue()] = currentTimeMillis;
                indentation = indentation + 1;
            }
        }
    }

    public static void refreshContext(@NonNull PathNameCS pathNameCS, ElementCS csContext) {
        if (pathNameCS.getContext() != csContext) {
            pathNameCS.setContext(csContext);
        }
    }

    public static void refreshElementType(PathElementCS pathElementCS, EClassifier elementType) {
        if (pathElementCS != null && pathElementCS.getElementType() != elementType) {
            pathElementCS.setElementType(elementType);
        }
    }

    public static void refreshScopeFilter(@NonNull PathNameCS pathNameCS, ScopeFilter scopeFilter) {
        if (pathNameCS.getScopeFilter() != scopeFilter) {
            pathNameCS.setScopeFilter(scopeFilter);
        }
    }

    public static void setElementType(@NonNull PathNameCS pathNameCS, EClass elementType, @NonNull ElementCS csContext, @Nullable ScopeFilter scopeFilter) {
        assert (elementType != null);
        CS2AS.refreshContext(pathNameCS, csContext);
        CS2AS.refreshScopeFilter(pathNameCS, scopeFilter);
        EList<PathElementCS> path = pathNameCS.getOwnedPathElements();
        int iMax = path.size() - 1;
        CS2AS.refreshElementType((PathElementCS)path.get(iMax), (EClassifier)elementType);
        if (PivotPackage.Literals.FEATURE.isSuperTypeOf(elementType) && iMax > 0) {
            CS2AS.refreshElementType((PathElementCS)path.get(--iMax), (EClassifier)PivotPackage.Literals.TYPE);
        }
        int i = 0;
        while (i < iMax) {
            CS2AS.refreshElementType((PathElementCS)path.get(i), (EClassifier)PivotPackage.Literals.NAMESPACE);
            ++i;
        }
    }

    public static MessageBinder setMessageBinder(MessageBinder messageBinder) {
        MessageBinder savedMessageBinder = CS2AS.messageBinder;
        CS2AS.messageBinder = messageBinder;
        return savedMessageBinder;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void setPathElement(@NonNull PathNameCS csPathName, @Nullable Element element, @Nullable List<@NonNull ? extends EObject> ambiguities) {
        @NonNull EList csPath = ClassUtil.nullFree(csPathName.getOwnedPathElements());
        PathElementCS csLastElement = (PathElementCS)csPath.get(csPath.size() - 1);
        AmbiguitiesAdapter.setAmbiguities(csLastElement, ambiguities);
        if (element == null || ambiguities != null) {
            PathElementCS eObject = csLastElement;
            ICompositeNode iNode = NodeModelUtils.getNode((EObject)csLastElement);
            Triple triple = Tuples.create((Object)eObject, (Object)BaseCSPackage.Literals.PATH_ELEMENT_CS__REFERRED_ELEMENT, (Object)iNode);
            Resource eResource = csLastElement.eResource();
            if (eResource instanceof BaseCSResource) {
                ((BaseCSResource)eResource).createAndAddDiagnostic((Triple<EObject, EReference, INode>)triple);
            }
            csLastElement.setReferredElement(null);
        } else {
            csLastElement.setReferredElement(element);
        }
    }

    public CS2AS(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull BaseCSResource csResource, @NonNull ASResource asResource) {
        super(environmentFactory);
        this.csi2asMapping = CSI2ASMapping.getCSI2ASMapping(environmentFactory);
        this.csResource = csResource;
        this.asResource = asResource;
        this.csi2asMapping.add(csResource, this);
        ParserContext parserContext2 = this.parserContext = csResource.getParserContext();
        assert (parserContext2 != null);
        if (parserContext2.getEnvironmentFactory() != environmentFactory) {
            System.out.println("[" + Thread.currentThread().getName() + "] Parser " + NameUtil.debugSimpleName((Object)parserContext2.getEnvironmentFactory()));
            System.out.println("[" + Thread.currentThread().getName() + "] CS2AS " + NameUtil.debugSimpleName((Object)environmentFactory));
            System.out.println("[" + Thread.currentThread().getName() + "] Thread " + NameUtil.debugSimpleName((Object)ThreadLocalExecutor.basicGetEnvironmentFactory()));
        }
        assert (parserContext2.getEnvironmentFactory() == environmentFactory);
    }

    protected CS2AS(@NonNull CS2AS aConverter) {
        super(aConverter.getEnvironmentFactory());
        this.csResource = aConverter.csResource;
        this.asResource = aConverter.asResource;
        this.csi2asMapping = CSI2ASMapping.getCSI2ASMapping(this.environmentFactory);
        this.parserContext = aConverter.parserContext;
        assert (this.parserContext != null);
        assert (this.parserContext.getEnvironmentFactory() == this.environmentFactory);
    }

    public @NonNull String bind(@NonNull EObject csContext, String messageTemplate, Object ... bindings) {
        assert (messageTemplate != null);
        return messageBinder.bind(csContext, messageTemplate, bindings);
    }

    protected abstract @NonNull BaseCSVisitor<Continuation<?>> createContainmentVisitor(@NonNull CS2ASConversion var1);

    protected @NonNull CS2ASConversion createConversion(@NonNull IDiagnosticConsumer diagnosticsConsumer, @NonNull BaseCSResource csResource) {
        return new CS2ASConversion(this, diagnosticsConsumer);
    }

    protected @NonNull PivotHelper createHelper() {
        return new PivotHelper((EnvironmentFactory)this.environmentFactory);
    }

    protected abstract @NonNull BaseCSVisitor<Element> createLeft2RightVisitor(@NonNull CS2ASConversion var1);

    protected abstract @NonNull BaseCSVisitor<Continuation<?>> createPostOrderVisitor(@NonNull CS2ASConversion var1);

    protected abstract @NonNull BaseCSVisitor<Continuation<?>> createPreOrderVisitor(@NonNull CS2ASConversion var1);

    public void dispose() {
        this.csi2asMapping.removeCSResource(this.csResource);
    }

    public @NonNull ASResource getASResource() {
        return this.asResource;
    }

    public @Nullable ModelElementCS getCSElement(@NonNull Element pivotElement) {
        return this.csi2asMapping.getCSElement(pivotElement);
    }

    public @NonNull BaseCSResource getCSResource() {
        return this.csResource;
    }

    public @NonNull PivotHelper getHelper() {
        PivotHelper helper2 = this.helper;
        if (helper2 == null) {
            this.helper = helper2 = this.createHelper();
        }
        return helper2;
    }

    public @Nullable Element getPivotElement(@NonNull ModelElementCS csElement) {
        return this.csi2asMapping.get(csElement);
    }

    public <T extends Element> @Nullable T getPivotElement(@NonNull Class<T> pivotClass, @NonNull ModelElementCS csElement) {
        Element pivotElement = this.csi2asMapping.get(csElement);
        if (pivotElement == null) {
            return null;
        }
        if (!pivotClass.isAssignableFrom(pivotElement.getClass())) {
            throw new ClassCastException(String.valueOf(pivotElement.getClass().getName()) + " is not assignable to " + pivotClass.getName());
        }
        Element castElement = pivotElement;
        return (T)castElement;
    }

    public void installPivotDefinition(@NonNull ModelElementCS csElement, @NonNull Element newPivotElement) {
        Element oldPivotElement = csElement.getPivot();
        if (oldPivotElement != newPivotElement) {
            assert (!newPivotElement.eIsProxy());
            csElement.setPivot(newPivotElement);
        }
        this.csi2asMapping.put(csElement, newPivotElement);
    }

    public void installPivotReference(@NonNull ElementRefCS csElement, @NonNull Element newPivotElement, @NonNull EReference eReference) {
        assert (eReference.getEContainingClass().isSuperTypeOf(csElement.eClass()));
        Element oldPivotElement = csElement.getPivot();
        if (oldPivotElement != newPivotElement) {
            assert (!newPivotElement.eIsProxy());
            csElement.setPivot(newPivotElement);
        }
    }

    public void installPivotUsage(@NonNull PivotableElementCS csElement, @NonNull Element newPivotElement) {
        Element oldPivotElement = csElement.getPivot();
        if (oldPivotElement != newPivotElement) {
            assert (!newPivotElement.eIsProxy());
            csElement.setPivot(newPivotElement);
        }
    }

    @Deprecated
    public void installRootContents(@NonNull BaseCSResource csResource2) {
    }

    public @Nullable Boolean isRequired(@NonNull TypedRefCS csTypeRef) {
        MultiplicityCS csMultiplicity = csTypeRef.getOwnedMultiplicity();
        if (csMultiplicity != null) {
            int upper = csMultiplicity.getUpper();
            if (upper != 1) {
                assert (!csTypeRef.eContainer().eClass().getName().equals("CollectionTypeCS"));
                return true;
            }
            int lower = csMultiplicity.getLower();
            if (lower > 0) {
                return true;
            }
            return false;
        }
        return null;
    }

    public @Nullable Iteration lookupIteration(@NonNull ElementCS csElement, @NonNull PathNameCS csPathName, @Nullable ScopeFilter scopeFilter) {
        CS2AS.setElementType(csPathName, PivotPackage.Literals.ITERATION, csElement, scopeFilter);
        Element namedElement = csPathName.getReferredElement();
        if (namedElement instanceof Iteration && !namedElement.eIsProxy()) {
            return (Iteration)namedElement;
        }
        return null;
    }

    public @Nullable Operation lookupOperation(@NonNull ElementCS csElement, @NonNull PathNameCS csPathName, @Nullable ScopeFilter scopeFilter) {
        CS2AS.setElementType(csPathName, PivotPackage.Literals.OPERATION, csElement, scopeFilter);
        Element namedElement = csPathName.getReferredElement();
        if (namedElement instanceof Operation && !namedElement.eIsProxy()) {
            return (Operation)namedElement;
        }
        return null;
    }

    public @Nullable Property lookupProperty(@NonNull ElementCS csElement, @NonNull PathNameCS csPathName, @Nullable ScopeFilter scopeFilter) {
        CS2AS.setElementType(csPathName, PivotPackage.Literals.PROPERTY, csElement, scopeFilter);
        Element namedElement = csPathName.getReferredElement();
        if (namedElement instanceof Property && !namedElement.eIsProxy()) {
            return (Property)namedElement;
        }
        return null;
    }

    public @Nullable VariableDeclaration lookupSelf(@NonNull ElementCS csElement) {
        @NonNull EReference eReference = PivotPackage.Literals.EXPRESSION_IN_OCL__OWNED_CONTEXT;
        EnvironmentView environmentView = this.parserContext != null ? new EnvironmentView(this.parserContext, (EStructuralFeature)eReference, "self") : new EnvironmentView(this.environmentFactory, (EStructuralFeature)eReference, "self");
        BaseScopeView baseScopeView = BaseScopeView.getScopeView(this.environmentFactory, csElement, eReference);
        environmentView.computeLookups((ScopeView)baseScopeView);
        VariableDeclaration variableDeclaration = (VariableDeclaration)environmentView.getContent();
        return variableDeclaration;
    }

    public @Nullable Type lookupType(@NonNull ElementCS csElement, @NonNull PathNameCS csPathName) {
        CS2AS.setElementType(csPathName, PivotPackage.Literals.TYPE, csElement, null);
        Element namedElement = csPathName.getReferredElement();
        if (namedElement instanceof Type && !namedElement.eIsProxy()) {
            return (Type)namedElement;
        }
        return null;
    }

    public @Nullable Type lookupTypeQualifier(@NonNull PathNameCS csPathName) {
        EList<PathElementCS> path = csPathName.getOwnedPathElements();
        int iMax = path.size();
        if (iMax <= 1) {
            return null;
        }
        PathElementCS pathElementCS = (PathElementCS)path.get(iMax - 2);
        CS2AS.refreshElementType(pathElementCS, (EClassifier)PivotPackage.Literals.TYPE);
        int i = 0;
        while (i < iMax - 2) {
            CS2AS.refreshElementType((PathElementCS)path.get(i), (EClassifier)PivotPackage.Literals.NAMESPACE);
            ++i;
        }
        Element namedElement = pathElementCS.getReferredElement();
        if (namedElement instanceof Type && !namedElement.eIsProxy()) {
            return (Type)namedElement;
        }
        return null;
    }

    public @Nullable Type lookupTypeValue(@NonNull ElementCS csElement, @NonNull PathNameCS csPathName) {
        CS2AS.setElementType(csPathName, PivotPackage.Literals.NAMED_ELEMENT, csElement, TypeValueFilter.INSTANCE);
        Element namedElement = csPathName.getReferredElement();
        if (namedElement instanceof Type && !namedElement.eIsProxy()) {
            return (Type)namedElement;
        }
        return null;
    }

    public @Nullable Element lookupUndecoratedName(@NonNull ElementCS csElement, @NonNull PathNameCS csPathName) {
        CS2AS.setElementType(csPathName, PivotPackage.Literals.ELEMENT, csElement, UndecoratedNameFilter.INSTANCE);
        Element namedElement = csPathName.getReferredElement();
        return namedElement;
    }

    public <T extends Element> @NonNull T refreshModelElement(@NonNull Class<T> pivotClass, @NonNull EClass pivotEClass, @Nullable ModelElementCS csElement) {
        Element pivotElement2;
        Element pivotElement;
        Element element = pivotElement = csElement != null ? this.getPivotElement(csElement) : null;
        if (pivotElement != null && pivotClass.isAssignableFrom(pivotElement.getClass()) && (csElement == null || csElement.eContainer() != null)) {
            PivotUtilInternal.resetContainer((EObject)pivotElement);
        }
        if (pivotElement == null || pivotEClass != pivotElement.eClass()) {
            Element pivotElement3;
            EFactory eFactoryInstance = pivotEClass.getEPackage().getEFactoryInstance();
            pivotElement2 = pivotElement3 = (Element)eFactoryInstance.create(pivotEClass);
        } else {
            pivotElement2 = pivotElement;
        }
        if (csElement != null) {
            this.installPivotDefinition(csElement, pivotElement2);
        }
        @NonNull Element castElement = pivotElement2;
        return (T)castElement;
    }

    public synchronized void update(@NonNull IDiagnosticConsumer diagnosticsConsumer) {
        Map<CSI, Element> oldCSI2AS = this.csi2asMapping.getMapping();
        Set<CSI> newCSIs = this.csi2asMapping.computeCSIs(this.csResource);
        CS2ASConversion conversion = this.createConversion(diagnosticsConsumer, this.csResource);
        boolean wasUpdating = false;
        ASResource asResource = this.csi2asMapping.getASResource(this.csResource);
        if (asResource != null) {
            asResource.setUpdating(true);
        }
        conversion.update(this.csResource);
        HashMap<BaseCSResource, ASResource> cs2asResourceMap = new HashMap<BaseCSResource, ASResource>();
        asResource = this.csi2asMapping.getASResource(this.csResource);
        assert (asResource != null);
        cs2asResourceMap.put(this.csResource, asResource);
        AbstractJavaClassScope javaClassScope = AbstractJavaClassScope.findAdapter(this.csResource);
        if (javaClassScope != null) {
            javaClassScope.installContents(this.csResource);
        }
        conversion.garbageCollect(cs2asResourceMap);
        this.csi2asMapping.update();
        assert (asResource.basicGetLUSSIDs() == null);
    }

    public static abstract class AbstractUnresolvedProxyMessageProvider
    implements UnresolvedProxyMessageProvider {
        protected final @NonNull EReference eReference;

        public AbstractUnresolvedProxyMessageProvider(EReference eReference) {
            assert (eReference != null);
            this.eReference = eReference;
        }

        @Override
        public @NonNull EReference getEReference() {
            return this.eReference;
        }

        @Override
        public abstract @Nullable String getMessage(@NonNull EObject var1, @NonNull String var2);
    }

    public static class DefaultMessageBinder
    implements MessageBinder {
        public static final @NonNull MessageBinder INSTANCE = new DefaultMessageBinder();

        @Override
        public @NonNull String bind(@NonNull EObject csContext, @NonNull String messageTemplate, Object ... bindings) {
            return StringUtil.bind((String)messageTemplate, (Object[])bindings);
        }
    }

    public static interface MessageBinder {
        public @NonNull String bind(@NonNull EObject var1, @NonNull String var2, Object ... var3);
    }

    public static class MessageBinderWithLineContext
    implements MessageBinder {
        public static final MessageBinder INSTANCE = new MessageBinderWithLineContext();

        @Override
        public @NonNull String bind(@NonNull EObject csContext, @NonNull String messageTemplate, Object ... bindings) {
            String message = StringUtil.bind((String)messageTemplate, (Object[])bindings);
            ICompositeNode node = NodeModelUtils.getNode((EObject)csContext);
            if (node != null) {
                int startLine = node.getStartLine();
                String uri = csContext.eResource().getURI().toString();
                return String.valueOf(uri) + ":" + startLine + " " + message;
            }
            return message;
        }
    }

    private static final class TypeValueFilter
    implements ScopeFilter {
        public static TypeValueFilter INSTANCE = new TypeValueFilter();

        private TypeValueFilter() {
        }

        public boolean matches(@NonNull EnvironmentView environmentView, @NonNull Object object) {
            if (object instanceof Type) {
                return true;
            }
            if (object instanceof TypedElement) {
                return false;
            }
            return false;
        }
    }

    private static final class UndecoratedNameFilter
    implements ScopeFilter {
        public static UndecoratedNameFilter INSTANCE = new UndecoratedNameFilter();

        private UndecoratedNameFilter() {
        }

        public boolean matches(@NonNull EnvironmentView environmentView, @NonNull Object object) {
            return !(object instanceof Operation) && !(object instanceof Package);
        }
    }

    public static interface UnresolvedProxyMessageProvider {
        public @NonNull EReference getEReference();

        public @Nullable String getMessage(@NonNull EObject var1, @NonNull String var2);
    }
}

