/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.manager;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.AnyType;
import org.eclipse.ocl.pivot.BooleanLiteralExp;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.CompleteInheritance;
import org.eclipse.ocl.pivot.CompletePackage;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ElementExtension;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.Feature;
import org.eclipse.ocl.pivot.IfExp;
import org.eclipse.ocl.pivot.Import;
import org.eclipse.ocl.pivot.IntegerLiteralExp;
import org.eclipse.ocl.pivot.InvalidLiteralExp;
import org.eclipse.ocl.pivot.InvalidType;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.LambdaType;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.Library;
import org.eclipse.ocl.pivot.MapType;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.NullLiteralExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.Precedence;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.RealLiteralExp;
import org.eclipse.ocl.pivot.State;
import org.eclipse.ocl.pivot.Stereotype;
import org.eclipse.ocl.pivot.StringLiteralExp;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.pivot.TemplateSignature;
import org.eclipse.ocl.pivot.TupleType;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.pivot.VoidType;
import org.eclipse.ocl.pivot.WildcardType;
import org.eclipse.ocl.pivot.internal.PackageImpl;
import org.eclipse.ocl.pivot.internal.compatibility.EMF_2_9;
import org.eclipse.ocl.pivot.internal.complete.CompleteClassInternal;
import org.eclipse.ocl.pivot.internal.complete.CompleteEnvironmentInternal;
import org.eclipse.ocl.pivot.internal.complete.CompleteInheritanceImpl;
import org.eclipse.ocl.pivot.internal.complete.CompleteModelInternal;
import org.eclipse.ocl.pivot.internal.complete.CompletePackageInternal;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.internal.ecore.as2es.AS2Ecore;
import org.eclipse.ocl.pivot.internal.ecore.es2as.Ecore2AS;
import org.eclipse.ocl.pivot.internal.library.ConstrainedOperation;
import org.eclipse.ocl.pivot.internal.library.EInvokeOperation;
import org.eclipse.ocl.pivot.internal.library.ImplementationManager;
import org.eclipse.ocl.pivot.internal.library.StandardLibraryContribution;
import org.eclipse.ocl.pivot.internal.manager.FinalAnalysis;
import org.eclipse.ocl.pivot.internal.manager.FlowAnalysis;
import org.eclipse.ocl.pivot.internal.manager.MetamodelManagerInternal;
import org.eclipse.ocl.pivot.internal.manager.Orphanage;
import org.eclipse.ocl.pivot.internal.manager.PrecedenceManager;
import org.eclipse.ocl.pivot.internal.manager.TemplateParameterSubstitutionVisitor;
import org.eclipse.ocl.pivot.internal.manager.TupleTypeManager;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.resource.ASResourceFactory;
import org.eclipse.ocl.pivot.internal.resource.ASResourceFactoryRegistry;
import org.eclipse.ocl.pivot.internal.resource.ASResourceImpl;
import org.eclipse.ocl.pivot.internal.resource.StandaloneProjectMap;
import org.eclipse.ocl.pivot.internal.utilities.AS2XMIid;
import org.eclipse.ocl.pivot.internal.utilities.CompleteElementIterable;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.External2AS;
import org.eclipse.ocl.pivot.internal.utilities.IllegalLibraryException;
import org.eclipse.ocl.pivot.internal.utilities.OppositePropertyDetails;
import org.eclipse.ocl.pivot.internal.utilities.PivotConstantsInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.library.LibraryFeature;
import org.eclipse.ocl.pivot.library.LibraryProperty;
import org.eclipse.ocl.pivot.library.UnsupportedOperation;
import org.eclipse.ocl.pivot.model.OCLmetamodel;
import org.eclipse.ocl.pivot.model.OCLstdlib;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.FeatureFilter;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.ParserContext;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.Pivotable;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.ocl.pivot.utilities.TypeUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.TemplateParameterSubstitutions;
import org.eclipse.ocl.pivot.values.UnlimitedNaturalValue;

public class PivotMetamodelManager
implements MetamodelManagerInternal.MetamodelManagerInternalExtension2,
Adapter.Internal {
    private static final Logger logger = Logger.getLogger(PivotMetamodelManager.class);
    public static final @NonNull TracingOption INSTALL_MODEL = new TracingOption("org.eclipse.ocl.pivot", "install/model");
    public static final @NonNull List<@NonNull Constraint> EMPTY_CONSTRAINT_LIST = Collections.emptyList();
    public static final @NonNull List<@NonNull Element> EMPTY_ELEMENT_LIST = Collections.emptyList();
    public static final @NonNull List<@NonNull Operation> EMPTY_OPERATION_LIST = Collections.emptyList();
    public static final @NonNull List<@NonNull Property> EMPTY_PROPERTY_LIST = Collections.emptyList();
    public static final @NonNull List<@NonNull State> EMPTY_STATE_LIST = Collections.emptyList();
    public static final @NonNull List<@NonNull TemplateParameter> EMPTY_TEMPLATE_PARAMETER_LIST = Collections.emptyList();
    private static final @NonNull List<TemplateParameter> EMPTY_TEMPLATE_PARAMETER_LIST2 = Collections.emptyList();
    public static final @NonNull List<@NonNull Type> EMPTY_TYPE_LIST = Collections.emptyList();
    public static WeakHashMap<@NonNull PivotMetamodelManager, @Nullable Object> liveMetamodelManagers = null;
    protected final @NonNull EnvironmentFactoryInternal environmentFactory;
    private final @NonNull StandardLibraryInternal standardLibrary;
    private final @NonNull CompleteEnvironmentInternal completeEnvironment;
    private final @NonNull CompleteModelInternal completeModel;
    private PrecedenceManager precedenceManager = null;
    private ImplementationManager implementationManager = null;
    protected Package asMetamodel = null;
    private boolean libraryLoadInProgress = false;
    protected final @NonNull ResourceSet asResourceSet;
    protected final @NonNull List<@NonNull Library> asLibraries = new ArrayList<Library>();
    protected @Nullable Resource asLibraryResource = null;
    private final @NonNull Map<String, Namespace> globalNamespaces = new HashMap<String, Namespace>();
    private final @NonNull Set<Type> globalTypes = new HashSet<Type>();
    private final @NonNull Map<URI, External2AS> external2asMap = new HashMap<URI, External2AS>();
    private @Nullable EAnnotation lockingAnnotation = null;
    private boolean autoLoadASmetamodel = true;
    private @Nullable Map<String, GenPackage> genPackageMap = null;
    private @Nullable FinalAnalysis finalAnalysis = null;
    private @Nullable Map<@NonNull OCLExpression, @NonNull FlowAnalysis> oclExpression2flowAnalysis = null;
    private @Nullable Map<Resource, External2AS> es2ases = null;

    public static @Nullable PivotMetamodelManager findAdapter(@NonNull ResourceSet asResourceSet) {
        @NonNull EList eAdapters = asResourceSet.eAdapters();
        return ClassUtil.getAdapter(PivotMetamodelManager.class, (List<Adapter>)eAdapters);
    }

    public static @NonNull PivotMetamodelManager getAdapter(@NonNull ResourceSet asResourceSet) {
        @NonNull EList eAdapters = asResourceSet.eAdapters();
        PivotMetamodelManager adapter = ClassUtil.getAdapter(PivotMetamodelManager.class, (List<Adapter>)eAdapters);
        return ClassUtil.nonNullState(adapter);
    }

    public PivotMetamodelManager(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull ResourceSet asResourceSet) {
        this.environmentFactory = environmentFactory;
        this.asResourceSet = asResourceSet;
        EList asResourceSetAdapters = asResourceSet.eAdapters();
        assert (!asResourceSetAdapters.contains(this));
        asResourceSetAdapters.add(this);
        assert (asResourceSetAdapters.contains(environmentFactory.getProjectManager()));
        this.completeEnvironment = environmentFactory.getCompleteEnvironment();
        this.standardLibrary = environmentFactory.getStandardLibrary();
        this.completeModel = environmentFactory.getCompleteModel();
        if (liveMetamodelManagers != null) {
            liveMetamodelManagers.put(this, null);
            PivotUtilInternal.debugPrintln("Create " + NameUtil.debugSimpleName(this) + " " + NameUtil.debugSimpleName(asResourceSet));
        }
    }

    @Override
    public void addClassLoader(@NonNull ClassLoader classLoader) {
        ImplementationManager implementationManager = this.getImplementationManager();
        implementationManager.addClassLoader(classLoader);
    }

    @Override
    public void addExternal2AS(@NonNull External2AS es2as) {
        Map<Resource, External2AS> es2ases2 = this.es2ases;
        if (es2ases2 == null) {
            this.es2ases = es2ases2 = new HashMap<Resource, External2AS>();
        }
        Resource resource = es2as.getResource();
        URI uri = es2as.getURI();
        External2AS oldES2AS = es2ases2.put(resource, es2as);
        assert (oldES2AS == null);
        oldES2AS = this.external2asMap.put(uri, es2as);
    }

    @Override
    public void addGenModel(@NonNull GenModel genModel) {
        for (GenPackage genPackage : genModel.getAllGenUsedAndStaticGenPackagesWithClassifiers()) {
            this.addGenPackage(genPackage);
        }
    }

    public void addGenPackage(@NonNull GenPackage genPackage) {
        Map<String, GenPackage> genPackageMap2 = this.genPackageMap;
        if (genPackageMap2 == null) {
            this.genPackageMap = genPackageMap2 = new HashMap<String, GenPackage>();
        }
        genPackageMap2.put(genPackage.getNSURI(), genPackage);
    }

    @Override
    public @Nullable Namespace addGlobalNamespace(@NonNull String name, @NonNull Namespace namespace) {
        return this.globalNamespaces.put(name, namespace);
    }

    public boolean addGlobalTypes(@NonNull Collection<Type> types) {
        return this.globalTypes.addAll(types);
    }

    @Override
    public void addLockedElement(@NonNull Object lockedElement) {
        if (lockedElement instanceof EObject) {
            EList lockingReferences;
            EAnnotation lockingAnnotation2 = this.lockingAnnotation;
            if (lockingAnnotation2 == null) {
                this.lockingAnnotation = lockingAnnotation2 = EcoreFactory.eINSTANCE.createEAnnotation();
            }
            if (!(lockingReferences = lockingAnnotation2.getReferences()).contains(lockedElement)) {
                lockingReferences.add((EObject)lockedElement);
            }
        }
    }

    @Deprecated
    public void assignLibraryIds(@NonNull AS2XMIid as2xmIid, @Nullable Map<@NonNull String, @Nullable Object> options) {
        for (Library asLibrary : this.asLibraries) {
            Resource eResource = asLibrary.eResource();
            if (!(eResource instanceof ASResource)) continue;
            as2xmIid.assignIds((ASResource)eResource, options);
        }
    }

    public int compareOperationMatches(@NonNull Operation reference, @NonNull TemplateParameterSubstitutions referenceBindings, @NonNull Operation candidate, @NonNull TemplateParameterSubstitutions candidateBindings) {
        if (reference instanceof Iteration && candidate instanceof Iteration) {
            Type specializedCandidateType;
            int iteratorCountDelta = ((Iteration)candidate).getOwnedIterators().size() - ((Iteration)reference).getOwnedIterators().size();
            if (iteratorCountDelta != 0) {
                return iteratorCountDelta;
            }
            Class referenceClass = reference.getOwningClass();
            Class candidateClass = candidate.getOwningClass();
            Type referenceType = referenceClass != null ? PivotUtil.getBehavioralType(referenceClass) : null;
            Type candidateType = candidateClass != null ? PivotUtil.getBehavioralType(candidateClass) : null;
            Type specializedReferenceType = referenceType != null ? this.completeModel.getSpecializedType(referenceType, referenceBindings) : null;
            Type type = specializedCandidateType = candidateType != null ? this.completeModel.getSpecializedType(candidateType, candidateBindings) : null;
            if (referenceType != candidateType && specializedReferenceType != null && specializedCandidateType != null) {
                if (this.conformsTo(specializedReferenceType, referenceBindings, specializedCandidateType, candidateBindings)) {
                    return 1;
                }
                if (this.conformsTo(specializedCandidateType, candidateBindings, specializedReferenceType, referenceBindings)) {
                    return -1;
                }
            }
        }
        List<Parameter> candidateParameters = candidate.getOwnedParameters();
        List<Parameter> referenceParameters = reference.getOwnedParameters();
        int parameterCountDelta = candidateParameters.size() - referenceParameters.size();
        if (parameterCountDelta != 0) {
            return parameterCountDelta;
        }
        boolean referenceConformsToCandidate = true;
        boolean candidateConformsToReference = true;
        int i = 0;
        while (i < candidateParameters.size()) {
            Parameter referenceParameter = referenceParameters.get(i);
            Parameter candidateParameter = candidateParameters.get(i);
            if (referenceParameter == null || candidateParameter == null) {
                referenceConformsToCandidate = false;
                candidateConformsToReference = false;
            } else {
                Type referenceType = ClassUtil.nonNullState(PivotUtil.getType(referenceParameter));
                Type candidateType = ClassUtil.nonNullState(PivotUtil.getType(candidateParameter));
                Type specializedReferenceType = this.completeModel.getSpecializedType(referenceType, referenceBindings);
                Type specializedCandidateType = this.completeModel.getSpecializedType(candidateType, candidateBindings);
                if (referenceType != candidateType) {
                    if (!this.conformsTo(specializedReferenceType, referenceBindings, specializedCandidateType, candidateBindings)) {
                        referenceConformsToCandidate = false;
                    }
                    if (!this.conformsTo(specializedCandidateType, candidateBindings, specializedReferenceType, referenceBindings)) {
                        candidateConformsToReference = false;
                    }
                }
            }
            ++i;
        }
        if (referenceConformsToCandidate != candidateConformsToReference) {
            return referenceConformsToCandidate ? 1 : -1;
        }
        Type referenceType = ClassUtil.nonNullModel(reference.getOwningClass());
        Type candidateType = ClassUtil.nonNullModel(candidate.getOwningClass());
        Type specializedReferenceType = this.completeModel.getSpecializedType(referenceType, referenceBindings);
        Type specializedCandidateType = this.completeModel.getSpecializedType(candidateType, candidateBindings);
        if (referenceType != candidateType) {
            if (this.conformsTo(specializedReferenceType, referenceBindings, specializedCandidateType, candidateBindings)) {
                return 1;
            }
            if (this.conformsTo(specializedCandidateType, candidateBindings, specializedReferenceType, referenceBindings)) {
                return -1;
            }
        }
        return 0;
    }

    @Override
    public boolean conformsTo(@NonNull Type firstType, @NonNull TemplateParameterSubstitutions firstSubstitutions, @NonNull Type secondType, @NonNull TemplateParameterSubstitutions secondSubstitutions) {
        return this.completeModel.conformsTo(firstType, firstSubstitutions, secondType, secondSubstitutions);
    }

    public @NonNull BooleanLiteralExp createBooleanLiteralExp(boolean booleanSymbol) {
        BooleanLiteralExp asBoolean = PivotFactory.eINSTANCE.createBooleanLiteralExp();
        asBoolean.setBooleanSymbol(booleanSymbol);
        asBoolean.setType(this.standardLibrary.getBooleanType());
        asBoolean.setIsRequired(true);
        return asBoolean;
    }

    public @NonNull IfExp createIfExp(@NonNull OperationCallExp asCondition, @NonNull OCLExpression asThen, @NonNull OCLExpression asElse) {
        return this.createIfExp((OCLExpression)asCondition, asThen, asElse);
    }

    public @NonNull IfExp createIfExp(@NonNull OCLExpression asCondition, @NonNull OCLExpression asThen, @NonNull OCLExpression asElse) {
        Type commonType = this.getCommonType(ClassUtil.nonNullState(asThen.getType()), TemplateParameterSubstitutions.EMPTY, ClassUtil.nonNullState(asElse.getType()), TemplateParameterSubstitutions.EMPTY);
        IfExp asIf = PivotFactory.eINSTANCE.createIfExp();
        asIf.setOwnedCondition(asCondition);
        asIf.setOwnedThen(asThen);
        asIf.setOwnedElse(asElse);
        asIf.setType(commonType);
        asIf.setIsRequired(asThen.isIsRequired() && asElse.isIsRequired());
        return asIf;
    }

    public void createImplicitOppositeProperty(@NonNull Property asProperty, @NonNull String oppositeName, boolean isOrdered, boolean isUnique, @NonNull IntegerValue lower, @NonNull UnlimitedNaturalValue upper) {
        Class localType = asProperty.getOwningClass();
        if (localType == null) {
            asProperty.setOpposite(null);
            return;
        }
        Model thisModel = PivotUtil.getContainingModel(localType);
        assert (thisModel != null);
        Class remoteType = (Class)asProperty.getType();
        while (remoteType instanceof CollectionType) {
            remoteType = (Class)((CollectionType)remoteType).getElementType();
        }
        if (remoteType == null) {
            asProperty.setOpposite(null);
            return;
        }
        Class thisRemoteType = this.getEquivalentClass(thisModel, remoteType);
        Property oppositeProperty = PivotFactory.eINSTANCE.createProperty();
        oppositeProperty.setName(oppositeName);
        oppositeProperty.setIsImplicit(true);
        if (!upper.equals(ValueUtil.ONE_VALUE)) {
            oppositeProperty.setType(this.getCollectionType(isOrdered, isUnique, localType, false, lower, upper));
            oppositeProperty.setIsRequired(true);
        } else {
            oppositeProperty.setType(localType);
            oppositeProperty.setIsRequired(lower.equals(ValueUtil.ONE_VALUE));
        }
        thisRemoteType.getOwnedProperties().add(oppositeProperty);
        oppositeProperty.setOpposite(asProperty);
        asProperty.setOpposite(oppositeProperty);
    }

    public @NonNull IntegerLiteralExp createIntegerLiteralExp(@NonNull Number integerSymbol) {
        IntegerLiteralExp asInteger = PivotFactory.eINSTANCE.createIntegerLiteralExp();
        asInteger.setIntegerSymbol(integerSymbol);
        asInteger.setType(this.standardLibrary.getIntegerType());
        asInteger.setIsRequired(true);
        return asInteger;
    }

    public @NonNull InvalidLiteralExp createInvalidExpression() {
        InvalidLiteralExp invalidLiteralExp = PivotFactory.eINSTANCE.createInvalidLiteralExp();
        invalidLiteralExp.setType(this.standardLibrary.getOclInvalidType());
        return invalidLiteralExp;
    }

    public @NonNull NullLiteralExp createNullLiteralExp() {
        NullLiteralExp asNull = PivotFactory.eINSTANCE.createNullLiteralExp();
        asNull.setType(this.standardLibrary.getOclVoidType());
        asNull.setIsRequired(false);
        return asNull;
    }

    @Deprecated
    public @Nullable Map<@NonNull String, @NonNull String> createOppositeEAnnotationDetails(@NonNull Property property) {
        OppositePropertyDetails oppositePropertyDetails = OppositePropertyDetails.createFromProperty(property);
        if (oppositePropertyDetails != null) {
            HashMap<@NonNull String, @NonNull String> details = new HashMap<String, String>();
            oppositePropertyDetails.addDetails(details);
            return details;
        }
        return null;
    }

    public @NonNull Orphanage createOrphanage() {
        return Orphanage.getOrphanage(this.asResourceSet);
    }

    @Override
    @Deprecated
    public @Nullable ParserContext createParserContext(@NonNull Element element, Object ... todoParameters) {
        return ((EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)this.environmentFactory).createParserContext(element);
    }

    protected @NonNull PrecedenceManager createPrecedenceManager() {
        PrecedenceManager precedenceManager = new PrecedenceManager();
        List<@NonNull String> errors = precedenceManager.compilePrecedences(this.asLibraries);
        for (String error : errors) {
            logger.error((Object)error);
        }
        return precedenceManager;
    }

    public @NonNull RealLiteralExp createRealLiteralExp(@NonNull Number realSymbol) {
        RealLiteralExp asReal = PivotFactory.eINSTANCE.createRealLiteralExp();
        asReal.setRealSymbol(realSymbol);
        asReal.setType(this.standardLibrary.getRealType());
        asReal.setIsRequired(true);
        return asReal;
    }

    public @NonNull StringLiteralExp createStringLiteralExp(@NonNull String stringSymbol) {
        StringLiteralExp asString = PivotFactory.eINSTANCE.createStringLiteralExp();
        asString.setStringSymbol(stringSymbol);
        asString.setType(this.standardLibrary.getStringType());
        asString.setIsRequired(true);
        return asString;
    }

    public @NonNull UnlimitedNaturalLiteralExp createUnlimitedNaturalLiteralExp(@NonNull Number unlimitedNaturalSymbol) {
        UnlimitedNaturalLiteralExp asUnlimitedNatural = PivotFactory.eINSTANCE.createUnlimitedNaturalLiteralExp();
        asUnlimitedNatural.setUnlimitedNaturalSymbol(unlimitedNaturalSymbol);
        asUnlimitedNatural.setType(this.standardLibrary.getUnlimitedNaturalType());
        asUnlimitedNatural.setIsRequired(true);
        return asUnlimitedNatural;
    }

    public @NonNull WildcardType createWildcardType(@Nullable Class lowerBound, @Nullable Class upperBound) {
        WildcardType wildcardType = Orphanage.getOrphanWildcardType(this.environmentFactory.getCompleteModel().getOrphanage());
        return wildcardType;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void dispose() {
        this.asResourceSet.eAdapters().remove((Object)this);
        @NonNull EList asResources = this.asResourceSet.getResources();
        for (Resource asResource : new ArrayList(asResources)) {
            asResource.unload();
            asResource.eAdapters().clear();
        }
        asResources.clear();
        this.asResourceSet.setPackageRegistry(null);
        this.asResourceSet.setResourceFactoryRegistry(null);
        this.asResourceSet.setURIConverter(null);
        this.asLibraries.clear();
        this.asLibraryResource = null;
        StandaloneProjectMap projectMap = StandaloneProjectMap.findAdapter(this.asResourceSet);
        if (projectMap != null) {
            projectMap.unload(this.asResourceSet);
        }
        this.asResourceSet.eAdapters().clear();
        this.globalNamespaces.clear();
        this.globalTypes.clear();
        this.external2asMap.clear();
        Map<Resource, External2AS> es2ases2 = this.es2ases;
        if (es2ases2 != null) {
            for (External2AS es2as : es2ases2.values()) {
                es2as.dispose();
            }
            this.es2ases = null;
        }
        this.lockingAnnotation = null;
        this.completeModel.dispose();
        if (this.precedenceManager != null) {
            this.precedenceManager.dispose();
            this.precedenceManager = null;
        }
        if (this.implementationManager != null) {
            this.implementationManager.dispose();
            this.implementationManager = null;
        }
        this.asMetamodel = null;
        this.standardLibrary.dispose();
    }

    protected void finalize() throws Throwable {
        if (liveMetamodelManagers != null) {
            PivotUtilInternal.debugPrintln("Finalize " + NameUtil.debugSimpleName(this));
            ArrayList<@NonNull PivotMetamodelManager> keySet = new ArrayList<PivotMetamodelManager>(liveMetamodelManagers.keySet());
            if (!keySet.isEmpty()) {
                StringBuilder s = new StringBuilder();
                s.append(" live");
                for (PivotMetamodelManager metamodelManager : keySet) {
                    s.append(" @" + Integer.toHexString(metamodelManager.hashCode()));
                }
                System.out.println(s.toString());
            }
        }
    }

    @Override
    public @Nullable Class getASClass(@NonNull String className) {
        if (this.asMetamodel == null) {
            this.getASmetamodel();
            if (this.asMetamodel == null) {
                return null;
            }
        }
        return NameUtil.getNameable(this.asMetamodel.getOwnedClasses(), className);
    }

    public @Nullable Element getASElement(@NonNull URI uri) {
        if (uri.fragment() == null) {
            ASResource resource = (ASResource)this.asResourceSet.getResource(uri, true);
            return resource.getModel();
        }
        Element element = (Element)this.asResourceSet.getEObject(uri, true);
        return element;
    }

    @Override
    @Deprecated
    public <T extends Element> @Nullable T getASOf(@NonNull java.lang.Class<T> pivotClass, @Nullable EObject eObject) throws ParserException {
        return ((EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)this.environmentFactory).getASOf(pivotClass, eObject);
    }

    @Override
    public <T extends Element> @Nullable T getASOfEcore(@NonNull java.lang.Class<T> pivotClass, @Nullable EObject eObject) {
        if (eObject == null) {
            return null;
        }
        Resource metamodel = eObject.eResource();
        if (metamodel == null) {
            return null;
        }
        External2AS es2as = Ecore2AS.findAdapter(metamodel, this.environmentFactory);
        if (es2as == null) {
            es2as = Ecore2AS.getAdapter(metamodel, this.environmentFactory);
        }
        return es2as.getCreated(pivotClass, eObject);
    }

    @Override
    public @Nullable Package getASmetamodel() {
        if (this.asMetamodel == null && this.autoLoadASmetamodel) {
            Package stdlibPackage = null;
            AnyType oclAnyType = this.standardLibrary.getOclAnyType();
            stdlibPackage = oclAnyType.getOwningPackage();
            if (stdlibPackage != null) {
                this.loadASmetamodel(stdlibPackage);
            }
        }
        return this.asMetamodel;
    }

    @Override
    public @NonNull ResourceSet getASResourceSet() {
        return this.asResourceSet;
    }

    public @NonNull Iterable<@NonNull CompletePackageInternal> getAllCompletePackages() {
        if (!this.libraryLoadInProgress && this.asMetamodel == null) {
            this.getASmetamodel();
        }
        return this.completeModel.getAllCompletePackages();
    }

    @Override
    public @NonNull Iterable<Constraint> getAllInvariants(@NonNull Type pivotType) {
        HashSet<Constraint> knownInvariants = new HashSet<Constraint>();
        for (CompleteClass superType : this.getAllSuperCompleteClasses(pivotType)) {
            for (Class partialSuperType : ClassUtil.nullFree(superType.getPartialClasses())) {
                Package partialPackage = partialSuperType.getOwningPackage();
                if (partialPackage instanceof PackageImpl && ((PackageImpl)partialPackage).isIgnoreInvariants()) continue;
                knownInvariants.addAll(partialSuperType.getOwnedInvariants());
            }
        }
        return knownInvariants;
    }

    public @NonNull Iterable<@NonNull Operation> getAllOperations(@NonNull Type type, @Nullable FeatureFilter featureFilter) {
        CompleteClassInternal completeClass = this.completeModel.getCompleteClass(type);
        return completeClass.getOperations(featureFilter);
    }

    public @NonNull Iterable<@NonNull Operation> getAllOperations(@NonNull Type type, @Nullable FeatureFilter featureFilter, @NonNull String name) {
        CompleteClassInternal completeClass = this.completeModel.getCompleteClass(type);
        return completeClass.getOperations(featureFilter, name);
    }

    public @NonNull Iterable<? extends Property> getAllProperties(@NonNull Type type, @Nullable FeatureFilter featureFilter) {
        CompleteClassInternal completeClass = this.completeModel.getCompleteClass(type);
        return completeClass.getProperties(featureFilter);
    }

    public @NonNull Iterable<? extends Property> getAllProperties(@NonNull Type type, @Nullable FeatureFilter featureFilter, @NonNull String name) {
        CompleteClassInternal completeClass = this.completeModel.getCompleteClass(type);
        return completeClass.getProperties(featureFilter, name);
    }

    public @NonNull Iterable<? extends Property> getAllProperties(@NonNull Property pivotProperty) {
        CompleteInheritance pivotClass = pivotProperty.getInheritance(this.standardLibrary);
        if (pivotClass == null) {
            throw new IllegalStateException("Missing owning type");
        }
        CompleteClassInternal completeClass = this.completeModel.getCompleteClass(pivotClass.getPivotClass());
        Iterable<Property> memberProperties = completeClass.getProperties(pivotProperty);
        if (memberProperties != null) {
            return memberProperties;
        }
        return Collections.singletonList(pivotProperty);
    }

    public @NonNull Iterable<@NonNull CompleteClass> getAllSuperCompleteClasses(@NonNull Type type) {
        CompleteClassInternal completeClass = this.completeModel.getCompleteClass(type);
        return completeClass.getSuperCompleteClasses();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Deprecated
    public @NonNull Iterable<@NonNull Class> getAllTypes(@NonNull Class pivotType) {
        CompleteClassInternal completeClass = this.completeModel.getCompleteClass(pivotType);
        @NonNull @NonNull Iterable filter = Iterables.filter(completeClass.getPartialClasses(), Class.class);
        return filter;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Deprecated
    public @NonNull Iterable<@NonNull Type> getAllTypes(@NonNull Type pivotType) {
        CompleteClassInternal completeClass = this.completeModel.getCompleteClass(pivotType);
        @NonNull @NonNull Iterable filter = Iterables.filter(completeClass.getPartialClasses(), Type.class);
        return filter;
    }

    public @Nullable ExpressionInOCL getBodyExpression(@NonNull Operation operation) {
        ExpressionInOCL bodyExpression = null;
        for (Operation operation2 : this.getOperationOverloads(operation)) {
            LanguageExpression anExpression = operation2.getBodyExpression();
            if (anExpression == null) continue;
            if (bodyExpression != null) {
                throw new IllegalStateException("Multiple bodies for " + operation);
            }
            try {
                bodyExpression = ((EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)this.environmentFactory).parseSpecification(anExpression);
            }
            catch (ParserException e) {
                String message = e.getMessage();
                if (message == null) {
                    message = "";
                }
                logger.error((Object)message);
                bodyExpression = PivotUtil.createExpressionInOCLError(message);
            }
        }
        return bodyExpression;
    }

    public @NonNull CollectionType getCollectionType(boolean isOrdered, boolean isUnique) {
        if (isOrdered) {
            if (isUnique) {
                return this.standardLibrary.getOrderedSetType();
            }
            return this.standardLibrary.getSequenceType();
        }
        if (isUnique) {
            return this.standardLibrary.getSetType();
        }
        return this.standardLibrary.getBagType();
    }

    public @NonNull CollectionType getCollectionType(boolean isOrdered, boolean isUnique, @NonNull Type elementType, boolean isNullFree, @Nullable IntegerValue lower, @Nullable UnlimitedNaturalValue upper) {
        return this.completeEnvironment.getCollectionType(this.getCollectionType(isOrdered, isUnique), elementType, isNullFree, lower, upper);
    }

    @Deprecated
    public @NonNull Class getCollectionType(@NonNull String collectionTypeName, @NonNull Type elementType, @Nullable IntegerValue lower, @Nullable UnlimitedNaturalValue upper) {
        return this.getCollectionType(collectionTypeName, elementType, false, lower, upper);
    }

    @Override
    public @NonNull Class getCollectionType(@NonNull String collectionTypeName, @NonNull Type elementType, boolean isNullFree, @Nullable IntegerValue lower, @Nullable UnlimitedNaturalValue upper) {
        if (elementType.eIsProxy()) {
            return this.standardLibrary.getOclInvalidType();
        }
        return this.completeEnvironment.getCollectionType(this.standardLibrary.getRequiredLibraryType(collectionTypeName), elementType, isNullFree, lower, upper);
    }

    public @NonNull Type getCommonType(@NonNull Type leftType, @NonNull TemplateParameterSubstitutions leftSubstitutions, @NonNull Type rightType, @NonNull TemplateParameterSubstitutions rightSubstitutions) {
        if (leftType instanceof TupleType && rightType instanceof TupleType) {
            TupleTypeManager tupleManager = this.completeModel.getTupleManager();
            Type commonType = tupleManager.getCommonType((TupleType)leftType, leftSubstitutions, (TupleType)rightType, rightSubstitutions);
            if (commonType == null) {
                commonType = this.standardLibrary.getOclAnyType();
            }
            return commonType;
        }
        if (leftType instanceof CollectionType && rightType instanceof CollectionType) {
            CompleteInheritance leftInheritance = leftType.getInheritance(this.standardLibrary);
            CompleteInheritance rightInheritance = rightType.getInheritance(this.standardLibrary);
            CompleteInheritance commonInheritance = leftInheritance.getCommonInheritance(rightInheritance);
            Class commonCollectionType = this.getPrimaryClass(commonInheritance.getPivotClass());
            CollectionType leftCollectionType = (CollectionType)leftType;
            CollectionType rightCollectionType = (CollectionType)rightType;
            Type leftElementType = ClassUtil.nonNullModel(leftCollectionType.getElementType());
            Type rightElementType = ClassUtil.nonNullModel(rightCollectionType.getElementType());
            Type commonElementType = this.getCommonType(leftElementType, leftSubstitutions, rightElementType, rightSubstitutions);
            boolean commonIsNullFree = leftCollectionType.isIsNullFree() && rightCollectionType.isIsNullFree();
            return this.completeEnvironment.getCollectionType(commonCollectionType, commonElementType, commonIsNullFree, (IntegerValue)null, (UnlimitedNaturalValue)null);
        }
        if (this.conformsTo(leftType, leftSubstitutions, rightType, rightSubstitutions)) {
            return rightType;
        }
        if (this.conformsTo(rightType, rightSubstitutions, leftType, leftSubstitutions)) {
            return leftType;
        }
        CompleteInheritance leftInheritance = leftType.getInheritance(this.standardLibrary);
        CompleteInheritance rightInheritance = rightType.getInheritance(this.standardLibrary);
        CompleteInheritance commonInheritance = leftInheritance.getCommonInheritance(rightInheritance);
        return this.getPrimaryClass(commonInheritance.getPivotClass());
    }

    @Override
    public @NonNull CompleteClassInternal getCompleteClass(@NonNull Type pivotType) {
        if (!(this.libraryLoadInProgress || this.asMetamodel != null || pivotType instanceof CollectionType || pivotType instanceof VoidType || pivotType instanceof InvalidType)) {
            this.getASmetamodel();
        }
        return this.completeModel.getCompleteClass(pivotType);
    }

    public @NonNull CompleteEnvironmentInternal getCompleteEnvironment() {
        return this.completeEnvironment;
    }

    @Override
    public @NonNull CompleteModelInternal getCompleteModel() {
        return this.completeModel;
    }

    @Override
    public @NonNull CompletePackage getCompletePackage(@NonNull Package asPackage) {
        if (!this.libraryLoadInProgress && this.asMetamodel == null) {
            this.getASmetamodel();
        }
        return this.completeModel.getCompletePackage(asPackage);
    }

    public @Nullable ExpressionInOCL getDefaultExpression(@NonNull Property property) {
        ExpressionInOCL defaultExpression = null;
        for (Property property2 : this.getAllProperties(property)) {
            LanguageExpression anExpression = property2.getOwnedExpression();
            if (anExpression == null) continue;
            if (defaultExpression != null) {
                throw new IllegalStateException("Multiple derivations for " + property);
            }
            try {
                defaultExpression = ((EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)this.environmentFactory).parseSpecification(anExpression);
            }
            catch (ParserException e) {
                String message = e.getMessage();
                if (message == null) {
                    message = "";
                }
                logger.error((Object)message);
                defaultExpression = PivotUtil.createExpressionInOCLError(message);
            }
        }
        return defaultExpression;
    }

    @Override
    public <T extends EObject> @Nullable T getEcoreOfPivot(@NonNull java.lang.Class<T> ecoreClass, @NonNull Element element) {
        EObject eTarget = element.getESObject();
        if (eTarget != null) {
            if (!ecoreClass.isAssignableFrom(eTarget.getClass())) {
                logger.error((Object)("Ecore " + eTarget.getClass().getName() + "' element is not a '" + ecoreClass.getName() + "'"));
                return null;
            }
            EObject castTarget = eTarget;
            return (T)castTarget;
        }
        Model root = (Model)EcoreUtil.getRootContainer((EObject)element);
        Resource asResource = element.eResource();
        if (asResource == null) {
            return null;
        }
        if (asResource instanceof OCLstdlib) {
            return null;
        }
        String externalUri = root.getExternalURI();
        URI externalURI = URI.createURI((String)externalUri);
        URI ecoreURI = PivotUtilInternal.isASURI(externalUri) ? ClassUtil.nonNullEMF(externalURI.trimFileExtension()) : ClassUtil.nonNullEMF(externalURI.appendFileExtension("ecore"));
        AS2Ecore converter = new AS2Ecore(this.environmentFactory, ecoreURI, null);
        converter.convertResource(asResource, ecoreURI);
        return converter.getCreated(ecoreClass, element);
    }

    public @NonNull ElementExtension getElementExtension(@NonNull Element asStereotypedElement, @NonNull Stereotype asStereotype) {
        ElementExtension asElementExtension2;
        List<ElementExtension> extensions = asStereotypedElement.getOwnedExtensions();
        for (ElementExtension asElementExtension2 : extensions) {
            if (asElementExtension2.getStereotype() != asStereotype) continue;
            return asElementExtension2;
        }
        asElementExtension2 = PivotFactory.eINSTANCE.createElementExtension();
        asElementExtension2.setStereotype(asStereotype);
        String name = this.environmentFactory.getTechnology().getExtensionName(asStereotypedElement);
        asElementExtension2.setName(String.valueOf(name) + "$" + asStereotype.getName());
        extensions.add(asElementExtension2);
        return asElementExtension2;
    }

    @Override
    public @NonNull EnvironmentFactoryInternal getEnvironmentFactory() {
        return this.environmentFactory;
    }

    public @NonNull Class getEquivalentClass(@NonNull Model thisModel, @NonNull Class thatClass) {
        String className;
        this.completeModel.getCompleteClass(thatClass);
        Model thatModel = PivotUtil.getContainingModel(thatClass);
        if (thisModel == thatModel) {
            return thatClass;
        }
        Package thatPackage = PivotUtil.getOwningPackage(thatClass);
        Package thisPackage = this.getEquivalentPackage(thisModel, thatPackage);
        List<Class> theseClasses = thisPackage.getOwnedClasses();
        Class thisClass = NameUtil.getNameable(theseClasses, className = PivotUtil.getName(thatClass));
        if (thisClass == null) {
            thisClass = PivotUtil.createClass(className);
            theseClasses.add(thisClass);
        }
        return thisClass;
    }

    private @NonNull Package getEquivalentPackage(@NonNull Model thisModel, @NonNull Package thatPackage) {
        List<Package> thesePackages;
        this.completeModel.getCompletePackage(thatPackage);
        Model thatModel = PivotUtil.getContainingModel(thatPackage);
        if (thisModel == thatModel) {
            return thatPackage;
        }
        Package thatParentPackage = thatPackage.getOwningPackage();
        if (thatParentPackage == null) {
            thesePackages = thisModel.getOwnedPackages();
        } else {
            Package thisParentPackage = this.getEquivalentPackage(thisModel, thatParentPackage);
            thesePackages = thisParentPackage.getOwnedPackages();
        }
        String packageName = PivotUtil.getName(thatPackage);
        Package thisPackage = NameUtil.getNameable(thesePackages, packageName);
        if (thisPackage == null) {
            String pkgURI = ClassUtil.nonNullModel(thatPackage.getURI());
            thisPackage = PivotUtil.createPackage(packageName, thatPackage.getNsPrefix(), pkgURI, thatPackage.getPackageId());
            thesePackages.add(thisPackage);
        }
        return thisPackage;
    }

    public @Nullable External2AS getES2AS(@NonNull Resource esResource) {
        return this.es2ases != null ? this.es2ases.get(esResource) : null;
    }

    @Override
    public @NonNull FinalAnalysis getFinalAnalysis() {
        FinalAnalysis finalAnalysis2 = this.finalAnalysis;
        if (finalAnalysis2 == null) {
            this.finalAnalysis = finalAnalysis2 = new FinalAnalysis(this.completeModel);
        }
        return finalAnalysis2;
    }

    @Override
    public @NonNull FlowAnalysis getFlowAnalysis(@NonNull OCLExpression oclExpression) {
        FlowAnalysis flowAnalysis;
        OCLExpression contextExpression = FlowAnalysis.getControlExpression(oclExpression);
        Map<@NonNull OCLExpression, @NonNull FlowAnalysis> oclExpression2flowAnalysis2 = this.oclExpression2flowAnalysis;
        if (oclExpression2flowAnalysis2 == null) {
            oclExpression2flowAnalysis2 = this.oclExpression2flowAnalysis = new HashMap<OCLExpression, FlowAnalysis>();
        }
        if ((flowAnalysis = oclExpression2flowAnalysis2.get(contextExpression)) == null) {
            flowAnalysis = this.environmentFactory.createFlowAnalysis(contextExpression);
            oclExpression2flowAnalysis2.put(contextExpression, flowAnalysis);
        }
        return flowAnalysis;
    }

    @Override
    public @Nullable GenPackage getGenPackage(@NonNull String nsURI) {
        GenPackage genPackage;
        if (this.genPackageMap != null && (genPackage = this.genPackageMap.get(nsURI)) != null) {
            return genPackage;
        }
        ResourceSet externalResourceSet = this.environmentFactory.getResourceSet();
        URI uri = EMF_2_9.EcorePlugin.getEPackageNsURIToGenModelLocationMap(true).get(nsURI);
        if (uri != null) {
            Resource resource = externalResourceSet.getResource(uri, true);
            for (EObject eObject : resource.getContents()) {
                if (!(eObject instanceof GenModel)) continue;
                GenModel genModel = (GenModel)eObject;
                genModel.reconcile();
                for (GenPackage genPackage2 : genModel.getGenPackages()) {
                    if (genPackage2 == null) continue;
                    this.addGenPackage(genPackage2);
                    return genPackage2;
                }
            }
        }
        return null;
    }

    public @NonNull Set<@NonNull Map.Entry<String, Namespace>> getGlobalNamespaces() {
        return this.globalNamespaces.entrySet();
    }

    public @NonNull Iterable<Type> getGlobalTypes() {
        return this.globalTypes;
    }

    public @NonNull LibraryFeature getImplementation(@NonNull Feature feature) throws ClassNotFoundException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        ImplementationManager implementationManager;
        LibraryFeature implementation = feature.getImplementation();
        if (implementation == null && (implementation = (implementationManager = this.getImplementationManager()).loadImplementation(feature)) == null) {
            implementation = UnsupportedOperation.INSTANCE;
        }
        return implementation;
    }

    public @NonNull LibraryFeature getImplementation(@NonNull Operation operation) {
        LibraryFeature implementation = operation.getImplementation();
        if (implementation == null) {
            EObject eTarget;
            ExpressionInOCL query;
            Class owningType;
            LanguageExpression specification;
            boolean isCodeGeneration = this.getCompleteEnvironment().isCodeGeneration();
            if (isCodeGeneration && (specification = operation.getBodyExpression()) != null && (owningType = operation.getOwningClass()) != null) {
                try {
                    query = ((EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)this.environmentFactory).parseSpecification(specification);
                    implementation = new ConstrainedOperation(query);
                }
                catch (ParserException e) {
                    implementation = UnsupportedOperation.INSTANCE;
                }
            }
            if (implementation == null && (eTarget = operation.getESObject()) != null) {
                EOperation eOperation = null;
                if (eTarget instanceof EOperation) {
                    eOperation = (EOperation)eTarget;
                    while (eOperation.eContainer() instanceof EAnnotation) {
                        EObject eReference;
                        EList references;
                        EAnnotation redefines = eOperation.getEAnnotation("redefines");
                        if (redefines == null || (references = redefines.getReferences()).size() <= 0 || !((eReference = (EObject)references.get(0)) instanceof EOperation)) continue;
                        eOperation = (EOperation)eReference;
                    }
                } else {
                    Resource resource = operation.eResource();
                    if (resource instanceof ASResource) {
                        ASResource asResource = (ASResource)resource;
                        eOperation = asResource.getASResourceFactory().getEOperation(asResource, eTarget);
                    }
                }
                if (eOperation != null && eOperation.getEType() != null) {
                    implementation = new EInvokeOperation(eOperation);
                }
            }
            if (!isCodeGeneration && implementation == null && (specification = operation.getBodyExpression()) != null && (owningType = operation.getOwningClass()) != null) {
                try {
                    query = ((EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)this.environmentFactory).parseSpecification(specification);
                    implementation = new ConstrainedOperation(query);
                }
                catch (ParserException e) {
                    implementation = UnsupportedOperation.INSTANCE;
                }
            }
            if (implementation == null) {
                try {
                    implementation = this.getImplementation((Feature)operation);
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
                    // empty catch block
                }
            }
            if (implementation == null) {
                implementation = UnsupportedOperation.INSTANCE;
            }
            operation.setImplementation(implementation);
        }
        return implementation;
    }

    @Deprecated
    public @NonNull LibraryProperty getImplementation(@Nullable Object sourceValue, @NonNull Property property) {
        return this.getImplementation(null, sourceValue, property);
    }

    @Override
    public @NonNull LibraryProperty getImplementation(@Nullable Element asNavigationExp, @Nullable Object sourceValue, @NonNull Property property) {
        LibraryProperty implementation = (LibraryProperty)property.getImplementation();
        if (implementation == null) {
            ImplementationManager implementationManager = this.getImplementationManager();
            implementation = implementationManager.getPropertyImplementation(asNavigationExp, sourceValue, property);
            property.setImplementation(implementation);
        }
        return implementation;
    }

    public @NonNull ImplementationManager getImplementationManager() {
        ImplementationManager implementationManager2 = this.implementationManager;
        if (implementationManager2 == null) {
            implementationManager2 = this.implementationManager = this.environmentFactory.createImplementationManager();
        }
        return implementationManager2;
    }

    public @Nullable Precedence getInfixPrecedence(@NonNull String operatorName) {
        this.getStandardLibrary();
        PrecedenceManager precedenceManager = this.getPrecedenceManager();
        return precedenceManager.getInfixPrecedence(operatorName);
    }

    public @NonNull CompleteInheritance getInheritance(@NonNull Class type) {
        Class type1 = this.getPrimaryClass(type);
        Class unspecializedType = (Class)type1.getUnspecializedElement();
        Class theType = unspecializedType != null ? unspecializedType : type1;
        CompleteInheritanceImpl completeInheritance = this.getCompleteClass(theType).getCompleteInheritance();
        return completeInheritance;
    }

    public @NonNull List<@NonNull Library> getLibraries() {
        return this.asLibraries;
    }

    public @Nullable Resource getLibraryResource() {
        return this.asLibraryResource;
    }

    public @Nullable Class getLibraryType(@NonNull String string, @NonNull List<@NonNull ? extends Type> templateArguments) {
        Class libraryType = this.standardLibrary.getRequiredLibraryType(string);
        return this.getLibraryType(libraryType, templateArguments);
    }

    public <T extends Class> @NonNull T getLibraryType(@NonNull T libraryType, @NonNull List<@NonNull ? extends Type> templateArguments) {
        List<TemplateParameter> templateParameters;
        assert (libraryType == PivotUtil.getUnspecializedTemplateableElement(libraryType));
        TemplateSignature templateSignature = libraryType.getOwnedSignature();
        List<TemplateParameter> list = templateParameters = templateSignature != null ? templateSignature.getOwnedParameters() : EMPTY_TEMPLATE_PARAMETER_LIST2;
        if (templateParameters.isEmpty()) {
            return libraryType;
        }
        if (templateArguments.size() != templateParameters.size()) {
            throw new IllegalArgumentException("Incorrect template bindings for template type " + libraryType.getName());
        }
        boolean isUnspecialized = this.isUnspecialized(templateParameters, templateArguments);
        if (isUnspecialized) {
            return libraryType;
        }
        CompleteClassInternal libraryCompleteClass = this.getCompleteClass(libraryType);
        Class pivotClass = libraryCompleteClass.getPrimaryClass();
        if (pivotClass instanceof CollectionType) {
            assert (pivotClass instanceof CollectionType);
            assert (templateArguments.size() == 1);
            @NonNull Type templateArgument = templateArguments.get(0);
            CollectionType specializedType = this.completeModel.getCollectionType(libraryCompleteClass, TypeUtil.createCollectionTypeParameters(templateArgument, true, null, null));
            return (T)specializedType;
        }
        if (pivotClass instanceof MapType) {
            assert (pivotClass instanceof MapType);
            assert (templateArguments.size() == 2);
            @NonNull Type keyTemplateArgument = templateArguments.get(0);
            @NonNull Type valueTemplateArgument = templateArguments.get(1);
            MapType specializedType = this.completeModel.getMapType(libraryCompleteClass, TypeUtil.createMapTypeParameters(keyTemplateArgument, true, valueTemplateArgument, true));
            return (T)specializedType;
        }
        Class specializedType = libraryCompleteClass.getPartialClasses().getSpecializedType(templateArguments);
        return (T)specializedType;
    }

    public @NonNull Iterable<Constraint> getLocalInvariants(@NonNull Class type) {
        type = PivotUtil.getUnspecializedTemplateableElement(type);
        return new CompleteElementInvariantsIterable(this.getAllTypes(type));
    }

    public @Nullable EObject getLockingObject() {
        return this.lockingAnnotation;
    }

    public @NonNull Class getMapType(@NonNull String mapTypeName, @NonNull Type keyType, boolean keysAreNullFree, @NonNull Type valueType, boolean valuesAreNullFree) {
        if (keyType.eIsProxy() || valueType.eIsProxy()) {
            return this.standardLibrary.getOclInvalidType();
        }
        return this.completeEnvironment.getMapType(this.standardLibrary.getRequiredLibraryType(mapTypeName), keyType, keysAreNullFree, valueType, valuesAreNullFree);
    }

    @Deprecated
    public @NonNull Class getMapType(@NonNull String mapTypeName, @NonNull Type keyType, @NonNull Type valueType) {
        return this.getMapType(mapTypeName, keyType, true, valueType, true);
    }

    public @NonNull Class getMapType(@NonNull Class entryClass) {
        if (entryClass.eIsProxy()) {
            return this.standardLibrary.getOclInvalidType();
        }
        return this.completeEnvironment.getMapType(this.standardLibrary.getMapType(), entryClass);
    }

    public @NonNull Iterable<@NonNull Operation> getMemberOperations(@NonNull Class type, boolean selectStatic) {
        type = PivotUtil.getUnspecializedTemplateableElement(type);
        return new CompleteTypeOperationsIterable(this.getAllTypes(type), selectStatic);
    }

    public @NonNull Iterable<? extends CompletePackage> getMemberPackages(@NonNull Package pkg) {
        return this.getCompletePackage(pkg).getOwnedCompletePackages();
    }

    public @NonNull Iterable<@NonNull Property> getMemberProperties(@NonNull Class type, boolean selectStatic) {
        type = PivotUtil.getUnspecializedTemplateableElement(type);
        return new CompleteClassPropertiesIterable(this.getAllTypes(type), selectStatic);
    }

    public @NonNull Class getMetaclass(@NonNull Type asInstanceType) {
        String metaclassName = TypeUtil.getMetaclassName(asInstanceType);
        return ClassUtil.nonNullState(this.getASClass(metaclassName));
    }

    public @Nullable Type getOclType(@NonNull String typeName) {
        Class pivotType = this.getASClass(typeName);
        return pivotType != null ? this.getInheritance(pivotType).getPivotClass() : null;
    }

    public @NonNull Iterable<? extends Operation> getOperationOverloads(@NonNull Operation pivotOperation) {
        CompleteInheritance pivotClass = pivotOperation.getInheritance(this.standardLibrary);
        if (pivotClass == null) {
            throw new IllegalStateException("Missing owning type");
        }
        CompleteClassInternal completeClass = this.completeModel.getCompleteClass(pivotClass.getPivotClass());
        Iterable<Operation> operationOverloads = completeClass.getOperationOverloads(pivotOperation);
        if (operationOverloads != null) {
            return operationOverloads;
        }
        return Collections.singletonList(pivotOperation);
    }

    public @NonNull Iterable<? extends @NonNull Package> getPartialPackages(@NonNull Package pkg, boolean loadASmetamodelFirst) {
        if (!this.libraryLoadInProgress && loadASmetamodelFirst && this.asMetamodel == null) {
            this.getASmetamodel();
        }
        CompletePackageInternal completePackage = this.completeModel.getCompletePackage(pkg);
        return ClassUtil.nullFree(completePackage.getPartialPackages());
    }

    public @NonNull Iterable<Class> getPartialClasses(@NonNull Type pivotType) {
        CompleteClassInternal completeClass = this.completeModel.getCompleteClass(pivotType);
        return completeClass.getPartialClasses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull PrecedenceManager getPrecedenceManager() {
        if (this.precedenceManager == null) {
            this.standardLibrary.getOclAnyType();
            PivotMetamodelManager pivotMetamodelManager = this;
            synchronized (pivotMetamodelManager) {
                if (this.precedenceManager == null) {
                    PivotMetamodelManager pivotMetamodelManager2 = this;
                    synchronized (pivotMetamodelManager2) {
                        this.precedenceManager = this.createPrecedenceManager();
                    }
                }
            }
        }
        return this.precedenceManager;
    }

    public @Nullable Precedence getPrefixPrecedence(@NonNull String operatorName) {
        PrecedenceManager precedenceManager = this.getPrecedenceManager();
        return precedenceManager.getPrefixPrecedence(operatorName);
    }

    public <T extends EObject> @NonNull T getPrimaryElement(@NonNull T element) {
        if (element instanceof Operation) {
            return (T)this.getPrimaryOperation((Operation)element);
        }
        if (element instanceof Package) {
            return (T)this.getPrimaryPackage((Package)element);
        }
        if (element instanceof Property) {
            return (T)this.getPrimaryProperty((Property)element);
        }
        if (element instanceof Type) {
            return (T)this.getPrimaryType((Type)element);
        }
        return element;
    }

    @Override
    public @NonNull Operation getPrimaryOperation(@NonNull Operation pivotOperation) {
        CompleteClassInternal completeClass;
        Operation operation;
        CompleteInheritance pivotClass = pivotOperation.getInheritance(this.standardLibrary);
        if (pivotClass != null && (operation = (completeClass = this.completeModel.getCompleteClass(pivotClass.getPivotClass())).getOperation(pivotOperation)) != null) {
            return operation;
        }
        return pivotOperation;
    }

    public @Nullable Package getPrimaryPackage(@NonNull String nsURI, String ... subPackagePath) {
        CompletePackage completePackage = this.completeModel.getCompletePackageByURI(nsURI);
        if (completePackage == null) {
            return null;
        }
        if (subPackagePath != null) {
            String[] stringArray = subPackagePath;
            int n = subPackagePath.length;
            int n2 = 0;
            while (n2 < n) {
                String subPackageName = stringArray[n2];
                if (subPackageName == null) {
                    return null;
                }
                if ((completePackage = completePackage.getOwnedCompletePackage(subPackageName)) == null) {
                    return null;
                }
                ++n2;
            }
        }
        return completePackage.getPrimaryPackage();
    }

    @Override
    public @NonNull Package getPrimaryPackage(@NonNull Package aPackage) {
        return ClassUtil.nonNullState(this.getCompletePackage(aPackage).getPrimaryPackage());
    }

    @Override
    public @NonNull Property getPrimaryProperty(@NonNull Property pivotProperty) {
        Property opposite;
        if (pivotProperty.eContainer() instanceof TupleType) {
            return pivotProperty;
        }
        if (pivotProperty.isIsImplicit() && (opposite = pivotProperty.getOpposite()) != null && !opposite.isIsImplicit()) {
            return PivotUtil.getOpposite(this.getPrimaryProperty(opposite));
        }
        CompleteInheritance owningInheritance = pivotProperty.getInheritance(this.standardLibrary);
        if (owningInheritance == null) {
            return pivotProperty;
        }
        String name = PivotUtil.getName(pivotProperty);
        CompleteClassInternal completeClass = this.completeModel.getCompleteClass(owningInheritance.getPivotClass());
        Iterable<@NonNull Property> memberProperties = completeClass.getProperties(pivotProperty.isIsStatic() ? FeatureFilter.SELECT_STATIC : FeatureFilter.SELECT_NON_STATIC, name);
        if (Iterables.size(memberProperties) <= 1) {
            return memberProperties.iterator().next();
        }
        Property opposite2 = pivotProperty.getOpposite();
        if (opposite2 == null) {
            return memberProperties.iterator().next();
        }
        String oppositeName = PivotUtil.getName(opposite2);
        CompleteClassInternal oppositeCompleteClass = this.completeModel.getCompleteClass(PivotUtil.getOwningClass(opposite2));
        for (Property memberProperty : memberProperties) {
            CompleteClassInternal memberOppositeCompleteClass;
            Property memberOpposite = memberProperty.getOpposite();
            if (memberOpposite == null || !oppositeName.equals(memberOpposite.getName()) || oppositeCompleteClass != (memberOppositeCompleteClass = this.completeModel.getCompleteClass(PivotUtil.getOwningClass(memberOpposite)))) continue;
            return memberProperty;
        }
        return memberProperties.iterator().next();
    }

    @Override
    public @NonNull Class getPrimaryClass(@NonNull Class type) {
        if (!this.isTypeServeable(type)) {
            return type;
        }
        String instanceClassName = type.getInstanceClassName();
        if (instanceClassName != null && instanceClassName.equals(Map.Entry.class.getName())) {
            return type;
        }
        return this.getCompleteClass(type).getPrimaryClass();
    }

    public @NonNull Type getPrimaryType(@NonNull Type type) {
        if (!this.isTypeServeable(type)) {
            return type;
        }
        return this.getCompleteClass(type).getPrimaryClass();
    }

    @Override
    public @Nullable Class getPrimaryType(@NonNull String nsURI, @NonNull String path, String ... extraPath) {
        CompletePackage completePackage = this.completeModel.getCompletePackageByURI(nsURI);
        if (completePackage == null) {
            return null;
        }
        if (extraPath == null || extraPath.length == 0) {
            return completePackage.getMemberType(path);
        }
        if ((completePackage = completePackage.getOwnedCompletePackage(path)) == null) {
            return null;
        }
        int iMax = extraPath.length - 1;
        int i = 0;
        while (i < iMax) {
            String subPackageName = extraPath[i];
            if (subPackageName == null) {
                return null;
            }
            if ((completePackage = completePackage.getOwnedCompletePackage(subPackageName)) == null) {
                return null;
            }
            ++i;
        }
        String subPackageName = extraPath[iMax];
        if (subPackageName == null) {
            return null;
        }
        return completePackage.getMemberType(subPackageName);
    }

    public @NonNull ASResource getResource(@NonNull URI uri, @Nullable String contentType) {
        Resource asResource = this.asResourceSet.getResource(uri, false);
        if (asResource == null) {
            Object asResourceFactory = this.asResourceSet.getResourceFactoryRegistry().getContentTypeToFactoryMap().get(contentType);
            if (asResourceFactory == null) {
                throw new IllegalStateException("No registration for content type '" + contentType + "'");
            }
            if (!(asResourceFactory instanceof ASResourceFactory)) {
                throw new IllegalStateException("Non ASResourceFactory registration for content type '" + contentType + "'");
            }
            asResource = ((ASResourceFactory)asResourceFactory).createResource(uri);
            assert (asResource != null);
            this.asResourceSet.getResources().add((Object)asResource);
        }
        return (ASResource)asResource;
    }

    @Override
    public @NonNull StandardLibraryInternal getStandardLibrary() {
        return this.standardLibrary;
    }

    public @NonNull Iterable<@NonNull CompleteClass> getSuperCompleteClasses(@NonNull Class pivotType) {
        if (!this.libraryLoadInProgress && this.asMetamodel == null && pivotType == this.standardLibrary.getClassType()) {
            this.getASmetamodel();
        }
        CompleteClassInternal completeClass = this.getCompleteClass(pivotType);
        return this.getSuperCompleteClasses(completeClass);
    }

    public @NonNull Iterable<@NonNull CompleteClass> getSuperCompleteClasses(@NonNull CompleteClass completeClass) {
        return completeClass.getProperSuperCompleteClasses();
    }

    public ResourceSet getTarget() {
        return this.asResourceSet;
    }

    protected void installLibrary(@NonNull Library asLibrary) {
        if (!this.asLibraries.contains(asLibrary)) {
            String uri = asLibrary.getURI();
            if (this.asLibraries.isEmpty()) {
                if (uri == null) {
                    throw new IllegalLibraryException(PivotMessagesInternal.MissingLibraryURI_ERROR_);
                }
                if (!this.standardLibrary.isExplicitDefaultStandardLibraryURI()) {
                    for (Class asClass : asLibrary.getOwnedClasses()) {
                        if (!"OclAny".equals(asClass.getName())) continue;
                        this.standardLibrary.setDefaultStandardLibraryURI(uri);
                        break;
                    }
                }
            }
            this.asLibraries.add(asLibrary);
            if (this.asLibraryResource != null) {
                this.installLibraryContents(asLibrary);
            }
        }
    }

    protected void installLibraryContents(@NonNull Library asLibrary) {
        ArrayList<@NonNull Class> asClasses = null;
        for (Class type : asLibrary.getOwnedClasses()) {
            Class primaryType;
            if (type == null || type != (primaryType = this.getPrimaryClass(type)) || PivotUtilInternal.isOrphanType(type)) continue;
            if (asClasses == null) {
                asClasses = new ArrayList<Class>();
            }
            asClasses.add(primaryType);
        }
        if (asClasses != null) {
            this.standardLibrary.defineLibraryTypes(asClasses);
        }
    }

    public void installPropertyDeclaration(@NonNull Property thisProperty) {
        Class lowerBound;
        TemplateParameter thatTemplateParameter;
        Property opposite = thisProperty.getOpposite();
        if (opposite != null) {
            return;
        }
        Type thatType = thisProperty.getType();
        if (thatType instanceof CollectionType) {
            thatType = ((CollectionType)thatType).getElementType();
        }
        if (thatType == null) {
            return;
        }
        Class thatClass = thatType.isClass();
        if (thatClass == null && (thatTemplateParameter = thatType.isTemplateParameter()) != null && (lowerBound = PivotUtil.basicGetLowerBound(thatTemplateParameter)) != null) {
            thatClass = lowerBound;
        }
        if (thatClass == null || thatClass instanceof DataType) {
            return;
        }
        Class thisClass = thisProperty.getOwningClass();
        if (thisClass == null) {
            return;
        }
        String name = thisClass.getName();
        if (name == null) {
            return;
        }
        Property newOpposite = PivotFactory.eINSTANCE.createProperty();
        newOpposite.setIsImplicit(true);
        newOpposite.setName(name);
        if (thisProperty.isIsComposite()) {
            newOpposite.setType(thisClass);
            newOpposite.setIsRequired(false);
        } else {
            newOpposite.setType(this.getCollectionType(false, false, thisClass, false, PivotConstantsInternal.DEFAULT_IMPLICIT_OPPOSITE_LOWER_VALUE, PivotConstantsInternal.DEFAULT_IMPLICIT_OPPOSITE_UPPER_VALUE));
            newOpposite.setIsRequired(true);
        }
        Model thisModel = PivotUtil.getContainingModel(thisClass);
        assert (thisModel != null);
        Class thisOppositeClass = this.getEquivalentClass(thisModel, thatClass);
        thisOppositeClass.getOwnedProperties().add(newOpposite);
        newOpposite.setOpposite(thisProperty);
        thisProperty.setOpposite(newOpposite);
    }

    public void installResource(@NonNull Resource asResource) {
        for (EObject eObject : asResource.getContents()) {
            if (!(eObject instanceof Model)) continue;
            this.installRoot((Model)eObject);
        }
        if (!this.libraryLoadInProgress && this.asLibraryResource == null && asResource instanceof OCLstdlib && this.asLibraries.size() > 0) {
            this.standardLibrary.getOclAnyType();
        }
    }

    @Override
    public void installRoot(@NonNull Model pivotModel) {
        if (this.completeModel.getPartialModels().contains(pivotModel)) {
            return;
        }
        if (INSTALL_MODEL.isActive()) {
            INSTALL_MODEL.println(String.valueOf(NameUtil.debugSimpleName(this)) + " " + pivotModel);
        }
        List<Package> ownedPackages = pivotModel.getOwnedPackages();
        List<Import> ownedImports = pivotModel.getOwnedImports();
        if (ownedPackages.isEmpty() && ownedImports.isEmpty()) {
            return;
        }
        this.completeModel.getPartialModels().add(pivotModel);
        for (Package asPackage : ownedPackages) {
            if (!(asPackage instanceof Library)) continue;
            this.installLibrary((Library)asPackage);
        }
        for (Import asImport : ownedImports) {
            Model asModel;
            Namespace asNamespace = asImport.getImportedNamespace();
            if (asNamespace == null || (asModel = PivotUtil.getContainingModel(asNamespace)) == null || this.completeModel.getPartialModels().contains(asModel)) continue;
            this.installRoot(asModel);
        }
    }

    public boolean isAdapterForType(Object type) {
        return type == PivotMetamodelManager.class;
    }

    public boolean isLibraryLoadInProgress() {
        return this.libraryLoadInProgress;
    }

    public boolean isSuperClassOf(@NonNull Class unspecializedFirstType, @NonNull Class secondType) {
        CompleteClassInternal firstCompleteClass = this.getCompleteClass(unspecializedFirstType);
        CompleteClassInternal secondCompleteClass = this.getCompleteClass(secondType);
        return this.isSuperCompleteClassOf(firstCompleteClass, secondCompleteClass);
    }

    public boolean isSuperCompleteClassOf(@NonNull CompleteClass unspecializedFirstType, @NonNull CompleteClass secondType) {
        CompleteClassInternal unspecializedSecondType = this.getCompleteClass(PivotUtil.getUnspecializedTemplateableElement(secondType.getPrimaryClass()));
        if (unspecializedFirstType == unspecializedSecondType) {
            return true;
        }
        for (CompleteClass superCompleteClass : this.getSuperCompleteClasses(unspecializedSecondType)) {
            if (!this.isSuperCompleteClassOf(unspecializedFirstType, superCompleteClass)) continue;
            return true;
        }
        return false;
    }

    public boolean isTypeServeable(@NonNull Type type) {
        if (type.isTemplateParameter() != null) {
            return false;
        }
        if (type instanceof LambdaType) {
            return false;
        }
        return !(type.eContainer() instanceof TemplateParameterSubstitution);
    }

    protected boolean isUnspecialized(@NonNull List<TemplateParameter> templateParameters, @NonNull List<? extends Type> templateArguments) {
        int iMax = templateParameters.size();
        assert (templateArguments.size() == iMax);
        int i = 0;
        while (i < iMax) {
            if (templateArguments.get(i) != templateParameters.get(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected void loadASmetamodel(@NonNull Package asLibrary) {
        void var2_6;
        for (Package package_ : this.getPartialPackages(asLibrary, false)) {
            if (NameUtil.getNameable(package_.getOwnedClasses(), PivotPackage.Literals.ELEMENT.getName()) == null) continue;
            this.setASmetamodel(package_);
            return;
        }
        Package asPackage = null;
        if (this.asLibraryResource instanceof ASResourceImpl.ImmutableResource && ((ASResourceImpl.ImmutableResource)this.asLibraryResource).isCompatibleWith("http://www.eclipse.org/ocl/2015/Pivot")) {
            Model model = OCLmetamodel.getDefaultModel();
            for (Package asPartialPackage : PivotUtil.getOwnedPackages(model)) {
                if (PivotUtilInternal.isImplicitPackage(asPartialPackage)) continue;
                asPackage = asPartialPackage;
                break;
            }
            if (asPackage == null) {
                asPackage = model.getOwnedPackages().get(0);
            }
        } else {
            String name = ClassUtil.nonNullState(asLibrary.getName());
            asPackage = OCLmetamodel.create(this.standardLibrary, name, asLibrary.getNsPrefix(), "http://www.eclipse.org/ocl/2015/Pivot");
            Model model = (Model)asPackage.eContainer();
        }
        Resource asResource = var2_6.eResource();
        assert (asResource != null);
        this.asResourceSet.getResources().add((Object)asResource);
        this.setASmetamodel(asPackage);
        this.installResource(asResource);
    }

    public @Nullable Resource loadDefaultLibrary(@Nullable String uri) {
        if (uri == null) {
            return null;
        }
        Resource asLibraryResource2 = this.asLibraryResource;
        if (asLibraryResource2 != null) {
            return asLibraryResource2;
        }
        boolean savedLibraryLoadInProgress = this.libraryLoadInProgress;
        this.libraryLoadInProgress = true;
        try {
            StandardLibraryContribution contribution = StandardLibraryContribution.REGISTRY.get(uri);
            if (contribution != null) {
                this.asLibraryResource = asLibraryResource2 = contribution.getResource();
            } else {
                for (Library asLibrary : this.asLibraries) {
                    if (!uri.equals(asLibrary.getURI())) continue;
                    this.asLibraryResource = asLibraryResource2 = asLibrary.eResource();
                    break;
                }
                if (asLibraryResource2 == null) {
                    return null;
                }
            }
            this.installResource(asLibraryResource2);
            if (!this.asLibraries.isEmpty()) {
                for (Library asLibrary : this.asLibraries) {
                    this.installLibraryContents(asLibrary);
                }
            }
            Resource resource = asLibraryResource2;
            return resource;
        }
        finally {
            this.libraryLoadInProgress = savedLibraryLoadInProgress;
        }
    }

    @Override
    public @Nullable Element loadResource(@NonNull URI uri, String zzalias, @Nullable ResourceSet resourceSet) throws ParserException {
        EPackage ePackage;
        URI resourceURI = uri.trimFragment();
        if (PivotUtilInternal.isASURI(resourceURI)) {
            Element asElement = this.getASElement(uri);
            if (asElement instanceof Model) {
                for (EObject eObject : ((Model)asElement).getOwnedPackages()) {
                    if (!(eObject instanceof Library) || !this.asLibraries.isEmpty() || this.asLibraryResource != null) continue;
                    this.asLibraryResource = asElement.eResource();
                    this.installLibrary((Library)eObject);
                }
            }
            return asElement;
        }
        ResourceSet externalResourceSet = resourceSet != null ? resourceSet : this.environmentFactory.getResourceSet();
        EPackage.Registry registry = externalResourceSet.getPackageRegistry();
        String uriString = resourceURI.toString();
        Resource resource = null;
        String fragment = uri.fragment();
        if (fragment == null) {
            ePackage = registry.getEPackage(uriString);
            if (ePackage != null) {
                return ((EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)this.environmentFactory).getASOf(Element.class, (EObject)ePackage);
            }
            if (uriString.equals(this.standardLibrary.getDefaultStandardLibraryURI())) {
                resource = this.asLibraryResource != null ? this.asLibraryResource : this.standardLibrary.loadDefaultLibrary(uriString);
            } else {
                StandardLibraryContribution contribution = StandardLibraryContribution.REGISTRY.get(uriString);
                if (contribution != null) {
                    resource = contribution.getResource();
                }
            }
        } else {
            Element asElement;
            Object eObject;
            Resource eResource;
            ePackage = registry.getEPackage(uriString);
            if (ePackage != null && (eResource = ePackage.eResource()) instanceof XMLResource && (eObject = ((XMLResource)eResource).getEObject(fragment)) != null && (asElement = ((EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)this.environmentFactory).getASOf(Element.class, (EObject)eObject)) != null) {
                return asElement;
            }
        }
        if (resource == null) {
            External2AS external2as = this.external2asMap.get(resourceURI);
            if (external2as != null) {
                resource = external2as.getResource();
            } else {
                resource = externalResourceSet.getResource(resourceURI, true);
                if (resource != null) {
                    for (Resource.Diagnostic diagnostic : resource.getErrors()) {
                        if (!(diagnostic instanceof WrappedException)) continue;
                        throw (WrappedException)diagnostic;
                    }
                }
                if (resource != null) {
                    EList contents;
                    if (resource instanceof StandaloneProjectMap.DelegatedSinglePackageResource) {
                        resource = ((StandaloneProjectMap.DelegatedSinglePackageResource)resource).getResource();
                    }
                    if ((contents = resource.getContents()).size() > 0) {
                        EObject firstContent = (EObject)contents.get(0);
                        for (ASResourceFactory resourceFactory : ASResourceFactoryRegistry.INSTANCE.getLoadedResourceFactories()) {
                            Resource knownResource;
                            URI packageURI = resourceFactory.getPackageURI(firstContent);
                            if (packageURI == null) continue;
                            External2AS external2as2 = this.external2asMap.get(packageURI);
                            if (external2as2 == null || (knownResource = external2as2.getResource()) == null || knownResource == resource) break;
                            for (EObject eContent : resource.getContents()) {
                                Element pivot;
                                if (!(eContent instanceof Pivotable) || !((pivot = ((Pivotable)firstContent).getPivot()) instanceof Model)) continue;
                                Model root = (Model)pivot;
                                this.completeModel.getPartialModels().remove(root);
                                ASResource asResource = (ASResource)root.eResource();
                                if (asResource == null) continue;
                                boolean wasUpdating = asResource.setUpdating(true);
                                this.asResourceSet.getResources().remove((Object)asResource);
                                asResource.unload();
                                asResource.setUpdating(wasUpdating);
                            }
                            if (!resourceFactory.getASResourceFactory().isCompatibleResource(resource, knownResource)) {
                                logger.error((Object)("Resource '" + resource.getURI() + "' already loaded as '" + knownResource.getURI() + "'"));
                            }
                            resource.getResourceSet().getResources().remove((Object)resource);
                            resource = knownResource;
                            break;
                        }
                    }
                }
            }
        }
        if (resource != null) {
            return this.environmentFactory.loadResource(resource, uri);
        }
        logger.warn((Object)("Cannot load package with URI '" + uri + "'"));
        return null;
    }

    public @NonNull LibraryFeature lookupImplementation(@NonNull Operation dynamicOperation) throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        return this.getImplementation(dynamicOperation);
    }

    public void notifyChanged(Notification notification) {
    }

    @Override
    @Deprecated
    public @NonNull ExpressionInOCL parseSpecification(@NonNull LanguageExpression specification) throws ParserException {
        return ((EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)this.environmentFactory).parseSpecification(specification);
    }

    public void removeExternalResource(@NonNull External2AS external2as) {
        this.external2asMap.remove(external2as.getURI());
    }

    public void removeExternalResource(@NonNull Resource esResource) {
        External2AS es2as;
        if (this.es2ases != null && (es2as = this.es2ases.remove(esResource)) != null) {
            es2as.dispose();
        }
    }

    @Override
    public void resetFinalAnalysis() {
        this.finalAnalysis = null;
    }

    @Override
    public void resetFlowAnalysis() {
        this.oclExpression2flowAnalysis = null;
    }

    public void setASmetamodel(Package asPackage) {
        this.asMetamodel = asPackage;
        String uri = this.asMetamodel.getURI();
        if (uri != null) {
            this.completeModel.addPackageURI2completeURI(uri, "$metamodel$");
        }
    }

    public void setAutoLoadASmetamodel(boolean autoLoadASmetamodel) {
        this.autoLoadASmetamodel = autoLoadASmetamodel;
    }

    public void setLibraryLoadInProgress(boolean libraryLoadInProgress) {
        this.libraryLoadInProgress = libraryLoadInProgress;
    }

    public void setMetamodelNsURI(@NonNull String metaNsURI) {
        if (this.asMetamodel == null) {
            this.getASmetamodel();
        } else if (!metaNsURI.equals(this.asMetamodel.getURI())) {
            this.completeModel.addPackageURI2completeURI(metaNsURI, "$metamodel$");
        }
    }

    public void setTarget(Notifier newTarget) {
    }

    public @NonNull Type specializeType(@NonNull Type type, @NonNull CallExp callExp, @NonNull Type selfType, @Nullable Type selfTypeValue) {
        return TemplateParameterSubstitutionVisitor.specializeType(type, callExp, this.environmentFactory, selfType, null);
    }

    public void unsetTarget(Notifier oldTarget) {
    }

    public class CompleteClassPropertiesIterable
    extends CompleteElementIterable<Class, Property> {
        protected final Boolean selectStatic;

        public CompleteClassPropertiesIterable(Iterable<Class> types, boolean selectStatic) {
            super(types);
            this.selectStatic = selectStatic;
        }

        @Override
        protected @NonNull Iterable<@NonNull Property> getInnerIterable(@NonNull Class model) {
            return ClassUtil.nullFree(model.getOwnedProperties());
        }

        @Override
        protected @Nullable Property getInnerValue(@NonNull Property element) {
            if (this.selectStatic != null && element.isIsStatic() != this.selectStatic.booleanValue()) {
                return null;
            }
            return element;
        }
    }

    public class CompleteElementInvariantsIterable
    extends CompleteElementIterable<Class, Constraint> {
        public CompleteElementInvariantsIterable(Iterable<? extends Class> models) {
            super(models);
        }

        @Override
        protected @NonNull Iterable<Constraint> getInnerIterable(@NonNull Class model) {
            return ClassUtil.nonNullEMF(model.getOwnedInvariants());
        }
    }

    public class CompleteTypeOperationsIterable
    extends CompleteElementIterable<Class, Operation> {
        protected final Boolean selectStatic;

        public CompleteTypeOperationsIterable(Iterable<Class> types, boolean selectStatic) {
            super(types);
            this.selectStatic = selectStatic;
        }

        @Override
        protected @NonNull Iterable<@NonNull Operation> getInnerIterable(@NonNull Class model) {
            return ClassUtil.nullFree(ClassUtil.nonNullEMF(model.getOwnedOperations()));
        }

        @Override
        protected @Nullable Operation getInnerValue(@NonNull Operation element) {
            if (this.selectStatic != null && element.isIsStatic() != this.selectStatic.booleanValue()) {
                return null;
            }
            return element;
        }
    }
}

