/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.ids;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.ids.BindingsId;
import org.eclipse.ocl.pivot.ids.SpecializedId;
import org.eclipse.ocl.pivot.ids.TemplateParameterId;
import org.eclipse.ocl.pivot.ids.TemplateableId;
import org.eclipse.ocl.pivot.internal.ids.AbstractTemplateableIdImpl;

public abstract class AbstractSpecializedIdImpl<@NonNull T extends TemplateableId>
extends AbstractTemplateableIdImpl<T>
implements SpecializedId {
    protected final @NonNull T generalizedId;
    protected final @NonNull BindingsId templateBindings;

    public AbstractSpecializedIdImpl(@NonNull T generalizedId, @NonNull BindingsId templateBindings) {
        super(generalizedId.hashCode() + templateBindings.hashCode(), generalizedId.getTemplateParameters());
        int generalizedTemplateParameters;
        this.generalizedId = generalizedId;
        this.templateBindings = templateBindings;
        int templateParameterCount = generalizedTemplateParameters = generalizedId.getTemplateParameters();
        assert (templateParameterCount > 0);
        assert (templateParameterCount == templateBindings.elementIdSize());
    }

    @Override
    public @NonNull String getDisplayName() {
        StringBuilder s = new StringBuilder();
        s.append(this.generalizedId.getDisplayName());
        s.append("<");
        int elementIdSize = this.templateBindings.elementIdSize();
        int i = 0;
        while (i < elementIdSize) {
            if (i > 0) {
                s.append(",");
            }
            s.append("$" + i + ":");
            s.append(this.templateBindings.getElementId(i));
            ++i;
        }
        i = 0;
        while (i < this.templateBindings.valuesSize()) {
            s.append(",");
            s.append("$" + (i + elementIdSize) + ":");
            s.append(this.templateBindings.getValue(i));
            ++i;
        }
        s.append(">");
        return s.toString();
    }

    public @NonNull T getGeneralizedId() {
        return this.generalizedId;
    }

    @Override
    public @NonNull String getMetaTypeName() {
        return this.generalizedId.getMetaTypeName();
    }

    @Override
    public @NonNull String getName() {
        return this.generalizedId.getName();
    }

    @Override
    public @NonNull BindingsId getTemplateBindings() {
        return this.templateBindings;
    }

    @Override
    public @NonNull TemplateParameterId getTemplateParameterId(int index, @NonNull String name) {
        throw new UnsupportedOperationException();
    }
}

