/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.wizards;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.wizards.Messages;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentModel;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Text;

public class AttachmentPreviewPage
extends WizardPage {
    private static final String DIALOG_SETTING_RUN_IN_BACKGROUND = "run-in-background";
    private static final String DIALOG_SETTINGS_SECTION_ATTACHMENTS_WIZARD = "attachments-wizard";
    protected static final int MAX_TEXT_SIZE = 50000;
    private static final String PAGE_NAME = "PreviewAttachmentPage";
    private final Set<String> imageTypes;
    private final TaskAttachmentModel model;
    private Button runInBackgroundButton;
    private ScrolledComposite scrolledComposite;
    private final Set<String> textTypes;
    private Composite contentComposite;

    public AttachmentPreviewPage(TaskAttachmentModel model) {
        super(PAGE_NAME);
        this.model = model;
        this.setTitle(Messages.AttachmentPreviewPage_Attachment_Preview);
        this.setDescription(Messages.AttachmentPreviewPage_Review_the_attachment_before_submitting);
        this.textTypes = new HashSet<String>();
        this.textTypes.add("text/plain");
        this.textTypes.add("text/html");
        this.textTypes.add("application/xml");
        this.imageTypes = new HashSet<String>();
        this.imageTypes.add("image/jpeg");
        this.imageTypes.add("image/gif");
        this.imageTypes.add("image/png");
        this.imageTypes.add("image/tiff");
        this.imageTypes.add("image/svg");
    }

    private void adjustScrollbars(Rectangle imgSize) {
        Rectangle clientArea = this.scrolledComposite.getClientArea();
        ScrollBar hBar = this.scrolledComposite.getHorizontalBar();
        hBar.setMinimum(0);
        hBar.setMaximum(imgSize.width - 1);
        hBar.setPageIncrement(clientArea.width);
        hBar.setIncrement(10);
        ScrollBar vBar = this.scrolledComposite.getVerticalBar();
        vBar.setMinimum(0);
        vBar.setMaximum(imgSize.height - 1);
        vBar.setPageIncrement(clientArea.height);
        vBar.setIncrement(10);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.setControl((Control)composite);
        this.contentComposite = new Composite(composite, 0);
        this.contentComposite.setLayoutData((Object)new GridData(1808));
        this.contentComposite.setLayout((Layout)new GridLayout());
        this.runInBackgroundButton = new Button(composite, 32);
        this.runInBackgroundButton.setText(Messages.AttachmentPreviewPage_Run_in_background);
        IDialogSettings settings = TasksUiPlugin.getDefault().getDialogSettings();
        IDialogSettings attachmentsSettings = settings.getSection(DIALOG_SETTINGS_SECTION_ATTACHMENTS_WIZARD);
        if (attachmentsSettings != null) {
            this.runInBackgroundButton.setSelection(attachmentsSettings.getBoolean(DIALOG_SETTING_RUN_IN_BACKGROUND));
        }
        Dialog.applyDialogFont((Control)composite);
    }

    public void dispose() {
        IDialogSettings settings = TasksUiPlugin.getDefault().getDialogSettings();
        IDialogSettings attachmentsSettings = settings.getSection(DIALOG_SETTINGS_SECTION_ATTACHMENTS_WIZARD);
        if (attachmentsSettings == null) {
            attachmentsSettings = settings.addNewSection(DIALOG_SETTINGS_SECTION_ATTACHMENTS_WIZARD);
        }
        attachmentsSettings.put(DIALOG_SETTING_RUN_IN_BACKGROUND, this.runInBackgroundButton.getSelection());
        super.dispose();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            Control[] children;
            Control[] controlArray = children = this.contentComposite.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.dispose();
                ++n2;
            }
            if (this.isTextAttachment() || this.isImageAttachment()) {
                Object content = this.getContent(this.contentComposite);
                if (content instanceof String) {
                    this.createTextPreview(this.contentComposite, (String)content);
                } else if (content instanceof Image) {
                    this.createImagePreview(this.contentComposite, (Image)content);
                }
            } else {
                this.createGenericPreview(this.contentComposite);
            }
            this.contentComposite.layout(true, true);
        }
        Dialog.applyDialogFont((Control)this.contentComposite);
        super.setVisible(visible);
    }

    private void createErrorPreview(Composite composite, String message) {
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(1808));
        label.setText(message);
    }

    private void createGenericPreview(Composite composite) {
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(1808));
        String name = this.model.getSource().getName();
        TaskAttachmentMapper taskAttachment = TaskAttachmentMapper.createFrom((TaskAttribute)this.model.getAttribute());
        if (taskAttachment.getFileName() != null) {
            name = taskAttachment.getFileName();
        }
        label.setText(MessageFormat.format(Messages.AttachmentPreviewPage_A_preview_the_type_X_is_currently_not_available, name, this.model.getContentType()));
    }

    private void createImagePreview(Composite composite, Image bufferedImage) {
        this.scrolledComposite = new ScrolledComposite(composite, 2816);
        this.scrolledComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        Composite canvasComposite = new Composite((Composite)this.scrolledComposite, 0);
        canvasComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        Canvas canvas = new Canvas(canvasComposite, 262144);
        final Rectangle imgSize = bufferedImage.getBounds();
        canvas.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, true).hint(imgSize.width, imgSize.height).create());
        canvas.addPaintListener(event -> event.gc.drawImage(bufferedImage, 0, 0));
        canvas.addDisposeListener(event -> bufferedImage.dispose());
        canvas.setSize(imgSize.width, imgSize.height);
        this.scrolledComposite.setMinSize(imgSize.width, imgSize.height);
        this.scrolledComposite.setContent((Control)canvasComposite);
        this.scrolledComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                AttachmentPreviewPage.this.adjustScrollbars(imgSize);
            }
        });
        this.adjustScrollbars(imgSize);
    }

    private void createTextPreview(Composite composite, String contents) {
        Text text = new Text(composite, 2826);
        GridData gd = new GridData(1808);
        gd.heightHint = composite.getBounds().y;
        gd.widthHint = composite.getBounds().x;
        text.setLayoutData((Object)gd);
        text.setText(contents);
    }

    private Object getContent(Composite composite) {
        Object[] result = new Object[1];
        try {
            this.getContainer().run(true, false, monitor -> {
                block21: {
                    try {
                        try {
                            monitor.beginTask(Messages.AttachmentPreviewPage_Preparing_preview, -1);
                            try {
                                Throwable throwable = null;
                                Object var5_8 = null;
                                try (InputStream in = this.model.getSource().createInputStream(monitor);){
                                    if (this.isTextAttachment()) {
                                        String line;
                                        StringBuilder content = new StringBuilder();
                                        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                                        while ((line = reader.readLine()) != null && content.length() < 50000 && !monitor.isCanceled()) {
                                            content.append(line);
                                            content.append("\n");
                                        }
                                        objectArray[0] = content.toString();
                                    } else if (this.isImageAttachment()) {
                                        Display.getDefault().syncExec(() -> {
                                            Image originalImage = new Image((Device)this.getShell().getDisplay(), in);
                                            Image bufferedImage = new Image((Device)this.getShell().getDisplay(), originalImage.getBounds());
                                            GC gc = new GC((Drawable)bufferedImage);
                                            gc.setBackground(composite.getBackground());
                                            gc.fillRectangle(originalImage.getBounds());
                                            gc.drawImage(originalImage, 0, 0);
                                            gc.dispose();
                                            originalImage.dispose();
                                            objectArray[0] = bufferedImage;
                                        });
                                    }
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    throw throwable;
                                }
                            }
                            catch (IOException e) {
                                if (e.getSuppressed() != null && e.getSuppressed().length > 0) {
                                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Failed to close file", e.getSuppressed()[0]));
                                    break block21;
                                }
                                throw new InvocationTargetException(e);
                            }
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Error generating preview", (Throwable)e));
            this.createErrorPreview(composite, Messages.AttachmentPreviewPage_Could_not_create_preview);
            return null;
        }
        catch (InterruptedException e) {
            return null;
        }
        return result[0];
    }

    private boolean isImageAttachment() {
        return this.imageTypes.contains(this.model.getContentType());
    }

    private boolean isTextAttachment() {
        return this.textTypes.contains(this.model.getContentType());
    }

    public boolean runInBackground() {
        return this.runInBackgroundButton.getSelection();
    }
}

