/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.ui.internal.dialogs;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.modisco.facet.widgets.celleditors.AbstractCellEditorComposite;
import org.eclipse.modisco.facet.widgets.celleditors.IValidator;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.discovery.catalog.DiscovererParameter;
import org.eclipse.modisco.infra.discovery.launch.LaunchConfiguration;
import org.eclipse.modisco.infra.discovery.launch.ParameterValue;
import org.eclipse.modisco.infra.discovery.ui.Activator;
import org.eclipse.modisco.infra.discovery.ui.Messages;
import org.eclipse.modisco.infra.discovery.ui.internal.dialogs.ParameterValueEditingSupport;
import org.eclipse.modisco.infra.discovery.ui.internal.util.DiscovererParameterDescriptionTooltip;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class GenericParametersDialog
extends TitleAreaDialog {
    private static final String NAME_COLUMN_PROPERTY = "name";
    private static final String VALUE_COLUMN_PROPERTY = "value";
    private static final String TYPE_COLUMN_PROPERTY = "type";
    private static final int NAME_COLUMN_INDEX = 0;
    private static final int VALUE_COLUMN_INDEX = 1;
    private static final int TYPE_COLUMN_INDEX = 2;
    private static final int DIALOG_WIDTH = 725;
    private static final int DIALOG_HEIGHT = 455;
    private static final int NAME_COLUMN_WIDTH = 150;
    private static final int VALUE_COLUMN_WIDTH = 250;
    private static final int TYPE_COLUMN_WIDTH = 250;
    private static final int PARAMETERS_TABLE_HEIGHT = 120;
    private final List<DiscovererParameter> parameters;
    private final Object[] fParameterValues;
    private final AbstractCellEditorComposite<?>[] cellEditors;
    private final String discovererName;
    private TableViewer tableViewerParameters;
    private Table tableParameters;
    private Image titleImage;
    private Button checkBoxOpenModel;
    private boolean openModel;
    private final boolean showOpenModelCheckbox;
    private boolean cellEditorOpened = false;
    private final LaunchConfiguration configurationModel;

    public GenericParametersDialog(Shell parentShell, List<DiscovererParameter> parameters, String discovererName, boolean showOpenModelCheckbox, LaunchConfiguration configurationModel) {
        super(parentShell);
        this.parameters = parameters;
        this.discovererName = discovererName;
        this.showOpenModelCheckbox = showOpenModelCheckbox;
        this.configurationModel = configurationModel;
        this.fParameterValues = this.initializeParameterValues();
        this.cellEditors = new AbstractCellEditorComposite[parameters.size()];
        this.setTitleImage(this.getTitleImage());
    }

    private Object[] initializeParameterValues() {
        Object[] values = new Object[this.parameters.size()];
        EList parameterValues = this.configurationModel.getParameterValues();
        for (ParameterValue parameterValue : parameterValues) {
            DiscovererParameter parameter = parameterValue.getParameter();
            int parameterIndex = this.getParameterIndex(parameter);
            if (parameterIndex == -1) continue;
            values[parameterIndex] = parameterValue.getValue();
        }
        return values;
    }

    private int getParameterIndex(DiscovererParameter parameter) {
        int i = 0;
        while (i < this.parameters.size()) {
            DiscovererParameter param = this.parameters.get(i);
            if (param.getId().equals(parameter.getId())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private Image getTitleImage() {
        if (this.titleImage == null) {
            this.titleImage = Activator.getImageDescriptor("icons/discoverer_banner.png").createImage();
        }
        return this.titleImage;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.GenericParametersDialog_title);
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        container.setFont(parent.getFont());
        this.createParametersTable(container);
        Label lblRequired = new Label(container, 0);
        lblRequired.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        lblRequired.setText(Messages.GenericParametersDialog_marksRequiredParam);
        if (this.showOpenModelCheckbox) {
            this.checkBoxOpenModel = new Button(container, 32);
            this.checkBoxOpenModel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
            this.checkBoxOpenModel.setText(Messages.GenericParametersDialog_openModelEditor);
            this.checkBoxOpenModel.setSelection(this.configurationModel.isOpenModelAfterDiscovery());
        }
        return container;
    }

    private void createParametersTable(Composite container) {
        this.tableViewerParameters = new TableViewer(container, 67586);
        this.tableParameters = this.tableViewerParameters.getTable();
        this.tableParameters.setLinesVisible(true);
        this.tableParameters.setHeaderVisible(true);
        GridData gdTableParameters = new GridData(4, 4, true, true, 2, 1);
        gdTableParameters.heightHint = 120;
        this.tableParameters.setLayoutData((Object)gdTableParameters);
        TableViewerColumn tableViewerColumnName = new TableViewerColumn(this.tableViewerParameters, 0);
        TableColumn tableColumnName = tableViewerColumnName.getColumn();
        tableColumnName.setWidth(150);
        tableColumnName.setText(Messages.GenericParametersDialog_name);
        TableViewerColumn tableViewerColumnValue = new TableViewerColumn(this.tableViewerParameters, 0);
        TableColumn tableColumnValue = tableViewerColumnValue.getColumn();
        tableColumnValue.setWidth(250);
        tableColumnValue.setText(Messages.GenericParametersDialog_value);
        tableViewerColumnValue.setEditingSupport((EditingSupport)new ParameterValueEditingSupport((ColumnViewer)this.tableViewerParameters, this));
        TableViewerColumn tableViewerColumnType = new TableViewerColumn(this.tableViewerParameters, 0);
        TableColumn tableColumnType = tableViewerColumnType.getColumn();
        tableColumnType.setWidth(250);
        tableColumnType.setText(Messages.GenericParametersDialog_type);
        this.tableViewerParameters.setColumnProperties(new String[]{NAME_COLUMN_PROPERTY, VALUE_COLUMN_PROPERTY, TYPE_COLUMN_PROPERTY});
        this.tableViewerParameters.setContentProvider((IContentProvider)new ParametersTableContentProvider());
        this.tableViewerParameters.setLabelProvider((IBaseLabelProvider)new ParametersTableLabelProvider());
        this.tableViewerParameters.setInput(this.parameters);
        tableColumnName.pack();
        this.tableViewerParameters.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000B) {
                    IStructuredSelection selection = (IStructuredSelection)GenericParametersDialog.this.tableViewerParameters.getSelection();
                    Object firstElement = selection.getFirstElement();
                    GenericParametersDialog.this.tableViewerParameters.editElement(firstElement, 1);
                }
            }
        });
        GenericParametersDialog.createDescriptionTooltip(this.tableParameters);
    }

    private static void createDescriptionTooltip(final Table table) {
        DiscovererParameterDescriptionTooltip tooltip = new DiscovererParameterDescriptionTooltip(table){

            @Override
            protected DiscovererParameter getDiscovererParameterAt(Event event) {
                TableItem item = table.getItem(new Point(event.x, event.y));
                if (item == null) {
                    return null;
                }
                DiscovererParameter parameter = (DiscovererParameter)item.getData();
                return parameter;
            }
        };
        tooltip.activate();
    }

    public void validate(boolean showErrors) {
        int i = 0;
        while (i < this.parameters.size()) {
            IValidator validator;
            IStatus status;
            Object value = this.fParameterValues[i];
            DiscovererParameter param = this.parameters.get(i);
            if (value == null && param.isRequiredInput()) {
                if (showErrors) {
                    this.setErrorMessage(NLS.bind((String)Messages.GenericParametersDialog_fieldIsEmpty, (Object)param.getId()));
                }
                this.getButton(0).setEnabled(false);
                return;
            }
            if (this.cellEditors[i] != null && (status = (validator = this.cellEditors[i].getValidator()).validate(this.cellEditors[i].getValue())) != Status.OK_STATUS) {
                if (showErrors) {
                    String statusMessage = status.getMessage();
                    String msg = statusMessage != null && statusMessage.trim().length() > 0 ? NLS.bind((String)Messages.GenericParametersDialog_invalidField1, (Object)param.getId(), (Object)statusMessage) : NLS.bind((String)Messages.GenericParametersDialog_invalidField2, (Object)param.getId());
                    this.setErrorMessage(msg);
                }
                this.getButton(0).setEnabled(false);
                return;
            }
            ++i;
        }
        this.setErrorMessage(null);
        if (this.cellEditorOpened) {
            this.getButton(0).setEnabled(false);
        } else {
            this.getButton(0).setEnabled(true);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "&" + IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.validate(false);
    }

    protected boolean isResizable() {
        return true;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        String sectionName = ((Object)((Object)this)).getClass().getName() + ":" + this.discovererName;
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(sectionName);
        if (section == null) {
            section = settings.addNewSection(sectionName);
            section.put("DIALOG_WIDTH", 725);
            section.put("DIALOG_HEIGHT", 455);
        }
        return section;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(NLS.bind((String)Messages.GenericParametersDialog_shellText, (Object)this.discovererName));
    }

    public Object[] getParameterValues() {
        return this.fParameterValues;
    }

    public boolean isHelpAvailable() {
        return false;
    }

    public Object getParameterValue(DiscovererParameter element) {
        return this.fParameterValues[this.parameters.indexOf(element)];
    }

    public void setParameterValue(DiscovererParameter element, Object value) {
        this.fParameterValues[this.parameters.indexOf((Object)element)] = value;
    }

    public boolean close() {
        this.openModel = this.checkBoxOpenModel != null ? this.checkBoxOpenModel.getSelection() : false;
        boolean closed = super.close();
        this.titleImage.dispose();
        return closed;
    }

    public boolean isOpenModel() {
        return this.openModel;
    }

    public boolean isCellEditorOpened() {
        return this.cellEditorOpened;
    }

    public void setCellEditorOpened(boolean value) {
        this.cellEditorOpened = value;
    }

    protected static final class ParametersTableContentProvider
    implements IStructuredContentProvider {
        protected ParametersTableContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                List list = (List)inputElement;
                return list.toArray();
            }
            throw new IllegalArgumentException();
        }
    }

    protected final class ParametersTableLabelProvider
    implements ITableLabelProvider {
        protected ParametersTableLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof DiscovererParameter) {
                DiscovererParameter param = (DiscovererParameter)element;
                switch (columnIndex) {
                    case 0: {
                        if (param.isRequiredInput()) {
                            return param.getId() + "*";
                        }
                        return param.getId();
                    }
                    case 1: {
                        Object parameterValue = GenericParametersDialog.this.fParameterValues[GenericParametersDialog.this.parameters.indexOf(element)];
                        if (parameterValue == null) {
                            return "";
                        }
                        return parameterValue.toString();
                    }
                    case 2: {
                        return param.getType().getName();
                    }
                }
                MoDiscoLogger.logError((String)"unhandled case", (Plugin)Activator.getDefault());
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void dispose() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

