/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.core.internal.annotations;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.MemberDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.InterfaceType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.apt.core.env.EclipseAnnotationProcessorEnvironment;
import org.eclipse.jdt.apt.core.env.Phase;
import org.eclipse.modisco.infra.discovery.core.annotations.Parameter;
import org.eclipse.modisco.infra.discovery.core.annotations.ParameterInitialValue;
import org.eclipse.modisco.infra.discovery.core.internal.annotations.DiscoveryAnnotationControls;
import org.eclipse.modisco.infra.discovery.core.internal.annotations.MarkerUtils;
import org.eclipse.modisco.infra.discovery.core.internal.annotations.ParameterDeclarationException;

public class DiscoveryAnnotationProcessor
implements AnnotationProcessor {
    private static final String PARAMETER_PB_MARKER_ID = "org.eclipse.modisco.infra.discovery.core.parameterDeclarationProblem";
    private EclipseAnnotationProcessorEnvironment env;

    public void setEnvironment(EclipseAnnotationProcessorEnvironment anEnv) {
        this.env = anEnv;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void process() {
        if (this.env == null || this.env.getPhase().equals((Object)Phase.RECONCILE)) {
            return;
        }
        for (TypeDeclaration type : this.env.getTypeDeclarations()) {
            memberToAnnotationsMaps = new HashMap<String, HashMap<MemberDeclaration, Parameter>>();
            initializerMethodToAnnotationsMaps = new HashMap<String, HashMap<MethodDeclaration, ParameterInitialValue>>();
            members = new ArrayList<MemberDeclaration>();
            this.retrieveMembers(type, members);
            for (MemberDeclaration member : members) {
                MarkerUtils.deleteMarkers(member, "org.eclipse.modisco.infra.discovery.core.parameterDeclarationProblem");
            }
            for (MemberDeclaration member : members) {
                parameterDeclaration = (Parameter)member.getAnnotation(Parameter.class);
                if (parameterDeclaration != null) {
                    try {
                        DiscoveryAnnotationControls.checkAnnotation(parameterDeclaration, member, null);
                    }
                    catch (ParameterDeclarationException e) {
                        MarkerUtils.createMarker(member, e.getMessage(), "org.eclipse.modisco.infra.discovery.core.parameterDeclarationProblem");
                    }
                    memberToParameterMap = (HashMap<MemberDeclaration, Parameter>)memberToAnnotationsMaps.get(parameterDeclaration.name());
                    if (memberToParameterMap == null) {
                        memberToParameterMap = new HashMap<MemberDeclaration, Parameter>();
                        memberToAnnotationsMaps.put(parameterDeclaration.name(), memberToParameterMap);
                    }
                    memberToParameterMap.put(member, parameterDeclaration);
                }
                if ((initializerAnnotation = (ParameterInitialValue)member.getAnnotation(ParameterInitialValue.class)) == null || !(member instanceof MethodDeclaration)) continue;
                try {
                    DiscoveryAnnotationControls.checkAnnotation(initializerAnnotation, (MethodDeclaration)member, null);
                }
                catch (ParameterDeclarationException e) {
                    MarkerUtils.createMarker(member, e.getMessage(), "org.eclipse.modisco.infra.discovery.core.parameterDeclarationProblem");
                }
                methodToParameterMap = (HashMap<MethodDeclaration, ParameterInitialValue>)initializerMethodToAnnotationsMaps.get(initializerAnnotation.name());
                if (methodToParameterMap == null) {
                    methodToParameterMap = new HashMap<MethodDeclaration, ParameterInitialValue>();
                    initializerMethodToAnnotationsMaps.put(initializerAnnotation.name(), methodToParameterMap);
                }
                methodToParameterMap.put((MethodDeclaration)member, initializerAnnotation);
            }
            for (Map.Entry entry : memberToAnnotationsMaps.entrySet()) {
                methodToParameterMap = (Map)initializerMethodToAnnotationsMaps.get(entry.getKey());
                try {
                    DiscoveryAnnotationControls.checkAnnotationsForOneParameter((Map)entry.getValue(), null, methodToParameterMap, null);
                    continue;
                }
                catch (ParameterDeclarationException e) {
                    localMembers = new ArrayList<MemberDeclaration>();
                    ** for (member : ((Map)entry.getValue()).keySet())
                }
lbl-1000:
                // 1 sources

                {
                    if (!member.getDeclaringType().equals((Object)type)) continue;
                    localMembers.add(member);
                    continue;
                }
lbl52:
                // 1 sources

                MarkerUtils.createMarkers(localMembers, e.getMessage(), "org.eclipse.modisco.infra.discovery.core.parameterDeclarationProblem");
            }
        }
    }

    private void retrieveMembers(TypeDeclaration aType, List<MemberDeclaration> members) {
        if (aType == null) {
            return;
        }
        for (FieldDeclaration aField : aType.getFields()) {
            members.add((MemberDeclaration)aField);
        }
        for (MethodDeclaration aMethod : aType.getMethods()) {
            members.add((MemberDeclaration)aMethod);
        }
        for (InterfaceType anInterface : aType.getSuperinterfaces()) {
            this.retrieveMembers((TypeDeclaration)anInterface.getDeclaration(), members);
        }
        if (aType instanceof ClassDeclaration && ((ClassDeclaration)aType).getSuperclass() != null) {
            this.retrieveMembers((TypeDeclaration)((ClassDeclaration)aType).getSuperclass().getDeclaration(), members);
        }
    }
}

