/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.browser.custom.validation.constraints;

import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.modisco.infra.browser.custom.TypeView;
import org.eclipse.modisco.infra.facet.FacetSet;
import org.eclipse.modisco.infra.facet.core.FacetSetCatalog;

public class MetaclassValidation
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext context) {
        EObject eObject = context.getTarget();
        EMFEventType eType = context.getEventType();
        if (eType == EMFEventType.NULL && eObject instanceof TypeView) {
            TypeView typeView = (TypeView)eObject;
            String metaclassName = typeView.getMetaclassName();
            if (metaclassName == null) {
                return context.createFailureStatus(new Object[]{"null"});
            }
            String metamodelURI = typeView.getMetamodelView().getMetamodelURI();
            EPackage ePackage = (EPackage)EPackage.Registry.INSTANCE.get((Object)metamodelURI);
            if (ePackage == null) {
                Collection allFacetSets = FacetSetCatalog.getSingleton().getAllFacetSets();
                for (FacetSet facetSet : allFacetSets) {
                    if (!metamodelURI.equals(facetSet.getNsURI())) continue;
                    ePackage = facetSet;
                }
            }
            if (ePackage != null) {
                String packageName = ePackage.getName();
                EList eClassifiers = ePackage.getEClassifiers();
                for (EClassifier eClassifier : eClassifiers) {
                    if (!metaclassName.equals(String.valueOf(packageName) + "." + eClassifier.getName())) continue;
                    return context.createSuccessStatus();
                }
            }
            return context.createFailureStatus(new Object[]{metaclassName});
        }
        return context.createSuccessStatus();
    }
}

