/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.blackbox.java;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.ModuleHandle;
import org.osgi.framework.Bundle;

class BundleModuleHandle
extends ModuleHandle {
    private final String bundleId;
    private final List<String> usedPackages;

    BundleModuleHandle(String bundleId, String className, String moduleName, List<String> usedPackages) {
        super(className, moduleName);
        if (bundleId == null || usedPackages == null) {
            throw new IllegalArgumentException();
        }
        this.bundleId = bundleId;
        this.usedPackages = usedPackages;
    }

    @Override
    public List<String> getUsedPackages() {
        ArrayList<String> packages = new ArrayList<String>(this.usedPackages);
        packages.addAll(super.getUsedPackages());
        return packages;
    }

    @Override
    public Class<?> getModuleJavaClass() throws ClassNotFoundException {
        Bundle bundle = Platform.getBundle((String)this.bundleId);
        if (bundle != null) {
            return bundle.loadClass(this.getJavaClassName());
        }
        return this.getClass().getClassLoader().loadClass(this.getJavaClassName());
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + ", bundle: " + this.bundleId;
    }
}

