/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtilPlugin;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelDesc;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelProvider;

public abstract class DelegatingMetamodelProvider
implements IMetamodelProvider {
    private IMetamodelProvider delegate;

    DelegatingMetamodelProvider(IMetamodelProvider delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException();
        }
        this.delegate = delegate;
    }

    @Override
    public final IMetamodelDesc[] getMetamodels() {
        ArrayList<IMetamodelDesc> metamodels = new ArrayList<IMetamodelDesc>();
        metamodels.addAll(Arrays.asList(this.getLocalMetamodels()));
        metamodels.addAll(Arrays.asList(this.delegate.getMetamodels()));
        return metamodels.toArray(new IMetamodelDesc[metamodels.size()]);
    }

    @Override
    public final IMetamodelDesc getMetamodel(String id) {
        IMetamodelDesc desc = this.getLocalMetamodel(id);
        if (desc == null || !EmfUtilPlugin.isSuccess(desc.getLoadStatus())) {
            IMetamodelDesc delegateDesc = this.delegate.getMetamodel(id);
            if (desc == null || delegateDesc != null && EmfUtilPlugin.isSuccess(delegateDesc.getLoadStatus())) {
                desc = delegateDesc;
            }
        }
        return desc;
    }

    protected abstract IMetamodelDesc[] getLocalMetamodels();

    protected IMetamodelDesc getLocalMetamodel(String id) {
        IMetamodelDesc desc = null;
        IMetamodelDesc[] iMetamodelDescArray = this.getLocalMetamodels();
        int n = iMetamodelDescArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMetamodelDesc d = iMetamodelDescArray[n2];
            if (d.getId().equals(id)) {
                desc = d;
                break;
            }
            ++n2;
        }
        return desc;
    }

    @Override
    public final EPackage.Registry getPackageRegistry() {
        EPackageRegistryImpl registry = new EPackageRegistryImpl(this.delegate.getPackageRegistry());
        IMetamodelDesc[] iMetamodelDescArray = this.getLocalMetamodels();
        int n = iMetamodelDescArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMetamodelDesc desc = iMetamodelDescArray[n2];
            if (EmfUtilPlugin.isSuccess(desc.getLoadStatus())) {
                registry.put((Object)desc.getId(), (Object)desc.getModel());
            }
            ++n2;
        }
        return registry;
    }
}

