/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.emfvm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.m2m.atl.engine.emfvm.ASM;
import org.eclipse.m2m.atl.engine.emfvm.ASMOperation;
import org.eclipse.m2m.atl.engine.emfvm.Bytecode;
import org.eclipse.m2m.atl.engine.emfvm.Messages;
import org.eclipse.m2m.atl.engine.emfvm.lib.ASMModule;
import org.eclipse.m2m.atl.engine.emfvm.lib.ExecEnv;

public class AtlSuperimposeModule {
    private ExecEnv env;
    private ASM asm;
    private boolean atl2006;

    public AtlSuperimposeModule(ExecEnv env, ASM asm) {
        this.env = env;
        this.asm = asm;
    }

    public void adaptModuleOperations() throws AtlSuperimposeModuleException {
        this.adaptMain();
        this.removeOperation("main");
        this.adaptOperation("__matcher__", 2);
        this.removeOperation("__matcher__");
        this.adaptOperation("__exec__", 10);
        this.removeOperation("__exec__");
    }

    private void adaptMain() throws AtlSuperimposeModuleException {
        ASMOperation origOp = (ASMOperation)this.env.getOperation(ASMModule.class, "main");
        ASMOperation newOp = this.asm.getMainOperation();
        if (origOp != null && newOp != null) {
            this.mainSanityCrossCheck(origOp, newOp);
            List<Bytecode> from = Arrays.asList(newOp.getBytecodes());
            ArrayList<Bytecode> into = new ArrayList<Bytecode>(Arrays.asList(origOp.getBytecodes()));
            if (this.atl2006) {
                this.insertHelperInits(from, into);
            } else {
                List<Bytecode> origInit = this.getInstructions(into, "call A.__init", 20, 1);
                List<Bytecode> newInit = this.getInstructions(from, "call A.__init", 20, 1);
                into.addAll(origInit.size() + 21, newInit);
            }
            origOp.setBytecodes(into.toArray(new Bytecode[0]));
        }
    }

    private void mainSanityCrossCheck(ASMOperation main1, ASMOperation main2) throws AtlSuperimposeModuleException {
        this.mainSanityCheck(main1);
        this.mainSanityCheck(main2);
        int preEnd = 21;
        if (this.atl2006) {
            preEnd = 16;
        }
        int i = 0;
        while (i < preEnd) {
            String ins2;
            String ins1 = main1.getBytecodes()[i].toString();
            if (!ins1.equals(ins2 = main2.getBytecodes()[i].toString())) {
                throw new AtlSuperimposeModuleException(Messages.getString("AtlSuperimposeModule.MAINPATTERNNOTEQUAL", ins1, ins2, String.valueOf(i)));
            }
            ++i;
        }
    }

    private void mainSanityCheck(ASMOperation main) throws AtlSuperimposeModuleException {
        List<Bytecode> instructions = Arrays.asList(main.getBytecodes());
        if (instructions.size() < 21) {
            throw new AtlSuperimposeModuleException(Messages.getString("AtlSuperimposeModule.UNEXPECTEDINSTRUCTIONCOUNT", String.valueOf(instructions.size())));
        }
        String instr16 = instructions.get(15).toString();
        if (!instr16.equals("set col")) {
            throw new AtlSuperimposeModuleException(Messages.getString("AtlSuperimposeModule.UNEXPECTEDINSTRUCTIONSEQUENCE", instr16));
        }
        if (this.indexOfInstruction(instructions, "set links", 16) == -1) {
            throw new AtlSuperimposeModuleException(Messages.getString("AtlSuperimposeModule.SETLINKSNOTFOUND"));
        }
        String instr1 = instructions.get(0).toString();
        if (instr1.equals("getasm")) {
            this.atl2006 = true;
        }
    }

    private List<Bytecode> getInstructions(List<Bytecode> instr, String prefix, int start, int context) {
        ArrayList<Bytecode> init = new ArrayList<Bytecode>();
        int i = start + context;
        while (i < instr.size()) {
            Bytecode ins = instr.get(i);
            if (((Object)ins).toString().startsWith(prefix)) {
                init.addAll(instr.subList(i - context, i + 1));
            }
            ++i;
        }
        return init;
    }

    private int indexOfInstruction(List<Bytecode> instr, String prefix, int start) {
        int i = start;
        while (i < instr.size()) {
            Bytecode ins = instr.get(i);
            if (((Object)ins).toString().startsWith(prefix)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void adaptOperation(String op, int patternLength) throws AtlSuperimposeModuleException {
        ASMOperation origOp = (ASMOperation)this.env.getOperation(ASMModule.class, op);
        ASMOperation newOp = null;
        Iterator<ASMOperation> i = this.asm.getOperations();
        while (i.hasNext()) {
            ASMOperation thisOp = i.next();
            if (!op.equals(thisOp.getName())) continue;
            Assert.isTrue((newOp == null ? 1 : 0) != 0);
            newOp = thisOp;
        }
        if (origOp != null && newOp != null) {
            this.sanityCrossCheck(origOp, newOp, patternLength);
            List<Bytecode> from = Arrays.asList(newOp.getBytecodes());
            ArrayList<Bytecode> into = new ArrayList<Bytecode>(Arrays.asList(origOp.getBytecodes()));
            String origOpRun = AtlSuperimposeModule.serialise(into, 0, into.size());
            int i2 = 0;
            while (i2 < from.size()) {
                String newOpRun = AtlSuperimposeModule.serialise(from, i2, patternLength);
                if (origOpRun.indexOf(newOpRun) == -1) {
                    int j = i2;
                    while (j < Math.min(i2 + patternLength, from.size())) {
                        into.add(from.get(j));
                        ++j;
                    }
                }
                i2 += patternLength;
            }
            origOp.setBytecodes(into.toArray(new Bytecode[0]));
        }
    }

    private void insertHelperInits(List<Bytecode> from, List<Bytecode> into) {
        int endOfInitCode = this.indexOfInstruction(from, "set links", 16) - 4;
        List<Bytecode> initInstr = from.subList(16, endOfInitCode);
        int pos = this.indexOfInstruction(into, "set links", 16) - 4;
        this.transposeOffsets(into, initInstr.size(), pos);
        this.transposeOffsets(initInstr, pos - 16, 0);
        into.addAll(pos, initInstr);
    }

    private void transposeOffsets(List<Bytecode> instructions, int transpose, int start) {
        for (Bytecode instruction : instructions) {
            int offset;
            Bytecode instr;
            int opcode;
            if (!(instruction instanceof Bytecode) || (opcode = (instr = instruction).getOpcode()) != 16 && opcode != 17 || (offset = Integer.parseInt((String)instr.getOperand())) < start) continue;
            instr.setOperand(String.valueOf(offset += transpose));
        }
    }

    private void sanityCrossCheck(ASMOperation op1, ASMOperation op2, int patternLength) throws AtlSuperimposeModuleException {
        this.sanityCheck(op1, patternLength);
        this.sanityCheck(op2, patternLength);
        List<Bytecode> instr1 = Arrays.asList(op1.getBytecodes());
        List<Bytecode> instr2 = Arrays.asList(op2.getBytecodes());
        int limit = Math.min(instr1.size(), instr2.size());
        limit = Math.min(limit, patternLength);
        int i = 0;
        while (i < limit) {
            int i2;
            int i1 = instr1.get(i).getOpcode();
            if (i1 != (i2 = instr2.get(i).getOpcode())) {
                throw new AtlSuperimposeModuleException(Messages.getString("AtlSuperimposeModule.PATTERNNOTEQUAL", op1.getName(), Bytecode.OPCODENAMES[i1], Bytecode.OPCODENAMES[i2], String.valueOf(i)));
            }
            ++i;
        }
    }

    private void sanityCheck(ASMOperation op, int patternLength) throws AtlSuperimposeModuleException {
        List<Bytecode> instr = Arrays.asList(op.getBytecodes());
        if (instr.size() % patternLength > 0) {
            throw new AtlSuperimposeModuleException(Messages.getString("AtlSuperimposeModule.INSTRUCTIONCOUNTPROBLEM", String.valueOf(patternLength), op.getName()));
        }
        int i = 0;
        while (i < instr.size() - patternLength) {
            int i2;
            int i1 = instr.get(i).getOpcode();
            if (i1 != (i2 = instr.get(i + patternLength).getOpcode())) {
                throw new AtlSuperimposeModuleException(Messages.getString("AtlSuperimposeModule.PATTERNDOESNOTREPEAT", String.valueOf(patternLength), op.getName(), Bytecode.OPCODENAMES[i1], Bytecode.OPCODENAMES[i2], String.valueOf(i)));
            }
            ++i;
        }
    }

    private static String serialise(List<Bytecode> instrs, int start, int length) {
        StringBuffer ser = new StringBuffer();
        int i = Math.max(0, start);
        while (i < Math.min(instrs.size(), start + length)) {
            ser.append(instrs.get(i));
            ser.append(';');
            ++i;
        }
        return ser.toString();
    }

    private void removeOperation(String op) {
        boolean removed = false;
        Iterator<ASMOperation> i = this.asm.getOperations();
        while (i.hasNext()) {
            ASMOperation asmOp = i.next();
            if (!op.equals(asmOp.getName())) continue;
            Assert.isTrue((!removed ? 1 : 0) != 0);
            i.remove();
            removed = true;
        }
    }

    public class AtlSuperimposeModuleException
    extends Exception {
        static final long serialVersionUID = 20080205L;

        public AtlSuperimposeModuleException(String msg) {
            super(msg);
        }
    }
}

