/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.preferences;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.m2m.atl.adt.ui.AtlUIPlugin;
import org.eclipse.m2m.atl.adt.ui.preferences.AlreadyExistsDialog;
import org.eclipse.m2m.atl.adt.ui.preferences.AtlCodeFormatterPropertyPage;
import org.eclipse.m2m.atl.adt.ui.preferences.AtlPreview;
import org.eclipse.m2m.atl.adt.ui.preferences.CreateProfileDialog;
import org.eclipse.m2m.atl.adt.ui.preferences.ModifyDialogTabPage;
import org.eclipse.m2m.atl.adt.ui.preferences.ProfileManager;
import org.eclipse.m2m.atl.adt.ui.preferences.ProfileStore;
import org.eclipse.m2m.atl.adt.ui.preferences.RenameProfileDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class AtlCodeFormatterProfilesTabPage
extends ModifyDialogTabPage {
    private AtlPreview fPreview;
    private org.eclipse.swt.widgets.List profilesList;
    private ProfileManager manager;
    private ProfileStore store;
    private final IDialogSettings fDialogSettings;
    private Button fEnableProjectSpecificSettings;
    private Button fRemove;
    private Button fNew;
    private Button fImport;
    private Button fExport;
    private Button fExportAll;
    private Button fRename;
    private Composite fComposite;
    private boolean isProjectSpecific;

    public AtlCodeFormatterProfilesTabPage(ProfileManager manager, ProfileStore store, boolean isProjectSpecific) {
        this.manager = manager;
        this.store = store;
        this.isProjectSpecific = isProjectSpecific;
        this.fDialogSettings = AtlUIPlugin.getDefault().getDialogSettings();
    }

    @Override
    public AtlPreview getPreview() {
        return this.fPreview;
    }

    public org.eclipse.swt.widgets.List getProfilesList() {
        return this.profilesList;
    }

    public ProfileManager getManager() {
        return this.manager;
    }

    public Button getfEnableProjectSpecificSettings() {
        return this.fEnableProjectSpecificSettings;
    }

    @Override
    protected void initializePage() {
    }

    @Override
    protected void doCreatePreferences(Composite composite, int numColumns) {
        AtlCodeFormatterProfilesTabPage.createLabel(numColumns - 1, composite, "Profiles managment:");
        this.fComposite = composite;
        if (this.isProjectSpecific) {
            this.fEnableProjectSpecificSettings = new Button(composite, 32);
            this.fEnableProjectSpecificSettings.setText("Enable project specific settings");
            this.fEnableProjectSpecificSettings.setLayoutData((Object)new GridData(131072, 128, true, false));
            this.fEnableProjectSpecificSettings.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean enabled = AtlCodeFormatterProfilesTabPage.this.fEnableProjectSpecificSettings.getSelection();
                    AtlCodeFormatterProfilesTabPage.this.updateTab(enabled);
                }
            });
        }
        Composite comp = new Composite(composite, 0);
        GridData gd3 = AtlCodeFormatterProfilesTabPage.createGridData(numColumns, 1808, 0);
        comp.setLayoutData((Object)gd3);
        GridLayout FCLayout = new GridLayout(numColumns, false);
        comp.setLayout((Layout)FCLayout);
        this.profilesList = new org.eclipse.swt.widgets.List(comp, 2052);
        GridData gd = AtlCodeFormatterProfilesTabPage.createGridData(numColumns - 2, 1808, 0);
        gd.verticalSpan = 7;
        this.profilesList.setLayoutData((Object)gd);
        GridData gd2 = new GridData(4);
        gd2.verticalAlignment = 4;
        gd2.horizontalSpan = 2;
        gd2.verticalIndent = 0;
        gd2.widthHint = 75;
        this.fNew = new Button(comp, 0);
        this.fNew.setText("New...");
        this.fNew.setLayoutData((Object)gd2);
        this.fImport = new Button(comp, 0);
        this.fImport.setText("Import...");
        this.fImport.setLayoutData((Object)gd2);
        this.fExport = new Button(comp, 0);
        this.fExport.setText("Export...");
        this.fExport.setLayoutData((Object)gd2);
        this.fExportAll = new Button(comp, 0);
        this.fExportAll.setText("Export all...");
        this.fExportAll.setLayoutData((Object)gd2);
        this.fRename = new Button(comp, 0);
        this.fRename.setText("Rename...");
        this.fRename.setLayoutData((Object)gd2);
        this.fRemove = new Button(comp, 0);
        this.fRemove.setText("Remove");
        this.fRemove.setLayoutData((Object)gd2);
        new ButtonController();
    }

    @Override
    protected Composite doCreatePreviewPane(Composite composite, int numColumns) {
        AtlCodeFormatterProfilesTabPage.createLabel(numColumns - 1, composite, "Preview:");
        this.fShowInvisibleButton = new Button(composite, 32);
        this.fShowInvisibleButton.setText("Show invisible characters");
        this.fShowInvisibleButton.setLayoutData((Object)new GridData(131072, 128, true, false));
        this.fShowInvisibleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AtlCodeFormatterProfilesTabPage.this.fPreview.showInvisibleCharacters(AtlCodeFormatterProfilesTabPage.this.fShowInvisibleButton.getSelection());
                AtlCodeFormatterProfilesTabPage.this.fDialogSettings.put(AtlCodeFormatterPropertyPage.SHOW_INVISIBLE_PREFERENCE_KEY, AtlCodeFormatterProfilesTabPage.this.fShowInvisibleButton.getSelection());
                AtlCodeFormatterProfilesTabPage.this.doUpdatePreview();
            }
        });
        this.fPreview = this.doCreateAtlPreview(composite);
        this.fDefaultFocusManager.add(this.fPreview.getControl());
        GridData gd = AtlCodeFormatterProfilesTabPage.createGridData(numColumns, 1808, 0);
        gd.widthHint = 0;
        gd.heightHint = 0;
        this.fPreview.getControl().setLayoutData((Object)gd);
        this.fPreview.setText("-- @nsURI MM1 = http://www.my.site/path/to/my/MM1\n-- @path MM2 = /MyProject/MM2.ecore\n\nmodule MyModule;\n\ncreate OUT: MM1 from IN: MM2;\n\n--- This is a special helper comment\nhelper def: simpleHelper: String =\nlet letVar : String = 'A first let variable' in\nlet letVar2 : String = 'Another let variable' in\n\tif true then\n\t\t\tletVar\n\t\telse\n\t\t\tletVar2\n\t\tendif\n\tand\n\ttrue;\n\nhelper def: simpleParametersHelper(t1: String, t2: Integer, t3: Integer):\n\t\tSequence(TupleType(a: Integer, b: String)) =\n\tt1 <= 'This is a string'\n\tand\n\tt2 = 5 / 1-- A comment\n\t; -- Another comment\n\nhelper context String def: simpleContextHelper(t1: String, t2: Integer): OclAny =\n\tt1 = 't1'\n\tand\n\tt2 = 5 + 1;\n\n-- This is a normal comment\n--- This is a special rule comment\nrule MyRule {\n\tfrom\n\t\tinput2: MM1!MyClass in IN (\n\t\t\ttrue\n\t\t)\n\tto\n\t\toutput: MM2!MyClass2 (\n\t\t\tname <- input.name -> toString(),\n\t\t\tabstract <- false\n\t\t),\n\t\toutput2: MM2!MyClass2 (\n\t\t\tname <- 'Test'\n\t\t)\n\tdo {\n\t\t\n\t}\n}\n");
        boolean selected = this.fDialogSettings.getBoolean(AtlCodeFormatterPropertyPage.SHOW_INVISIBLE_PREFERENCE_KEY);
        this.fPreview.showInvisibleCharacters(selected);
        this.fShowInvisibleButton.setSelection(selected);
        return composite;
    }

    @Override
    protected void doUpdatePreview() {
        boolean showInvisible = this.isShowInvisible();
        this.fPreview.showInvisibleCharacters(showInvisible);
        this.fShowInvisibleButton.setSelection(showInvisible);
        this.fPreview.updateEditor();
    }

    private boolean isShowInvisible() {
        return this.fDialogSettings.getBoolean(AtlCodeFormatterPropertyPage.SHOW_INVISIBLE_PREFERENCE_KEY);
    }

    @Override
    protected AtlPreview doCreateAtlPreview(Composite parent) {
        AtlPreview preview = new AtlPreview(this.manager.getSelected().getSettings(), parent);
        return preview;
    }

    @Override
    public void updateTab(boolean enabled) {
        if (!this.profilesList.isDisposed()) {
            this.profilesList.setEnabled(enabled);
        }
        if (this.isProjectSpecific) {
            this.fEnableProjectSpecificSettings.setSelection(enabled);
        }
        boolean isNotBuiltIn = !this.manager.getSelected().isBuiltInProfile();
        this.fRemove.setEnabled(enabled && isNotBuiltIn);
        this.fNew.setEnabled(enabled);
        this.fImport.setEnabled(enabled);
        this.fExport.setEnabled(enabled && isNotBuiltIn);
        this.fExportAll.setEnabled(enabled);
        this.fRename.setEnabled(enabled);
        boolean selected = this.fDialogSettings.getBoolean(AtlCodeFormatterPropertyPage.SHOW_INVISIBLE_PREFERENCE_KEY);
        this.fPreview.showInvisibleCharacters(selected);
        this.getShowInvisibleButton().setSelection(selected);
        this.fPreview.updateEditor();
    }

    class ButtonController
    implements Observer,
    SelectionListener {
        public ButtonController() {
            AtlCodeFormatterProfilesTabPage.this.manager.addObserver(this);
            AtlCodeFormatterProfilesTabPage.this.fRemove.addSelectionListener((SelectionListener)this);
            AtlCodeFormatterProfilesTabPage.this.fNew.addSelectionListener((SelectionListener)this);
            AtlCodeFormatterProfilesTabPage.this.fImport.addSelectionListener((SelectionListener)this);
            AtlCodeFormatterProfilesTabPage.this.fExport.addSelectionListener((SelectionListener)this);
            AtlCodeFormatterProfilesTabPage.this.fExportAll.addSelectionListener((SelectionListener)this);
            AtlCodeFormatterProfilesTabPage.this.fRename.addSelectionListener((SelectionListener)this);
            this.update(AtlCodeFormatterProfilesTabPage.this.manager, null);
        }

        @Override
        public void update(Observable o, Object arg) {
            ProfileManager.Profile selected = ((ProfileManager)o).getSelected();
            boolean notBuiltIn = !selected.isBuiltInProfile();
            AtlCodeFormatterProfilesTabPage.this.fRemove.setEnabled(notBuiltIn);
            AtlCodeFormatterProfilesTabPage.this.fExport.setEnabled(notBuiltIn);
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            if (button == AtlCodeFormatterProfilesTabPage.this.fRemove) {
                this.deleteButtonPressed();
            } else if (button == AtlCodeFormatterProfilesTabPage.this.fNew) {
                this.newButtonPressed();
            } else if (button == AtlCodeFormatterProfilesTabPage.this.fImport) {
                this.importButtonPressed();
            } else if (button == AtlCodeFormatterProfilesTabPage.this.fExport) {
                this.exportButtonPressed();
            } else if (button == AtlCodeFormatterProfilesTabPage.this.fExportAll) {
                this.exportAllButtonPressed();
            } else if (button == AtlCodeFormatterProfilesTabPage.this.fRename) {
                this.renameButtonPressed();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        private void exportAllButtonPressed() {
            String path;
            FileDialog dialog = new FileDialog(AtlCodeFormatterProfilesTabPage.this.fComposite.getShell(), 8192);
            dialog.setText("Export all profiles...");
            dialog.setFilterExtensions(new String[]{"*.xml"});
            String lastPath = AtlCodeFormatterProfilesTabPage.this.fDialogSettings.get(AtlCodeFormatterPropertyPage.DIALOG_STORE_LAST_SAVE_PATH);
            if (lastPath != null) {
                dialog.setFilterPath(lastPath);
            }
            if ((path = dialog.open()) == null) {
                return;
            }
            AtlCodeFormatterProfilesTabPage.this.fDialogSettings.put(AtlCodeFormatterPropertyPage.DIALOG_STORE_LAST_SAVE_PATH, dialog.getFilterPath());
            File file = new File(path);
            if (file.exists() && !MessageDialog.openQuestion((Shell)AtlCodeFormatterProfilesTabPage.this.fComposite.getShell(), (String)"Overwrite?", (String)"Do you want to overwrite this file?")) {
                return;
            }
            String encoding = "UTF-8";
            IContentType type = Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.xml");
            if (type != null) {
                encoding = type.getDefaultCharset();
            }
            ArrayList<ProfileManager.Profile> profiles = new ArrayList<ProfileManager.Profile>();
            profiles.addAll(AtlCodeFormatterProfilesTabPage.this.manager.getSortedProfiles());
            try {
                AtlCodeFormatterProfilesTabPage.this.store.writeProfilesToFile(profiles, file, encoding);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }

        private void exportButtonPressed() {
            String path;
            FileDialog dialog = new FileDialog(AtlCodeFormatterProfilesTabPage.this.fComposite.getShell(), 8192);
            dialog.setText("Export selected profile...");
            dialog.setFilterExtensions(new String[]{"*.xml"});
            String lastPath = AtlCodeFormatterProfilesTabPage.this.fDialogSettings.get(AtlCodeFormatterPropertyPage.DIALOG_STORE_LAST_SAVE_PATH);
            if (lastPath != null) {
                dialog.setFilterPath(lastPath);
            }
            if ((path = dialog.open()) == null) {
                return;
            }
            AtlCodeFormatterProfilesTabPage.this.fDialogSettings.put(AtlCodeFormatterPropertyPage.DIALOG_STORE_LAST_SAVE_PATH, dialog.getFilterPath());
            File file = new File(path);
            if (file.exists() && !MessageDialog.openQuestion((Shell)AtlCodeFormatterProfilesTabPage.this.fComposite.getShell(), (String)"Overwrite?", (String)"Do you want to overwrite this file?")) {
                return;
            }
            String encoding = "UTF-8";
            IContentType type = Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.xml");
            if (type != null) {
                encoding = type.getDefaultCharset();
            }
            ArrayList<ProfileManager.Profile> profiles = new ArrayList<ProfileManager.Profile>();
            profiles.add(AtlCodeFormatterProfilesTabPage.this.manager.getSelected());
            try {
                AtlCodeFormatterProfilesTabPage.this.store.writeProfilesToFile(profiles, file, encoding);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }

        private void importButtonPressed() {
            String path;
            FileDialog dialog = new FileDialog(AtlCodeFormatterProfilesTabPage.this.fComposite.getShell(), 4096);
            dialog.setText("Import profiles...");
            dialog.setFilterExtensions(new String[]{"*.xml"});
            String lastPath = AtlCodeFormatterProfilesTabPage.this.fDialogSettings.get(AtlCodeFormatterPropertyPage.DIALOG_STORE_LAST_LOAD_PATH);
            if (lastPath != null) {
                dialog.setFilterPath(lastPath);
            }
            if ((path = dialog.open()) == null) {
                return;
            }
            AtlCodeFormatterProfilesTabPage.this.fDialogSettings.put(AtlCodeFormatterPropertyPage.DIALOG_STORE_LAST_LOAD_PATH, dialog.getFilterPath());
            File file = new File(path);
            List<ProfileManager.Profile> profiles = null;
            try {
                profiles = AtlCodeFormatterProfilesTabPage.this.store.readProfilesFromFile(file);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            if (profiles == null || profiles.isEmpty()) {
                return;
            }
            for (ProfileManager.CustomProfile customProfile : profiles) {
                AlreadyExistsDialog aeDialog;
                if (AtlCodeFormatterProfilesTabPage.this.manager.containsName(customProfile.getName()) && (aeDialog = new AlreadyExistsDialog(AtlCodeFormatterProfilesTabPage.this.fComposite.getShell(), customProfile, AtlCodeFormatterProfilesTabPage.this.manager)).open() != 0) {
                    return;
                }
                AtlCodeFormatterProfilesTabPage.this.manager.addProfile(customProfile);
            }
        }

        private void deleteButtonPressed() {
            if (MessageDialog.openQuestion((Shell)AtlCodeFormatterProfilesTabPage.this.fComposite.getShell(), (String)"Profile deletion", (String)("Do you really want to delete " + AtlCodeFormatterProfilesTabPage.this.manager.getSelected().getName() + "?"))) {
                AtlCodeFormatterProfilesTabPage.this.manager.deleteSelected();
            }
        }

        private void newButtonPressed() {
            CreateProfileDialog p = new CreateProfileDialog(AtlCodeFormatterProfilesTabPage.this.fComposite.getShell(), AtlCodeFormatterProfilesTabPage.this.manager);
            if (p.open() != 0) {
                return;
            }
        }

        private void renameButtonPressed() {
            RenameProfileDialog p = new RenameProfileDialog(AtlCodeFormatterProfilesTabPage.this.fComposite.getShell(), AtlCodeFormatterProfilesTabPage.this.manager.getSelected(), AtlCodeFormatterProfilesTabPage.this.manager);
            if (p.open() != 0) {
                return;
            }
        }
    }
}

