/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.ui.internal.form;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.jsf.common.ui.internal.form.AbstractDetailsForm;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public abstract class AbstractXMLSectionsDetailsForm
extends AbstractDetailsForm {
    private Map<Object, XMLTextSection> _textSections;
    private Composite _detailFormComposite;

    @Override
    public final void createContents(Composite parent) {
        this._detailFormComposite = this.getToolkit().createComposite(parent, 0);
        RowLayout rowLayout = new RowLayout(512);
        rowLayout.fill = true;
        this._detailFormComposite.setLayout((Layout)rowLayout);
        this._textSections = Collections.unmodifiableMap(new HashMap<Object, XMLTextSection>(this.createXMLTextSections(this._detailFormComposite)));
        Set<XMLTextSection> expandedSections = this.getInitiallyExpanded(this._textSections);
        for (Map.Entry<Object, XMLTextSection> entry : this._textSections.entrySet()) {
            XMLTextSection section = entry.getValue();
            if (!expandedSections.contains(section)) continue;
            section._section.setExpanded(true);
        }
    }

    protected abstract Map<? extends Object, XMLTextSection> createXMLTextSections(Composite var1);

    protected abstract Set<XMLTextSection> getInitiallyExpanded(Map<Object, XMLTextSection> var1);

    @Override
    public Control getControl() {
        return this._detailFormComposite;
    }

    @Override
    public final void selectionChanged(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Object selectionObj = ((IStructuredSelection)selection).getFirstElement();
            this.doUpdateSelection(selectionObj);
        }
    }

    @Override
    public void commit(boolean onSave) {
    }

    @Override
    public void dispose() {
    }

    @Override
    public void setFocus() {
    }

    protected static final class XMLTextSection {
        private final Section _section;
        private FormText _formText;

        public XMLTextSection(FormToolkit toolkit, Composite parent, String title) {
            this._section = toolkit.createSection(parent, 20);
            this._section.setLayoutData((Object)new RowData());
            this._section.setText(title);
            this._formText = toolkit.createFormText((Composite)this._section, true);
            this._formText.setText("", false, false);
            this._section.setClient((Control)this._formText);
        }

        public void setText(String text, boolean parseTags, boolean expandURLs) {
            this._formText.setText(text, parseTags, expandURLs);
        }

        public Control getControl() {
            return this._section;
        }

        public void refresh() {
            this._section.getParent().layout(true, true);
        }
    }
}

