/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.testrecorder;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.common.revision.delta.CDOAddFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOClearFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDOMoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORemoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOSetFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOUnsetFeatureDelta;
import org.eclipse.emf.cdo.common.util.CDOTimeProvider;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.internal.net4j.testrecorder.TestRecorderBranch;
import org.eclipse.emf.cdo.internal.net4j.testrecorder.TestRecorderSession;
import org.eclipse.emf.cdo.internal.net4j.testrecorder.TestRecorderTransaction;
import org.eclipse.emf.cdo.internal.net4j.testrecorder.TestRecorderView;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.revision.CDOFeatureDeltaVisitorImpl;
import org.eclipse.emf.cdo.transaction.CDOMerger;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.transaction.CDOTransactionHandler1;
import org.eclipse.emf.cdo.transaction.CDOTransactionHandlerBase;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.FSMUtil;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.event.EventUtil;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.om.OMPlatform;

public final class TestRecorder
implements CDOTransactionHandler1.WithUndo {
    public static final TestRecorder INSTANCE = new TestRecorder();
    private static final String OUTPUT_FOLDER = OMPlatform.INSTANCE.getProperty("org.eclipse.emf.cdo.test.recorder.outputFolder");
    private static final String CLASS_NAME = OMPlatform.INSTANCE.getProperty("org.eclipse.emf.cdo.test.recorder.className");
    private static final String DESCRIPTION = OMPlatform.INSTANCE.getProperty("org.eclipse.emf.cdo.test.recorder.description");
    private static final boolean RECORD_VIEWS = OMPlatform.INSTANCE.isProperty("org.eclipse.emf.cdo.test.recorder.recordViews");
    private static final Map<Object, String> TYPES = new HashMap<Object, String>();
    private final Map<Object, Variable> variables = new HashMap<Object, Variable>();
    private final Map<String, AtomicInteger> typeCounters = new HashMap<String, AtomicInteger>();
    private PrintStream out;

    static {
        TYPES.put("mango", "getMangoFactory()");
        TYPES.put("model1", "getModel1Factory()");
        TYPES.put("model2", "getModel2Factory()");
        TYPES.put("model3", "getModel3Factory()");
        TYPES.put("subpackage", "getModel3SubpackageFactory()");
        TYPES.put("model4", "getModel4Factory()");
        TYPES.put("model5", "getModel5Factory()");
        TYPES.put("model6", "getModel6Factory()");
        TYPES.put(EresourcePackage.Literals.CDO_RESOURCE_FOLDER, "folder");
        TYPES.put(EresourcePackage.Literals.CDO_RESOURCE, "resource");
        TYPES.put(EresourcePackage.Literals.CDO_TEXT_RESOURCE, "text");
        TYPES.put(EresourcePackage.Literals.CDO_BINARY_RESOURCE, "file");
    }

    private TestRecorder() {
    }

    private void println(String line) {
        if (this.out == null) {
            String packageName;
            String className = CLASS_NAME;
            if (StringUtil.isEmpty((String)className)) {
                className = "RecordedTest";
                packageName = "";
            } else {
                int lastDot = className.lastIndexOf(46);
                if (lastDot != -1) {
                    packageName = className.substring(0, lastDot);
                    className = className.substring(lastDot + 1);
                } else {
                    packageName = "";
                }
            }
            if (StringUtil.isEmpty((String)OUTPUT_FOLDER)) {
                this.out = System.out;
            } else {
                String suffix;
                String prefix;
                int star = className.indexOf(42);
                if (star != -1) {
                    prefix = className.substring(0, star);
                    suffix = className.substring(star + 1);
                } else {
                    prefix = className;
                    suffix = "";
                }
                className = String.valueOf(prefix) + suffix;
                File folder = new File(OUTPUT_FOLDER, packageName.replace('.', '/'));
                File file = new File(folder, String.valueOf(className) + ".java");
                char c = 'a';
                while (file.exists()) {
                    char c2 = c;
                    c = (char)(c2 + 1);
                    className = String.valueOf(prefix) + Character.toString(c2) + suffix;
                    file = new File(folder, String.valueOf(className) + ".java");
                }
                try {
                    this.out = new PrintStream(file);
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        @Override
                        public void run() {
                            if (TestRecorder.this.out != null) {
                                TestRecorder.this.out.println("\t}");
                                TestRecorder.this.out.println("}");
                                IOUtil.close((Closeable)TestRecorder.this.out);
                            }
                        }
                    });
                }
                catch (FileNotFoundException ex) {
                    ex.printStackTrace();
                    this.out = System.out;
                }
            }
            if (packageName.length() != 0) {
                this.out.println("package " + packageName + ";");
                this.out.println();
            }
            this.out.println("import org.eclipse.emf.cdo.common.branch.CDOBranch;");
            this.out.println("import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;");
            this.out.println("import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;");
            this.out.println("import org.eclipse.emf.cdo.eresource.CDOResource;");
            this.out.println("import org.eclipse.emf.cdo.session.CDOSession;");
            this.out.println("import org.eclipse.emf.cdo.tests.AbstractCDOTest;");
            this.out.println("import org.eclipse.emf.cdo.transaction.CDOTransaction;");
            this.out.println("import org.eclipse.emf.spi.cdo.DefaultCDOMerger;");
            this.out.println();
            if (!StringUtil.isEmpty((String)DESCRIPTION)) {
                this.out.println("/**");
                this.out.println(" * " + DESCRIPTION);
                this.out.println(" */");
            }
            this.out.println("public class " + className + " extends AbstractCDOTest");
            this.out.println("{");
            this.out.println("\tpublic void testCase() throws Exception");
            this.out.println("\t{");
        }
        this.out.println("\t\t" + line);
    }

    public synchronized void openSession(TestRecorderSession session) {
        Variable variable = this.createVariable("session", session);
        this.println("CDOSession " + variable + " = openSession();");
        this.addCloseListener(variable);
    }

    public synchronized void createBranch(TestRecorderBranch branch, long originalBaseTimeStamp) {
        Variable variable = this.createVariable("branch", (Object)branch);
        String lhs = "CDOBranch " + variable + " = ";
        String create = ".createBranch(" + TestRecorder.list(TestRecorder.quot(branch.getName()), this.formatTimeStamp(originalBaseTimeStamp, true)) + ");";
        CDOBranch baseBranch = branch.getBase().getBranch();
        if (baseBranch.isMainBranch()) {
            this.println(String.valueOf(lhs) + this.variables.get(TestRecorder.getSession((CDOBranch)branch)) + ".getBranchManager().getMainBranch()" + create);
        } else {
            Variable baseBranchVariable = this.variables.get(baseBranch);
            if (baseBranchVariable != null) {
                this.println(String.valueOf(lhs) + baseBranchVariable + create);
            } else {
                this.println(String.valueOf(lhs) + this.variables.get(TestRecorder.getSession((CDOBranch)branch)) + ".getBranchManager().getBranch(" + TestRecorder.quot(baseBranch.getPathName()) + ")" + create);
            }
        }
    }

    public synchronized void renameBranch(TestRecorderBranch branch) {
    }

    public synchronized void openView(TestRecorderView view, CDOSession session, CDOBranch branch, long timeStamp) {
        if (RECORD_VIEWS) {
            Variable variable = this.createVariable("view", (Object)view);
            this.println("CDOView " + variable + " = " + this.variables.get(session) + ".openView(" + TestRecorder.list(this.formatBranch(branch, true), this.formatTimeStamp(timeStamp, true)) + ");");
            this.addCloseListener(variable);
        }
    }

    public synchronized void openTransaction(TestRecorderTransaction transaction, CDOSession session, CDOBranch branch) {
        Variable variable = this.createVariable("transaction", (Object)transaction);
        this.println("CDOTransaction " + variable + " = " + this.variables.get(session) + ".openTransaction(" + this.formatBranch(branch, true) + ");");
        this.addCloseListener(variable);
        transaction.addTransactionHandler((CDOTransactionHandlerBase)this);
    }

    public synchronized void attachingObject(CDOTransaction transaction, CDOObject object) {
        if (object instanceof CDOResourceNode) {
            CDOResourceNode resourceNode = (CDOResourceNode)object;
            EClass eClass = resourceNode.eClass();
            String typeName = eClass.getName();
            String type = TYPES.get(eClass);
            Variable variable = this.createVariable(type, resourceNode);
            this.println(String.valueOf(typeName) + " " + variable + " = " + this.variables.get(transaction) + "." + typeName.replace("CDO", "create") + "(getResourcePath(" + TestRecorder.quot(resourceNode.getPath()) + "));");
        }
    }

    public synchronized void detachingObject(CDOTransaction transaction, CDOObject object) {
        if (object instanceof CDOResourceNode) {
            CDOResourceNode resourceNode = (CDOResourceNode)object;
            this.println(String.valueOf(this.formatResourceNode(resourceNode)) + ".delete(null);");
            this.variables.remove(resourceNode);
        }
    }

    public synchronized void modifyingObject(CDOTransaction transaction, final CDOObject object, CDOFeatureDelta featureDelta) {
        if (object instanceof CDOResourceNode) {
            return;
        }
        final EStructuralFeature feature = featureDelta.getFeature();
        final String featureName = StringUtil.cap((String)feature.getName());
        featureDelta.accept((CDOFeatureDeltaVisitor)new CDOFeatureDeltaVisitorImpl(){

            public void visit(CDOClearFeatureDelta delta) {
                if (this.filter(feature)) {
                    return;
                }
                Object value = object.eGet(feature);
                if (value == null || value instanceof List && ((List)value).isEmpty()) {
                    return;
                }
                TestRecorder.this.println(String.valueOf(this.formatGet()) + ".clear();");
            }

            public void visit(CDOUnsetFeatureDelta delta) {
                if (this.filter(feature)) {
                    return;
                }
                TestRecorder.this.println(String.valueOf(this.formatGet()) + ".unset();");
            }

            public void visit(CDOSetFeatureDelta delta) {
                if (this.filter(feature)) {
                    return;
                }
                String value = TestRecorder.this.formatValue(object, feature, delta.getValue());
                TestRecorder.this.println(String.valueOf(TestRecorder.this.formatObject(object)) + ".set" + featureName + "(" + value + ");");
            }

            public void visit(CDORemoveFeatureDelta delta) {
                if (this.filter(feature)) {
                    return;
                }
                TestRecorder.this.println(String.valueOf(this.formatGet()) + ".remove(" + delta.getIndex() + ");");
            }

            public void visit(CDOAddFeatureDelta delta) {
                if (this.filter(feature)) {
                    return;
                }
                List list = (List)object.eGet(feature);
                Integer index = delta.getIndex() >= list.size() - 1 ? null : Integer.valueOf(delta.getIndex());
                String value = TestRecorder.this.formatValue(object, feature, delta.getValue());
                TestRecorder.this.println(String.valueOf(this.formatGet()) + ".add(" + TestRecorder.list(new Object[]{index, value}) + ");");
            }

            public void visit(CDOMoveFeatureDelta delta) {
                TestRecorder.this.println(String.valueOf(this.formatGet()) + ".move(" + delta.getOldPosition() + ", " + delta.getNewPosition() + ");");
            }

            private boolean filter(EStructuralFeature feature2) {
                EReference reference;
                EReference oppositeReference;
                if (feature2 instanceof EReference && (oppositeReference = (reference = (EReference)feature2).getEOpposite()) != null) {
                    if (reference.isMany()) {
                        if (oppositeReference.isMany() && this.pick(reference, oppositeReference)) {
                            return true;
                        }
                    } else {
                        if (oppositeReference.isMany()) {
                            return true;
                        }
                        if (this.pick(reference, oppositeReference)) {
                            return true;
                        }
                    }
                }
                return false;
            }

            private boolean pick(EReference r1, EReference r2) {
                return this.getID(r1).compareTo(this.getID(r2)) > 0;
            }

            private String getID(EReference r) {
                EClass c = r.getEContainingClass();
                return String.valueOf(c.getEPackage().getNsURI()) + "#" + c.getName() + "#" + r.getName();
            }

            private String formatGet() {
                return String.valueOf(TestRecorder.this.formatObject(object)) + ".get" + featureName + "()";
            }
        });
    }

    public synchronized void undoingObject(CDOTransaction transaction, CDOObject object, CDOFeatureDelta featureDelta) {
        this.modifyingObject(transaction, object, featureDelta);
    }

    public synchronized void mergeTransaction(TestRecorderTransaction transaction, CDOBranch source, CDOMerger merger) {
        this.println(this.variables.get((Object)transaction) + ".merge(" + this.formatBranch(source, false) + ", new " + TestRecorder.simpleClassName(merger) + "());");
    }

    public synchronized void mergeTransaction(TestRecorderTransaction transaction, CDOBranchPoint source, CDOMerger merger) {
        this.println(this.variables.get((Object)transaction) + ".merge(" + this.formatBranchPoint(source, false) + ", new " + TestRecorder.simpleClassName(merger) + "());");
    }

    public synchronized void commitTransaction(TestRecorderTransaction transaction, CDOCommitInfo commitInfo) {
        CDOBranchPoint branchPoint;
        Variable variable = this.createVariable("commit", commitInfo);
        long timeStamp = commitInfo.getTimeStamp();
        Variable oldVariable = this.variables.put(timeStamp, variable);
        if (oldVariable != null) {
            this.variables.put(timeStamp, oldVariable);
        }
        if ((oldVariable = this.variables.put(branchPoint = CDOBranchUtil.copyBranchPoint((CDOBranchPoint)commitInfo), variable)) != null) {
            this.variables.put(branchPoint, oldVariable);
        }
        StringBuilder builder = new StringBuilder("CDOCommitInfo " + variable + " = commitAndSync(" + this.variables.get((Object)transaction));
        InternalCDOView[] internalCDOViewArray = transaction.getSession().getViews();
        int n = internalCDOViewArray.length;
        int n2 = 0;
        while (n2 < n) {
            Variable viewVariable;
            InternalCDOView view = internalCDOViewArray[n2];
            if (view != transaction && (viewVariable = this.variables.get(view)) != null) {
                builder.append(", ");
                builder.append(viewVariable);
            }
            ++n2;
        }
        builder.append(");");
        this.println(builder.toString());
    }

    public synchronized void rollbackTransaction(TestRecorderTransaction transaction) {
        this.println(this.variables.get((Object)transaction) + ".rollback();");
    }

    private Variable createVariable(String type, Object object) {
        AtomicInteger counter = this.typeCounters.get(type);
        if (counter == null) {
            counter = new AtomicInteger();
            this.typeCounters.put(type, counter);
        }
        int number = counter.incrementAndGet();
        Variable variable = new Variable(type, number, object);
        this.variables.put(object, variable);
        return variable;
    }

    private void addCloseListener(final Variable variable) {
        final Object object = variable.getObject();
        EventUtil.addListener((Object)object, (IListener)new LifecycleEventAdapter(){

            protected void onDeactivated(ILifecycle lifecycle) {
                TestRecorder.this.variables.remove(object);
                TestRecorder.this.println(variable + ".close();");
            }
        });
    }

    private String formatBranchPoint(CDOBranchPoint branchPoint, boolean optional) {
        CDOBranch branch = branchPoint.getBranch();
        long timeStamp = branchPoint.getTimeStamp();
        if (branch.isMainBranch() && timeStamp == 0L && optional) {
            return "";
        }
        Variable branchPointVariable = this.variables.get(branchPoint);
        if (branchPointVariable == null) {
            branchPointVariable = this.createVariable("point", branchPoint);
            this.println("CDOBranchPoint " + branchPointVariable + " = " + this.formatBranch(branch, false) + ".getPoint(" + this.formatTimeStamp(timeStamp, false) + ");");
        }
        return branchPointVariable.toString();
    }

    private String formatBranch(CDOBranch branch, boolean optional) {
        if (branch.isMainBranch() && optional) {
            return "";
        }
        Variable branchVariable = this.variables.get(branch);
        if (branchVariable == null) {
            Variable sessionVariable = this.variables.get(TestRecorder.getSession(branch));
            if (branch.isMainBranch()) {
                return sessionVariable + ".getBranchManager().getMainBranch()";
            }
            branchVariable = this.createVariable("branch", branch);
            this.println("CDOBranch " + branchVariable + " = " + sessionVariable + ".getBranchManager().getBranch(" + TestRecorder.quot(branch.getPathName()) + ");");
        }
        return branchVariable.toString();
    }

    private String formatTimeStamp(long timeStamp, boolean optional) {
        if (timeStamp == 0L) {
            if (optional) {
                return "";
            }
            return "CDOBranchPoint.UNSPECIFIED_DATE";
        }
        Variable variable = this.variables.get(timeStamp);
        if (variable != null && variable.getObject() instanceof CDOTimeProvider) {
            return variable + ".getTimeStamp()";
        }
        return String.valueOf(timeStamp) + "L";
    }

    private String formatResourceNode(CDOResourceNode resourceNode) {
        Variable variable = this.variables.get(resourceNode);
        if (variable == null) {
            EClass eClass = resourceNode.eClass();
            String typeName = eClass.getName();
            String type = TYPES.get(eClass);
            variable = this.createVariable(type, resourceNode);
            this.println(String.valueOf(typeName) + " " + variable + " = " + this.variables.get(resourceNode.cdoView()) + "." + typeName.replace("CDO", "get") + "(getResourcePath(" + TestRecorder.quot(resourceNode.getPath()) + "));");
        }
        return variable.toString();
    }

    private String formatObject(CDOObject object) {
        Variable variable = this.variables.get(object);
        if (variable == null) {
            EClass eClass = object.eClass();
            String typeName = eClass.getName();
            String type = StringUtil.uncap((String)eClass.getName());
            variable = this.createVariable(type, object);
            if (FSMUtil.isTransient((CDOObject)object)) {
                String packageName = eClass.getEPackage().getName();
                String factory = TYPES.get(packageName);
                if (factory == null) {
                    factory = String.valueOf(StringUtil.cap((String)packageName)) + "Factory.eINSTANCE";
                }
                this.println(String.valueOf(typeName) + " " + variable + " = " + factory + ".create" + eClass.getName() + "();");
                for (EStructuralFeature feature : eClass.getEAllStructuralFeatures()) {
                    Object value = object.eGet(feature);
                    if (value instanceof List) {
                        List list = (List)value;
                        for (Object element : list) {
                            this.println(variable + ".get" + StringUtil.cap((String)feature.getName()) + "().add(" + this.formatValue(object, feature, element) + ");");
                        }
                        continue;
                    }
                    if (value == null) continue;
                    this.println(variable + ".set" + StringUtil.cap((String)feature.getName()) + "(" + this.formatValue(object, feature, value) + ");");
                }
            } else {
                String rhs;
                CDOObject container = CDOUtil.getCDOObject((EObject)object.eContainer());
                if (container != null) {
                    EReference reference = (EReference)object.eContainingFeature();
                    rhs = String.valueOf(this.formatObject(container)) + ".get" + StringUtil.cap((String)reference.getName()) + "()";
                    if (reference.isMany()) {
                        List list = (List)container.eGet((EStructuralFeature)reference);
                        int index = list.indexOf(object);
                        rhs = String.valueOf(rhs) + ".get(" + index + ")";
                    }
                } else {
                    CDOResource resource = (CDOResource)object.eResource();
                    int index = resource.getContents().indexOf((Object)object);
                    rhs = "(" + typeName + ")" + this.formatResourceNode((CDOResourceNode)resource) + ".getContents().get(" + index + ")";
                }
                this.println(String.valueOf(typeName) + " " + variable + " = " + rhs + ";");
            }
        }
        return variable.toString();
    }

    private String formatValue(CDOObject object, EStructuralFeature feature, Object value) {
        if (value != null) {
            EClassifier eType = feature.getEType();
            if (eType instanceof EEnum) {
                EEnumLiteral literal = ((EEnum)eType).getEEnumLiteral(value.toString());
                return String.valueOf(literal.getEEnum().getName()) + "." + literal.toString().toUpperCase();
            }
            CDOType type = CDOModelUtil.getType((EClassifier)eType);
            if (type != null) {
                value = type.convertToEMF(eType, value);
            }
            if (value instanceof String) {
                return TestRecorder.quot((String)value);
            }
            if (value instanceof CDOID) {
                value = object.cdoView().getObject((CDOID)value);
            }
            if (value instanceof EObject) {
                return this.formatObject(CDOUtil.getCDOObject((EObject)((EObject)value)));
            }
        }
        return String.valueOf(value);
    }

    private static TestRecorderSession getSession(CDOBranch branch) {
        InternalCDOBranchManager branchManager = (InternalCDOBranchManager)branch.getBranchManager();
        return (TestRecorderSession)((CDOSessionProtocol)branchManager.getBranchLoader()).getSession();
    }

    private static String simpleClassName(Object object) {
        String name = object.getClass().getName();
        int lastDot = name.lastIndexOf(46);
        if (lastDot != -1) {
            name = name.substring(lastDot + 1);
        }
        return name.replace('$', '.');
    }

    private static String list(Object ... values) {
        StringBuilder builder = new StringBuilder();
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String str;
            Object value = objectArray[n2];
            if (value != null && (str = value.toString()).length() != 0) {
                StringUtil.appendSeparator((StringBuilder)builder, (String)", ");
                builder.append(str);
            }
            ++n2;
        }
        return builder.toString();
    }

    private static String quot(String value) {
        StringBuilder builder = new StringBuilder();
        builder.append("\"");
        if (value != null && value.length() != 0) {
            builder.append(value);
        }
        builder.append("\"");
        return builder.toString();
    }

    public static final class Variable {
        private final String type;
        private final int number;
        private final Object object;

        private Variable(String type, int number, Object object) {
            this.type = type;
            this.number = number;
            this.object = object;
        }

        public String getType() {
            return this.type;
        }

        public int getNumber() {
            return this.number;
        }

        public Object getObject() {
            return this.object;
        }

        public String toString() {
            return String.valueOf(this.type) + this.number;
        }
    }
}

