/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.internal.ui.annotation;

import org.eclipse.eclemma.internal.ui.UIMessages;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.osgi.util.NLS;
import org.jacoco.core.analysis.ICounter;
import org.jacoco.core.analysis.ILine;

public class CoverageAnnotation
extends Annotation {
    private static final String FULL_COVERAGE = "org.eclipse.eclemma.ui.fullCoverageAnnotation";
    private static final String PARTIAL_COVERAGE = "org.eclipse.eclemma.ui.partialCoverageAnnotation";
    private static final String NO_COVERAGE = "org.eclipse.eclemma.ui.noCoverageAnnotation";
    private final Position position;
    private final ILine line;

    public CoverageAnnotation(int offset, int length, ILine line) {
        super(CoverageAnnotation.getAnnotationID(line), false, null);
        this.line = line;
        this.position = new Position(offset, length);
    }

    public Position getPosition() {
        return this.position;
    }

    public ILine getLine() {
        return this.line;
    }

    public String getText() {
        ICounter branches = this.line.getBranchCounter();
        switch (branches.getStatus()) {
            case 1: {
                return NLS.bind((String)UIMessages.AnnotationTextAllBranchesMissed_message, (Object)branches.getMissedCount());
            }
            case 2: {
                return NLS.bind((String)UIMessages.AnnotationTextAllBranchesCovered_message, (Object)branches.getTotalCount());
            }
            case 3: {
                return NLS.bind((String)UIMessages.AnnotationTextSomeBranchesMissed_message, (Object)branches.getMissedCount(), (Object)branches.getTotalCount());
            }
        }
        return null;
    }

    private static String getAnnotationID(ILine line) {
        switch (line.getStatus()) {
            case 2: {
                return FULL_COVERAGE;
            }
            case 3: {
                return PARTIAL_COVERAGE;
            }
            case 1: {
                return NO_COVERAGE;
            }
        }
        throw new AssertionError(line.getStatus());
    }
}

