/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.completion;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.CompletionContext;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.ILocalVariable;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.ScriptElementImageDescriptor;
import org.eclipse.dltk.ui.ScriptElementImageProvider;
import org.eclipse.dltk.ui.text.completion.ScriptTextMessages;
import org.eclipse.jface.resource.ImageDescriptor;

public class CompletionProposalLabelProvider {
    public String createParameterList(CompletionProposal methodProposal) {
        Assert.isTrue((methodProposal.getKind() == 5 ? 1 : 0) != 0);
        return this.appendParameterList(new StringBuffer(), methodProposal).toString();
    }

    protected StringBuffer appendParameterList(StringBuffer buffer, CompletionProposal methodProposal) {
        Integer paramLimit;
        String[] parameterNames = methodProposal.findParameterNames(null);
        String[] parameterTypes = null;
        if (parameterNames != null && (paramLimit = (Integer)methodProposal.getAttribute("org.eclipse.dltk.uiCompletionProposal#ParameterLimit")) != null) {
            int i = 0;
            while (i < parameterNames.length) {
                if (i >= paramLimit) break;
                if (i > 0) {
                    buffer.append(',');
                    buffer.append(' ');
                }
                buffer.append(parameterNames[i]);
                ++i;
            }
            return buffer;
        }
        return this.appendParameterSignature(buffer, parameterTypes, parameterNames);
    }

    protected StringBuffer appendParameterSignature(StringBuffer buffer, String[] parameterTypes, String[] parameterNames) {
        if (parameterNames != null) {
            int i = 0;
            while (i < parameterNames.length) {
                if (i > 0) {
                    buffer.append(',');
                    buffer.append(' ');
                }
                buffer.append(parameterNames[i]);
                ++i;
            }
        }
        return buffer;
    }

    protected String createMethodProposalLabel(CompletionProposal methodProposal) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(methodProposal.getName());
        buffer.append('(');
        this.appendParameterList(buffer, methodProposal);
        buffer.append(')');
        IModelElement element = methodProposal.getModelElement();
        if (element != null && element.getElementType() == 9 && element.exists()) {
            IMethod method = (IMethod)element;
            try {
                if (!method.isConstructor()) {
                    IType declaringType;
                    String type = method.getType();
                    if (type != null) {
                        buffer.append(this.getReturnTypeSeparator()).append(type);
                    }
                    if ((declaringType = method.getDeclaringType()) != null) {
                        buffer.append(this.getQualifierSeparator()).append(declaringType.getElementName());
                    }
                }
            }
            catch (ModelException modelException) {
                // empty catch block
            }
        }
        return buffer.toString();
    }

    protected String createOverrideMethodProposalLabel(CompletionProposal methodProposal) {
        StringBuffer nameBuffer = new StringBuffer();
        nameBuffer.append(methodProposal.getName());
        nameBuffer.append('(');
        this.appendParameterList(nameBuffer, methodProposal);
        nameBuffer.append(")  ");
        return nameBuffer.toString();
    }

    public String createTypeProposalLabel(CompletionProposal typeProposal) {
        return this.createTypeProposalLabel(typeProposal.getName());
    }

    protected String createTypeProposalLabel(String fullName) {
        return fullName;
    }

    protected String createSimpleLabelWithType(CompletionProposal proposal) {
        ILocalVariable var;
        String type;
        IModelElement element = proposal.getModelElement();
        if (element != null && element.getElementType() == 13 && element.exists() && (type = (var = (ILocalVariable)element).getType()) != null) {
            return proposal.getName() + this.getReturnTypeSeparator() + type;
        }
        return proposal.getName();
    }

    protected String createFieldProposalLabel(CompletionProposal proposal) {
        IModelElement element = proposal.getModelElement();
        if (element != null && element.getElementType() == 8 && element.exists()) {
            IField field = (IField)element;
            try {
                String type = field.getType();
                if (type != null) {
                    return proposal.getName() + this.getReturnTypeSeparator() + type;
                }
            }
            catch (ModelException modelException) {
                // empty catch block
            }
        }
        return proposal.getName();
    }

    public String createSimpleLabel(CompletionProposal proposal) {
        return String.valueOf(proposal.getName());
    }

    public String createKeywordLabel(CompletionProposal proposal) {
        return String.valueOf(proposal.getName());
    }

    public String createLabel(CompletionProposal proposal) {
        switch (proposal.getKind()) {
            case 5: 
            case 9: 
            case 10: {
                return this.createMethodProposalLabel(proposal);
            }
            case 6: {
                return this.createOverrideMethodProposalLabel(proposal);
            }
            case 7: {
                return this.createTypeProposalLabel(proposal);
            }
            case 1: {
                return this.createFieldProposalLabel(proposal);
            }
            case 4: 
            case 8: {
                return this.createSimpleLabelWithType(proposal);
            }
            case 2: {
                return this.createKeywordLabel(proposal);
            }
            case 3: 
            case 11: {
                return this.createSimpleLabel(proposal);
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public ImageDescriptor createImageDescriptor(CompletionProposal proposal) {
        ImageDescriptor descriptor;
        switch (proposal.getKind()) {
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                return this.createMethodImageDescriptor(proposal);
            }
            case 7: {
                descriptor = DLTKPluginImages.DESC_OBJS_CLASSALT;
                break;
            }
            case 1: {
                descriptor = DLTKPluginImages.DESC_FIELD_DEFAULT;
                break;
            }
            case 4: 
            case 8: {
                descriptor = DLTKPluginImages.DESC_OBJS_LOCAL_VARIABLE;
                break;
            }
            case 11: {
                descriptor = DLTKPluginImages.DESC_OBJS_PACKAGE;
                break;
            }
            case 2: {
                descriptor = DLTKPluginImages.DESC_OBJS_KEYWORD;
                break;
            }
            case 3: {
                descriptor = null;
                break;
            }
            default: {
                descriptor = null;
                Assert.isTrue((boolean)false);
            }
        }
        if (descriptor == null) {
            return null;
        }
        return this.decorateImageDescriptor(descriptor, proposal);
    }

    public ImageDescriptor createMethodImageDescriptor(CompletionProposal proposal) {
        return this.decorateImageDescriptor(ScriptElementImageProvider.getMethodImageDescriptor(proposal.getFlags()), proposal);
    }

    public ImageDescriptor createTypeImageDescriptor(CompletionProposal proposal) {
        return this.decorateImageDescriptor(ScriptElementImageProvider.getTypeImageDescriptor(proposal.getFlags(), false), proposal);
    }

    protected ImageDescriptor createFieldImageDescriptor(CompletionProposal proposal) {
        return this.decorateImageDescriptor(ScriptElementImageProvider.getFieldImageDescriptor(proposal.getFlags()), proposal);
    }

    protected ImageDescriptor createLocalImageDescriptor(CompletionProposal proposal) {
        return this.decorateImageDescriptor(DLTKPluginImages.DESC_OBJS_LOCAL_VARIABLE, proposal);
    }

    protected ImageDescriptor createPackageImageDescriptor(CompletionProposal proposal) {
        return this.decorateImageDescriptor(DLTKPluginImages.DESC_OBJS_PACKAGE, proposal);
    }

    protected ImageDescriptor decorateImageDescriptor(ImageDescriptor descriptor, CompletionProposal proposal) {
        int adornmentFlags = ScriptElementImageProvider.computeAdornmentFlags(proposal.getModelElement(), 3);
        if (proposal.isConstructor()) {
            adornmentFlags |= 0x200;
        }
        if (adornmentFlags == 0) {
            return descriptor;
        }
        return new ScriptElementImageDescriptor(descriptor, adornmentFlags, ScriptElementImageProvider.SMALL_SIZE);
    }

    void setContext(CompletionContext context) {
    }

    protected String getReturnTypeSeparator() {
        return ScriptTextMessages.CompletionProposalLabelProvider_returnTypeSeparator;
    }

    protected String getQualifierSeparator() {
        return ScriptTextMessages.CompletionProposalLabelProvider_qualifierSeparator;
    }
}

