/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.refactoring.changes;

import java.text.MessageFormat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.internal.corext.refactoring.AbstractModelElementRenameChange;
import org.eclipse.dltk.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public final class RenameSourceFolderChange
extends AbstractModelElementRenameChange {
    private static RefactoringStatus checkIfModifiable(IProjectFragment root, IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        RenameSourceFolderChange.checkExistence(result, root);
        if (result.hasFatalError()) {
            return result;
        }
        if (root.isArchive()) {
            result.addFatalError(MessageFormat.format(RefactoringCoreMessages.RenameSourceFolderChange_rename_archive, root.getElementName()));
            return result;
        }
        if (root.isExternal()) {
            result.addFatalError(MessageFormat.format(RefactoringCoreMessages.RenameSourceFolderChange_rename_external, root.getElementName()));
            return result;
        }
        RenameSourceFolderChange.checkExistence(result, root.getCorrespondingResource());
        if (result.hasFatalError()) {
            return result;
        }
        if (root.getCorrespondingResource().isLinked()) {
            result.addFatalError(MessageFormat.format(RefactoringCoreMessages.RenameSourceFolderChange_rename_linked, root.getElementName()));
            return result;
        }
        return result;
    }

    public RenameSourceFolderChange(RefactoringDescriptor descriptor, IProjectFragment sourceFolder, String newName, String comment) {
        this(descriptor, sourceFolder.getPath(), sourceFolder.getElementName(), newName, comment, -1L);
        Assert.isTrue((!sourceFolder.isReadOnly() ? 1 : 0) != 0, (String)"should not be read only");
        Assert.isTrue((!sourceFolder.isArchive() ? 1 : 0) != 0, (String)"should not be an archive");
    }

    private RenameSourceFolderChange(RefactoringDescriptor descriptor, IPath resourcePath, String oldName, String newName, String comment, long stampToRestore) {
        super(descriptor, resourcePath, oldName, newName, comment);
    }

    @Override
    protected IPath createNewPath() {
        return this.getResourcePath().removeLastSegments(1).append(this.getNewName());
    }

    @Override
    protected Change createUndoChange(long stampToRestore) {
        return new RenameSourceFolderChange(null, this.createNewPath(), this.getNewName(), this.getOldName(), this.getComment(), stampToRestore);
    }

    @Override
    protected void doRename(IProgressMonitor pm) throws CoreException {
        IProjectFragment sourceFolder = this.getSourceFolder();
        if (sourceFolder != null) {
            sourceFolder.move(this.getNewPath(), this.getCoreMoveFlags(), this.getScriptModelUpdateFlags(), null, pm);
        }
    }

    private int getCoreMoveFlags() {
        if (this.getResource().isLinked()) {
            return 32;
        }
        return 0;
    }

    private int getScriptModelUpdateFlags() {
        return 30;
    }

    public String getName() {
        return MessageFormat.format(RefactoringCoreMessages.RenameSourceFolderChange_rename, this.getOldName(), this.getNewName());
    }

    private IPath getNewPath() {
        return this.getResource().getFullPath().removeLastSegments(1).append(this.getNewName());
    }

    private IProjectFragment getSourceFolder() {
        return (IProjectFragment)this.getModifiedElement();
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        pm.beginTask("", 2);
        result.merge(this.isValid((IProgressMonitor)new SubProgressMonitor(pm, 1), 2));
        if (result.hasFatalError()) {
            return result;
        }
        IProjectFragment sourceFolder = this.getSourceFolder();
        result.merge(RenameSourceFolderChange.checkIfModifiable(sourceFolder, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
        return result;
    }
}

