/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.activestatedebugger;

import java.util.Set;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.InstrumentationConfig;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.InstrumentationMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstrumentationUtils {
    public static void collectProjects(IScriptModel model, Set<IScriptProject> projects, IScriptProject project) {
        if (projects.add(project)) {
            IBuildpathEntry[] entries;
            try {
                entries = project.getResolvedBuildpath(true);
            }
            catch (ModelException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
                return;
            }
            IBuildpathEntry[] iBuildpathEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IBuildpathEntry entry = iBuildpathEntryArray[n2];
                if (entry.getEntryKind() == 2) {
                    InstrumentationUtils.collectProjects(model, projects, model.getScriptProject(entry.getPath().segment(0)));
                }
                ++n2;
            }
        }
    }

    public static void collectProjects(Set<IScriptProject> projects, IScriptProject project) {
        IScriptModel model = DLTKCore.create((IWorkspaceRoot)InstrumentationUtils.getWorkspaceRoot());
        InstrumentationUtils.collectProjects(model, projects, project);
    }

    public static InstrumentationMode getMode(InstrumentationConfig config) {
        if (config != null) {
            return config.getMode();
        }
        return InstrumentationMode.SOURCES;
    }

    protected static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }
}

