/*******************************************************************************
 * Copyright (c) 2000, 2016 IBM Corporation and others.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 *******************************************************************************/
package org.eclipse.dltk.internal.compiler.lookup;

import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.compiler.env.lookup.Scope;

public class TypeScope extends Scope {

	public TypeDeclaration referenceContext;

	public TypeScope(Scope parent, TypeDeclaration context) {
		super(CLASS_SCOPE, parent);
		this.referenceContext = context;
	}

	/*
	 * Answer the reference type of this scope. It is the nearest enclosing type
	 * of this scope.
	 */
	public TypeDeclaration referenceType() {
		return referenceContext;
	}

	@Override
	public String toString() {
		if (referenceContext != null) {
			return "--- Class Scope ---\n\n"; //$NON-NLS-1$
		}
		return "--- Class Scope ---\n\n Binding not initialized"; //$NON-NLS-1$
	}
}
