/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.ddl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentServiceImpl;
import org.eclipse.datatools.connectivity.sqm.core.rte.EngineeringOption;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.EngineeringOptionCategory;
import org.eclipse.datatools.enablement.ibm.IBMPluginActivator;
import org.eclipse.datatools.enablement.ibm.ddl.CodeTemplateContextPattern;
import org.eclipse.datatools.enablement.ibm.ddl.DdlGenerationMessages;
import org.eclipse.datatools.enablement.ibm.ddl.ExtendDdlBuilder;
import org.eclipse.datatools.enablement.ibm.ddl.ModelValidationProvider;
import org.eclipse.datatools.enablement.ibm.ddl.OlapDdlBuilder;
import org.eclipse.datatools.enablement.ibm.ddl.TypedElementLogicalDomainProvider;
import org.eclipse.datatools.enablement.ibm.util.ModelHelper;
import org.eclipse.datatools.modelbase.sql.accesscontrol.AuthorizationIdentifier;
import org.eclipse.datatools.modelbase.sql.constraints.CheckConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.Index;
import org.eclipse.datatools.modelbase.sql.constraints.IndexMember;
import org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint;
import org.eclipse.datatools.modelbase.sql.expressions.SearchCondition;
import org.eclipse.datatools.modelbase.sql.query.QuerySearchCondition;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionColumn;
import org.eclipse.datatools.modelbase.sql.query.helper.StatementHelper;
import org.eclipse.datatools.modelbase.sql.query.helper.TableHelper;
import org.eclipse.datatools.modelbase.sql.query.util.SQLQuerySourceFormat;
import org.eclipse.datatools.modelbase.sql.query.util.SQLQuerySourceInfo;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.SQLSchemaPackage;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.sqltools.parsers.sql.query.SQLQueryParseResult;
import org.eclipse.datatools.sqltools.parsers.sql.query.SQLQueryParserManager;
import org.eclipse.datatools.sqltools.parsers.sql.query.SQLQueryParserManagerProvider;
import org.eclipse.datatools.sqltools.parsers.sql.query.postparse.DataTypeResolver;
import org.eclipse.datatools.sqltools.parsers.sql.query.postparse.TableReferenceResolver;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.osgi.service.prefs.Preferences;

public class DdlGenerationUtility {
    private static OlapDdlBuilder olapDdlBuilder = null;
    private static ExtendDdlBuilder nicknameDdlBuilder = null;
    private static ExtendDdlBuilder federatedProcedureDdlBuilder = null;
    private static ExtendDdlBuilder remoteServerDdlBuilder = null;
    private static ExtendDdlBuilder wrapperDdlBuilder = null;
    private static ExtendDdlBuilder userMappingDdlBuilder = null;
    private static TypedElementLogicalDomainProvider elementDomainProvider = null;
    private static ModelValidationProvider modelValidationProvider = null;
    public static final String QUOTE_IDENTIFIERS_DEFAULT = "quoteIdentifiersDefault";
    public static final String QUALIFY_NAMES_DEFAULT = "qualifyNamesDefault";
    public static final boolean DEFAULT_QUOTE_IDENTIFIERS_DEFAULT_VALUE = true;
    public static final boolean DEFAULT_QUALIFY_NAMES_DEFAULT_VALUE = true;
    protected static boolean quoteIdentifiersDefault = true;
    protected static boolean qualifyNamesDefault = true;
    public static final String SPUFI_RUNSQLSTM_FORMAT = "spufi_runsqlstm";
    public static final boolean SPUFI_RUNSQLSTM_FORMAT_VALUE = false;
    protected static boolean spufi_runsqlstm_format = false;
    private static final String CREATE_STATEMENT = "CREATE";
    private static final String DROP_STATEMENT = "DROP";
    private static final String STATEMENT_TYPE_SEPARATOR = ";";
    private static final String CONTEXT_SEPARATOR = ",";
    private static final String CONTEXT_APPLY_FLAG = "?";
    public static final String PATTERN_KEY = "codetemplate::";
    public static String CREATE_PROLOG = "C_PRO";
    public static String CREATE_POSTLOG = "C_POST";
    public static String DROP_PROLOG = "D_PRO";
    public static String DROP_POSTLOG = "D_POST";
    public static final byte GENERATE_CREATE_PATTERN = 2;
    public static final byte GENERATE_DROP_PATTERN = 4;
    public static final String DATABASE_NAME_PROPERTY = "org.eclipse.datatools.connectivity.db.databaseName";
    public static Preferences instanceNode = InstanceScope.INSTANCE.getNode("com.ibm.datatools.core.ui");
    private static int tableNameSuffix;

    static {
        DdlGenerationUtility.initDdlGenerationPreferences();
        tableNameSuffix = 0;
    }

    public static EngineeringOptionCategory[] createDDLGenerationOptionCategories(String product, String version) {
        Vector<EngineeringOptionCategory> categoryVec = new Vector<EngineeringOptionCategory>();
        categoryVec.add(new EngineeringOptionCategory("GENERATE_OPTIONS", DdlGenerationMessages.GENERATION_OPTIONS, DdlGenerationMessages.GENERATION_OPTIONS_DES));
        categoryVec.add(new EngineeringOptionCategory("GENERATE_ELEMENTS", DdlGenerationMessages.ADDITIONAL_ELEMENTS, DdlGenerationMessages.ADDITIONAL_ELEMENTS_DES));
        Object[] categories = new EngineeringOptionCategory[categoryVec.size()];
        categoryVec.copyInto(categories);
        return categories;
    }

    public static Set getAllContainedDisplayableElementSetPlus(SQLObject[] elements) {
        HashSet<SQLObject> s = new HashSet<SQLObject>();
        int i = 0;
        while (i < elements.length) {
            s.add(elements[i]);
            if (elements[i] instanceof AuthorizationIdentifier) {
                s.addAll(ContainmentServiceImpl.INSTANCE.getAllContainedElements((EObject)elements[i]));
            } else {
                s.addAll(ContainmentServiceImpl.INSTANCE.getAllContainedDisplayableElements((EObject)elements[i]));
            }
            ++i;
        }
        return s;
    }

    public static Set getAllContainedDisplayableElementSet(SQLObject[] elements) {
        LinkedHashSet<SQLObject> s = new LinkedHashSet<SQLObject>();
        int i = 0;
        while (i < elements.length) {
            s.add(elements[i]);
            s.addAll(ContainmentServiceImpl.INSTANCE.getAllContainedDisplayableElements((EObject)elements[i]));
            ++i;
        }
        return s;
    }

    public static void initDdlGenerationPreferences() {
        IEclipsePreferences instanceNode = new InstanceScope().getNode("com.ibm.datatools.core.ui");
        quoteIdentifiersDefault = instanceNode.getBoolean(QUOTE_IDENTIFIERS_DEFAULT, true);
        qualifyNamesDefault = instanceNode.getBoolean(QUALIFY_NAMES_DEFAULT, true);
        spufi_runsqlstm_format = instanceNode.getBoolean(SPUFI_RUNSQLSTM_FORMAT, false);
    }

    public static boolean getQualifyNamesDefault() {
        return qualifyNamesDefault;
    }

    public static boolean getQuoteIdentifiersDefault() {
        return quoteIdentifiersDefault;
    }

    public static void setQualifyNamesDefault(boolean newValue) {
        qualifyNamesDefault = newValue;
    }

    public static void setQuoteIdentifiersDefault(boolean newValue) {
        quoteIdentifiersDefault = newValue;
    }

    public static boolean getSpufiRunsqlstmFormat() {
        return spufi_runsqlstm_format;
    }

    public static void setSpufiRunsqlstmFormat(boolean newValue) {
        spufi_runsqlstm_format = newValue;
    }

    public static EngineeringOption getEngineeringOption(String id, String product, String version, EngineeringOptionCategory general_options, EngineeringOptionCategory additional_element) {
        try {
            if (id.equalsIgnoreCase("GENERATE_FULLY_QUALIFIED_NAME")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_FULLY_QUALIFIED_NAME, DdlGenerationMessages.GENERATE_FULLY_QUALIFIED_NAME_DES, qualifyNamesDefault, general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_QUOTED_IDENTIFIER")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_QUOTED_IDENTIFIER, DdlGenerationMessages.GENERATE_QUOTED_IDENTIFIER_DES, quoteIdentifiersDefault, general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_DROP_STATEMENTS")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_DROP_STATEMENTS, DdlGenerationMessages.GENERATE_DROP_STATEMENTS_DES, false, general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_CREATE_STATEMENTS")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_CREATE_STATEMENTS, DdlGenerationMessages.GENERATE_CREATE_STATEMENTS_DES, true, general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_PRIVILEGE")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_PRIVILEGE, DdlGenerationMessages.GENERATE_PRIVILEGE_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_COMMENTS")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_COMMENTS, DdlGenerationMessages.GENERATE_COMMENTS_DES, true, general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_LABELS")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_LABELS, DdlGenerationMessages.GENERATE_LABELS_DES, true, general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_IN_TABLESPACE_CLAUSE")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_IN_TABLESPACE_CLAUSE, DdlGenerationMessages.GENERATE_IN_TABLESPACE_CLAUSE_DES, true, general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_ON_FILEGROUP_CLAUSE")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_ON_FILEGROUP_CLAUSE, DdlGenerationMessages.GENERATE_ON_FILEGROUP_CLAUSE_DES, true, general_options);
            }
            if (id.equalsIgnoreCase("USE_DOMAIN_IF_EXIST")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_USE_DOMAIN_IF_EXIST, DdlGenerationMessages.GENERATE_USE_DOMAIN_IF_EXIST_DES, false, general_options);
            }
            if (id.equalsIgnoreCase("CREATE_OR_REPLACE") && ModelHelper.getVersionAsFloat(version) >= 9.7f) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_CREATE_OR_REPLACE, DdlGenerationMessages.GENERATE_CREATE_OR_REPLACE_DES, false, general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_TABLES")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_TABLES, DdlGenerationMessages.GENERATE_TABLES_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_TABLESPACES")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_TABLESPACES, DdlGenerationMessages.GENERATE_TABLESPACES_DES, false, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_FILEGROUPS")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_FILEGROUPS, DdlGenerationMessages.GENERATE_FILEGROUPS_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_INDICES")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_INDEX, DdlGenerationMessages.GENERATE_INDEX_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_STOREDPROCEDURES")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_STOREDPROCEDURE, DdlGenerationMessages.GENERATE_STOREDPROCEDURE_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_FUNCTIONS")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_FUNCTION, DdlGenerationMessages.GENERATE_FUNCTION_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_VIEWS")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_VIEW, DdlGenerationMessages.GENERATE_VIEW_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_TRIGGERS")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_TRIGGER, DdlGenerationMessages.GENERATE_TRIGGER_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_SEQUENCES")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_SEQUENCE, DdlGenerationMessages.GENERATE_SEQUENCE_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_USER_DEFINED_TYPE")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_USER_DEFINED_TYPE, DdlGenerationMessages.GENERATE_USER_DEFINED_TYPE_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_PK_CONSTRAINTS")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_PK_CONSTRAINTS, DdlGenerationMessages.GENERATE_PK_CONSTRAINTS_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_CK_CONSTRAINTS")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_CK_CONSTRAINTS, DdlGenerationMessages.GENERATE_CK_CONSTRAINTS_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_FK_CONSTRAINTS")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_FK_CONSTRAINTS, DdlGenerationMessages.GENERATE_FK_CONSTRAINTS_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_TABLESPACES")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_TABLESPACES, DdlGenerationMessages.GENERATE_TABLESPACES_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_DATABASE")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_DATABASE, DdlGenerationMessages.GENERATE_DATABASE_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_MQT")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_MQT, DdlGenerationMessages.GENERATE_MQT_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_ALIAS")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_ALIAS, DdlGenerationMessages.GENERATE_ALIAS_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_SYNONYM")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_SYNONYM, DdlGenerationMessages.GENERATE_SYNONYM_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_BUFFERPOOL")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_BUFFERPOOL, DdlGenerationMessages.GENERATE_BUFFERPOOL_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_STORAGEGROUP")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_STORAGEGROUP, DdlGenerationMessages.GENERATE_STORAGEGROUP_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_PARTITIONGROUP")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_PARTITIONGROUP, DdlGenerationMessages.GENERATE_PARTITIONGROUP_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_SCHEMAS")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_SCHEMA, DdlGenerationMessages.GENERATE_SCHEMA_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_NICKNAME")) {
                ExtendDdlBuilder nicknameDdlBuilder = DdlGenerationUtility.getNicknameDdlBuilder(product, version);
                if (nicknameDdlBuilder != null) {
                    return new EngineeringOption(null, nicknameDdlBuilder.getOption(), nicknameDdlBuilder.getOptionDescription(), true, additional_element);
                }
            } else if (id.equalsIgnoreCase("GENERATE_FEDERATEDPROCEDURES")) {
                ExtendDdlBuilder federatedProcedureDdlBuilder = DdlGenerationUtility.getFederatedProcedureDdlBuilder(product, version);
                if (federatedProcedureDdlBuilder != null) {
                    return new EngineeringOption(null, federatedProcedureDdlBuilder.getOption(), federatedProcedureDdlBuilder.getOptionDescription(), true, additional_element);
                }
            } else if (id.equalsIgnoreCase("GENERATE_REMOTESERVER")) {
                ExtendDdlBuilder remoteServerDdlBuilder = DdlGenerationUtility.getRemoteServerDdlBuilder(product, version);
                if (remoteServerDdlBuilder != null) {
                    return new EngineeringOption(null, remoteServerDdlBuilder.getOption(), remoteServerDdlBuilder.getOptionDescription(), true, additional_element);
                }
            } else if (id.equalsIgnoreCase("GENERATE_WRAPPER")) {
                ExtendDdlBuilder wrapperDdlBuilder = DdlGenerationUtility.getWrapperDdlBuilder(product, version);
                if (wrapperDdlBuilder != null) {
                    return new EngineeringOption(null, wrapperDdlBuilder.getOption(), wrapperDdlBuilder.getOptionDescription(), true, additional_element);
                }
            } else if (id.equalsIgnoreCase("GENERATE_USERMAPPING")) {
                ExtendDdlBuilder userMappingDdlBuilder = DdlGenerationUtility.getUserMappingDdlBuilder(product, version);
                if (userMappingDdlBuilder != null) {
                    return new EngineeringOption(null, userMappingDdlBuilder.getOption(), userMappingDdlBuilder.getOptionDescription(), true, additional_element);
                }
            } else if (id.equalsIgnoreCase("GENERATE_OLAP")) {
                OlapDdlBuilder olapDdlBuilder = DdlGenerationUtility.getOlapDdlBuilder(product, version);
                if (olapDdlBuilder != null) {
                    return new EngineeringOption(null, olapDdlBuilder.getOption(), olapDdlBuilder.getOptionDescription(), true, additional_element);
                }
            } else {
                if (id.equalsIgnoreCase("GENERATE_PACKAGE")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_PACKAGE, DdlGenerationMessages.GENERATE_PACKAGE_DES, true, additional_element);
                }
                if (id.equalsIgnoreCase("GENERATE_PACKAGE_BODY")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_PACKAGE_BODY, DdlGenerationMessages.GENERATE_PACKAGE_BODY_DES, true, additional_element);
                }
                if (id.equalsIgnoreCase("GENERATE_BACKUP_TABLE")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_BACKUP_TABLE, DdlGenerationMessages.GENERATE_BACKUP_TABLE_DES, true, general_options);
                }
                if (id.equalsIgnoreCase("GENERATE_STATISTICS")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_STATISTICS, DdlGenerationMessages.GENERATE_STATISTICS_DES, false, general_options);
                }
                if (id.equalsIgnoreCase("GENERATE_ROLE")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_ROLE, DdlGenerationMessages.GENERATE_ROLE_DES, true, additional_element);
                }
                if (id.equalsIgnoreCase("GENERATE_USER")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_USER, DdlGenerationMessages.GENERATE_USER_DES, true, additional_element);
                }
                if (id.equalsIgnoreCase("GENERATE_GROUP")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_GROUP, DdlGenerationMessages.GENERATE_GROUP_DES, true, additional_element);
                }
                if (id.equalsIgnoreCase("CHECK_MODEL")) {
                    return new EngineeringOption(id, DdlGenerationMessages.CHECK_MODEL, DdlGenerationMessages.CHECK_MODEL_DES, false, general_options);
                }
                if (id.equalsIgnoreCase("GENERATE_MODULE")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_MODULE, DdlGenerationMessages.GENERATE_MODULE_DES, true, additional_element);
                }
                if (id.equalsIgnoreCase("GENERATE_CONDITION")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_MODULE_CONDITION, DdlGenerationMessages.GENERATE_MODULE_CONDITION_DES, true, additional_element);
                }
                if (id.equalsIgnoreCase("GENERATE_GLOBAL_VARIABLE")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_GLOBAL_VARIABLE, DdlGenerationMessages.GENERATE_GLOBAL_VARIABLE_DES, true, additional_element);
                }
                if (id.equalsIgnoreCase("GENERATE_HISTORY_TABLE")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_HISTORY_TABLE, DdlGenerationMessages.GENERATE_HISTORY_TABLE_DES, true, additional_element);
                }
                if (id.equalsIgnoreCase("GENERATE_TEMPORARY_TABLES")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_TEMPORARY_TABLE, DdlGenerationMessages.GENERATE_TEMPORARY_TABLE_DES, true, additional_element);
                }
                if (id.equalsIgnoreCase("GENERATE_XMLSCHEMA")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_XMLSCHEMA, DdlGenerationMessages.GENERATE_XMLSCHEMA_DES, false, additional_element);
                }
                if (id.equalsIgnoreCase("XMLSCHEMA_CONNECTION_NAME")) {
                    return new EngineeringOption("XMLSCHEMA_CONNECTION_NAME", "XMLSCHEMA_CONNECTION_NAME", "");
                }
                if (id.equalsIgnoreCase("XMLSCHEMA_DIRECTORY")) {
                    return new EngineeringOption("XMLSCHEMA_DIRECTORY", "XMLSCHEMA_DIRECTORY", "");
                }
                if (id.equalsIgnoreCase("GENERATE_SECURITY_POLICY")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_SECURITY_POLICY, DdlGenerationMessages.GENERATE_SECURITY_POLICY_DES, true, additional_element);
                }
                if (id.equalsIgnoreCase("DROP_RESTRICT")) {
                    return new EngineeringOption(id, DdlGenerationMessages.DROP_RESTRICT, DdlGenerationMessages.DROP_RESTRICT_DES, false, general_options);
                }
                if (id.equalsIgnoreCase("GENERATE_ROW_PERMISSIONS")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_ROW_PERMISSIONS, DdlGenerationMessages.GENERATE_ROW_PERMISSIONS_DES, true, additional_element);
                }
                if (id.equalsIgnoreCase("GENERATE_COLUMN_MASKS")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_COLUMN_MASKS, DdlGenerationMessages.GENERATE_COLUMN_MASKS_DES, true, additional_element);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static EngineeringOption getDefaultEngineeringOption(String id, String product, String version, EngineeringOptionCategory general_options, EngineeringOptionCategory additional_element) {
        try {
            if (id.equalsIgnoreCase("GENERATE_FULLY_QUALIFIED_NAME")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_FULLY_QUALIFIED_NAME, DdlGenerationMessages.GENERATE_FULLY_QUALIFIED_NAME_DES, qualifyNamesDefault, general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_QUOTED_IDENTIFIER")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_QUOTED_IDENTIFIER, DdlGenerationMessages.GENERATE_QUOTED_IDENTIFIER_DES, quoteIdentifiersDefault, general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_DROP_STATEMENTS")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_DROP_STATEMENTS, DdlGenerationMessages.GENERATE_DROP_STATEMENTS_DES, false, general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_CREATE_STATEMENTS")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_CREATE_STATEMENTS, DdlGenerationMessages.GENERATE_CREATE_STATEMENTS_DES, true, general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_PRIVILEGE")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_PRIVILEGE, DdlGenerationMessages.GENERATE_PRIVILEGE_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_COMMENTS")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_COMMENTS, DdlGenerationMessages.GENERATE_COMMENTS_DES, true, general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_LABELS")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_LABELS, DdlGenerationMessages.GENERATE_LABELS_DES, true, general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_IN_TABLESPACE_CLAUSE")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_IN_TABLESPACE_CLAUSE, DdlGenerationMessages.GENERATE_IN_TABLESPACE_CLAUSE_DES, true, general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_ON_FILEGROUP_CLAUSE")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_ON_FILEGROUP_CLAUSE, DdlGenerationMessages.GENERATE_ON_FILEGROUP_CLAUSE_DES, true, general_options);
            }
            if (id.equalsIgnoreCase("USE_DOMAIN_IF_EXIST")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_USE_DOMAIN_IF_EXIST, DdlGenerationMessages.GENERATE_USE_DOMAIN_IF_EXIST_DES, false, general_options);
            }
            if (id.equalsIgnoreCase("CREATE_OR_REPLACE") && ModelHelper.getVersionAsFloat(version) >= 9.7f) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_CREATE_OR_REPLACE, DdlGenerationMessages.GENERATE_CREATE_OR_REPLACE_DES, false, general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_TABLES")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_TABLES, DdlGenerationMessages.GENERATE_TABLES_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_TABLESPACES")) {
                if (product.equals("Oracle")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_TABLESPACES, DdlGenerationMessages.GENERATE_TABLESPACES_DES, true, additional_element);
                }
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_TABLESPACES, DdlGenerationMessages.GENERATE_TABLESPACES_DES, false, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_FILEGROUPS")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_FILEGROUPS, DdlGenerationMessages.GENERATE_FILEGROUPS_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_INDICES")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_INDEX, DdlGenerationMessages.GENERATE_INDEX_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_STOREDPROCEDURES")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_STOREDPROCEDURE, DdlGenerationMessages.GENERATE_STOREDPROCEDURE_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_FUNCTIONS")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_FUNCTION, DdlGenerationMessages.GENERATE_FUNCTION_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_VIEWS")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_VIEW, DdlGenerationMessages.GENERATE_VIEW_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_TRIGGERS")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_TRIGGER, DdlGenerationMessages.GENERATE_TRIGGER_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_SEQUENCES")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_SEQUENCE, DdlGenerationMessages.GENERATE_SEQUENCE_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_USER_DEFINED_TYPE")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_USER_DEFINED_TYPE, DdlGenerationMessages.GENERATE_USER_DEFINED_TYPE_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_DOMAIN")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_DOMAIN, DdlGenerationMessages.GENERATE_DOMAIN_TYPE_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_PK_CONSTRAINTS")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_PK_CONSTRAINTS, DdlGenerationMessages.GENERATE_PK_CONSTRAINTS_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_CK_CONSTRAINTS")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_CK_CONSTRAINTS, DdlGenerationMessages.GENERATE_CK_CONSTRAINTS_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_FK_CONSTRAINTS")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_FK_CONSTRAINTS, DdlGenerationMessages.GENERATE_FK_CONSTRAINTS_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_TABLESPACES")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_TABLESPACES, DdlGenerationMessages.GENERATE_TABLESPACES_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_DATABASE")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_DATABASE, DdlGenerationMessages.GENERATE_DATABASE_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_MQT")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_MQT, DdlGenerationMessages.GENERATE_MQT_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_ALIAS")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_ALIAS, DdlGenerationMessages.GENERATE_ALIAS_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_SYNONYM")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_SYNONYM, DdlGenerationMessages.GENERATE_SYNONYM_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_BUFFERPOOL")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_BUFFERPOOL, DdlGenerationMessages.GENERATE_BUFFERPOOL_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_STORAGEGROUP")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_STORAGEGROUP, DdlGenerationMessages.GENERATE_STORAGEGROUP_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_PARTITIONGROUP")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_PARTITIONGROUP, DdlGenerationMessages.GENERATE_PARTITIONGROUP_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_SCHEMAS")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_SCHEMA, DdlGenerationMessages.GENERATE_SCHEMA_DES, true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_NICKNAME")) {
                ExtendDdlBuilder nicknameDdlBuilder = DdlGenerationUtility.getNicknameDdlBuilder(product, version);
                if (nicknameDdlBuilder != null) {
                    return new EngineeringOption(id, nicknameDdlBuilder.getOption(), nicknameDdlBuilder.getOptionDescription(), true, additional_element);
                }
            } else if (id.equalsIgnoreCase("GENERATE_FEDERATEDPROCEDURES")) {
                ExtendDdlBuilder federatedProcedureDdlBuilder = DdlGenerationUtility.getFederatedProcedureDdlBuilder(product, version);
                if (federatedProcedureDdlBuilder != null) {
                    return new EngineeringOption(id, federatedProcedureDdlBuilder.getOption(), federatedProcedureDdlBuilder.getOptionDescription(), true, additional_element);
                }
            } else if (id.equalsIgnoreCase("GENERATE_REMOTESERVER")) {
                ExtendDdlBuilder remoteServerDdlBuilder = DdlGenerationUtility.getRemoteServerDdlBuilder(product, version);
                if (remoteServerDdlBuilder != null) {
                    return new EngineeringOption(id, remoteServerDdlBuilder.getOption(), remoteServerDdlBuilder.getOptionDescription(), true, additional_element);
                }
            } else if (id.equalsIgnoreCase("GENERATE_WRAPPER")) {
                ExtendDdlBuilder wrapperDdlBuilder = DdlGenerationUtility.getWrapperDdlBuilder(product, version);
                if (wrapperDdlBuilder != null) {
                    return new EngineeringOption(id, wrapperDdlBuilder.getOption(), wrapperDdlBuilder.getOptionDescription(), true, additional_element);
                }
            } else if (id.equalsIgnoreCase("GENERATE_USERMAPPING")) {
                ExtendDdlBuilder userMappingDdlBuilder = DdlGenerationUtility.getUserMappingDdlBuilder(product, version);
                if (userMappingDdlBuilder != null) {
                    return new EngineeringOption(id, userMappingDdlBuilder.getOption(), userMappingDdlBuilder.getOptionDescription(), true, additional_element);
                }
            } else if (id.equalsIgnoreCase("GENERATE_OLAP")) {
                OlapDdlBuilder olapDdlBuilder = DdlGenerationUtility.getOlapDdlBuilder(product, version);
                if (olapDdlBuilder != null) {
                    return new EngineeringOption(id, olapDdlBuilder.getOption(), olapDdlBuilder.getOptionDescription(), true, additional_element);
                }
            } else {
                if (id.equalsIgnoreCase("GENERATE_PACKAGE")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_PACKAGE, DdlGenerationMessages.GENERATE_PACKAGE_DES, true, additional_element);
                }
                if (id.equalsIgnoreCase("GENERATE_PACKAGE_BODY")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_PACKAGE_BODY, DdlGenerationMessages.GENERATE_PACKAGE_BODY_DES, true, additional_element);
                }
                if (id.equalsIgnoreCase("GENERATE_BACKUP_TABLE")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_BACKUP_TABLE, DdlGenerationMessages.GENERATE_BACKUP_TABLE_DES, true, general_options);
                }
                if (id.equalsIgnoreCase("GENERATE_STATISTICS")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_STATISTICS, DdlGenerationMessages.GENERATE_STATISTICS_DES, false, general_options);
                }
                if (id.equalsIgnoreCase("GENERATE_ROLE")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_ROLE, DdlGenerationMessages.GENERATE_ROLE_DES, true, additional_element);
                }
                if (id.equalsIgnoreCase("GENERATE_USER")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_USER, DdlGenerationMessages.GENERATE_USER_DES, true, additional_element);
                }
                if (id.equalsIgnoreCase("GENERATE_GROUP")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_GROUP, DdlGenerationMessages.GENERATE_GROUP_DES, true, additional_element);
                }
                if (id.equalsIgnoreCase("CHECK_MODEL")) {
                    return new EngineeringOption(id, DdlGenerationMessages.CHECK_MODEL, DdlGenerationMessages.CHECK_MODEL_DES, false, general_options);
                }
                if (id.equalsIgnoreCase("GENERATE_MODULE")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_MODULE, DdlGenerationMessages.GENERATE_MODULE_DES, true, additional_element);
                }
                if (id.equalsIgnoreCase("GENERATE_CONDITION")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_MODULE_CONDITION, DdlGenerationMessages.GENERATE_MODULE_CONDITION_DES, true, additional_element);
                }
                if (id.equalsIgnoreCase("GENERATE_GLOBAL_VARIABLE")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_GLOBAL_VARIABLE, DdlGenerationMessages.GENERATE_GLOBAL_VARIABLE_DES, true, additional_element);
                }
                if (id.equalsIgnoreCase("GENERATE_HISTORY_TABLE")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_HISTORY_TABLE, DdlGenerationMessages.GENERATE_HISTORY_TABLE_DES, true, additional_element);
                }
                if (id.equalsIgnoreCase("GENERATE_TEMPORARY_TABLES")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_TEMPORARY_TABLE, DdlGenerationMessages.GENERATE_TEMPORARY_TABLE_DES, true, additional_element);
                }
                if (id.equalsIgnoreCase("GENERATE_XMLSCHEMA")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_XMLSCHEMA, DdlGenerationMessages.GENERATE_XMLSCHEMA_DES, false, additional_element);
                }
                if (id.equalsIgnoreCase("XMLSCHEMA_CONNECTION_NAME")) {
                    return new EngineeringOption("XMLSCHEMA_CONNECTION_NAME", "XMLSCHEMA_CONNECTION_NAME", "");
                }
                if (id.equalsIgnoreCase("XMLSCHEMA_DIRECTORY")) {
                    return new EngineeringOption("XMLSCHEMA_DIRECTORY", "XMLSCHEMA_DIRECTORY", "");
                }
                if (id.equalsIgnoreCase("GENERATE_SECURITY_POLICY")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_SECURITY_POLICY, DdlGenerationMessages.GENERATE_SECURITY_POLICY_DES, true, additional_element);
                }
                if (id.equalsIgnoreCase("DROP_RESTRICT")) {
                    return new EngineeringOption(id, DdlGenerationMessages.DROP_RESTRICT, DdlGenerationMessages.DROP_RESTRICT_DES, false, general_options);
                }
                if (id.equalsIgnoreCase("GENERATE_ROW_PERMISSIONS")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_ROW_PERMISSIONS, DdlGenerationMessages.GENERATE_ROW_PERMISSIONS_DES, true, additional_element);
                }
                if (id.equalsIgnoreCase("GENERATE_COLUMN_MASKS")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_COLUMN_MASKS, DdlGenerationMessages.GENERATE_COLUMN_MASKS_DES, true, additional_element);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static EngineeringOption getEngineeringOption(String id, String product, String version, EngineeringOptionCategory general_options, EngineeringOptionCategory additional_element, SQLObject[] elements) {
        try {
            if (id.equalsIgnoreCase("GENERATE_FULLY_QUALIFIED_NAME")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_FULLY_QUALIFIED_NAME, DdlGenerationMessages.GENERATE_FULLY_QUALIFIED_NAME_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, qualifyNamesDefault), general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_QUOTED_IDENTIFIER")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_QUOTED_IDENTIFIER, DdlGenerationMessages.GENERATE_QUOTED_IDENTIFIER_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, quoteIdentifiersDefault), general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_DROP_STATEMENTS")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_DROP_STATEMENTS, DdlGenerationMessages.GENERATE_DROP_STATEMENTS_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, false), general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_CREATE_STATEMENTS")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_CREATE_STATEMENTS, DdlGenerationMessages.GENERATE_CREATE_STATEMENTS_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_PRIVILEGE")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_PRIVILEGE, DdlGenerationMessages.GENERATE_PRIVILEGE_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_COMMENTS")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_COMMENTS, DdlGenerationMessages.GENERATE_COMMENTS_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_LABELS")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_LABELS, DdlGenerationMessages.GENERATE_LABELS_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_IN_TABLESPACE_CLAUSE")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_IN_TABLESPACE_CLAUSE, DdlGenerationMessages.GENERATE_IN_TABLESPACE_CLAUSE_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_ON_FILEGROUP_CLAUSE")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_ON_FILEGROUP_CLAUSE, DdlGenerationMessages.GENERATE_ON_FILEGROUP_CLAUSE_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), general_options);
            }
            if (id.equalsIgnoreCase("USE_DOMAIN_IF_EXIST")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_USE_DOMAIN_IF_EXIST, DdlGenerationMessages.GENERATE_USE_DOMAIN_IF_EXIST_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, false), general_options);
            }
            if (id.equalsIgnoreCase("CREATE_OR_REPLACE") && ModelHelper.getVersionAsFloat(version) >= 9.7f) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_CREATE_OR_REPLACE, DdlGenerationMessages.GENERATE_CREATE_OR_REPLACE_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, false), general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_TABLES")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_TABLES, DdlGenerationMessages.GENERATE_TABLES_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_TABLESPACES")) {
                if (product.equals("Oracle")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_TABLESPACES, DdlGenerationMessages.GENERATE_TABLESPACES_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
                }
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_TABLESPACES, DdlGenerationMessages.GENERATE_TABLESPACES_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, false), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_FILEGROUPS")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_FILEGROUPS, DdlGenerationMessages.GENERATE_FILEGROUPS_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_INDICES")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_INDEX, DdlGenerationMessages.GENERATE_INDEX_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_STOREDPROCEDURES")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_STOREDPROCEDURE, DdlGenerationMessages.GENERATE_STOREDPROCEDURE_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_FUNCTIONS")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_FUNCTION, DdlGenerationMessages.GENERATE_FUNCTION_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_VIEWS")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_VIEW, DdlGenerationMessages.GENERATE_VIEW_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_TRIGGERS")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_TRIGGER, DdlGenerationMessages.GENERATE_TRIGGER_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_SEQUENCES")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_SEQUENCE, DdlGenerationMessages.GENERATE_SEQUENCE_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_USER_DEFINED_TYPE")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_USER_DEFINED_TYPE, DdlGenerationMessages.GENERATE_USER_DEFINED_TYPE_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_DOMAIN")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_DOMAIN, DdlGenerationMessages.GENERATE_DOMAIN_TYPE_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_PK_CONSTRAINTS")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_PK_CONSTRAINTS, DdlGenerationMessages.GENERATE_PK_CONSTRAINTS_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_CK_CONSTRAINTS")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_CK_CONSTRAINTS, DdlGenerationMessages.GENERATE_CK_CONSTRAINTS_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_FK_CONSTRAINTS")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_FK_CONSTRAINTS, DdlGenerationMessages.GENERATE_FK_CONSTRAINTS_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_TABLESPACES")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_TABLESPACES, DdlGenerationMessages.GENERATE_TABLESPACES_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_DATABASE")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_DATABASE, DdlGenerationMessages.GENERATE_DATABASE_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_MQT")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_MQT, DdlGenerationMessages.GENERATE_MQT_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_ALIAS")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_ALIAS, DdlGenerationMessages.GENERATE_ALIAS_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_SYNONYM")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_SYNONYM, DdlGenerationMessages.GENERATE_SYNONYM_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_BUFFERPOOL")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_BUFFERPOOL, DdlGenerationMessages.GENERATE_BUFFERPOOL_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_STORAGEGROUP")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_STORAGEGROUP, DdlGenerationMessages.GENERATE_STORAGEGROUP_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_PARTITIONGROUP")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_PARTITIONGROUP, DdlGenerationMessages.GENERATE_PARTITIONGROUP_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_SCHEMAS")) {
                return new EngineeringOption(id, DdlGenerationMessages.GENERATE_SCHEMA, DdlGenerationMessages.GENERATE_SCHEMA_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_NICKNAME")) {
                ExtendDdlBuilder nicknameDdlBuilder = DdlGenerationUtility.getNicknameDdlBuilder(product, version);
                if (nicknameDdlBuilder != null) {
                    return new EngineeringOption(id, nicknameDdlBuilder.getOption(), nicknameDdlBuilder.getOptionDescription(), DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
                }
            } else if (id.equalsIgnoreCase("GENERATE_FEDERATEDPROCEDURES")) {
                ExtendDdlBuilder federatedProcedureDdlBuilder = DdlGenerationUtility.getFederatedProcedureDdlBuilder(product, version);
                if (federatedProcedureDdlBuilder != null) {
                    return new EngineeringOption(id, federatedProcedureDdlBuilder.getOption(), federatedProcedureDdlBuilder.getOptionDescription(), DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
                }
            } else if (id.equalsIgnoreCase("GENERATE_REMOTESERVER")) {
                ExtendDdlBuilder remoteServerDdlBuilder = DdlGenerationUtility.getRemoteServerDdlBuilder(product, version);
                if (remoteServerDdlBuilder != null) {
                    return new EngineeringOption(id, remoteServerDdlBuilder.getOption(), remoteServerDdlBuilder.getOptionDescription(), DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
                }
            } else if (id.equalsIgnoreCase("GENERATE_WRAPPER")) {
                ExtendDdlBuilder wrapperDdlBuilder = DdlGenerationUtility.getWrapperDdlBuilder(product, version);
                if (wrapperDdlBuilder != null) {
                    return new EngineeringOption(id, wrapperDdlBuilder.getOption(), wrapperDdlBuilder.getOptionDescription(), DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
                }
            } else if (id.equalsIgnoreCase("GENERATE_USERMAPPING")) {
                ExtendDdlBuilder userMappingDdlBuilder = DdlGenerationUtility.getUserMappingDdlBuilder(product, version);
                if (userMappingDdlBuilder != null) {
                    return new EngineeringOption(id, userMappingDdlBuilder.getOption(), userMappingDdlBuilder.getOptionDescription(), DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
                }
            } else if (id.equalsIgnoreCase("GENERATE_OLAP")) {
                OlapDdlBuilder olapDdlBuilder = DdlGenerationUtility.getOlapDdlBuilder(product, version);
                if (olapDdlBuilder != null) {
                    return new EngineeringOption(id, olapDdlBuilder.getOption(), olapDdlBuilder.getOptionDescription(), DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
                }
            } else {
                if (id.equalsIgnoreCase("GENERATE_PACKAGE")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_PACKAGE, DdlGenerationMessages.GENERATE_PACKAGE_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
                }
                if (id.equalsIgnoreCase("GENERATE_PACKAGE_BODY")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_PACKAGE_BODY, DdlGenerationMessages.GENERATE_PACKAGE_BODY_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
                }
                if (id.equalsIgnoreCase("GENERATE_BACKUP_TABLE")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_BACKUP_TABLE, DdlGenerationMessages.GENERATE_BACKUP_TABLE_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), general_options);
                }
                if (id.equalsIgnoreCase("GENERATE_STATISTICS")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_STATISTICS, DdlGenerationMessages.GENERATE_STATISTICS_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, false), general_options);
                }
                if (id.equalsIgnoreCase("GENERATE_ROLE")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_ROLE, DdlGenerationMessages.GENERATE_ROLE_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
                }
                if (id.equalsIgnoreCase("GENERATE_USER")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_USER, DdlGenerationMessages.GENERATE_USER_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
                }
                if (id.equalsIgnoreCase("GENERATE_GROUP")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_GROUP, DdlGenerationMessages.GENERATE_GROUP_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
                }
                if (id.equalsIgnoreCase("CHECK_MODEL")) {
                    return new EngineeringOption(id, DdlGenerationMessages.CHECK_MODEL, DdlGenerationMessages.CHECK_MODEL_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, false), general_options);
                }
                if (id.equalsIgnoreCase("GENERATE_MODULE")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_MODULE, DdlGenerationMessages.GENERATE_MODULE_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
                }
                if (id.equalsIgnoreCase("GENERATE_CONDITION")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_MODULE_CONDITION, DdlGenerationMessages.GENERATE_MODULE_CONDITION_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
                }
                if (id.equalsIgnoreCase("GENERATE_GLOBAL_VARIABLE")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_GLOBAL_VARIABLE, DdlGenerationMessages.GENERATE_GLOBAL_VARIABLE_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
                }
                if (id.equalsIgnoreCase("GENERATE_HISTORY_TABLE")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_HISTORY_TABLE, DdlGenerationMessages.GENERATE_HISTORY_TABLE_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
                }
                if (id.equalsIgnoreCase("GENERATE_TEMPORARY_TABLES")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_TEMPORARY_TABLE, DdlGenerationMessages.GENERATE_TEMPORARY_TABLE_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
                }
                if (id.equalsIgnoreCase("GENERATE_XMLSCHEMA")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_XMLSCHEMA, DdlGenerationMessages.GENERATE_XMLSCHEMA_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, false), additional_element);
                }
                if (id.equalsIgnoreCase("GENERATE_SECURITY_POLICY")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_SECURITY_POLICY, DdlGenerationMessages.GENERATE_SECURITY_POLICY_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
                }
                if (id.equalsIgnoreCase("DROP_RESTRICT")) {
                    return new EngineeringOption(id, DdlGenerationMessages.DROP_RESTRICT, DdlGenerationMessages.DROP_RESTRICT_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, false), general_options);
                }
                if (id.equalsIgnoreCase("GENERATE_ROW_PERMISSIONS")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_ROW_PERMISSIONS, DdlGenerationMessages.GENERATE_ROW_PERMISSIONS_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
                }
                if (id.equalsIgnoreCase("GENERATE_COLUMN_MASKS")) {
                    return new EngineeringOption(id, DdlGenerationMessages.GENERATE_COLUMN_MASKS, DdlGenerationMessages.GENERATE_COLUMN_MASKS_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static EngineeringOption getEngineeringOption(String id, String product, String version, EngineeringOptionCategory general_options, EngineeringOptionCategory additional_element, SQLObject[] elements, String descriptorName) {
        try {
            if (id.equalsIgnoreCase("GENERATE_FULLY_QUALIFIED_NAME")) {
                return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_FULLY_QUALIFIED_NAME_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, qualifyNamesDefault), general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_QUOTED_IDENTIFIER")) {
                return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_QUOTED_IDENTIFIER_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, quoteIdentifiersDefault), general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_DROP_STATEMENTS")) {
                return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_DROP_STATEMENTS_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, false), general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_CREATE_STATEMENTS")) {
                return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_CREATE_STATEMENTS_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_PRIVILEGE")) {
                return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_PRIVILEGE_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_COMMENTS")) {
                return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_COMMENTS_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_LABELS")) {
                return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_LABELS_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_IN_TABLESPACE_CLAUSE")) {
                return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_IN_TABLESPACE_CLAUSE_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_ON_FILEGROUP_CLAUSE")) {
                return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_ON_FILEGROUP_CLAUSE_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), general_options);
            }
            if (id.equalsIgnoreCase("USE_DOMAIN_IF_EXIST")) {
                return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_USE_DOMAIN_IF_EXIST_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, false), general_options);
            }
            if (id.equalsIgnoreCase("CREATE_OR_REPLACE") && ModelHelper.getVersionAsFloat(version) >= 9.7f) {
                return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_CREATE_OR_REPLACE_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, false), general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_TABLES")) {
                return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_TABLES_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_TABLESPACES")) {
                if (product.equals("Oracle")) {
                    return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_TABLESPACES_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
                }
                return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_TABLESPACES_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, false), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_FILEGROUPS")) {
                return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_FILEGROUPS_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_INDICES")) {
                return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_INDEX_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_STOREDPROCEDURES")) {
                return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_STOREDPROCEDURE_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_FUNCTIONS")) {
                return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_FUNCTION_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_VIEWS")) {
                return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_VIEW_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_TRIGGERS")) {
                return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_TRIGGER_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_SEQUENCES")) {
                return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_SEQUENCE_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_USER_DEFINED_TYPE")) {
                return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_USER_DEFINED_TYPE_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_PK_CONSTRAINTS")) {
                return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_PK_CONSTRAINTS_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_CK_CONSTRAINTS")) {
                return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_CK_CONSTRAINTS_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_FK_CONSTRAINTS")) {
                return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_FK_CONSTRAINTS_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_TABLESPACES")) {
                return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_TABLESPACES_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_DATABASE")) {
                return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_DATABASE_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_MQT")) {
                return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_MQT_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_ALIAS")) {
                return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_ALIAS_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_SYNONYM")) {
                return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_SYNONYM_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_BUFFERPOOL")) {
                return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_BUFFERPOOL_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_STORAGEGROUP")) {
                return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_STORAGEGROUP_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_PARTITIONGROUP")) {
                return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_PARTITIONGROUP_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_SCHEMAS")) {
                return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_SCHEMA_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_NICKNAME")) {
                ExtendDdlBuilder nicknameDdlBuilder = DdlGenerationUtility.getNicknameDdlBuilder(product, version);
                if (nicknameDdlBuilder != null) {
                    return new EngineeringOption(id, nicknameDdlBuilder.getOption(), nicknameDdlBuilder.getOptionDescription(), DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
                }
            } else if (id.equalsIgnoreCase("GENERATE_FEDERATEDPROCEDURES")) {
                ExtendDdlBuilder federatedProcedureDdlBuilder = DdlGenerationUtility.getFederatedProcedureDdlBuilder(product, version);
                if (federatedProcedureDdlBuilder != null) {
                    return new EngineeringOption(id, federatedProcedureDdlBuilder.getOption(), federatedProcedureDdlBuilder.getOptionDescription(), DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
                }
            } else if (id.equalsIgnoreCase("GENERATE_REMOTESERVER")) {
                ExtendDdlBuilder remoteServerDdlBuilder = DdlGenerationUtility.getRemoteServerDdlBuilder(product, version);
                if (remoteServerDdlBuilder != null) {
                    return new EngineeringOption(id, remoteServerDdlBuilder.getOption(), remoteServerDdlBuilder.getOptionDescription(), DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
                }
            } else if (id.equalsIgnoreCase("GENERATE_WRAPPER")) {
                ExtendDdlBuilder wrapperDdlBuilder = DdlGenerationUtility.getWrapperDdlBuilder(product, version);
                if (wrapperDdlBuilder != null) {
                    return new EngineeringOption(id, wrapperDdlBuilder.getOption(), wrapperDdlBuilder.getOptionDescription(), DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
                }
            } else if (id.equalsIgnoreCase("GENERATE_USERMAPPING")) {
                ExtendDdlBuilder userMappingDdlBuilder = DdlGenerationUtility.getUserMappingDdlBuilder(product, version);
                if (userMappingDdlBuilder != null) {
                    return new EngineeringOption(id, userMappingDdlBuilder.getOption(), userMappingDdlBuilder.getOptionDescription(), DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
                }
            } else if (id.equalsIgnoreCase("GENERATE_OLAP")) {
                OlapDdlBuilder olapDdlBuilder = DdlGenerationUtility.getOlapDdlBuilder(product, version);
                if (olapDdlBuilder != null) {
                    return new EngineeringOption(id, olapDdlBuilder.getOption(), olapDdlBuilder.getOptionDescription(), DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
                }
            } else {
                if (id.equalsIgnoreCase("GENERATE_PACKAGE")) {
                    return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_PACKAGE_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
                }
                if (id.equalsIgnoreCase("GENERATE_PACKAGE_BODY")) {
                    return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_PACKAGE_BODY_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
                }
                if (id.equalsIgnoreCase("GENERATE_BACKUP_TABLE")) {
                    return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_BACKUP_TABLE_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), general_options);
                }
                if (id.equalsIgnoreCase("GENERATE_STATISTICS")) {
                    return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_STATISTICS_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, false), general_options);
                }
                if (id.equalsIgnoreCase("GENERATE_ROLE")) {
                    return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_ROLE_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
                }
                if (id.equalsIgnoreCase("GENERATE_USER")) {
                    return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_USER_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
                }
                if (id.equalsIgnoreCase("GENERATE_GROUP")) {
                    return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_GROUP_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
                }
                if (id.equalsIgnoreCase("CHECK_MODEL")) {
                    return new EngineeringOption(id, descriptorName, DdlGenerationMessages.CHECK_MODEL_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, false), general_options);
                }
                if (id.equalsIgnoreCase("GENERATE_MODULE")) {
                    return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_MODULE_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
                }
                if (id.equalsIgnoreCase("GENERATE_CONDITION")) {
                    return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_MODULE_CONDITION_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
                }
                if (id.equalsIgnoreCase("GENERATE_GLOBAL_VARIABLE")) {
                    return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_GLOBAL_VARIABLE_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
                }
                if (id.equalsIgnoreCase("GENERATE_HISTORY_TABLE")) {
                    return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_HISTORY_TABLE_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
                }
                if (id.equalsIgnoreCase("GENERATE_TEMPORARY_TABLES")) {
                    return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_TEMPORARY_TABLE_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
                }
                if (id.equalsIgnoreCase("GENERATE_XMLSCHEMA")) {
                    return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_XMLSCHEMA_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, false), additional_element);
                }
                if (id.equalsIgnoreCase("GENERATE_SECURITY_POLICY")) {
                    return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_SECURITY_POLICY_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
                }
                if (id.equalsIgnoreCase("DROP_RESTRICT")) {
                    return new EngineeringOption(id, descriptorName, DdlGenerationMessages.DROP_RESTRICT_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, false), general_options);
                }
                if (id.equalsIgnoreCase("GENERATE_ROW_PERMISSIONS")) {
                    return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_ROW_PERMISSIONS_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
                }
                if (id.equalsIgnoreCase("GENERATE_COLUMN_MASKS")) {
                    return new EngineeringOption(id, descriptorName, DdlGenerationMessages.GENERATE_COLUMN_MASKS_DES, DdlGenerationUtility.getOptionPreference(id, product, version, elements, true), additional_element);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean getOptionPreference(String id, String product, String version, SQLObject[] elements, boolean defaultValue) {
        return Boolean.parseBoolean(instanceNode.get("generateDDLOption" + product + version + elements[0].eClass().getName() + id, String.valueOf(defaultValue)));
    }

    public static String getOptionPreference(String id, String product, String version, SQLObject[] elements, String defaultValue) {
        return instanceNode.get("generateDDLOption" + product + version + elements[0].eClass().getName() + id, defaultValue);
    }

    public static OlapDdlBuilder getOlapDdlBuilder(String dbProduct, String dbVersion) {
        if (olapDdlBuilder != null) {
            return olapDdlBuilder;
        }
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("com.ibm.datatools.core", "olapDdlBuilder");
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    String product;
                    if (configElements[j].getName().equals("builder") && (product = configElements[j].getAttribute("product")).equals(dbProduct)) {
                        try {
                            olapDdlBuilder = (OlapDdlBuilder)configElements[j].createExecutableExtension("provider");
                        }
                        catch (CoreException e) {
                            Status status = new Status(4, RDBCorePlugin.getDefault().getBundle().getSymbolicName(), 4, "The error was detected when creating the olap ddl builder for " + product, (Throwable)e);
                            IBMPluginActivator.getInstance().getLog().log((IStatus)status);
                        }
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return olapDdlBuilder;
    }

    public static ExtendDdlBuilder getNicknameDdlBuilder(String dbProduct, String dbVersion) {
        if (nicknameDdlBuilder != null) {
            return nicknameDdlBuilder;
        }
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("com.ibm.datatools.core", "nicknameDdlBuilder");
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    String product;
                    if (configElements[j].getName().equals("builder") && (product = configElements[j].getAttribute("product")).equals(dbProduct)) {
                        try {
                            nicknameDdlBuilder = (ExtendDdlBuilder)configElements[j].createExecutableExtension("provider");
                        }
                        catch (CoreException e) {
                            Status status = new Status(4, RDBCorePlugin.getDefault().getBundle().getSymbolicName(), 4, "The error was detected when creating the nickname ddl builder for " + product, (Throwable)e);
                            IBMPluginActivator.getInstance().getLog().log((IStatus)status);
                        }
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return nicknameDdlBuilder;
    }

    public static ExtendDdlBuilder getFederatedProcedureDdlBuilder(String dbProduct, String dbVersion) {
        if (federatedProcedureDdlBuilder != null) {
            return federatedProcedureDdlBuilder;
        }
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("com.ibm.datatools.core", "federatedProcedureDdlBuilder");
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    String product;
                    if (configElements[j].getName().equals("builder") && (product = configElements[j].getAttribute("product")).equals(dbProduct)) {
                        try {
                            federatedProcedureDdlBuilder = (ExtendDdlBuilder)configElements[j].createExecutableExtension("provider");
                        }
                        catch (CoreException e) {
                            Status status = new Status(4, RDBCorePlugin.getDefault().getBundle().getSymbolicName(), 4, "The error was detected when creating the federated stored procedure ddl builder for " + product, (Throwable)e);
                            IBMPluginActivator.getInstance().getLog().log((IStatus)status);
                        }
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return federatedProcedureDdlBuilder;
    }

    public static ExtendDdlBuilder getRemoteServerDdlBuilder(String dbProduct, String dbVersion) {
        if (remoteServerDdlBuilder != null) {
            return remoteServerDdlBuilder;
        }
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("com.ibm.datatools.core", "remoteServerDdlBuilder");
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    String product;
                    if (configElements[j].getName().equals("builder") && (product = configElements[j].getAttribute("product")).equals(dbProduct)) {
                        try {
                            remoteServerDdlBuilder = (ExtendDdlBuilder)configElements[j].createExecutableExtension("provider");
                        }
                        catch (CoreException e) {
                            Status status = new Status(4, RDBCorePlugin.getDefault().getBundle().getSymbolicName(), 4, "The error was detected when creating the remote Server ddl builder for " + product, (Throwable)e);
                            IBMPluginActivator.getInstance().getLog().log((IStatus)status);
                        }
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return remoteServerDdlBuilder;
    }

    public static ExtendDdlBuilder getWrapperDdlBuilder(String dbProduct, String dbVersion) {
        if (wrapperDdlBuilder != null) {
            return wrapperDdlBuilder;
        }
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("com.ibm.datatools.core", "wrapperDdlBuilder");
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    String product;
                    if (configElements[j].getName().equals("builder") && (product = configElements[j].getAttribute("product")).equals(dbProduct)) {
                        try {
                            wrapperDdlBuilder = (ExtendDdlBuilder)configElements[j].createExecutableExtension("provider");
                        }
                        catch (CoreException e) {
                            Status status = new Status(4, RDBCorePlugin.getDefault().getBundle().getSymbolicName(), 4, "The error was detected when creating the Wrapper ddl builder for " + product, (Throwable)e);
                            IBMPluginActivator.getInstance().getLog().log((IStatus)status);
                        }
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return wrapperDdlBuilder;
    }

    public static ExtendDdlBuilder getUserMappingDdlBuilder(String dbProduct, String dbVersion) {
        if (userMappingDdlBuilder != null) {
            return userMappingDdlBuilder;
        }
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("com.ibm.datatools.core", "userMappingDdlBuilder");
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    String product;
                    if (configElements[j].getName().equals("builder") && (product = configElements[j].getAttribute("product")).equals(dbProduct)) {
                        try {
                            userMappingDdlBuilder = (ExtendDdlBuilder)configElements[j].createExecutableExtension("provider");
                        }
                        catch (CoreException e) {
                            Status status = new Status(4, RDBCorePlugin.getDefault().getBundle().getSymbolicName(), 4, "The error was detected when creating the User Mapping ddl builder for " + product, (Throwable)e);
                            IBMPluginActivator.getInstance().getLog().log((IStatus)status);
                        }
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return userMappingDdlBuilder;
    }

    public static TypedElementLogicalDomainProvider getElementDomainProvider() {
        if (elementDomainProvider != null) {
            return elementDomainProvider;
        }
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("com.ibm.datatools.core", "typedElementLogicalDomainProvider");
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    if (configElements[j].getName().equals("provider")) {
                        try {
                            elementDomainProvider = (TypedElementLogicalDomainProvider)configElements[j].createExecutableExtension("typeProvider");
                        }
                        catch (CoreException e) {
                            Status status = new Status(4, RDBCorePlugin.getDefault().getBundle().getSymbolicName(), 4, "The error was detected when creating the element domain provider ", (Throwable)e);
                            IBMPluginActivator.getInstance().getLog().log((IStatus)status);
                        }
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return elementDomainProvider;
    }

    public static ModelValidationProvider getModelValidationProvider() {
        if (modelValidationProvider != null) {
            return modelValidationProvider;
        }
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("com.ibm.datatools.core", "checkModelProvider");
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    if (configElements[j].getName().equals("checkModel")) {
                        try {
                            modelValidationProvider = (ModelValidationProvider)configElements[j].createExecutableExtension("provider");
                        }
                        catch (CoreException e) {
                            Status status = new Status(4, RDBCorePlugin.getDefault().getBundle().getSymbolicName(), 4, "The error was detected when creating the model validation provider ", (Throwable)e);
                            IBMPluginActivator.getInstance().getLog().log((IStatus)status);
                        }
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return modelValidationProvider;
    }

    public static Map getCodetemplatePatterns() {
        HashMap patterns = new HashMap();
        IEclipsePreferences instanceNode = InstanceScope.INSTANCE.getNode("com.ibm.datatools.core.ui");
        String text = "";
        if ((text = instanceNode.get("codetemplate_apply_context", text)) != null && !text.equals("")) {
            DdlGenerationUtility.getCodetemplateContext(patterns, CREATE_STATEMENT, text);
            DdlGenerationUtility.getCodetemplateContext(patterns, DROP_STATEMENT, text);
        }
        text = instanceNode.get("codetemplate_table_pattern", "");
        DdlGenerationUtility.getCodetemplatePattern(patterns, text);
        text = instanceNode.get("codetemplate_routine_pattern", "");
        DdlGenerationUtility.getCodetemplatePattern(patterns, text);
        text = instanceNode.get("codetemplate_view_pattern", "");
        DdlGenerationUtility.getCodetemplatePattern(patterns, text);
        text = instanceNode.get("codetemplate_constraint_pattern", "");
        DdlGenerationUtility.getCodetemplatePattern(patterns, text);
        return patterns;
    }

    private static void getCodetemplateContext(Map map, String statementType, String data) {
        StringTokenizer token = new StringTokenizer(data, STATEMENT_TYPE_SEPARATOR);
        while (token.hasMoreTokens()) {
            String str = token.nextToken();
            int pos = str.indexOf(statementType);
            if (pos == -1) continue;
            StringTokenizer contextToken = new StringTokenizer(str.substring(statementType.length() + 1), CONTEXT_SEPARATOR);
            while (contextToken.hasMoreTokens()) {
                String str1;
                String name = str1 = contextToken.nextToken();
                boolean applied = false;
                if (str1.endsWith(CONTEXT_APPLY_FLAG)) {
                    name = str1.substring(0, str1.length() - 1);
                    applied = true;
                }
                CodeTemplateContextPattern context = null;
                if (map.containsKey(name)) {
                    context = (CodeTemplateContextPattern)map.get(name);
                } else {
                    context = new CodeTemplateContextPattern();
                    map.put(name, context);
                }
                if (!applied) continue;
                if (statementType.equals(CREATE_STATEMENT)) {
                    context.setAppliedType(2);
                    continue;
                }
                if (!statementType.equals(DROP_STATEMENT)) continue;
                context.setAppliedType(4);
            }
        }
    }

    private static void getCodetemplatePattern(Map map, String codeTemplate) {
        if (codeTemplate == null) {
            return;
        }
        Pattern pattern = Pattern.compile(PATTERN_KEY, 32);
        String[] result = pattern.split(codeTemplate);
        int i = 0;
        while (i < result.length) {
            DdlGenerationUtility.parserPattern(map, result[i]);
            ++i;
        }
    }

    private static void parserPattern(Map map, String pattern) {
        int pos = pattern.indexOf("::");
        if (pos == -1) {
            return;
        }
        String context = pattern.substring(0, pos);
        String text = pattern.substring(pos + 2);
        if (!map.containsKey(context)) {
            return;
        }
        CodeTemplateContextPattern contextPattern = (CodeTemplateContextPattern)map.get(context);
        if (contextPattern == null) {
            return;
        }
        pos = text.indexOf("::");
        if (pos == -1) {
            return;
        }
        String type = text.substring(0, pos);
        if (type.equals(CREATE_PROLOG)) {
            contextPattern.setCreateProlog(text.substring(pos + 2));
        } else if (type.equals(CREATE_POSTLOG)) {
            contextPattern.setCreatePostlog(text.substring(pos + 2));
        } else if (type.equals(DROP_PROLOG)) {
            contextPattern.setDropProlog(text.substring(pos + 2));
        } else if (type.equals(DROP_POSTLOG)) {
            contextPattern.setDropPostlog(text.substring(pos + 2));
        }
    }

    private static String getTableNameSuffix() {
        return String.valueOf(tableNameSuffix++);
    }

    private static String iterateUntilUnique(ArrayList<String> tables, String prefix) {
        String retString = String.valueOf(prefix) + DdlGenerationUtility.getTableNameSuffix();
        if (tables.size() > 0) {
            for (String table : tables) {
                if (!table.equals(retString)) continue;
                return DdlGenerationUtility.iterateUntilUnique(tables, prefix);
            }
        }
        return retString;
    }

    private static String createUniqueTableName(List<Table> existing, String prefix) {
        int prefixLength = prefix.length();
        ArrayList<String> tableNames = new ArrayList<String>();
        Iterator<Table> it = existing.iterator();
        while (it.hasNext()) {
            String tableName = it.next().getName();
            if (tableName.length() < prefixLength || !tableName.substring(0, prefixLength).equals(prefix)) continue;
            tableNames.add(tableName);
        }
        return DdlGenerationUtility.iterateUntilUnique(tableNames, prefix);
    }

    public static String getUniqueTableName(Schema schema, String prefix) {
        Object collection = schema.eGet((EStructuralFeature)SQLSchemaPackage.eINSTANCE.getSchema_Tables());
        if (collection instanceof EList) {
            return DdlGenerationUtility.createUniqueTableName((List<Table>)((EList)collection), prefix);
        }
        return null;
    }

    public static boolean isSameMembership(Index o, UniqueConstraint o1) {
        EList idxMembers = o.getMembers();
        EList ucMembers = o1.getMembers();
        if (idxMembers.size() != ucMembers.size()) {
            return false;
        }
        int i = 0;
        while (i < idxMembers.size()) {
            if (ucMembers.get(i) != ((IndexMember)idxMembers.get(i)).getColumn()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static char getSqlIdentifierDelimiterCharacter(SQLObject object) {
        SQLQuerySourceFormat sourceFormat = SQLQuerySourceFormat.copyDefaultFormat();
        return sourceFormat.getDelimitedIdentifierQuote();
    }

    public static char getSqlEscapeCharacter(SQLObject object) {
        return DdlGenerationUtility.getSqlIdentifierDelimiterCharacter(object);
    }

    public static boolean isValidUnquotedDataObjectIdentifier(SQLObject object) {
        String allowedFirstCharSymbols = "@$#";
        String name = object.getName();
        if (name == null || name.length() < 1) {
            return false;
        }
        char firstChar = name.charAt(0);
        if (!Character.isLetter(firstChar) && !allowedFirstCharSymbols.contains(new String(new char[]{firstChar}))) {
            return false;
        }
        int i = 1;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (!Character.isLetterOrDigit(c) && !allowedFirstCharSymbols.contains(new String(new char[]{c})) && c != '_') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static List<Integer> getConstraintColumnReferencePointers(CheckConstraint constraint, Column col) {
        ArrayList<Integer> occurrenceIdxs = new ArrayList<Integer>();
        if (col == null) {
            return occurrenceIdxs;
        }
        String name = col.getName();
        if (name == null || name.length() == 0) {
            return occurrenceIdxs;
        }
        SearchCondition cond = constraint.getSearchCondition();
        if (cond == null) {
            return occurrenceIdxs;
        }
        String sql = cond.getSQL();
        if (sql == null || sql.length() == 0) {
            return occurrenceIdxs;
        }
        BaseTable table = constraint.getBaseTable();
        String tableName = table.getName();
        Schema schema = table.getSchema();
        String schemaName = schema.getName();
        Set<ValueExpressionColumn> vECs = DdlGenerationUtility.getConstraintValueExpressionColumns(schema, (Table)table, constraint);
        SQLQuerySourceFormat sourceFormat = SQLQuerySourceFormat.copyDefaultFormat();
        sourceFormat.setOmitSchema(schemaName);
        char nameDelimiter = sourceFormat.getDelimitedIdentifierQuote();
        String selectProlog = "SELECT * FROM " + nameDelimiter + tableName + nameDelimiter + " WHERE ";
        for (ValueExpressionColumn vEC : vECs) {
            if (DdlGenerationUtility.isValidUnquotedDataObjectIdentifier((SQLObject)col) ? !vEC.getName().equalsIgnoreCase(col.getName()) : !vEC.getName().equals(col.getName())) continue;
            SQLQuerySourceInfo info = vEC.getSourceInfo();
            int idx = info.getSpanStartOffset();
            String snippet = info.getSourceSnippet();
            if (snippet.charAt(0) == nameDelimiter && snippet.length() > name.length()) {
                ++idx;
            }
            occurrenceIdxs.add(idx - selectProlog.length());
        }
        return occurrenceIdxs;
    }

    public static Set<ValueExpressionColumn> getConstraintValueExpressionColumns(Schema schema, Table table, CheckConstraint constraint) {
        HashSet<ValueExpressionColumn> cols = new HashSet<ValueExpressionColumn>();
        SearchCondition cond = constraint.getSearchCondition();
        if (cond == null) {
            return cols;
        }
        String sql = cond.getSQL();
        if (sql == null || sql.length() == 0) {
            return cols;
        }
        String tableName = table.getName();
        String schemaName = schema.getName();
        Database database = schema.getDatabase();
        try {
            TableReferenceResolver tableRefResolver = new TableReferenceResolver(database, schemaName);
            DataTypeResolver dataTypeResolver = new DataTypeResolver();
            ArrayList<Object> postParseProcessors = new ArrayList<Object>();
            postParseProcessors.add(0, tableRefResolver);
            postParseProcessors.add(1, dataTypeResolver);
            SQLQuerySourceFormat sourceFormat = SQLQuerySourceFormat.copyDefaultFormat();
            sourceFormat.setOmitSchema(schemaName);
            char nameDelimiter = sourceFormat.getDelimitedIdentifierQuote();
            String selectProlog = "SELECT * FROM " + nameDelimiter + tableName + nameDelimiter + " WHERE ";
            String selectStatement = String.valueOf(selectProlog) + sql;
            SQLQueryParserManager parserManager = SQLQueryParserManagerProvider.getInstance().getParserManager(database.getVendor(), database.getVersion());
            parserManager.configParser(sourceFormat, postParseProcessors);
            SQLQueryParseResult parseResult = parserManager.parseQuery(selectStatement);
            QueryStatement qS = parseResult.getQueryStatement();
            QuerySearchCondition qSC = StatementHelper.getSearchCondition((QueryStatement)qS);
            Set colSet = TableHelper.findColumnReferencesInSearchCondition((QuerySearchCondition)qSC);
            for (Object vEC : colSet) {
                if (!(vEC instanceof ValueExpressionColumn)) continue;
                cols.add((ValueExpressionColumn)vEC);
            }
        }
        catch (Exception exception) {}
        return cols;
    }

    public static Column getFirstColumnInCheckConstraintSearchCondition(Schema schema, Table table, CheckConstraint constraint) {
        Set<ValueExpressionColumn> vECs = DdlGenerationUtility.getConstraintValueExpressionColumns(schema, table, constraint);
        EList cols = table.getColumns();
        for (ValueExpressionColumn vEC : vECs) {
            for (Column col : cols) {
                if (DdlGenerationUtility.isValidUnquotedDataObjectIdentifier((SQLObject)col) ? !vEC.getName().equalsIgnoreCase(col.getName()) : !vEC.getName().equals(col.getName())) continue;
                return col;
            }
        }
        return null;
    }

    public static String convertLineEndings(String str, String lineEnding) {
        BufferedReader reader = new BufferedReader(new StringReader(str));
        StringBuffer buf = new StringBuffer();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                buf.append(String.valueOf(line) + lineEnding);
            }
            reader.close();
        }
        catch (IOException iOException) {
            return null;
        }
        return buf.toString();
    }

    public static boolean filterOutComments(String sql) {
        String[] statements;
        String[] stringArray = statements = sql.split("\n");
        int n = statements.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (!s.startsWith("--") && s.trim().length() > 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

