/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.Messages;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

public class SharedImagesFactory {
    private static final char OVERLAY_SEPARATOR = '.';
    private Bundle bundle;
    private ImageRegistry imageRegistry;
    private Map<String, URL> urlMap = new HashMap<String, URL>();

    public SharedImagesFactory(Plugin plugin) {
        this.bundle = plugin.getBundle();
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        this.imageRegistry = new ImageRegistry(display);
    }

    private URL getUrl(String key) {
        if (this.urlMap.containsKey(key)) {
            return this.urlMap.get(key);
        }
        Path projectRelativePath = new Path(key);
        URL url = FileLocator.find((Bundle)this.bundle, (IPath)projectRelativePath, null);
        if (url == null) {
            Exception e = new Exception(NLS.bind((String)Messages.CDTSharedImages_MissingImage, (Object)key, (Object)"org.eclipse.cdt.ui"));
            CUIPlugin.log(e.getMessage(), e);
        }
        this.urlMap.put(key, url);
        return url;
    }

    public void register(URL url) {
        this.urlMap.put(url.toString(), url);
    }

    public Image getImage(String key) {
        URL url = this.getUrl(key);
        String registryKey = url != null ? url.toString() : null;
        Image image = this.imageRegistry.get(registryKey);
        if (image == null) {
            ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)url);
            this.imageRegistry.put(registryKey, descriptor);
            image = this.imageRegistry.get(registryKey);
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String key) {
        URL url = this.getUrl(key);
        String registryKey = url != null ? url.toString() : null;
        ImageDescriptor descriptor = this.imageRegistry.getDescriptor(registryKey);
        if (descriptor == null) {
            descriptor = ImageDescriptor.createFromURL((URL)url);
            this.imageRegistry.put(registryKey, descriptor);
        }
        return descriptor;
    }

    public Image getImageOverlaid(String baseKey, String[] overlayKeys) {
        Assert.isTrue((overlayKeys.length == 5 ? 1 : 0) != 0);
        Object suffix = "";
        int i = 0;
        while (i < 5) {
            String overlayKey = "";
            if (i < overlayKeys.length && overlayKeys[i] != null) {
                overlayKey = overlayKeys[i];
            }
            suffix = (String)suffix + "." + overlayKey;
            ++i;
        }
        if (((String)suffix).length() == 5) {
            Image result = this.getImage(baseKey);
            return result;
        }
        String compositeKey = baseKey + (String)suffix;
        Image result = this.imageRegistry.get(compositeKey);
        if (result != null) {
            return result;
        }
        Image baseImage = this.getImage(baseKey);
        ImageDescriptor[] overlayDescriptors = new ImageDescriptor[5];
        int i2 = 0;
        while (i2 < 5) {
            String overlayKey = overlayKeys[i2];
            if (overlayKey != null) {
                overlayDescriptors[i2] = this.getImageDescriptor(overlayKey);
            }
            ++i2;
        }
        DecorationOverlayIcon compositeDescriptor = new DecorationOverlayIcon(baseImage, overlayDescriptors);
        this.imageRegistry.put(compositeKey, (ImageDescriptor)compositeDescriptor);
        result = this.imageRegistry.get(compositeKey);
        return result;
    }

    public Image getImageOverlaid(String baseKey, String overlayKey, int quadrant) {
        String[] overlayKeys = new String[5];
        overlayKeys[quadrant] = overlayKey;
        return this.getImageOverlaid(baseKey, overlayKeys);
    }
}

