/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.internal.ui.navigator;

import java.util.Arrays;
import java.util.Set;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.navigator.CNavigatorContentProvider;
import org.eclipse.cdt.lsp.internal.messages.LspUiMessages;
import org.eclipse.cdt.lsp.internal.ui.navigator.SymbolsManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.lsp4e.outline.SymbolsModel;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;

public class CSymbolsContentProvider
extends CNavigatorContentProvider {
    private final SymbolsManager symbolsManager = SymbolsManager.INSTANCE;
    private DeferredCSymbolLoader loader;
    private Object currentInput;
    private static final WorkbenchAdapter ERROR_ELEMENT = new WorkbenchAdapter(){

        public String getLabel(Object object) {
            return LspUiMessages.NavigatorView_ErrorOnLoad;
        }
    };

    public void dispose() {
        if (this.currentInput != null && this.loader != null) {
            this.loader.cancel(this.currentInput);
        }
        this.currentInput = null;
        this.symbolsManager.dispose();
        this.loader = null;
        super.dispose();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (oldInput != null && this.loader != null) {
            this.loader.cancel(oldInput);
        }
        this.currentInput = newInput;
        if (viewer instanceof AbstractTreeViewer && newInput != null) {
            this.loader = new DeferredCSymbolLoader((AbstractTreeViewer)viewer, this.symbolsManager);
        }
        super.inputChanged(viewer, oldInput, newInput);
    }

    public void getPipelinedChildren(Object parent, Set currentChildren) {
        if (parent instanceof ITranslationUnit) {
            currentChildren.clear();
            Object[] objectArray = this.getChildren(parent);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (child != null) {
                    currentChildren.add(child);
                }
                ++n2;
            }
        }
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof SymbolsModel.DocumentSymbolWithURI) {
            return this.symbolsManager.getChildren(parentElement);
        }
        if (parentElement instanceof ITranslationUnit) {
            ITranslationUnit unit = (ITranslationUnit)parentElement;
            return this.getTranslationUnitChildren(unit);
        }
        return NO_CHILDREN;
    }

    protected Object[] getTranslationUnitChildren(ITranslationUnit unit) {
        Object[] symbols;
        if (!this.symbolsManager.isDirty(unit) && (symbols = this.symbolsManager.getTranslationUnitElements(unit)) != null) {
            return symbols;
        }
        if (this.loader != null) {
            return this.loader.getChildren(unit);
        }
        return NO_CHILDREN;
    }

    private static class DeferredCSymbolLoader
    extends DeferredTreeContentManager {
        private final IDeferredWorkbenchAdapter adapter;
        private final AbstractTreeViewer viewer;
        private static final int MAX_INITIAL_CHILDREN = 100;

        public DeferredCSymbolLoader(AbstractTreeViewer viewer, IDeferredWorkbenchAdapter adapter) {
            super(viewer);
            this.viewer = viewer;
            this.adapter = adapter;
        }

        protected IDeferredWorkbenchAdapter getAdapter(Object element) {
            return this.adapter;
        }

        protected void addChildren(Object parent, Object[] children, IProgressMonitor monitor) {
            Control control = this.viewer.getControl();
            if (control == null || control.isDisposed()) {
                return;
            }
            control.getDisplay().asyncExec(() -> {
                if (!control.isDisposed()) {
                    try {
                        control.setRedraw(false);
                        if (children.length != 1 || children[0] != ERROR_ELEMENT) {
                            this.viewer.remove((Object)ERROR_ELEMENT);
                        }
                        Object[] limitedChildren = children;
                        if (children.length > 100) {
                            limitedChildren = Arrays.copyOfRange(children, 0, 100);
                        }
                        this.viewer.add(parent, limitedChildren);
                    }
                    finally {
                        control.setRedraw(true);
                    }
                }
            });
        }
    }
}

