/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.clangd.format;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import org.eclipse.cdt.lsp.clangd.format.RegexMarkerPattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;

public class ClangFormatValidator {
    public static final String CLANG_FORMAT_MARKER = "org.eclipse.cdt.lsp.clangd.format.marker";
    private static final String ClangFormatError = "(?<file>.*?\\.clang-format):(?<line>\\d+):(?<column>\\d+:)?\\s*(([Ee]rror)|(ERROR)): (.*)";
    private static final String group1 = "$1";
    private static final String group2 = "$2";
    private static final String group3 = "$3";
    private static final String group7 = "$7";
    private final RegexMarkerPattern pattern = new RegexMarkerPattern("(?<file>.*?\\.clang-format):(?<line>\\d+):(?<column>\\d+:)?\\s*(([Ee]rror)|(ERROR)): (.*)", "$1", "$2", "$3", "$7", 2, "org.eclipse.cdt.lsp.clangd.format.marker");

    public void validateFile(List<String> commandLine, final IFile clangFormatFile) throws IOException {
        final IDocument fileDocument = LSPEclipseUtils.getDocument((IResource)clangFormatFile);
        if (fileDocument == null) {
            return;
        }
        File directory = null;
        if (clangFormatFile.getParent() != null && clangFormatFile.getParent().getLocation() != null) {
            directory = clangFormatFile.getParent().getLocation().toFile();
        }
        ProcessBuilder processBuilder = new ProcessBuilder(commandLine).directory(directory);
        final Process process = processBuilder.start();
        try {
            clangFormatFile.deleteMarkers(CLANG_FORMAT_MARKER, false, 0);
        }
        catch (CoreException e) {
            Platform.getLog(this.getClass()).error(e.getMessage(), (Throwable)e);
        }
        Thread clangdStderrReaderThread = new Thread("Clangd Format Validator"){

            @Override
            public void run() {
                try {
                    Throwable throwable = null;
                    Object var2_4 = null;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
                        String line = reader.readLine();
                        while (line != null) {
                            ClangFormatValidator.this.pattern.processLine(line, clangFormatFile, fileDocument);
                            line = reader.readLine();
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    Platform.getLog(this.getClass()).error(e.getMessage(), (Throwable)e);
                }
            }
        };
        clangdStderrReaderThread.start();
        try {
            clangdStderrReaderThread.join();
            process.waitFor();
        }
        catch (InterruptedException e) {
            Platform.getLog(this.getClass()).error(e.getMessage(), (Throwable)e);
        }
    }
}

