/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.docker.launcher;

import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.internal.docker.launcher.BaseDatabindingModel;
import org.eclipse.cdt.internal.docker.launcher.ContainerPropertyVolumesModel;
import org.eclipse.core.runtime.Platform;

public class DataVolumeModel
extends BaseDatabindingModel
implements Comparable<DataVolumeModel> {
    private static final String SEPARATOR = ":";
    public static final String CONTAINER_PATH = "containerPath";
    public static final String MOUNT_TYPE = "mountType";
    public static final String MOUNT = "mount";
    public static final String HOST_PATH_MOUNT = "hostPathMount";
    public static final String READ_ONLY_VOLUME = "readOnly";
    public static final String CONTAINER_MOUNT = "containerMount";
    public static final String SELECTED = "selected";
    private final String id = UUID.randomUUID().toString();
    private String containerPath;
    private ContainerPropertyVolumesModel.MountType mountType;
    private String mount;
    private String hostPathMount;
    private String containerMount;
    private boolean readOnly = false;
    private boolean selected;

    public DataVolumeModel() {
    }

    public DataVolumeModel(String containerPath) {
        this.containerPath = containerPath;
        this.mountType = ContainerPropertyVolumesModel.MountType.NONE;
    }

    public DataVolumeModel(String containerPath, String hostPath, boolean readOnly) {
        this.containerPath = containerPath;
        this.mountType = ContainerPropertyVolumesModel.MountType.HOST_FILE_SYSTEM;
        this.mount = this.hostPathMount = hostPath;
        this.readOnly = readOnly;
    }

    public DataVolumeModel(DataVolumeModel selectedDataVolume) {
        this.containerPath = selectedDataVolume.getContainerPath();
        this.mountType = selectedDataVolume.getMountType();
        if (this.mountType != null) {
            switch (this.mountType) {
                case CONTAINER: {
                    this.containerMount = selectedDataVolume.getMount();
                    break;
                }
                case HOST_FILE_SYSTEM: {
                    this.hostPathMount = selectedDataVolume.getMount();
                    this.readOnly = selectedDataVolume.isReadOnly();
                    break;
                }
            }
        } else {
            this.mountType = ContainerPropertyVolumesModel.MountType.NONE;
        }
    }

    public static DataVolumeModel parseString(String fromString) {
        DataVolumeModel model = new DataVolumeModel();
        String[] items = fromString.split(SEPARATOR);
        model.containerPath = items[0];
        model.mountType = ContainerPropertyVolumesModel.MountType.valueOf(items[1]);
        switch (model.mountType) {
            case CONTAINER: {
                model.setContainerMount(items[2]);
                model.setSelected(Boolean.valueOf(items[3]));
                break;
            }
            case HOST_FILE_SYSTEM: {
                if ("win32".equals(Platform.getOS()) && items.length > 5) {
                    model.setHostPathMount(items[2] + SEPARATOR + items[3]);
                    model.setReadOnly(Boolean.valueOf(items[4]));
                    model.setSelected(Boolean.valueOf(items[5]));
                    break;
                }
                model.setHostPathMount(items[2]);
                model.setReadOnly(Boolean.valueOf(items[3]));
                model.setSelected(Boolean.valueOf(items[4]));
                break;
            }
            case NONE: {
                model.setSelected(Boolean.valueOf(items[2]));
            }
        }
        return model;
    }

    public static DataVolumeModel parseVolumeFrom(String volumeFrom) {
        DataVolumeModel model = new DataVolumeModel();
        model.mountType = ContainerPropertyVolumesModel.MountType.CONTAINER;
        model.containerMount = volumeFrom;
        model.selected = true;
        return model;
    }

    public static DataVolumeModel parseHostBinding(String volumeFrom) {
        DataVolumeModel model = new DataVolumeModel();
        String[] items = volumeFrom.split(SEPARATOR);
        model.setHostPathMount(DataVolumeModel.convertToWin32Path(Platform.getOS(), items[0]));
        model.containerPath = items[1];
        model.mountType = ContainerPropertyVolumesModel.MountType.HOST_FILE_SYSTEM;
        if (items[2].equals("ro")) {
            model.setReadOnly(true);
        } else {
            model.setReadOnly(false);
        }
        model.selected = true;
        return model;
    }

    public static String convertToWin32Path(String os, String path) {
        Matcher m;
        if (os != null && os.equals("win32") && (m = Pattern.compile("^/([a-zA-Z])/").matcher(path)).find()) {
            StringBuffer b = new StringBuffer();
            m.appendReplacement(b, m.group(1).toUpperCase());
            b.append(":\\");
            m.appendTail(b);
            return b.toString().replace('/', '\\');
        }
        return path;
    }

    public String getContainerPath() {
        return this.containerPath;
    }

    public void setContainerPath(String containerPath) {
        this.containerPath = containerPath;
        this.firePropertyChange(CONTAINER_PATH, this.containerPath, this.containerPath);
    }

    public String getMount() {
        return this.mount;
    }

    public void setMount(String mount) {
        this.mount = mount;
        this.firePropertyChange(MOUNT, this.mount, this.mount);
    }

    public ContainerPropertyVolumesModel.MountType getMountType() {
        return this.mountType;
    }

    public void setMountType(ContainerPropertyVolumesModel.MountType mountType) {
        if (mountType == null) {
            return;
        }
        this.mountType = mountType;
        this.firePropertyChange(MOUNT_TYPE, (Object)this.mountType, (Object)this.mountType);
        if (this.mountType == ContainerPropertyVolumesModel.MountType.NONE) {
            this.setMount("");
        }
    }

    public String getHostPathMount() {
        return this.hostPathMount;
    }

    public void setHostPathMount(String hostPathMount) {
        this.hostPathMount = hostPathMount;
        this.firePropertyChange(HOST_PATH_MOUNT, this.hostPathMount, this.hostPathMount);
        if (this.mountType == ContainerPropertyVolumesModel.MountType.HOST_FILE_SYSTEM) {
            this.setMount(this.hostPathMount);
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.firePropertyChange(READ_ONLY_VOLUME, this.readOnly, this.readOnly);
    }

    public String getContainerMount() {
        return this.containerMount;
    }

    public void setContainerMount(String containerMount) {
        this.containerMount = containerMount;
        this.firePropertyChange(CONTAINER_MOUNT, this.containerMount, this.containerMount);
        if (this.mountType == ContainerPropertyVolumesModel.MountType.CONTAINER) {
            this.setMount(this.containerMount);
        }
    }

    public boolean getSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.firePropertyChange(SELECTED, this.selected, this.selected);
    }

    @Override
    public int compareTo(DataVolumeModel other) {
        return this.getContainerPath().compareTo(other.getContainerPath());
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.containerPath + SEPARATOR + String.valueOf((Object)this.getMountType()) + SEPARATOR);
        switch (this.getMountType()) {
            case CONTAINER: {
                buffer.append(this.getContainerMount());
                break;
            }
            case HOST_FILE_SYSTEM: {
                buffer.append(this.getHostPathMount() + SEPARATOR);
                buffer.append(this.isReadOnly());
                break;
            }
        }
        buffer.append(SEPARATOR).append(this.selected);
        return buffer.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataVolumeModel other = (DataVolumeModel)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

